<?php
/**
 * View: Default Template for Events
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events/v2/default-template.php
 *
 * See more documentation about our views templating system.
 *
 * @link http://m.tri.be/1aiy
 *
 * @version 5.0.0
 */

use Tribe\Events\Views\V2\Template_Bootstrap;

get_header();

if ( is_singular( 'tribe_events' ) ) {
	zuperla_eutf_print_header_title( 'event' );
	zuperla_eutf_print_header_breadcrumbs( 'event' );
	zuperla_eutf_print_anchor_menu( 'event' );
} else {
	if ( is_singular( 'tribe_organizer' ) || is_singular( 'tribe_venue' )  ) {
		// No advanced title
	} else {
		zuperla_eutf_print_header_title( 'event_tax' );
		zuperla_eutf_print_header_breadcrumbs( 'event_tax' );
	}
}
?>

<?php if ( is_singular( 'tribe_events' ) ) { ?>
<div class="eut-single-wrapper">
<?php } ?>
	<!-- CONTENT -->
	<div id="eut-content" class="clearfix <?php echo zuperla_eutf_sidebar_class( 'event' ); ?>">
		<div class="eut-content-wrapper">
			<!-- MAIN CONTENT -->
			<div id="eut-main-content">
				<div class="eut-main-content-wrapper clearfix">
					<div class="eut-container">
						<?php echo tribe( Template_Bootstrap::class )->get_view_html(); ?>
					</div>
				</div>
			</div>
			<!-- END MAIN CONTENT -->
			<?php zuperla_eutf_set_current_view( 'event' ); ?>
			<?php get_sidebar(); ?>
		</div>
	</div>
	<!-- END CONTENT -->
<?php if ( is_singular( 'tribe_events' ) ) { ?>
<?php zuperla_eutf_print_event_bar(); ?>
</div>
<?php } ?>
<?php get_footer();

//Omit closing PHP tag to avoid accidental whitespace output errors.
