<?php
/*
*	Template Post Related
*
* 	@version	1.0
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/


$zuperla_eutf_link = get_permalink();
$zuperla_eutf_target = '_self';

if ( 'link' == get_post_format() ) {
	$zuperla_eutf_link = get_post_meta( get_the_ID(), '_zuperla_eutf_post_link_url', true );
	$new_window = get_post_meta( get_the_ID(), '_zuperla_eutf_post_link_new_window', true );
	if( empty( $zuperla_eutf_link ) ) {
		$zuperla_eutf_link = get_permalink();
	}

	if( !empty( $new_window ) ) {
		$zuperla_eutf_target = '_blank';
	}
}
?>

	<div class="eut-column eut-column-1-3">
		<div class="eut-column-wrapper">
				<?php if ( has_post_thumbnail() ) { ?>
				<div id="eut-post-related-<?php the_ID(); ?><?php echo uniqid('-'); ?>" class="eut-element eut-hover-item eut-hover-style-2">
					<figure class="eut-image-hover eut-media eut-zoom-none">
						<a class="eut-item-url" href="<?php echo esc_url( $zuperla_eutf_link ); ?>" target="<?php echo esc_attr( $zuperla_eutf_target ); ?>"></a>
						<div class="eut-bg-dark eut-hover-overlay eut-opacity-40"></div>
						<?php $image_size = 'zuperla-eutf-small-rect-horizontal'; ?>
						<?php the_post_thumbnail( $image_size ); ?>
						<figcaption class="eut-content eut-align-center">
							<div class="eut-title eut-h6 eut-text-light"><?php the_title(); ?></div>
						</figcaption>
					</figure>
				</div>
				<?php } else {?>
				<div id="eut-post-related-<?php the_ID(); ?><?php echo uniqid('-'); ?>" class="eut-element">
					<figure class="eut-without-thumb">
						<a class="eut-item-url" href="<?php echo esc_url( $zuperla_eutf_link ); ?>" target="<?php echo esc_attr( $zuperla_eutf_target ); ?>"></a>
						<figcaption class="eut-content eut-align-center">
							<div class="eut-title eut-h6"><?php the_title(); ?></div>
						</figcaption>
					</figure>
				</div>
				<?php } ?>
		</div>
	</div>