<?php
/**
 *  Add Dynamic css to header
 *  @version	1.0
 *  @author		Euthemians Team
 *  @URI		http://euthemians.com
 */


if ( !function_exists( 'zuperla_eutf_load_dynamic_css' ) ) {

	function zuperla_eutf_load_dynamic_css() {
		include_once get_template_directory() . '/includes/eut-dynamic-typography-css.php';
		include_once get_template_directory() . '/includes/eut-dynamic-css.php';
		if ( zuperla_eutf_woocommerce_enabled() ) {
			include_once get_template_directory() . '/includes/eut-dynamic-woo-css.php';
		}
		if ( zuperla_eutf_events_calendar_enabled() ) {
			include_once get_template_directory() . '/includes/eut-dynamic-event-css.php';
		}
		if ( zuperla_eutf_bbpress_enabled() ) {
			include_once get_template_directory() . '/includes/eut-dynamic-bbpress-css.php';
		}

		$custom_css_code = zuperla_eutf_option( 'css_code' );
		if ( !empty( $custom_css_code ) ) {
			wp_add_inline_style( 'zuperla-eutf-custom-style', zuperla_eutf_compress_css( $custom_css_code ) );
		}

		zuperla_eutf_add_custom_page_css();
		zuperla_eutf_get_global_button_style();
		zuperla_eutf_get_global_shape_style();
	}
}

function zuperla_eutf_add_custom_page_css( $id = null ) {

	$zuperla_eutf_custom_css = '';
	$zuperla_eutf_woo_shop = zuperla_eutf_is_woo_shop();

	if ( is_front_page() && is_home() ) {
		// Default homepage
		$mode = 'blog';
	} else if ( is_front_page() ) {
		// static homepage
		$mode = 'page';
	} else if ( is_home() ) {
		// blog page
		$mode = 'blog';
	} else if ( is_search() ) {
		$mode = 'search_page';
	} else if ( zuperla_eutf_is_bbpress() ) {
		$mode = 'forum';
	} else if ( is_singular() || $zuperla_eutf_woo_shop ) {
		if ( is_singular( 'post' ) ) {
			$mode = 'post';
		} else if ( is_singular( 'portfolio' ) ) {
			$mode = 'portfolio';
		} else if ( is_singular( 'product' ) ) {
			$mode = 'product';
		} else if ( is_singular( 'tribe_events' ) ) {
			$mode = 'event';
		} else if ( is_singular( 'tribe_organizer' ) || is_singular( 'tribe_venue' ) ) {
			$mode = 'event_tax';
		} else {
			$mode = 'page';
		}
	} else if ( is_archive() ) {
		if( zuperla_eutf_is_woo_tax() ) {
			$mode = 'product_tax';
		} else if ( zuperla_eutf_events_calendar_is_overview() || is_post_type_archive( 'tribe_events' ) ) {
			$mode = 'event_tax';
		} else {
			$mode = 'blog';
		}

	} else {
		$mode = 'page';
	}

	$zuperla_eutf_page_title = array(
		'bg_color' => zuperla_eutf_option( $mode . '_title_bg_color', 'dark' ),
		'bg_color_custom' => zuperla_eutf_option( $mode . '_title_bg_color_custom', '#000000' ),
		'content_bg_color' => zuperla_eutf_option( $mode . '_title_content_bg_color', 'none' ),
		'content_bg_color_custom' => zuperla_eutf_option( $mode . '_title_content_bg_color_custom', '#ffffff' ),
		'title_color' => zuperla_eutf_option( $mode . '_title_color', 'light' ),
		'title_color_custom' => zuperla_eutf_option( $mode . '_title_color_custom', '#ffffff' ),
		'caption_color' => zuperla_eutf_option( $mode . '_description_color', 'light' ),
		'caption_color_custom' => zuperla_eutf_option( $mode . '_description_color_custom', '#ffffff' ),
	);

	if ( is_tag() || is_category() || zuperla_eutf_is_woo_category() || zuperla_eutf_is_woo_tag() ) {
		$category_id = get_queried_object_id();
		$zuperla_eutf_custom_title_options = zuperla_eutf_get_term_meta( $category_id, '_zuperla_eutf_custom_title_options' );
		$zuperla_eutf_page_title_custom = zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'custom' );
		if ( 'custom' == $zuperla_eutf_page_title_custom ) {
			$zuperla_eutf_page_title = $zuperla_eutf_custom_title_options;
		}
	}


	if ( is_singular() || $zuperla_eutf_woo_shop ) {

		if ( ! $id ) {
			if ( $zuperla_eutf_woo_shop ) {
				$id = wc_get_page_id( 'shop' );
			} else {
				$id = get_the_ID();
			}
		}
		if ( $id ) {

			//Custom Title
			$zuperla_eutf_custom_title_options = get_post_meta( $id, '_zuperla_eutf_custom_title_options', true );
			$zuperla_eutf_page_title_custom = zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'custom' );
			if ( !empty( $zuperla_eutf_page_title_custom ) ) {
				$zuperla_eutf_page_title = $zuperla_eutf_custom_title_options;
			}

			//Feature Section
			$feature_section = get_post_meta( $id, '_zuperla_eutf_feature_section', true );
			$feature_settings = zuperla_eutf_array_value( $feature_section, 'feature_settings' );
			$feature_element = zuperla_eutf_array_value( $feature_settings, 'element' );

			if ( !empty( $feature_element ) ) {

				switch( $feature_element ) {

					case 'title':
					case 'image':
					case 'video':
						$single_item = zuperla_eutf_array_value( $feature_section, 'single_item' );
						if ( !empty( $single_item ) ) {
							$zuperla_eutf_custom_css .= zuperla_eutf_get_feature_title_css( $single_item );
						}
						break;
					case 'slider':
						$slider_items = zuperla_eutf_array_value( $feature_section, 'slider_items' );
						if ( !empty( $slider_items ) ) {
							foreach ( $slider_items as $item ) {
								$zuperla_eutf_custom_css .= zuperla_eutf_get_feature_title_css( $item, 'slider' );
							}
						}
						break;
					default:
						break;

				}
			}
		}
	}

	$zuperla_eutf_custom_css .= zuperla_eutf_get_title_css( $zuperla_eutf_page_title );

	if ( ! empty( $zuperla_eutf_custom_css ) ) {
		wp_add_inline_style( 'zuperla-eutf-custom-style', zuperla_eutf_compress_css( $zuperla_eutf_custom_css ) );
	}
}

function zuperla_eutf_get_feature_title_css( $item, $type = 'single' ) {

	$zuperla_eutf_custom_css = '';
	$custom_class = '';

	if( 'slider' == $type ) {
		$id = zuperla_eutf_array_value( $item, 'id' );
		if ( !empty( $id ) ) {
			$custom_class = ' .eut-slider-item-id-' . $id ;
		}
	}

	$content_bg_color = zuperla_eutf_array_value( $item, 'content_bg_color', 'none' );
	if ( 'custom' == $content_bg_color ) {
		$content_bg_color_custom = zuperla_eutf_array_value( $item, 'content_bg_color_custom', '#ffffff' );
		$zuperla_eutf_custom_css .= '#eut-feature-section' . esc_attr( $custom_class ) . ' .eut-title-content-wrapper {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'background-color', $content_bg_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	$subheading_color = zuperla_eutf_array_value( $item, 'subheading_color', 'light' );
	if ( 'custom' == $subheading_color ) {
		$subheading_color_custom = zuperla_eutf_array_value( $item, 'subheading_color_custom', '#ffffff' );
		$zuperla_eutf_custom_css .= '#eut-feature-section' . esc_attr( $custom_class ) . ' .eut-subheading, #eut-feature-section' . esc_attr( $custom_class ) . ' .eut-title-meta {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'color', $subheading_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	$title_color = zuperla_eutf_array_value( $item, 'title_color', 'light' );
	if ( 'custom' == $title_color ) {
		$title_color_custom = zuperla_eutf_array_value( $item, 'title_color_custom', '#ffffff' );
		$zuperla_eutf_custom_css .= '#eut-feature-section' . esc_attr( $custom_class ) . ' .eut-title {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'color', $title_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	$caption_color = zuperla_eutf_array_value( $item, 'caption_color', 'light' );
	if ( 'custom' == $caption_color ) {
		$caption_color_custom = zuperla_eutf_array_value( $item, 'caption_color_custom', '#ffffff' );
		$zuperla_eutf_custom_css .= '#eut-feature-section' . esc_attr( $custom_class ) . ' .eut-description {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'color', $caption_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	$media_id = zuperla_eutf_array_value( $item, 'content_image_id', '0' );
	$media_max_height = zuperla_eutf_array_value( $item, 'content_image_max_height', '150' );
	$media_responsive_max_height = zuperla_eutf_array_value( $item, 'content_image_responsive_max_height', '50' );

	if( '0' != $media_id ) {
		$zuperla_eutf_custom_css .= '#eut-feature-section' . esc_attr( $custom_class ) . ' .eut-content .eut-graphic img  {';
		$zuperla_eutf_custom_css .= 'max-height:' . esc_attr( $media_max_height ) .'px';
		$zuperla_eutf_custom_css .= '}';

		$zuperla_eutf_custom_css .= '@media only screen and (max-width: 768px) {';
		$zuperla_eutf_custom_css .= '#eut-feature-section' . esc_attr( $custom_class ) . ' .eut-content .eut-graphic img  {';
		$zuperla_eutf_custom_css .= 'max-height:' . esc_attr( $media_responsive_max_height ) .'px';
		$zuperla_eutf_custom_css .= '}';
		$zuperla_eutf_custom_css .= '}';
	}

	return $zuperla_eutf_custom_css;

}

function zuperla_eutf_get_title_css( $title ) {
	$zuperla_eutf_custom_css = '';

	$bg_color = zuperla_eutf_array_value( $title, 'bg_color', 'dark' );
	if ( 'custom' == $bg_color ) {
		$bg_color_custom = zuperla_eutf_array_value( $title, 'bg_color_custom', '#000000' );
		$zuperla_eutf_custom_css .= '.eut-page-title {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'background-color', $bg_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	$content_bg_color = zuperla_eutf_array_value( $title, 'content_bg_color', 'none' );
	if ( 'custom' == $content_bg_color ) {
		$content_bg_color_custom = zuperla_eutf_array_value( $title, 'content_bg_color_custom', '#ffffff' );
		$zuperla_eutf_custom_css .= '.eut-page-title .eut-title-content-wrapper {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'background-color', $content_bg_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	$subheading_color = zuperla_eutf_array_value( $title, 'subheading_color', 'light' );
	if ( 'custom' == $subheading_color ) {
		$subheading_color_custom = zuperla_eutf_array_value( $title, 'subheading_color_custom', '#ffffff' );
		$zuperla_eutf_custom_css .= '.eut-page-title .eut-title-categories, .eut-page-title .eut-title-meta {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'color', $subheading_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	$title_color = zuperla_eutf_array_value( $title, 'title_color', 'light' );
	if ( 'custom' == $title_color ) {
		$title_color_custom = zuperla_eutf_array_value( $title, 'title_color_custom', '#ffffff' );
		$zuperla_eutf_custom_css .= '.eut-page-title .eut-title, .eut-page-title .eut-title-meta {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'color', $title_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	$caption_color = zuperla_eutf_array_value( $title, 'caption_color', 'light' );
	if ( 'custom' == $caption_color ) {
		$caption_color_custom = zuperla_eutf_array_value( $title, 'caption_color_custom', '#ffffff' );
		$zuperla_eutf_custom_css .= '.eut-page-title .eut-description {';
		$zuperla_eutf_custom_css .= zuperla_eutf_get_css_color( 'color', $caption_color_custom );
		$zuperla_eutf_custom_css .= '}';
	}

	return $zuperla_eutf_custom_css;
}

function zuperla_eutf_get_global_button_style() {

	$zuperla_eutf_custom_css = "";

	$button_type = zuperla_eutf_option( 'button_type', 'simple' );
	$button_shape = zuperla_eutf_option( 'button_shape', 'square' );
	$button_color = zuperla_eutf_option( 'button_color', 'primary-1' );
	$button_hover_color = zuperla_eutf_option( 'button_hover_color', 'black' );

	$zuperla_eutf_colors = zuperla_eutf_get_color_array();

		$zuperla_eutf_custom_css .= ".eut-modal input[type='submit']:not(.eut-custom-btn), #eut-theme-wrapper input[type='submit']:not(.eut-custom-btn), #eut-theme-wrapper input[type='reset']:not(.eut-custom-btn), #eut-theme-wrapper input[type='button']:not(.eut-custom-btn), #eut-theme-wrapper button:not(.eut-custom-btn):not(.vc_general):not(.tribe-events-c-subscribe-dropdown__button-text):not(.tribe-events-calendar-month__day-cell--mobile):not(.tribe-events-c-top-bar__datepicker-button):not(.tribe-events-c-nav__next):not(.tribe-events-c-nav__prev), .eut-portfolio-details-btn.eut-btn:not(.eut-custom-btn) {";
			switch( $button_shape ) {
				case "round":
					$zuperla_eutf_custom_css .= "-webkit-border-radius: 3px;";
					$zuperla_eutf_custom_css .= "border-radius: 3px;";
				break;
				case "extra-round":
					$zuperla_eutf_custom_css .= "-webkit-border-radius: 50px;";
					$zuperla_eutf_custom_css .= "border-radius: 50px;";
				break;
				case "square":
				default:
				break;
			}

			$default_color = zuperla_eutf_option( 'body_primary_1_color' );
			$color = zuperla_eutf_array_value( $zuperla_eutf_colors, $button_color, $default_color );

			if ( "outline" == $button_type ) {

				$zuperla_eutf_custom_css .= "border: 2px solid;";
				$zuperla_eutf_custom_css .= "background-color: transparent;";
				$zuperla_eutf_custom_css .= "border-color: " . esc_attr( $color ) . ";";
				$zuperla_eutf_custom_css .= "color: " . esc_attr( $color ) . ";";

			} else {
				$zuperla_eutf_custom_css .= "background-color: " . esc_attr( $color ) . ";";
				if ( 'white' == $button_color ) {
					$zuperla_eutf_custom_css .= "color: #bababa;";
				} else {
					$zuperla_eutf_custom_css .= "color: #ffffff;";
				}
			}


		$zuperla_eutf_custom_css .= "}";

		$zuperla_eutf_custom_css .= ".eut-modal input[type='submit']:not(.eut-custom-btn):hover, #eut-theme-wrapper input[type='submit']:not(.eut-custom-btn):hover, #eut-theme-wrapper input[type='reset']:not(.eut-custom-btn):hover, #eut-theme-wrapper input[type='button']:not(.eut-custom-btn):hover, #eut-theme-wrapper button:not(.eut-custom-btn):not(.vc_general):not(.tribe-events-c-subscribe-dropdown__button-text):not(.tribe-events-calendar-month__day-cell--mobile):not(.tribe-events-c-top-bar__datepicker-button):not(.tribe-events-c-nav__next):not(.tribe-events-c-nav__prev):hover,.woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover, .eut-portfolio-details-btn.eut-btn:not(.eut-custom-btn):hover {";

		$hover_color = zuperla_eutf_array_value( $zuperla_eutf_colors, $button_hover_color, "#bababa" );

		if ( "outline" == $button_type ) {

			$zuperla_eutf_custom_css .= "background-color: " . esc_attr( $hover_color ) . ";";
			$zuperla_eutf_custom_css .= "border-color: " . esc_attr( $hover_color ) . ";";
			if ( 'white' == $button_hover_color ) {
				$zuperla_eutf_custom_css .= "color: #bababa;";
			} else {
				$zuperla_eutf_custom_css .= "color: #ffffff;";
			}

		} else {
			$zuperla_eutf_custom_css .= "background-color: " . esc_attr( $hover_color ) . ";";
			if ( 'white' == $button_hover_color ) {
				$zuperla_eutf_custom_css .= "color: #bababa;";
			} else {
				$zuperla_eutf_custom_css .= "color: #ffffff;";
			}
		}

		$zuperla_eutf_custom_css .= "}";

	wp_add_inline_style( 'zuperla-eutf-custom-style', zuperla_eutf_compress_css( $zuperla_eutf_custom_css ) );
}

function zuperla_eutf_get_global_shape_style() {
	$zuperla_eutf_custom_css = "";

	$global_shape = zuperla_eutf_option( 'button_shape', 'square' );

	$zuperla_eutf_custom_css .= "#eut-related-post .eut-related-title, .eut-nav-btn a, #eut-single-post-categories .eut-categories li a, .eut-body #eut-theme-wrapper .eut-newsletter input[type='text'], .eut-body #eut-theme-wrapper .eut-newsletter input[type='email'], #eut-theme-wrapper .eut-search:not(.eut-search-modal) input[type='text'], #eut-socials-modal .eut-social li a, .eut-pagination ul li, .eut-dropcap span.eut-style-2, .eut-menu-type-button > a .eut-item {";
	switch( $global_shape ) {
		case "round":
			$zuperla_eutf_custom_css .= "-webkit-border-radius: 3px !important;";
			$zuperla_eutf_custom_css .= "border-radius: 3px !important;";
		break;
		case "extra-round":
			$zuperla_eutf_custom_css .= "-webkit-border-radius: 50px !important;";
			$zuperla_eutf_custom_css .= "border-radius: 50px !important;";
		break;
		case "square":
		default:
		break;
	}
	$zuperla_eutf_custom_css .= "}";

	wp_add_inline_style( 'zuperla-eutf-custom-style', zuperla_eutf_compress_css( $zuperla_eutf_custom_css ) );
}

function zuperla_eutf_get_background_css( $value = array() ) {

	$css = '';

	if ( ! empty( $value ) && is_array( $value ) ) {
		foreach ( $value as $key => $value ) {
			if ( ! empty( $value ) && $key != "media" && $key != "skin" && $key != "heading_color" && $key != "text_color"  ) {
				if ( $key == "background-image" ) {
					$css .= $key . ":url('" . $value . "');";
				} else {
					$css .= $key . ":" . $value . ";";
				}
			}
		}
	}

	return $css;
}

function zuperla_eutf_get_color_array() {
	return array(
		'primary-1' => zuperla_eutf_option( 'body_primary_1_color' ),
		'primary-2' => zuperla_eutf_option( 'body_primary_2_color' ),
		'primary-3' => zuperla_eutf_option( 'body_primary_3_color' ),
		'primary-4' => zuperla_eutf_option( 'body_primary_4_color' ),
		'primary-5' => zuperla_eutf_option( 'body_primary_5_color' ),
		'primary-6' => zuperla_eutf_option( 'body_primary_6_color' ),
		'green' => '#6ECA09',
		'red' => '#D0021B',
		'orange' => '#FAB901',
		'aqua' => '#28d2dc',
		'blue' => '#15c7ff',
		'purple' => '#7639e2',
		'dark' => '#000000',
		'black' => '#000000',
		'grey' => '#e2e2e2',
		'light' => '#ffffff',
		'white' => '#ffffff',
	);
}

 /**
 * Add dynamic CSS for Page Builder
 */
function zuperla_eutf_load_dynamic_selector_css() {

	$colors = zuperla_eutf_get_color_array();
	$css = '';
	foreach ( $colors as $key => $value ) {
		$font_color = '#ffffff';
		if( 'white' == $key || 'light' == $key ) {
			$font_color = '#000000';
		}
		$css .= "
			.eut-colored-dropdown ." . esc_attr( $key ) . " {
				background-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $font_color ) . ";
			}
		";
	}
	wp_add_inline_style( 'zuperla-ext-vc-elements', zuperla_eutf_compress_css( $css ) );

}
add_action( 'admin_enqueue_scripts' , 'zuperla_eutf_load_dynamic_selector_css', 11 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
