<?php
/**
*	Theme Options Config File
*	@version	1.0
*
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

if ( !class_exists( "ReduxFramework" ) ) {
	return;
}

if (!class_exists("Zuperla_Eutf_Redux_Framework_config")) {

	class Zuperla_Eutf_Redux_Framework_config {

		public $args = array();
		public $sections = array();
		public $theme;
		public $ReduxFramework;

		public function __construct() {
			// Set the default arguments
			$this->setArguments();

			// Create the sections and fields
			$this->setSections();

			// No errors please
			if ( !isset( $this->args['opt_name'] ) ) {
				return;
			}
			$this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
		}

		public function zuperla_eutf_redux_customizer_visibility() {
			$visibility = apply_filters( 'zuperla_eutf_redux_customizer_visibility', false );
			return $visibility;
		}

		public function setSections() {

			/**
			 * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
			 * */
			global $zuperla_eutf_social_list, $zuperla_eutf_button_type_selection, $zuperla_eutf_button_shape_selection, $zuperla_eutf_button_color_selection, $zuperla_eutf_area_height;

			//Gravity Forms
			$zuperla_eutf_gravity_options = array();
			if ( class_exists( 'RGFormsModel' ) ) {
				$gravity_forms = RGFormsModel::get_forms( 1, 'title' );
				if ( $gravity_forms ) {
					$zuperla_eutf_gravity_options = array( esc_html__( 'Select a form to display.', 'zuperla' ) => '' );
					foreach ( $gravity_forms as $gravity_form ) {
						$zuperla_eutf_gravity_options[ $gravity_form->id ] = $gravity_form->title;
					}
				}
			}

			$zuperla_eutf_social_options = $zuperla_eutf_social_list;

			$zuperla_eutf_portfolio_social_options = array(
				'email' => esc_html__( 'E-mail', 'zuperla' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'pinterest' => 'Pinterest',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'eut-likes' => '(Euthemians) Likes',
			);

			$zuperla_eutf_portfolio_term_selection = array(
				'none' => esc_html__( 'None', 'zuperla' ),
				'portfolio_category' => esc_html__( 'Portfolio Category', 'zuperla' ),
				'portfolio_field' => esc_html__( 'Portfolio Field', 'zuperla' ),
			);

			$zuperla_eutf_post_social_options = array(
				'email' => esc_html__( 'E-mail', 'zuperla' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'eut-likes' => '(Euthemians) Likes',
			);

			$zuperla_eutf_product_social_options = array(
				'email' => esc_html__( 'E-mail', 'zuperla' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'eut-likes' => '(Euthemians) Likes',
			);

			$zuperla_eutf_event_social_options = array(
				'email' => esc_html__( 'E-mail', 'zuperla' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'eut-likes' => '(Euthemians) Likes',
			);

			$zuperla_eutf_event_mode_selection = array(
				'small' => esc_html__( 'Small Media', 'zuperla' ),
				'grid' => esc_html__( 'Grid' , 'zuperla' ),
			);

			$zuperla_eutf_blog_mode_selection = array(
				'large' => esc_html__( 'Large Media', 'zuperla' ),
				'small' => esc_html__( 'Small Media', 'zuperla' ),
				'masonry' => esc_html__( 'Masonry' , 'zuperla' ),
				'grid' => esc_html__( 'Grid' , 'zuperla' ),
			);

			$zuperla_eutf_blog_image_mode_selection = array(
				'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'zuperla' ),
				'landscape-medium' => esc_html__( 'Landscape Medium Crop', 'zuperla' ),
				'large' => esc_html__( 'Resize ( Large )', 'zuperla' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
			);

			$zuperla_eutf_blog_grid_image_mode_selection = array(
				'square' => esc_html__( 'Square Small Crop', 'zuperla' ),
				'landscape' => esc_html__( 'Landscape Small Crop', 'zuperla' ),
				'portrait' => esc_html__( 'Portrait Small Crop', 'zuperla' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
			);

			$zuperla_eutf_blog_masonry_image_mode_selection = array(
				'large' => esc_html__( 'Resize ( Large )', 'zuperla' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
			);

			$zuperla_eutf_search_grid_image_mode_selection = array(
				'square' => esc_html__( 'Square Small Crop', 'zuperla' ),
				'landscape' => esc_html__( 'Landscape Small Crop', 'zuperla' ),
				'portrait' => esc_html__( 'Portrait Small Crop', 'zuperla' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
			);

			$zuperla_eutf_search_masonry_image_mode_selection = array(
				'large' => esc_html__( 'Resize ( Large )', 'zuperla' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
			);

			$zuperla_eutf_blog_columns_selection = array(
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
			);
			$zuperla_eutf_blog_columns_selection_tablet = array(
				'2' => '2',
				'3' => '3',
				'4' => '4',
			);
			$zuperla_eutf_blog_columns_selection_mobile = array(
				'1' => '1',
				'2' => '2',
			);
			$zuperla_eutf_blog_headings_tag_selection = array(
				'auto' => esc_html__( 'Auto', 'zuperla' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'div'  => 'div',
			);

			$zuperla_eutf_blog_headings_selection = array(
				'auto' => esc_html__( 'Auto', 'zuperla' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'zuperla' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'zuperla' ),
				'small-text' => esc_html__( 'Small Text', 'zuperla' ),
				'link-text' => esc_html__( 'Link Text', 'zuperla' ),
			);

			$zuperla_eutf_event_headings_selection = array(
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
			);

			$zuperla_eutf_theme_layout_selection = array(
				'stretched' => esc_html__( 'Stretched', 'zuperla' ),
				'boxed' => esc_html__( 'Boxed', 'zuperla' ),
				'framed' => esc_html__( 'Framed', 'zuperla' ),
			);

			$zuperla_eutf_layout_selection = array(
				'none' => array('alt' => esc_html__( 'Full Width', 'zuperla' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
				'left' => array('alt' => esc_html__( 'Left Sidebar', 'zuperla' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png'),
				'right' => array('alt' => esc_html__( 'Right Sidebar', 'zuperla' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png'),
			);

			$zuperla_eutf_align_selection = array(
				'left' => esc_html__( 'Left', 'zuperla' ),
				'right' => esc_html__( 'Right', 'zuperla' ),
			);

			$zuperla_eutf_align_selection_extra = array(
				'left' => esc_html__( 'Left', 'zuperla' ),
				'center' => esc_html__( 'Center', 'zuperla' ),
				'right' => esc_html__( 'Right', 'zuperla' ),
			);

			$zuperla_eutf_align_selection_full = array(
				'left-top' => esc_html__( 'Left Top', 'zuperla' ),
				'left-center' => esc_html__( 'Left Center', 'zuperla' ),
				'left-bottom' => esc_html__( 'Left Bottom', 'zuperla' ),
				'center-top' => esc_html__( 'Center Top', 'zuperla' ),
				'center-center' => esc_html__( 'Center Center', 'zuperla' ),
				'center-bottom' => esc_html__( 'Center Bottom', 'zuperla' ),
				'right-top' => esc_html__( 'Right Top', 'zuperla' ),
				'right-center' => esc_html__( 'Right Center', 'zuperla' ),
				'right-bottom' => esc_html__( 'Right Bottom', 'zuperla' ),
			);

			$zuperla_eutf_animation_selection = array(
				'fade-in' => esc_html__( 'Default', 'zuperla' ),
				'none' => esc_html__( 'None', 'zuperla' ),
				'fade-in-up' => esc_html__( 'Fade In Up', 'zuperla' ),
				'fade-in-down' => esc_html__( 'Fade In Down', 'zuperla' ),
				'fade-in-left' => esc_html__( 'Fade In Left', 'zuperla' ),
				'fade-in-right' => esc_html__( 'Fade In Right', 'zuperla' ),
				'zoom-in' => esc_html__( 'Zoom In', 'zuperla' ),
				'zoom-out' => esc_html__( 'Zoom Out', 'zuperla' ),
			);

			$zuperla_eutf_title_bg_mode = array(
				'color' => esc_html__( 'Color Only', 'zuperla' ),
				'featured' => esc_html__( 'Featured Image', 'zuperla' ),
				'custom' => esc_html__( 'Custom Image', 'zuperla' ),
			);

			$zuperla_eutf_title_bg_mode_limited = array(
				'color' => esc_html__( 'Color Only', 'zuperla' ),
				'custom' => esc_html__( 'Custom Image', 'zuperla' ),

			);

			$zuperla_eutf_background_type = array(
				'transparent' => esc_html__( 'None', 'zuperla' ),
				'colored' => esc_html__( 'Background', 'zuperla' ),
				'advanced' => esc_html__( 'Stretched Background', 'zuperla' ),
			);

			$zuperla_eutf_header_menu_options = array(
				'search' => esc_html__( 'Search', 'zuperla' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7 or Gravity Forms Required Required)', 'zuperla' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'zuperla' ),
				//'login' => esc_html__( 'Login', 'zuperla' ),
				'cart' => esc_html__( 'Shopping Cart (WooCommerce Required)', 'zuperla' ),
				'social' => esc_html__( 'Social Icons', 'zuperla' ),
			);
			$zuperla_eutf_header_menu_options_default = array(
				'search' => false,
				'form' => false,
				'language' => false,
				//'login' => false,
				'cart' => false,
				'social' => false,
			);

			$zuperla_eutf_header_menu_selection = array(
				'default' => esc_html__( 'Default', 'zuperla' ),
				'disabled' => esc_html__( 'Disabled', 'zuperla' ),
			);

			$zuperla_eutf_top_bar_options = array(
				'menu' => esc_html__( 'Menu (Assigned: Menus - Manage Locations)', 'zuperla' ),
				'text' => esc_html__( 'Text', 'zuperla' ),
				'search' => esc_html__( 'Search', 'zuperla' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'zuperla' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7 or Gravity Forms Required)', 'zuperla' ),
				//'login' => esc_html__( 'Login', 'zuperla' ),
				'social' => esc_html__( 'Social Icons', 'zuperla' ),
			);
			$zuperla_eutf_top_bar_options_default = array(
				'menu' => false,
				'text' => false,
				'search' => false,
				'language' => false,
				'form' => false,
				//'login' => false,
				'social' => false,
			);

			$zuperla_eutf_menu_animations = array(
				'none' => esc_html__( 'None', 'zuperla' ),
				'fade-in' => esc_html__( 'Fade in', 'zuperla' ),
				'fade-in-up' => esc_html__( 'Fade in Up', 'zuperla' ),
				'fade-in-down' => esc_html__( 'Fade in Down', 'zuperla' ),
				'fade-in-left' => esc_html__( 'Fade in Left', 'zuperla' ),
				'fade-in-right' => esc_html__( 'Fade in Right', 'zuperla' ),
			);
			$zuperla_eutf_menu_pointers = array(
				'none' => esc_html__( 'None', 'zuperla' ),
				'arrow' => esc_html__( 'Arrow', 'zuperla' ),
				'arrow-not-first-level' => esc_html__( 'Arrow (exclude first level items)', 'zuperla' ),
			);

			$zuperla_eutf_color_selection = array(
				'dark' => esc_html__( 'Dark', 'zuperla' ),
				'light' => esc_html__( 'Light', 'zuperla' ),
				'primary-1' => esc_html__( 'Primary 1', 'zuperla' ),
				'primary-2' => esc_html__( 'Primary 2', 'zuperla' ),
				'primary-3' => esc_html__( 'Primary 3', 'zuperla' ),
				'primary-4' => esc_html__( 'Primary 4', 'zuperla' ),
				'primary-5' => esc_html__( 'Primary 5', 'zuperla' ),
				'primary-6' => esc_html__( 'Primary 6', 'zuperla' ),
			);
			$zuperla_eutf_color_selection_extra = array(
				'dark' => esc_html__( 'Dark', 'zuperla' ),
				'light' => esc_html__( 'Light', 'zuperla' ),
				'primary-1' => esc_html__( 'Primary 1', 'zuperla' ),
				'primary-2' => esc_html__( 'Primary 2', 'zuperla' ),
				'primary-3' => esc_html__( 'Primary 3', 'zuperla' ),
				'primary-4' => esc_html__( 'Primary 4', 'zuperla' ),
				'primary-5' => esc_html__( 'Primary 5', 'zuperla' ),
				'primary-6' => esc_html__( 'Primary 6', 'zuperla' ),
				'custom' => esc_html__( 'Custom', 'zuperla' ),
			);

			$zuperla_eutf_bg_color_selection = array(
				'none' => esc_html__( 'None', 'zuperla' ),
				'dark' => esc_html__( 'Dark', 'zuperla' ),
				'light' => esc_html__( 'Light', 'zuperla' ),
				'primary-1' => esc_html__( 'Primary 1', 'zuperla' ),
				'primary-2' => esc_html__( 'Primary 2', 'zuperla' ),
				'primary-3' => esc_html__( 'Primary 3', 'zuperla' ),
				'primary-4' => esc_html__( 'Primary 4', 'zuperla' ),
				'primary-5' => esc_html__( 'Primary 5', 'zuperla' ),
				'primary-6' => esc_html__( 'Primary 6', 'zuperla' ),
			);

			$zuperla_eutf_bg_color_selection_extra = array(
				'transparent' => esc_html__( 'Transparent', 'zuperla' ),
				'dark' => esc_html__( 'Dark', 'zuperla' ),
				'light' => esc_html__( 'Light', 'zuperla' ),
				'primary-1' => esc_html__( 'Primary 1', 'zuperla' ),
				'primary-2' => esc_html__( 'Primary 2', 'zuperla' ),
				'primary-3' => esc_html__( 'Primary 3', 'zuperla' ),
				'primary-4' => esc_html__( 'Primary 4', 'zuperla' ),
				'primary-5' => esc_html__( 'Primary 5', 'zuperla' ),
				'primary-6' => esc_html__( 'Primary 6', 'zuperla' ),
				'custom' => esc_html__( 'Custom', 'zuperla' ),
			);
			$zuperla_eutf_content_bg_color_selection_extra = array(
				'none' => esc_html__( 'None', 'zuperla' ),
				'dark' => esc_html__( 'Dark', 'zuperla' ),
				'light' => esc_html__( 'Light', 'zuperla' ),
				'primary-1' => esc_html__( 'Primary 1', 'zuperla' ),
				'primary-2' => esc_html__( 'Primary 2', 'zuperla' ),
				'primary-3' => esc_html__( 'Primary 3', 'zuperla' ),
				'primary-4' => esc_html__( 'Primary 4', 'zuperla' ),
				'primary-5' => esc_html__( 'Primary 5', 'zuperla' ),
				'primary-6' => esc_html__( 'Primary 6', 'zuperla' ),
				'custom' => esc_html__( 'Custom', 'zuperla' ),
			);

			$zuperla_eutf_header_mode_selection = array(
				'default' => array('alt' => esc_html__( 'Default', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-default.png' ),
				'logo-top' => array('alt' => esc_html__( 'Logo on Top', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-logo-top.png' ),
				'side' => array('alt' => esc_html__( 'Side', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-side.png' ),
			);
			$zuperla_eutf_header_menu_mode_selection = array(
				'default' => array('alt' => esc_html__( 'Default', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/menu/default-menu.png' ),
				'split' => array('alt' => esc_html__( 'Split', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/menu/split-menu.png' ),
			);

			$zuperla_eutf_header_style = array(
				'default' => esc_html__( 'Default', 'zuperla' ),
				'dark' => esc_html__( 'Dark', 'zuperla' ),
				'light' => esc_html__( 'Light', 'zuperla' ),
			);

			$zuperla_eutf_title_style = array(
				'advanced' => esc_html__( 'Advanced Title', 'zuperla' ),
				'simple' => esc_html__( 'Simple Title', 'zuperla' ),
			);

			$zuperla_eutf_enable_selection = array(
				'no' => esc_html__( 'No', 'zuperla' ),
				'yes' => esc_html__( 'Yes', 'zuperla' ),
			);

			$zuperla_eutf_menu_responsibe_style_selection = array(
				'1' => esc_html__( 'Style 1', 'zuperla' ),
				'2' => esc_html__( 'Style 2', 'zuperla' ),
			);

			$zuperla_eutf_menu_responsibe_toggle_selection = array(
				'icon' => esc_html__( 'Icon', 'zuperla' ),
				'text' => esc_html__( 'Text', 'zuperla' ),
			);

			$zuperla_eutf_footer_column_selection = array(
				'footer-1' => array('alt' => esc_html__( 'Footer 1', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-1.png' ),
				'footer-2' => array('alt' => esc_html__( 'Footer 2', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-2.png' ),
				'footer-3' => array('alt' => esc_html__( 'Footer 3', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-3.png' ),
				'footer-4' => array('alt' => esc_html__( 'Footer 4', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-4.png' ),
				'footer-5' => array('alt' => esc_html__( 'Footer 5', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-5.png' ),
				'footer-6' => array('alt' => esc_html__( 'Footer 6', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-6.png' ),
				'footer-7' => array('alt' => esc_html__( 'Footer 7', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-7.png' ),
				'footer-8' => array('alt' => esc_html__( 'Footer 8', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-8.png' ),
				'footer-9' => array('alt' => esc_html__( 'Footer 9', 'zuperla' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-9.png' ),
			);


			$zuperla_eutf_opacity_selection_simple = array(
				'0'  => '0%',
				'10' => '10%',
				'20' => '20%',
				'30' => '30%',
				'40' => '40%',
				'50' => '50%',
				'60' => '60%',
				'70' => '70%',
				'80' => '80%',
				'90' => '90%',
				'100'=> '100%',
			);

			$zuperla_eutf_opacity_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.10' => '10%',
				'0.15' => '15%',
				'0.20' => '20%',
				'0.25' => '25%',
				'0.30' => '30%',
				'0.35' => '35%',
				'0.40' => '40%',
				'0.45' => '45%',
				'0.50' => '50%',
				'0.55' => '55%',
				'0.60' => '60%',
				'0.65' => '65%',
				'0.70' => '70%',
				'0.75' => '75%',
				'0.80' => '80%',
				'0.85' => '85%',
				'0.90' => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);
			$zuperla_eutf_ratio_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.1'  => '10%',
				'0.15' => '15%',
				'0.2'  => '20%',
				'0.25' => '25%',
				'0.3'  => '30%',
				'0.35' => '35%',
				'0.4'  => '40%',
				'0.45' => '45%',
				'0.5'  => '50%',
				'0.55' => '55%',
				'0.6'  => '60%',
				'0.65' => '65%',
				'0.7'  => '70%',
				'0.75' => '75%',
				'0.8'  => '80%',
				'0.85'  => '85%',
				'0.9'  => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);

			$zuperla_eutf_headings_tag_selection = array(
				'div' => 'div',
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
			);

			$zuperla_eutf_headings_selection = array(
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'zuperla' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'zuperla' ),
				'small-text' => esc_html__( 'Small Text', 'zuperla' ),
				'link-text' => esc_html__( 'Link Text', 'zuperla' ),
			);

			$zuperla_eutf_pattern_selection = array(
				'none' => esc_html__( 'No', 'zuperla' ),
				'default' => esc_html__( 'Yes', 'zuperla' ),
			);

			$zuperla_eutf_padding_selection = array(
				'none' => esc_html__( 'None', 'zuperla' ),
				'1x' => esc_html__( '1x', 'zuperla' ),
				'2x' => esc_html__( '2x', 'zuperla' ),
				'3x' => esc_html__( '3x', 'zuperla' ),
				'4x' => esc_html__( '4x', 'zuperla' ),
				'5x' => esc_html__( '5x', 'zuperla' ),
				'6x' => esc_html__( '6x', 'zuperla' ),
			);
			$zuperla_eutf_padding_selection_extra = array(
				'none' => esc_html__( 'None', 'zuperla' ),
				'1x' => esc_html__( '1x', 'zuperla' ),
				'2x' => esc_html__( '2x', 'zuperla' ),
				'3x' => esc_html__( '3x', 'zuperla' ),
				'4x' => esc_html__( '4x', 'zuperla' ),
				'5x' => esc_html__( '5x', 'zuperla' ),
				'6x' => esc_html__( '6x', 'zuperla' ),
				'custom' => esc_html__( 'Custom', 'zuperla' ),
			);

			$zuperla_eutf_content_size_selection = array(
				'large' => esc_html__( 'Large', 'zuperla' ),
				'medium' => esc_html__( 'Medium', 'zuperla' ),
				'small' => esc_html__( 'Small', 'zuperla' ),
			);

			$zuperla_eutf_container_size_selection = array(
				'default' => esc_html__( 'Default', 'zuperla' ),
				'large' => esc_html__( 'Large', 'zuperla' ),
			);

			//Standard Fonts
			$zuperla_eutf_std_fonts = array(
				"Arial, Helvetica, sans-serif"                         => "Arial, Helvetica, sans-serif",
				"'Arial Black', Gadget, sans-serif"                    => "'Arial Black', Gadget, sans-serif",
				"'Bookman Old Style', serif"                           => "'Bookman Old Style', serif",
				"'Comic Sans MS', cursive"                             => "'Comic Sans MS', cursive",
				"Courier, monospace"                                   => "Courier, monospace",
				"Garamond, serif"                                      => "Garamond, serif",
				"Georgia, serif"                                       => "Georgia, serif",
				"Impact, Charcoal, sans-serif"                         => "Impact, Charcoal, sans-serif",
				"'Lucida Console', Monaco, monospace"                  => "'Lucida Console', Monaco, monospace",
				"'Lucida Sans Unicode', 'Lucida Grande', sans-serif"   => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
				"'MS Sans Serif', Geneva, sans-serif"                  => "'MS Sans Serif', Geneva, sans-serif",
				"'MS Serif', 'New York', sans-serif"                   => "'MS Serif', 'New York', sans-serif",
				"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
				"Tahoma,Geneva, sans-serif"                            => "Tahoma, Geneva, sans-serif",
				"'Times New Roman', Times,serif"                       => "'Times New Roman', Times, serif",
				"'Trebuchet MS', Helvetica, sans-serif"                => "'Trebuchet MS', Helvetica, sans-serif",
				"Verdana, Geneva, sans-serif"                          => "Verdana, Geneva, sans-serif",
			);
			$zuperla_eutf_std_fonts = apply_filters( 'zuperla_eutf_std_fonts', $zuperla_eutf_std_fonts );

			$zuperla_eutf_feature_section_post_types_selection = array(
				'page'   => esc_html__( 'Pages', 'zuperla' ),
				'portfolio'   => esc_html__( 'Portfolio Items', 'zuperla' ),
				'post'   => esc_html__( 'Posts', 'zuperla' ),
				'product'   => esc_html__( 'Products', 'zuperla' ),
				'tribe_events'   => esc_html__( 'Events', 'zuperla' ),
			);

			$zuperla_eutf_container_size_selector = array(
				'container' => esc_html__( 'Container Size' , 'zuperla' ),
				'large' => esc_html__( 'Large' , 'zuperla' ),
				'medium' => esc_html__( 'Medium' , 'zuperla' ),
				'small' => esc_html__( 'Small' , 'zuperla' ),
			);

			//Skin Presets
			$zuperla_eutf_skin_palette_1 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#2C0F73","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#2C0F73","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#2C0F73","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","default_header_label_bg_color":"#454545","default_header_label_text_color":"#ffffff","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#2C0F73","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#2C0F73","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#2C0F73","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#2C0F73","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#2C0F73","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#2C0F73","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0","responsive_header_background_color":"#ffffff","responsive_header_background_opacity":"1","responsive_header_elements_color":"#838383","responsive_header_elements_hover_color":"#000000","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#2C0F73","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#2C0F73","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","body_heading_color":"#000000","body_text_color":"#272727","body_text_link_color":"#000000","body_text_link_hover_color":"#2C0F73","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#2C0F73","body_primary_2_color":"#1472DE","body_primary_3_color":"#fe3956","body_primary_4_color":"#411992","body_primary_5_color":"#355880","body_primary_6_color":"#db5111","blog_title_bg_color":"primary-1","blog_title_bg_color_custom":"#f7f7f7","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#000000","blog_description_color":"light","blog_description_color_custom":"#9B9B9B","post_title_bg_color":"primary-1","post_title_bg_color_custom":"#f7f7f7","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#000000","post_description_color":"light","post_description_color_custom":"#9B9B9B","post_bar_background_color":"#f9f9f9","post_bar_nav_title_color":"#9b9b9b","post_bar_arrow_color":"#000000","page_title_bg_color":"primary-1","page_title_bg_color_custom":"#f7f7f7","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#000000","page_description_color":"light","page_description_color_custom":"#9B9B9B","search_page_title_bg_color":"primary-1","search_page_title_bg_color_custom":"#f7f7f7","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#000000","search_page_description_color":"light","search_page_description_color_custom":"#9B9B9B","portfolio_title_bg_color":"primary-1","portfolio_title_bg_color_custom":"#f7f7f7","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#000000","portfolio_description_color":"light","portfolio_description_color_custom":"#9B9B9B","portfolio_bar_background_color":"#f9f9f9","portfolio_bar_nav_title_color":"#9b9b9b","portfolio_bar_arrow_color":"#000000","product_tax_title_bg_color":"primary-1","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"primary-1","product_title_bg_color_custom":"#f7f7f7","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#9B9B9B","product_area_bg_color":"#ffffff","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#f9f9f9","product_bar_nav_title_color":"#9b9b9b","product_bar_arrow_color":"#000000","event_tax_title_bg_color":"primary-1","event_tax_title_bg_color_custom":"#f7f7f7","event_tax_title_content_bg_color":"none","event_tax_title_content_bg_color_custom":"#ffffff","event_tax_title_color":"light","event_tax_title_color_custom":"#000000","event_tax_description_color":"light","event_tax_description_color_custom":"#9B9B9B","event_title_bg_color":"primary-1","event_title_bg_color_custom":"#f7f7f7","event_title_content_bg_color":"none","event_title_content_bg_color_custom":"#ffffff","event_title_color":"light","event_title_color_custom":"#000000","event_description_color":"light","event_description_color_custom":"#9B9B9B","event_bar_background_color":"#f9f9f9","event_bar_nav_title_color":"#9b9b9b","event_bar_arrow_color":"#000000","forum_title_bg_color":"primary-1","forum_title_bg_color_custom":"#000000","forum_title_content_bg_color":"none","forum_title_content_bg_color_custom":"#ffffff","forum_title_color":"light","forum_title_color_custom":"#ffffff","footer_widgets_bg_color":"#1E1E1E","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#808080","footer_widgets_link_color":"#808080","footer_widgets_hover_color":"#ffffff","footer_widgets_border_color":"#1E1E1E","footer_bar_bg_color":"#1E1E1E","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#cecece","footer_bar_link_color":"#cecece","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#2C0F73","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#ffffff","sliding_area_title_color":"#000000","sliding_area_text_color":"#808080","sliding_area_link_color":"#808080","sliding_area_link_hover_color":"#000000","sliding_area_close_btn_color":"#808080","sliding_area_border_color":"#e9e9e9","sliding_area_overflow_background_color":"#000000","sliding_area_overflow_background_color_opacity":"0","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#e9e9e9","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$zuperla_eutf_skin_palette_2 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#15c7ff","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#15c7ff","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#15c7ff","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","default_header_label_bg_color":"#454545","default_header_label_text_color":"#ffffff","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#15c7ff","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#15c7ff","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#15c7ff","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#15c7ff","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#15c7ff","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#15c7ff","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0","responsive_header_background_color":"#ffffff","responsive_header_background_opacity":"1","responsive_header_elements_color":"#838383","responsive_header_elements_hover_color":"#000000","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#15c7ff","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#15c7ff","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","body_heading_color":"#000000","body_text_color":"#272727","body_text_link_color":"#000000","body_text_link_hover_color":"#15c7ff","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#15c7ff","body_primary_2_color":"#1472DE","body_primary_3_color":"#fe3956","body_primary_4_color":"#411992","body_primary_5_color":"#355880","body_primary_6_color":"#db5111","blog_title_bg_color":"primary-1","blog_title_bg_color_custom":"#f7f7f7","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#000000","blog_description_color":"light","blog_description_color_custom":"#9B9B9B","post_title_bg_color":"primary-1","post_title_bg_color_custom":"#f7f7f7","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#000000","post_description_color":"light","post_description_color_custom":"#9B9B9B","post_bar_background_color":"#f9f9f9","post_bar_nav_title_color":"#9b9b9b","post_bar_arrow_color":"#000000","page_title_bg_color":"primary-1","page_title_bg_color_custom":"#f7f7f7","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#000000","page_description_color":"light","page_description_color_custom":"#9B9B9B","search_page_title_bg_color":"primary-1","search_page_title_bg_color_custom":"#f7f7f7","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#000000","search_page_description_color":"light","search_page_description_color_custom":"#9B9B9B","portfolio_title_bg_color":"primary-1","portfolio_title_bg_color_custom":"#f7f7f7","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#000000","portfolio_description_color":"light","portfolio_description_color_custom":"#9B9B9B","portfolio_bar_background_color":"#f9f9f9","portfolio_bar_nav_title_color":"#9b9b9b","portfolio_bar_arrow_color":"#000000","product_tax_title_bg_color":"primary-1","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"primary-1","product_title_bg_color_custom":"#f7f7f7","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#9B9B9B","product_area_bg_color":"#ffffff","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#f9f9f9","product_bar_nav_title_color":"#9b9b9b","product_bar_arrow_color":"#000000","event_tax_title_bg_color":"primary-1","event_tax_title_bg_color_custom":"#f7f7f7","event_tax_title_content_bg_color":"none","event_tax_title_content_bg_color_custom":"#ffffff","event_tax_title_color":"light","event_tax_title_color_custom":"#000000","event_tax_description_color":"light","event_tax_description_color_custom":"#9B9B9B","event_title_bg_color":"primary-1","event_title_bg_color_custom":"#f7f7f7","event_title_content_bg_color":"none","event_title_content_bg_color_custom":"#ffffff","event_title_color":"light","event_title_color_custom":"#000000","event_description_color":"light","event_description_color_custom":"#9B9B9B","event_bar_background_color":"#f9f9f9","event_bar_nav_title_color":"#9b9b9b","event_bar_arrow_color":"#000000","forum_title_bg_color":"primary-1","forum_title_bg_color_custom":"#000000","forum_title_content_bg_color":"none","forum_title_content_bg_color_custom":"#ffffff","forum_title_color":"light","forum_title_color_custom":"#ffffff","footer_widgets_bg_color":"#1E1E1E","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#808080","footer_widgets_link_color":"#808080","footer_widgets_hover_color":"#ffffff","footer_widgets_border_color":"#1E1E1E","footer_bar_bg_color":"#1E1E1E","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#cecece","footer_bar_link_color":"#cecece","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#15c7ff","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#ffffff","sliding_area_title_color":"#000000","sliding_area_text_color":"#808080","sliding_area_link_color":"#808080","sliding_area_link_hover_color":"#000000","sliding_area_close_btn_color":"#808080","sliding_area_border_color":"#e9e9e9","sliding_area_overflow_background_color":"#000000","sliding_area_overflow_background_color_opacity":"0","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#e9e9e9","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$zuperla_eutf_skin_palette_3 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#e01076","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#e01076","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#e01076","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","default_header_label_bg_color":"#454545","default_header_label_text_color":"#ffffff","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#e01076","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#e01076","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#e01076","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#e01076","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#e01076","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#e01076","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0","responsive_header_background_color":"#ffffff","responsive_header_background_opacity":"1","responsive_header_elements_color":"#838383","responsive_header_elements_hover_color":"#000000","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#e01076","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#e01076","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","body_heading_color":"#000000","body_text_color":"#272727","body_text_link_color":"#000000","body_text_link_hover_color":"#e01076","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#e01076","body_primary_2_color":"#1472DE","body_primary_3_color":"#fe3956","body_primary_4_color":"#411992","body_primary_5_color":"#355880","body_primary_6_color":"#db5111","blog_title_bg_color":"primary-1","blog_title_bg_color_custom":"#f7f7f7","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#000000","blog_description_color":"light","blog_description_color_custom":"#9B9B9B","post_title_bg_color":"primary-1","post_title_bg_color_custom":"#f7f7f7","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#000000","post_description_color":"light","post_description_color_custom":"#9B9B9B","post_bar_background_color":"#f9f9f9","post_bar_nav_title_color":"#9b9b9b","post_bar_arrow_color":"#000000","page_title_bg_color":"primary-1","page_title_bg_color_custom":"#f7f7f7","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#000000","page_description_color":"light","page_description_color_custom":"#9B9B9B","search_page_title_bg_color":"primary-1","search_page_title_bg_color_custom":"#f7f7f7","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#000000","search_page_description_color":"light","search_page_description_color_custom":"#9B9B9B","portfolio_title_bg_color":"primary-1","portfolio_title_bg_color_custom":"#f7f7f7","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#000000","portfolio_description_color":"light","portfolio_description_color_custom":"#9B9B9B","portfolio_bar_background_color":"#f9f9f9","portfolio_bar_nav_title_color":"#9b9b9b","portfolio_bar_arrow_color":"#000000","product_tax_title_bg_color":"primary-1","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"primary-1","product_title_bg_color_custom":"#f7f7f7","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#9B9B9B","product_area_bg_color":"#ffffff","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#f9f9f9","product_bar_nav_title_color":"#9b9b9b","product_bar_arrow_color":"#000000","event_tax_title_bg_color":"primary-1","event_tax_title_bg_color_custom":"#f7f7f7","event_tax_title_content_bg_color":"none","event_tax_title_content_bg_color_custom":"#ffffff","event_tax_title_color":"light","event_tax_title_color_custom":"#000000","event_tax_description_color":"light","event_tax_description_color_custom":"#9B9B9B","event_title_bg_color":"primary-1","event_title_bg_color_custom":"#f7f7f7","event_title_content_bg_color":"none","event_title_content_bg_color_custom":"#ffffff","event_title_color":"light","event_title_color_custom":"#000000","event_description_color":"light","event_description_color_custom":"#9B9B9B","event_bar_background_color":"#f9f9f9","event_bar_nav_title_color":"#9b9b9b","event_bar_arrow_color":"#000000","forum_title_bg_color":"primary-1","forum_title_bg_color_custom":"#000000","forum_title_content_bg_color":"none","forum_title_content_bg_color_custom":"#ffffff","forum_title_color":"light","forum_title_color_custom":"#ffffff","footer_widgets_bg_color":"#1E1E1E","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#808080","footer_widgets_link_color":"#808080","footer_widgets_hover_color":"#ffffff","footer_widgets_border_color":"#1E1E1E","footer_bar_bg_color":"#1E1E1E","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#cecece","footer_bar_link_color":"#cecece","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#e01076","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#ffffff","sliding_area_title_color":"#000000","sliding_area_text_color":"#808080","sliding_area_link_color":"#808080","sliding_area_link_hover_color":"#000000","sliding_area_close_btn_color":"#808080","sliding_area_border_color":"#e9e9e9","sliding_area_overflow_background_color":"#000000","sliding_area_overflow_background_color_opacity":"0","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#e9e9e9","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$zuperla_eutf_skin_palette_4 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#6eca09","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#6eca09","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#6eca09","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","default_header_label_bg_color":"#454545","default_header_label_text_color":"#ffffff","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#6eca09","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#6eca09","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#6eca09","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#6eca09","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#6eca09","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#6eca09","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0","responsive_header_background_color":"#ffffff","responsive_header_background_opacity":"1","responsive_header_elements_color":"#838383","responsive_header_elements_hover_color":"#000000","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#6eca09","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#6eca09","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","body_heading_color":"#000000","body_text_color":"#272727","body_text_link_color":"#000000","body_text_link_hover_color":"#6eca09","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#6eca09","body_primary_2_color":"#1472DE","body_primary_3_color":"#fe3956","body_primary_4_color":"#411992","body_primary_5_color":"#355880","body_primary_6_color":"#db5111","blog_title_bg_color":"primary-1","blog_title_bg_color_custom":"#f7f7f7","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#000000","blog_description_color":"light","blog_description_color_custom":"#9B9B9B","post_title_bg_color":"primary-1","post_title_bg_color_custom":"#f7f7f7","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#000000","post_description_color":"light","post_description_color_custom":"#9B9B9B","post_bar_background_color":"#f9f9f9","post_bar_nav_title_color":"#9b9b9b","post_bar_arrow_color":"#000000","page_title_bg_color":"primary-1","page_title_bg_color_custom":"#f7f7f7","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#000000","page_description_color":"light","page_description_color_custom":"#9B9B9B","search_page_title_bg_color":"primary-1","search_page_title_bg_color_custom":"#f7f7f7","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#000000","search_page_description_color":"light","search_page_description_color_custom":"#9B9B9B","portfolio_title_bg_color":"primary-1","portfolio_title_bg_color_custom":"#f7f7f7","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#000000","portfolio_description_color":"light","portfolio_description_color_custom":"#9B9B9B","portfolio_bar_background_color":"#f9f9f9","portfolio_bar_nav_title_color":"#9b9b9b","portfolio_bar_arrow_color":"#000000","product_tax_title_bg_color":"primary-1","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"primary-1","product_title_bg_color_custom":"#f7f7f7","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#9B9B9B","product_area_bg_color":"#ffffff","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#f9f9f9","product_bar_nav_title_color":"#9b9b9b","product_bar_arrow_color":"#000000","event_tax_title_bg_color":"primary-1","event_tax_title_bg_color_custom":"#f7f7f7","event_tax_title_content_bg_color":"none","event_tax_title_content_bg_color_custom":"#ffffff","event_tax_title_color":"light","event_tax_title_color_custom":"#000000","event_tax_description_color":"light","event_tax_description_color_custom":"#9B9B9B","event_title_bg_color":"primary-1","event_title_bg_color_custom":"#f7f7f7","event_title_content_bg_color":"none","event_title_content_bg_color_custom":"#ffffff","event_title_color":"light","event_title_color_custom":"#000000","event_description_color":"light","event_description_color_custom":"#9B9B9B","event_bar_background_color":"#f9f9f9","event_bar_nav_title_color":"#9b9b9b","event_bar_arrow_color":"#000000","forum_title_bg_color":"primary-1","forum_title_bg_color_custom":"#000000","forum_title_content_bg_color":"none","forum_title_content_bg_color_custom":"#ffffff","forum_title_color":"light","forum_title_color_custom":"#ffffff","footer_widgets_bg_color":"#1E1E1E","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#808080","footer_widgets_link_color":"#808080","footer_widgets_hover_color":"#ffffff","footer_widgets_border_color":"#1E1E1E","footer_bar_bg_color":"#1E1E1E","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#cecece","footer_bar_link_color":"#cecece","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#6eca09","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#ffffff","sliding_area_title_color":"#000000","sliding_area_text_color":"#808080","sliding_area_link_color":"#808080","sliding_area_link_hover_color":"#000000","sliding_area_close_btn_color":"#808080","sliding_area_border_color":"#e9e9e9","sliding_area_overflow_background_color":"#000000","sliding_area_overflow_background_color_opacity":"0","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#e9e9e9","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$zuperla_eutf_skin_palette_5 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#0652fd","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#0652fd","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#0652fd","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","default_header_label_bg_color":"#454545","default_header_label_text_color":"#ffffff","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#0652fd","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#0652fd","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#0652fd","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#0652fd","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#0652fd","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#0652fd","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0","responsive_header_background_color":"#ffffff","responsive_header_background_opacity":"1","responsive_header_elements_color":"#838383","responsive_header_elements_hover_color":"#000000","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#0652fd","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#0652fd","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","body_heading_color":"#000000","body_text_color":"#272727","body_text_link_color":"#000000","body_text_link_hover_color":"#0652fd","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#0652fd","body_primary_2_color":"#1472DE","body_primary_3_color":"#fe3956","body_primary_4_color":"#411992","body_primary_5_color":"#355880","body_primary_6_color":"#db5111","blog_title_bg_color":"primary-1","blog_title_bg_color_custom":"#f7f7f7","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#000000","blog_description_color":"light","blog_description_color_custom":"#9B9B9B","post_title_bg_color":"primary-1","post_title_bg_color_custom":"#f7f7f7","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#000000","post_description_color":"light","post_description_color_custom":"#9B9B9B","post_bar_background_color":"#f9f9f9","post_bar_nav_title_color":"#9b9b9b","post_bar_arrow_color":"#000000","page_title_bg_color":"primary-1","page_title_bg_color_custom":"#f7f7f7","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#000000","page_description_color":"light","page_description_color_custom":"#9B9B9B","search_page_title_bg_color":"primary-1","search_page_title_bg_color_custom":"#f7f7f7","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#000000","search_page_description_color":"light","search_page_description_color_custom":"#9B9B9B","portfolio_title_bg_color":"primary-1","portfolio_title_bg_color_custom":"#f7f7f7","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#000000","portfolio_description_color":"light","portfolio_description_color_custom":"#9B9B9B","portfolio_bar_background_color":"#f9f9f9","portfolio_bar_nav_title_color":"#9b9b9b","portfolio_bar_arrow_color":"#000000","product_tax_title_bg_color":"primary-1","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"primary-1","product_title_bg_color_custom":"#f7f7f7","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#9B9B9B","product_area_bg_color":"#ffffff","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#f9f9f9","product_bar_nav_title_color":"#9b9b9b","product_bar_arrow_color":"#000000","event_tax_title_bg_color":"primary-1","event_tax_title_bg_color_custom":"#f7f7f7","event_tax_title_content_bg_color":"none","event_tax_title_content_bg_color_custom":"#ffffff","event_tax_title_color":"light","event_tax_title_color_custom":"#000000","event_tax_description_color":"light","event_tax_description_color_custom":"#9B9B9B","event_title_bg_color":"primary-1","event_title_bg_color_custom":"#f7f7f7","event_title_content_bg_color":"none","event_title_content_bg_color_custom":"#ffffff","event_title_color":"light","event_title_color_custom":"#000000","event_description_color":"light","event_description_color_custom":"#9B9B9B","event_bar_background_color":"#f9f9f9","event_bar_nav_title_color":"#9b9b9b","event_bar_arrow_color":"#000000","forum_title_bg_color":"primary-1","forum_title_bg_color_custom":"#000000","forum_title_content_bg_color":"none","forum_title_content_bg_color_custom":"#ffffff","forum_title_color":"light","forum_title_color_custom":"#ffffff","footer_widgets_bg_color":"#1E1E1E","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#808080","footer_widgets_link_color":"#808080","footer_widgets_hover_color":"#ffffff","footer_widgets_border_color":"#1E1E1E","footer_bar_bg_color":"#1E1E1E","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#cecece","footer_bar_link_color":"#cecece","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#0652fd","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#ffffff","sliding_area_title_color":"#000000","sliding_area_text_color":"#808080","sliding_area_link_color":"#808080","sliding_area_link_hover_color":"#000000","sliding_area_close_btn_color":"#808080","sliding_area_border_color":"#e9e9e9","sliding_area_overflow_background_color":"#000000","sliding_area_overflow_background_color_opacity":"0","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#e9e9e9","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$zuperla_eutf_skin_palette_6 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#f5a623","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#f5a623","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#f5a623","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","default_header_label_bg_color":"#454545","default_header_label_text_color":"#ffffff","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#f5a623","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#f5a623","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#f5a623","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#f5a623","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#f5a623","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#f5a623","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0","responsive_header_background_color":"#ffffff","responsive_header_background_opacity":"1","responsive_header_elements_color":"#838383","responsive_header_elements_hover_color":"#000000","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#f5a623","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#f5a623","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","body_heading_color":"#000000","body_text_color":"#272727","body_text_link_color":"#000000","body_text_link_hover_color":"#f5a623","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#f5a623","body_primary_2_color":"#1472DE","body_primary_3_color":"#fe3956","body_primary_4_color":"#411992","body_primary_5_color":"#355880","body_primary_6_color":"#db5111","blog_title_bg_color":"primary-1","blog_title_bg_color_custom":"#f7f7f7","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#000000","blog_description_color":"light","blog_description_color_custom":"#9B9B9B","post_title_bg_color":"primary-1","post_title_bg_color_custom":"#f7f7f7","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#000000","post_description_color":"light","post_description_color_custom":"#9B9B9B","post_bar_background_color":"#f9f9f9","post_bar_nav_title_color":"#9b9b9b","post_bar_arrow_color":"#000000","page_title_bg_color":"primary-1","page_title_bg_color_custom":"#f7f7f7","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#000000","page_description_color":"light","page_description_color_custom":"#9B9B9B","search_page_title_bg_color":"primary-1","search_page_title_bg_color_custom":"#f7f7f7","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#000000","search_page_description_color":"light","search_page_description_color_custom":"#9B9B9B","portfolio_title_bg_color":"primary-1","portfolio_title_bg_color_custom":"#f7f7f7","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#000000","portfolio_description_color":"light","portfolio_description_color_custom":"#9B9B9B","portfolio_bar_background_color":"#f9f9f9","portfolio_bar_nav_title_color":"#9b9b9b","portfolio_bar_arrow_color":"#000000","product_tax_title_bg_color":"primary-1","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"primary-1","product_title_bg_color_custom":"#f7f7f7","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#9B9B9B","product_area_bg_color":"#ffffff","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#f9f9f9","product_bar_nav_title_color":"#9b9b9b","product_bar_arrow_color":"#000000","event_tax_title_bg_color":"primary-1","event_tax_title_bg_color_custom":"#f7f7f7","event_tax_title_content_bg_color":"none","event_tax_title_content_bg_color_custom":"#ffffff","event_tax_title_color":"light","event_tax_title_color_custom":"#000000","event_tax_description_color":"light","event_tax_description_color_custom":"#9B9B9B","event_title_bg_color":"primary-1","event_title_bg_color_custom":"#f7f7f7","event_title_content_bg_color":"none","event_title_content_bg_color_custom":"#ffffff","event_title_color":"light","event_title_color_custom":"#000000","event_description_color":"light","event_description_color_custom":"#9B9B9B","event_bar_background_color":"#f9f9f9","event_bar_nav_title_color":"#9b9b9b","event_bar_arrow_color":"#000000","forum_title_bg_color":"primary-1","forum_title_bg_color_custom":"#000000","forum_title_content_bg_color":"none","forum_title_content_bg_color_custom":"#ffffff","forum_title_color":"light","forum_title_color_custom":"#ffffff","footer_widgets_bg_color":"#1E1E1E","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#808080","footer_widgets_link_color":"#808080","footer_widgets_hover_color":"#ffffff","footer_widgets_border_color":"#1E1E1E","footer_bar_bg_color":"#1E1E1E","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#cecece","footer_bar_link_color":"#cecece","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#f5a623","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#ffffff","sliding_area_title_color":"#000000","sliding_area_text_color":"#808080","sliding_area_link_color":"#808080","sliding_area_link_hover_color":"#000000","sliding_area_close_btn_color":"#808080","sliding_area_border_color":"#e9e9e9","sliding_area_overflow_background_color":"#000000","sliding_area_overflow_background_color_opacity":"0","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#e9e9e9","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';

			$zuperla_gmap_api_key_link = '<a href="//developers.google.com/maps/documentation/javascript/get-api-key" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Generate Google Map API Key', 'zuperla' ) . '</a>';
			$zuperla_gmap_style_link = '<a href="//mapstyle.withgoogle.com/" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Styling Wizard Google Maps API.', 'zuperla' ) . '</a>';

			$zuperla_is_google = apply_filters( 'zuperla_eutf_gfonts_visibility', true );
			// ACTUAL DECLARATION OF SECTIONS

			$this->sections[] = array(
				'icon' => 'el-icon-cogs',
				'title' => esc_html__( 'General Settings', 'zuperla' ),
				'id' => 'eut_redux_section_general_settings',
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'theme_layout',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Theme Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select between Streched or Boxed for the theme basic Layout.', 'zuperla' ),
						'options' => $zuperla_eutf_theme_layout_selection,
						'default' => 'stretched',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'boxed_size',
						'type' => 'text',
						'default' => '1440',
						'title' => esc_html__( 'Theme Wrapper Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Theme Wrapper width in px (Default is 1440).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'theme_layout', 'equals', 'boxed' ),
					),
					array(
						'id' => 'frame_size',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Frame Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter frame size in px (Default is 30).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'theme_layout', 'equals', 'framed' ),
					),
					array(
						'id'          => 'frame_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Frame Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select a color for the framed layout.', 'zuperla' ),
						'default'     => '#ffffff',
						'required' => array( 'theme_layout', 'equals', 'framed' ),
						'transparent' => false,
					),
					array(
						'id' => 'container_size',
						'type' => 'text',
						'default' => '1390',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Container width in px (Default is 1390).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id'       => 'body_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Theme Background Image / Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image or color for the theme.', 'zuperla' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#171A1D',
						),
					),
					array(
						'id'       => 'content_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Content Background Image / Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image or color for the content.', 'zuperla' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#ffffff',
						),
					),
					array(
						'id'=>'theme_loader',
						'type' => 'switch',
						'title' => esc_html__( 'Theme Loader', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader.', 'zuperla' ),
						'default' => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'show_spinner',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Spinner', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader Spinner.', 'zuperla' ),
						'default' => '1',
						'1' => esc_html__( 'On', 'zuperla' ),
						'0' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'theme_loader', 'equals', '1' ),
					),
					array(
						'id' => 'page_transition',
						'type' => 'select',
						'title' => esc_html__( 'Page Transition', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the page transition when navigating from one page to another. It is worth noting that it maybe causes problems with plugins which use ajax requests.', 'zuperla' ),
						'options' => array(
							'none' => esc_html__( 'None', 'zuperla' ),
							'fade-in' => esc_html__( 'Fade In', 'zuperla' ),
							'left-to-right' => esc_html__( 'Left to Right', 'zuperla' ),
							'right-to-left' => esc_html__( 'Right to Left', 'zuperla' ),
							'top-to-bottom' => esc_html__( 'Top to Bottom', 'zuperla' ),
							'bottom-to-top' => esc_html__( 'Bottom to Top', 'zuperla' ),
							'zoom-out' => esc_html__( 'Zoom Out', 'zuperla' ),
						),
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'theme_loader', 'equals', '1' ),
					),
					array(
						'id' => 'replace_admin_logo',
						'type' => 'switch',
						'title' => esc_html__( 'Replace Admin Logo', 'zuperla' ),
						'subtitle'=> esc_html__( 'Replace the backend admin logo with your company logo.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'       => 'admin_logo',
						'type'     => 'media',
						'title' => esc_html__( 'Admin Logo', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the image for your company logo. ( If empty Logo Default will be used instead )', 'zuperla' ),
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
					array(
						'id' => 'admin_logo_height',
						'type' => 'text',
						'default' => '84',
						'title' => esc_html__( 'Admin Logo Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the company logo height in px (Default is 84).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Logos', 'zuperla' ),
				'id' => 'eut_redux_section_logos',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-photo',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'logo',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Default Header', 'zuperla' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-default.png', 'width' => '172', 'height' => '72' ),
						'subtitle' => esc_html__( 'Upload the logo for the Default Header.', 'zuperla' ),
					),
					array(
						'id' => 'logo_light',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Light Header', 'zuperla' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-light.png', 'width' => '172', 'height' => '72' ),
						'subtitle' => esc_html__( 'Upload the logo for the Light Header.', 'zuperla' ),
					),
					array(
						'id' => 'logo_dark',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Dark Header', 'zuperla' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-default.png', 'width' => '172', 'height' => '72' ),
						'subtitle' => esc_html__( 'Upload the logo for the Dark Header.', 'zuperla' ),
					),
					array(
						'id' => 'logo_side',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Side Header', 'zuperla' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-side.png', 'width' => '172', 'height' => '72' ),
						'subtitle' => esc_html__( 'Upload the logo for the Side Header.', 'zuperla' ),
					),
					array(
						'id' => 'logo_sticky',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Sticky Header', 'zuperla' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-sticky.png', 'width' => '150', 'height' => '62' ),
						'subtitle' => esc_html__( 'Upload the logo for the Sticky Header.', 'zuperla' ),
					),
					array(
						'id' => 'logo_responsive',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Responsive Header', 'zuperla' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-responsive.png', 'width' => '150', 'height' => '62' ),
						'subtitle' => esc_html__( 'Upload the logo for the Responsive Header.', 'zuperla' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Top Bar Options', 'zuperla' ),
				'id' => 'eut_redux_section_top_bar_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the TopBar area, just above the Header, in order to add various elements in two different positions, left and right.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-arrow-up',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'top_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Top Bar Area', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the TopBar Area, the area just above your header.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'             => 'top_bar_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Top Bar Spacing', 'zuperla' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the TopBar Area.', 'zuperla' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'zuperla'),
						'default'        => array(
							'padding-top'     => '15px',
							'padding-bottom'  => '15px',
							'units'           => 'px',
						),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Top Bar Full Width', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Top Bar Area.', 'zuperla' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'zuperla' ),
							'fullwidth-element' => esc_html__( 'Yes', 'zuperla' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_top_bar_left',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Left Top Bar Area', 'zuperla' ),
						'desc' => esc_html__( 'In side navigation mode, Left Top Bar Area is shown first.', 'zuperla' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_left_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Left Area', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Left TopBar Area.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_left_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Left Area Elements', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Left TopBar Area.', 'zuperla' ),
						'options' => $zuperla_eutf_top_bar_options,
						'default' => $zuperla_eutf_top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_text',
						'type' => 'text',
						'title' => esc_html__( 'Left Area Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Left TopBar Area.', 'zuperla' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_left_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Left Form Type', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'zuperla' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'zuperla' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'zuperla' ),
						),
						'default' => 'contact-form',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_form',
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'zuperla' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'top_bar_left_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'zuperla' ),
						'options' => $zuperla_eutf_gravity_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id' => 'top_bar_left_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Left Area Social Icons', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'zuperla' ),
						'desc' => '',
						'class' => 'eut-redux-columns',
						'label' => true,
						'options' => $zuperla_eutf_social_options,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'   => 'info_top_bar_right',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Right Top Bar Area', 'zuperla' ),
						'desc' => esc_html__( 'In side navigation mode, Right Top Bar Area is shown second.', 'zuperla' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_right_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Right Area', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Right TopBar Area.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_right_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Right Area Elements', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Right TopBar Area.', 'zuperla' ),
						'options' => $zuperla_eutf_top_bar_options,
						'default' => $zuperla_eutf_top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_text',
						'type' => 'text',
						'title' => esc_html__( 'Right Area Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Right TopBar Area.', 'zuperla' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_right_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Right Form Type', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'zuperla' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'zuperla' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'zuperla' ),
						),
						'default' => 'contact-form',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_form',
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'zuperla' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'top_bar_right_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'zuperla' ),
						'options' => $zuperla_eutf_gravity_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id' => 'top_bar_right_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Right Area Social Icons', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'zuperla' ),
						'label' => true,
						'class' => 'eut-redux-columns',
						'options' => $zuperla_eutf_social_options,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header Options', 'zuperla' ),
				'id' => 'eut_redux_section_header_options',
				'header' => '',
				'desc' => esc_html__( 'Here you can set your preferences for the Theme Header(Logo, Menu and Menu Elements). Notice that most of the options below depend on your first selection where you have to select among Default, Logo on Top or Side Navigation Header.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'header_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Header Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your Header Mode. keep in mind that this is one of the most important options for the appearance of your site. Your selection here will determine the following section options.', 'zuperla' ),
						'options' => $zuperla_eutf_header_mode_selection,
						'default' => 'default',
					),
					array(
						'id'=>'header_menu_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Main Menu Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your main menu mode. Select between default and split menu', 'zuperla' ),
						'options' => $zuperla_eutf_header_menu_mode_selection,
						'default' => 'default',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id'=>'split_menu_item_position',
						'type' => 'button_set',
						'title' => esc_html__( 'Extra Menu Item Position ', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select where you want to place the extra menu item in case of even menu items.', 'zuperla' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'zuperla' ),
							'right' => esc_html__( 'Right', 'zuperla' ),
						),
						'default' => 'left',
						'required' => array(
							array( 'header_mode', 'equals', 'default' ),
							array( 'header_menu_mode', 'equals', 'split' ),
						),
					),
					array(
						'id' => 'header_height',
						'type' => 'text',
						'default' => '140',
						'title' => esc_html__( 'Header Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Header height in px (Default is 140).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'header_side_width',
						'type' => 'text',
						'default' => '300',
						'title' => esc_html__( 'Header Width', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Header Width in px (Default is 300).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'             => 'header_side_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'top'           => 'false',
						'bottom'          => 'false',
						'title'          => esc_html__( 'Spacing', 'zuperla' ),
						'subtitle'       => esc_html__( 'Set the spacings for the content of the Header.', 'zuperla' ),
						'desc'           => esc_html__( 'Set spacing Right, Left in px.', 'zuperla'),
						'default'        => array(
							'padding-left'     => '30px',
							'padding-right'  => '30px',
							'units'           => 'px',
						),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'       => 'header_side_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Header Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode_limited,
						'default'  => 'color',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'       => 'header_side_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the header.', 'zuperla' ),
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Full Width', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable/Disable full width Header.', 'zuperla' ),
						'default' => 1,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id'   => 'info_logo_default_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Default Header', 'zuperla' ),
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'logo_height',
						'type' => 'text',
						'default' => '36',
						'title' => esc_html__( 'Logo Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 36).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id'   => 'info_logo_ontop_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Logo on Top Header', 'zuperla' ),
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_height',
						'type' => 'text',
						'default' => '36',
						'title' => esc_html__( 'Logo Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 36).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_height',
						'type' => 'text',
						'default' => '180',
						'title' => esc_html__( 'Logo Area Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Logo Area Height in px (Default is 120).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Logo Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Align your Logo as you wish.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id'   => 'info_logo_side_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Side Header', 'zuperla' ),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_logo_height',
						'type' => 'text',
						'default' => '90',
						'title' => esc_html__( 'Logo Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Logo Height in px (Default is 90).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_logo_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Logo Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Align your Logo as you wish.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'             => 'header_side_logo_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Spacing', 'zuperla' ),
						'subtitle'       => esc_html__( 'Set the spacings of the Logo.', 'zuperla' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'zuperla'),
						'default'        => array(
							'padding-top'     => '100px',
							'padding-bottom'  => '100px',
							'units'           => 'px',
						),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'   => 'info_menu_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Menu Options', 'zuperla' ),
					),
					array(
						'id' => 'menu_type',
						'type' => 'select',
						'title' => esc_html__( 'Menu Type', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the type of the Main Menu.', 'zuperla' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'zuperla' ),
							'button' => esc_html__( 'Button Style', 'zuperla' ),
							'underline' => esc_html__( 'Underline', 'zuperla' ),
							'hidden' => esc_html__( 'Hidden', 'zuperla' ),
							'advanced-hidden' => esc_html__( 'Advanced Hidden', 'zuperla' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'right',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'default' ),
							array( 'header_menu_mode', 'equals', 'default' ),
							array( 'menu_type', '!=', 'hidden' ),
						),
					),
					array(
						'id' => 'header_bottom_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Menu Area Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Menu Area Height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_menu_type',
						'type' => 'select',
						'title' => esc_html__( 'Menu Type', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the type of the Main Menu.', 'zuperla' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'zuperla' ),
							'button' => esc_html__( 'Button Style', 'zuperla' ),
							'underline' => esc_html__( 'Underline', 'zuperla' ),
							'hidden' => esc_html__( 'Hidden', 'zuperla' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'logo-top' ),
							array( 'header_top_logo_menu_type', '!=', 'hidden' ),
						),
					),
					array(
						'id' => 'submenu_pointer',
						'type' => 'select',
						'title' => esc_html__( 'Sub Menu Pointer', 'zuperla' ),
						'subtitle'=> esc_html__( 'Choose pointer for the submenu.', 'zuperla' ),
						'desc' => esc_html__( "Note: This setting will not affect hidden menu.", 'zuperla' ),
						'options' => $zuperla_eutf_menu_pointers,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id' => 'submenu_top_position',
						'type' => 'text',
						'default' => '0',
						'title' => esc_html__( 'Sub Menu Position', 'zuperla' ),
						'subtitle' => esc_html__( 'Define the distance between the top position of the Submenu and the bottom of the Header in px. (Default is 0 - Submenu starts at the bottom of the Header).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id' => 'header_menu_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Type', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your menu type.', 'zuperla' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'zuperla' ),
							'slide' => esc_html__( 'Slide', 'zuperla' ),
						),
						'default' => 'toggle',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
						),

					),
					array(
						'id'   => 'info_menu_elements',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Menu Elements Options', 'zuperla' ),
					),
					array(
						'id'=>'header_menu_options_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Menu Elements', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or disable the use of various elements in your header like socials, search, language selector and Contact Form.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'header_menu_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Menu Elements Options', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable / Disable various menu elements options.', 'zuperla' ),
						'options' => $zuperla_eutf_header_menu_options,
						'default' => $zuperla_eutf_header_menu_options_default,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'header_menu_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Menu Form Type', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'zuperla' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'zuperla' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'zuperla' ),
						),
						'default' => 'contact-form',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_form',
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'zuperla' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'header_menu_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'zuperla' ),
						'options' => $zuperla_eutf_gravity_options,
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id'=>'header_menu_social_mode',
						'type' => 'select',
						'title' => esc_html__( 'Menu Social Icons Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social icons single or modal.', 'zuperla' ),
						'options' => array(
							'modal' => esc_html__( 'Modal Popup', 'zuperla' ),
							'single' => esc_html__( 'Single Social Icons', 'zuperla' ),
						),
						"default" => 'modal',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Menu Social Icons', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the social icons.', 'zuperla' ),
						'desc' => '',
						'class' => 'eut-redux-columns',
						'label' => true,
						'options' => $zuperla_eutf_social_options,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Sticky Header Options', 'zuperla' ),
				'id' => 'eut_redux_section_sticky_header_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the Sticky Header option if you want to provide constant access to the Header elements while visitors scroll down the page. These settings will not affect if you select the Side Header Mode in Theme Options > Header Options.', 'zuperla' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'header_sticky_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Header', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header option.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array(
							array( 'header_mode', '!=', 'side' ),
						),
					),
					array(
						'id' => 'header_sticky_type',
						'type' => 'select',
						'title' => esc_html__( 'Sticky Header Type', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the type of the Sticky Header.', 'zuperla' ),
						'options' => array(
							'simple' => esc_html__( 'Simple', 'zuperla' ),
							'shrink' => esc_html__( 'Shrink', 'zuperla' ),
							'scrollup' => esc_html__( 'Scroll Up', 'zuperla' ),
						),
						'default' => 'simple',
						'validate' => 'not_empty',
						'required' => array( 'header_sticky_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_sticky_shrink_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Header Shrink Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Header in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'header_sticky_enabled', 'equals', '1' ),
							array( 'header_sticky_type', '!=', 'simple' ),
						),
					),
					array(
						'id' => 'header_sticky_shrink_logo_height',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Logo Shrink Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Logo in px (Default is 30).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'header_sticky_enabled', 'equals', '1' ),
							array( 'header_sticky_type', '!=', 'simple' ),
						),
					),
					array(
						'id'=>'header_sticky_devices_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Devices Sticky Header', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header on small devices ( Tablet Portrait and Mobiles ).', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Header Options / Hidden Menu Options', 'zuperla' ),
				'id' => 'eut_redux_section_responsive_header_options',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the responsive header.', 'zuperla' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'responsive_header_threshold',
						'type' => 'text',
						'default' => '1024',
						'title' => esc_html__( 'Responsive Header Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the screensize you want to activate the responsive header in px, based on the menu items you have (Default is 1024).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'responsive_header_height',
						'type' => 'text',
						'default' => '70',
						'title' => esc_html__( 'Responsive Header Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Header height in px (Default is 70).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'responsive_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Responsive Header overlaps the content.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_responsive_logo_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Responsive Header', 'zuperla' ),
					),
					array(
						'id' => 'responsive_logo_height',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Responsive Logo Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 30).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id'   => 'info_responsive_menu_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Responsive / Hidden Menu Options', 'zuperla' ),
					),
					array(
						'id' => 'menu_responsive_toggle_selection',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Toggle Button Selection', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the toggle button content for your responsive menu.', 'zuperla' ),
						'options' => $zuperla_eutf_menu_responsibe_toggle_selection,
						'default' => 'icon',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_toggle_text',
						'type' => 'text',
						'title' => esc_html__( 'Responsive Menu Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the text for your responsive menu.', 'zuperla' ),
						'default' => 'Menu',
						'required' => array( 'menu_responsive_toggle_selection', 'equals', 'text' ),
					),
					array(
						'id' => 'menu_responsive_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive / Hidden Menu Type', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your responsive menu type.', 'zuperla' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'zuperla' ),
							'slide' => esc_html__( 'Slide', 'zuperla' ),
						),
						'default' => 'slide',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_align',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Align', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your responsive menu align.', 'zuperla' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'zuperla' ),
							'center' => esc_html__( 'Center', 'zuperla' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_width',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive / Hidden Menu Width', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the width for your hidden menu.', 'zuperla' ),
						'options' => array(
							'small' => esc_html__( 'Small', 'zuperla' ),
							'medium' => esc_html__( 'Medium', 'zuperla' ),
							'large' => esc_html__( 'Large', 'zuperla' ),
						),
						'default' => 'small',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Responsive / Hidden Menu Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'zuperla' ),
						'default' => '',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-arrow-down',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Bottom / Footer Areas', 'zuperla' ),
				'id' => 'eut_redux_section_footer_options',
				'desc' => esc_html__( 'These areas appear at the bottom of your pages. Define your preferences.', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'sticky_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Areas', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to make sticky these areas.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'bottom_bar_area',
						'type' => 'select',
						'title' => esc_html__( 'Bottom Bar Area Item', 'zuperla' ),
						'subtitle' => esc_html__( 'Select an area item for your Bottom Bar Area.', 'zuperla' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'area-item', 'numberposts' => -1 ),
						'default' => '',
					),
					array(
						'id'   => 'info_footer_widgets',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Footer Widgets Settings', 'zuperla' ),
					),
					array(
						'id'       => 'footer_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Footer Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'footer_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the footer.', 'zuperla' ),
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id'=>'footer_widgets_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Widgets Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable the Footer Area to show the widget areas of the footer.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'footer_widgets_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Footer Column Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Footer column layout.', 'zuperla' ),
						'options' => $zuperla_eutf_footer_column_selection,
						'default' => 'footer-1',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Full Width', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Area.', 'zuperla' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'zuperla' ),
							'fullwidth-element' => esc_html__( 'Yes', 'zuperla' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Footer Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space above the footer area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space below the footer area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_footer_bar',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Footer Bar Settings', 'zuperla' ),
					),
					array(
						'id'=>'footer_bar_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Bar Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable the Footer Bar Area to add text (copyright), bottom menu and socials.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'footer_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Full Width', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Bar Area.', 'zuperla' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'zuperla' ),
							'fullwidth-element' => esc_html__( 'Yes', 'zuperla' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_bar_align_center',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Center', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if the Footer Bar elements will be centered.', 'zuperla' ),
						'options' => array(
							'no' => esc_html__( 'No', 'zuperla' ),
							'yes' => esc_html__( 'Yes', 'zuperla' ),
						),
						'default' => 'yes',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'footer_copyright_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Copyright Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable the Footer Copyright Area. Edit it as you wish.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_copyright_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Copyright Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Type your copyright text or anything else you want.', 'zuperla' ),
						'default' => '<p>With <i class="eut-text-primary-3 fa fa-heart"></i> by <a href="//themeforest.net/user/euthemians/portfolio" target="_blank" rel="noopener noreferrer">Euthemians</a> - Premium Themes</p>',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'footer_copyright_visibility', 'equals', '1' ),
						),
					),
					array(
						'id'=>'second_area_visibility',
						'type' => 'button_set',
						'title' => esc_html__( 'Second Footer Area', 'zuperla' ),
						'subtitle'=> esc_html__( 'This is the second position in the Footer Bar Area. You can easily add the Bottom Menu (assigned in Appearance > Menus) or socials.', 'zuperla' ),
						'options' => array(
							'1' => esc_html__( 'Hide', 'zuperla' ),
							'2' => esc_html__( 'Menu', 'zuperla' ),
							'3' => esc_html__( 'Socials', 'zuperla' ),
							'4' => esc_html__( 'Text', 'zuperla' ),
						),
						'default' => '1',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_second_copyright_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'zuperla' ),
						'default' => '',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '4' ),
						),
					),
					array(
						'id' => 'footer_social_display',
						'type' => 'select',
						'title' => esc_html__( 'Footer Social Display', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social items.', 'zuperla' ),
						'options' => array(
							'text' => esc_html__( 'Text', 'zuperla' ),
							'icon' => esc_html__( 'Icons', 'zuperla' ),
						),
						'default' => 'text',
						'validate' => 'not_empty',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
					array(
						'id' => 'footer_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Footer Social items', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your social icons.', 'zuperla' ),
						'desc' => '',
						'class' => 'eut-redux-columns',
						'label' => true,
						'options' => $zuperla_eutf_social_options,
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Blog Options', 'zuperla' ),
				'id' => 'eut_redux_section_blog_options',
				'desc' => esc_html__( 'Changes here will affect the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays and not when you use the shortcodes to create a blog page. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'blog_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Blog Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the layout for the assigned blog page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'blog_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar for the assigned blog page.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Blog Sliding Area for the assigned blog page.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_blog_settings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Blog Style and Basic Blog Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the default blog.', 'zuperla' ),
					),
					array(
						'id' => 'blog_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Mode', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the blog mode', 'zuperla' ),
						'options' => $zuperla_eutf_blog_mode_selection,
						'default' => 'large',
					),
					array(
						'id' => 'blog_shadow_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Style', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the blog style', 'zuperla' ),
						'options' =>array(
							'shadow-mode' => esc_html__( 'With Shadow', 'zuperla' ),
							'no-shadow-mode' => esc_html__( 'Without Shadow', 'zuperla' ),
						),
						'default' => 'shadow-mode',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_media_area',
						'type' => 'switch',
						'title' => esc_html__( 'Blog Media Area visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Select if you want to enable media area', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'blog_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your Blog Image Size', 'zuperla' ),
						'options' => $zuperla_eutf_blog_image_mode_selection,
						'default' => 'landscape-large-wide',
						'required' => array(
							array( 'blog_mode','equals', 'large' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_grid_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Grid Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your Blog Image Size', 'zuperla' ),
						'options' => $zuperla_eutf_blog_grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Masonry_Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your Blog Masonry Image Size', 'zuperla' ),
						'options' => $zuperla_eutf_blog_masonry_image_mode_selection,
						'default' => 'medium',
						'required' => array(
							array( 'blog_mode','equals', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_image_prio',
						'type' => 'select',
						'title' => esc_html__( 'Blog Featured Image Priority', 'zuperla' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed instead of media element', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
						'required' => array( 'blog_media_area', 'equals', '1' ),
					),
					array(
						'id' => 'blog_columns_large_screen',
						'type' => 'select',
						'title' => esc_html__( 'Blog Columns Large Screens', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Blog Columns for large screens', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection,
						'default' => '3',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns',
						'type' => 'select',
						'title' => esc_html__( 'Blog Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Blog Columns', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection,
						'default' => '3',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Blog Tablet Landscape Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Blog Tablet Portrait Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Blog Mobile Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection_mobile,
						'default' => '1',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_gutter',
						"type" => "select",
						"title" => esc_html__( "Gutter between items", "zuperla" ),
						'subtitle' => esc_html__( 'Add gutter among items.', 'zuperla' ),
						"options" => array(
							'yes' => esc_html__( "Yes", "zuperla" ),
							'no' => esc_html__( "No", "zuperla" ),
						),
						'default' => 'yes',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id'=>'blog_gutter_size',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Gutter Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Define the gutter size.', 'zuperla' ),
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
							array( 'blog_gutter','equals', 'yes' ),
						),
					),
					array(
						"id" => "blog_animation",
						"type" => "select",
						"title" => esc_html__( "Blog CSS Animation", "zuperla"),
						"subtitle" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "zuperla" ),
						"options" => array(
							'none' => esc_html__( "No", "zuperla" ),
							"eut-fade-in" => esc_html__( "Fade In", "zuperla" ),
							"eut-fade-in-up" => esc_html__( "Fade In Up", "zuperla" ),
							"eut-fade-in-down" => esc_html__( "Fade In Down", "zuperla" ),
							"eut-fade-in-left" => esc_html__( "Fade In Left", "zuperla" ),
							"eut-fade-in-right" => esc_html__( "Fade In Right", "zuperla" ),
							"eut-zoom-in" => esc_html__( "Zoom In", "zuperla" ),
						),
						'default' => 'none',
					),
					array(
						'id' => 'blog_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Blog Title Tag', 'zuperla' ),
						'subtitle' => esc_html__( 'Select tag for your blog title.', 'zuperla' ),
						'options' => $zuperla_eutf_blog_headings_tag_selection,
						'default' => 'auto',
					),
					array(
						'id' => 'blog_heading',
						'type' => 'select',
						'title' => esc_html__( 'Blog Title Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select size and typography for your blog title.', 'zuperla' ),
						'options' => $zuperla_eutf_blog_headings_selection,
						'default' => 'auto',
					),
					array(
						'id' => 'blog_item_spinner',
						'type' => 'select',
						'title' => esc_html__( 'Blog Loader', 'zuperla' ),
						'subtitle' => esc_html__( 'If selected, this will enable a graphic spinner before load.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'=>'blog_excerpt_length_small',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'zuperla' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'blog_mode', '!=', 'large' ),
					),
					array(
						'id' => 'blog_auto_excerpt',
						'type' => 'switch',
						'title' => esc_html__( 'Auto Excerpt', 'zuperla' ),
						'subtitle'=> esc_html__( "Adds automatic excerpt to all posts. If auto excerpt is off, blog will show all content, a desired 'cut-off' can be inserted in each post with more quicktag.", 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'blog_mode', 'equals', 'large' ),
					),

					array(
						'id'=>'blog_excerpt_length',
						'type' => 'text',
						'default' => '55',
						'title' => esc_html__( 'Excerpt Length', 'zuperla' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 55).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'blog_auto_excerpt', 'equals', '1' ),
							array( 'blog_mode', 'equals', 'large' ),
						),
					),
					array(
						'id' => 'blog_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'zuperla' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'blog_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Field Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments field of your blog overview.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'blog_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Field Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the author field of your blog overview.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'blog_date_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Date Field Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the date field of your blog overview.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'blog_like_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Like Field Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the like field of your blog overview.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'blog_categories_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Categories Field Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the categories field of your blog overview.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_blog_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Blog Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default blog header.', 'zuperla' ),
					),
					array(
						'id' => 'blog_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your blog header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'light',
					),
					array(
						'id' => 'blog_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Blog Header overlaps the content. Combine this option with the Light or Dark Header.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'=>'blog_title',
						'type' => 'select',
						'title' => esc_html__( 'Main Blog Title', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to use the site name and tagline as the main blog title or hide it.', 'zuperla' ),
						'options' => array(
							'sitetitle' => esc_html__( 'Site Title / Tagline', 'zuperla' ),
							'custom' => esc_html__( 'Custom Title / Description', 'zuperla' ),
							'none' => esc_html__( 'None', 'zuperla' ),
						),
						'default' => 'sitetitle',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_custom_title', //translatable
						'type' => 'text',
						'default' => '',
						'title' => esc_html__( 'Custom Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter blog custom title.', 'zuperla' ),
						'required' => array( 'blog_title', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_custom_description', //translatable
						'type' => 'text',
						'default' => '',
						'title' => esc_html__( 'Custom Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter blog custom description.', 'zuperla' ),
						'required' => array( 'blog_title', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter blog title height (Default is Large Height).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter blog title minimum height in px (Default is 200).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'blog_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default blog title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default blog title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'blog_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Background for the blog page, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'blog_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default blog title.', 'zuperla' ),
						'required' => array( 'blog_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Post Settings', 'zuperla' ),
				'id' => 'eut_redux_section_single_post_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Posts. Notice that most of them can be overridden when you create a single post.', 'zuperla' ),
				'submenu' => true,
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Post Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Post Custom Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'post_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Post Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Post Custom Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'post_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Post Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Posts. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'post_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Posts.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Post Content Width', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Single Post Content width (only for Full Width Post Layout)', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selector,
						'default' => 'small',
					),
					array(
						'id' => 'post_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Post Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Post Sliding Area if you want.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_feature_image_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Featured Image Visibility (Standard Post)', 'zuperla' ),
						'subtitle'=> esc_html__( 'Toggle Featured Image on or off.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'post_tag_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Tags Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post tags.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'post_category_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Categories Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post categories.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'post_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Info Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Author Info field.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'post_author_info_link_text',
						'type' => 'text',
						'title' => esc_html__( 'Author Info Link Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the text for the author info link.', 'zuperla' ),
						"default" => 'All stories by :',
						'required' => array( 'post_author_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'post_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your single posts.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_post_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Post Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'zuperla' ),
					),
					array(
						'id' => 'post_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your post header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'light',
					),
					array(
						'id' => 'post_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Post Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single post.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'   => 'info_style_post_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Post Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default single post title.', 'zuperla' ),
					),
					array(
						'id' => 'post_title_style',
						'type' => 'select',
						'default' => 'advanced',
						'title' => esc_html__( 'Title Style', 'zuperla' ),
						'subtitle' => esc_html__( 'Select Post Title Style', 'zuperla' ),
						'options' => $zuperla_eutf_title_style,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter post title height(Default is Large Height).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter post title minimum height in px (Default is 200).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default post title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default post title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'post_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Post Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode,
						'default'  => 'color',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'post_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default post title.', 'zuperla' ),
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'post_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id'   => 'info_style_post_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per post.', 'zuperla' ),
					),
					array(
						'id' => 'post_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'post_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in posts.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_post_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'zuperla' ),
					),
					array(
						'id'=>'post_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Post / Archives / Categories / Tags.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'post_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_post_social',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Socials Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the social.', 'zuperla' ),
					),
					array(
						'id' => 'post_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Posts.', 'zuperla' ),
						'options' => $zuperla_eutf_post_social_options,
						'default' => 0,
					),
					array(
						'id'   => 'info_style_post_related',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Related Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the related posts.', 'zuperla' ),
					),
					array(
						'id'=>'post_related_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Related Posts Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the related posts.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'post_related_title_first',
						'type' => 'text',
						'title' => esc_html__( 'Related Posts First Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the text for the first posts related title.', 'zuperla' ),
						"default" => 'You might also like',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_related_title_second',
						'type' => 'text',
						'title' => esc_html__( 'Related Posts Second Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the text for the second posts related title.', 'zuperla' ),
						"default" => '',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_post_nav',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Navigation Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'zuperla' ),
					),
					array(
						'id'=>'post_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Posts Navigation Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the posts navigation.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'post_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Post Navigation Same Term', 'zuperla' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'zuperla' ),
						'default' => 0,
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_backlink_id',
						'type' => 'select',
						'title' => esc_html__( 'Post Backlink', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the overview page for your post backlink.', 'zuperla' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'post_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'zuperla' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'zuperla' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'zuperla'),
						'default'        => array(
							'padding-top'     => '60px',
							'padding-bottom'  => '60px',
							'units'           => 'px',
						),
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-pencil',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Options', 'zuperla'),
				'id' => 'eut_redux_section_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'zuperla' ),
				'desc' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Page Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Page Custom Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'page_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Page Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Page Custom Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'page_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Page Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the layout for the pages. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'page_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the pages in case you do not use full width layout.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Page Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the pages.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'page_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Easily disable the comments for all pages.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_page_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Page Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default page header.', 'zuperla' ),
					),
					array(
						'id' => 'page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'light',
					),
					array(
						'id' => 'page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single page.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'   => 'info_style_page_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Page Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default page title.', 'zuperla' ),
					),
					array(
						'id' => 'page_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Page title height (Default is Large Height).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter page title minimum height in px (Default is 200).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default page title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default page title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default page title.', 'zuperla' ),
						'required' => array( 'page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_page_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per page.', 'zuperla' ),
					),
					array(
						'id' => 'page_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_page_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'zuperla' ),
					),
					array(
						'id'=>'page_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Page.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'page_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-search',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Search Options', 'zuperla'),
				'id' => 'eut_redux_section_search_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the search page here.', 'zuperla' ),
				'desc' => esc_html__( 'You can find the basic settings for the search page here.', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'search_page_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Search Page Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the layout for the search page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'search_page_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the search page in case you do not use full width layout.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'search_page_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_search_page_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Search Page Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the search page header.', 'zuperla' ),
					),
					array(
						'id' => 'search_page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'light',
					),
					array(
						'id' => 'search_page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'   => 'info_style_search_page_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Search Page Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the search page title.', 'zuperla' ),
					),
					array(
						'id' => 'search_page_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter page title height (Default is Large Height).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter page title minimum height in px (Default is 200).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the search page title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the search page title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'search_page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'search_page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the search page title.', 'zuperla' ),
						'required' => array( 'search_page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_search_page_settings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Search Page Style and Basic Search Page Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the search page.', 'zuperla' ),
					),
					array(
						'id' => 'search_page_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mode', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the search page mode', 'zuperla' ),
						'options' => array(
							'masonry' => esc_html__( 'Masonry' , 'zuperla' ),
							'grid' => esc_html__( 'Grid' , 'zuperla' ),
							'small' => esc_html__( 'Small Media', 'zuperla' ),
						),
						'default' => 'masonry',
					),
					array(
						'id' => 'search_page_shadow_style',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Style', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the search style', 'zuperla' ),
						'options' =>array(
							'shadow-mode' => esc_html__( 'With Shadow', 'zuperla' ),
							'no-shadow-mode' => esc_html__( 'Without Shadow', 'zuperla' ),
						),
						'default' => 'shadow-mode',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_show_image',
						'type' => 'select',
						'title' => esc_html__( 'Show Search Page Featured Image', 'zuperla' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id' => 'search_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Grid Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your Search Grid Image Size', 'zuperla' ),
						'options' => $zuperla_eutf_search_grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'search_page_mode', '!=', 'masonry' ),
							array( 'search_page_show_image', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'search_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Masonry_Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select your Search Masonry Image Size', 'zuperla' ),
						'options' => $zuperla_eutf_search_masonry_image_mode_selection,
						'default' => 'medium',
						'required' => array(
							array( 'search_page_mode','equals', 'masonry' ),
							array( 'search_page_show_image', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'search_page_columns_large_screen',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Large Screen Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns on large screen devices', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection,
						'default' => '3',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection,
						'default' => '3',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Landscape Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Portrait Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mobile Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'zuperla' ),
						'options' => $zuperla_eutf_blog_columns_selection_mobile,
						'default' => '1',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Tag', 'zuperla' ),
						'subtitle' => esc_html__( 'Select tag for your search result title.', 'zuperla' ),
						'options' => $zuperla_eutf_headings_tag_selection,
						'default' => 'h4',
					),
					array(
						'id' => 'search_page_heading',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select size and typography for your search result title.', 'zuperla' ),
						'options' => $zuperla_eutf_headings_selection,
						'default' => 'h4',
					),
					array(
						'id'=>'search_page_excerpt_length_small',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'zuperla' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'zuperla' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'search_modal_text',
						'type' => 'text',
						'title' => esc_html__( 'Search Modal Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the search text of the modal.', 'zuperla' ),
						'default' => 'Start Typing',
					),
					array(
						'id' => 'search_modal_button_text',
						'type' => 'text',
						'title' => esc_html__( 'Search Modal Button Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the search text of the modal button.', 'zuperla' ),
						'default' => 'Start Searching',
					),
					array(
						'id' => 'search_page_not_found_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Search Page Not Found Content', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the content of your search page when no results are found.', 'zuperla' ),
						'default' => '<h3 class="eut-align-center eut-subtitle-text">Maybe you should check again your spelling.</h3><h3 class="eut-align-center">This is not the page you are looking for...</h3>',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-briefcase',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Portfolio Options', 'zuperla' ),
				'id' => 'eut_redux_section_portfolio_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'portfolio_slug',
						'type' => 'text',
						'default' => 'portfolio',
						'title' => esc_html__( 'Slug', 'zuperla' ),
						'subtitle' => esc_html__( "Enter Portfolio Slug (Default is 'portfolio'). If you change it, go to Settings - Permalinks and click on Save Changes.", 'zuperla' ),
						'desc' => esc_html__( "Slug must not be used anywhere else (e.g: category, page, post).", 'zuperla' ),
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Custom Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'portfolio_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Custom Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'portfolio_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Portfolio Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default layout for the Portfolio (single portfolio items). Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'portfolio_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single portfolio items.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the single portfolio items.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_details_text',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details title.', 'zuperla' ),
						"default" => 'Project Details',
					),
					array(
						'id' => 'portfolio_details_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Details Text Heading Tag', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Portfolio Details Text.', 'zuperla' ),
						'options' => $zuperla_eutf_headings_tag_selection,
						'default' => 'div',
					),
					array(
						'id' => 'portfolio_details_link_text',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Link Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details link text.', 'zuperla' ),
						"default" => 'View Project',
					),
					array(
						'id'=>'portfolio_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your portfolio.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_portfolio_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Portfolio Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default portfolio header.', 'zuperla' ),
					),
					array(
						'id' => 'portfolio_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your portfolio header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'light',
					),
					array(
						'id' => 'portfolio_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Portfolio Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single portfolio.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'   => 'info_style_portfolio_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Portfolio Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the single default portfolio title.', 'zuperla' ),
					),
					array(
						'id' => 'portfolio_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter portfolio title height (Default is Large Height).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter portfolio title minimum height in px (Default is 200).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default portfolio title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default portfolio title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'portfolio_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Portfolio Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'portfolio_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default portfolio title.', 'zuperla' ),
						'required' => array( 'portfolio_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_portfolio_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per portfolio item.', 'zuperla' ),
					),
					array(
						'id' => 'portfolio_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_portfolio_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'zuperla' ),
					),
					array(
						'id'=>'portfolio_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Portfolio.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'zuperla' ),
						'default' => 0,
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_portfolio_socials',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Socials Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Socials.', 'zuperla' ),
					),
					array(
						'id' => 'portfolio_social_bar_layout',
						'type' => 'select',
						'title' => esc_html__( 'Socials Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Layout for Socials', 'zuperla' ),
						'options' => array(
							'layout-1' => esc_html__( 'Bottom Layout', 'zuperla' ),
							'layout-2' => esc_html__( 'Side Layout', 'zuperla' ),
						),
						'default' => 'layout-1',
					),
					array(
						'id' => 'portfolio_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable or Disable the social shares you like in the single portfolio items.', 'zuperla' ),
						'options' => $zuperla_eutf_portfolio_social_options,
						'default' => 0,
					),
					array(
						'id'   => 'info_style_portfolio_recent',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Recent Items Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Recent Items.', 'zuperla' ),
					),
					array(
						'id'=>'portfolio_recents_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Recent Items Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the recent items carousel.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'portfolio_recent_title',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Recent Items Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio recent items title.', 'zuperla' ),
						"default" => 'More Projects',
						'required' => array( 'portfolio_recents_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_portfolio_nav',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Navigation Bar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation Bar.', 'zuperla' ),
					),
					array(
						'id'=>'portfolio_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Portfolio Navigation Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the portfolio navigation.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'portfolio_nav_term',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Navigation Same Term', 'zuperla' ),
						'subtitle' => esc_html__( 'If selected, only navigation items with the same selected taxonomy term will be displayed.', 'zuperla' ),
						'options' => $zuperla_eutf_portfolio_term_selection,
						'default' => 'none',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_backlink_id',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Backlink', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the overview page for your portfolio backlink.', 'zuperla' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'portfolio_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'zuperla' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'zuperla' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'zuperla'),
						'default'        => array(
							'padding-top'     => '60px',
							'padding-bottom'  => '60px',
							'units'           => 'px',
						),
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'WooCommerce Options', 'zuperla'),
				'id' => 'eut_redux_section_woocommerce_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the WooCommerce here.', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'product_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Taxonomy Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default layout for the Product Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'product_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Product Taxonomy.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Product Taxonomy.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_product_tax_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default Product Taxonomy header.', 'zuperla' ),
					),
					array(
						'id' => 'product_tax_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your Product Taxonomy header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'product_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_tax_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Product Taxonomy title.', 'zuperla' ),
					),
					array(
						'id' => 'product_tax_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title height (Default is 60%).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title minimum height in px (Default is 320).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_tax_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default Product Taxonomy title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Product Taxonomy title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'product_tax_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Product Taxonomy Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'product_tax_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default Product Taxonomy title.', 'zuperla' ),
						'required' => array( 'product_tax_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_product_overview',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Shop Overview Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the shop overview.', 'zuperla' ),
					),
					array(
						'id' => 'product_overview_hover_style',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Hover Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the hover style for the product overview.', 'zuperla' ),
						'options' => array(
							'hover-style-1' => esc_html__( 'Content Below Image', 'zuperla' ),
							'hover-style-2' => esc_html__( 'Top Down Animated Content', 'zuperla' ),
						),
						'default' => 'hover-style-1',
					),
					array(
						'id' => 'product_overview_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Image effect', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the effect for the overview product image', 'zuperla' ),
						'options' => array(
							'none' => esc_html__( 'None', 'zuperla' ),
							'second' => esc_html__( 'Second Image on Hover', 'zuperla' ),
						),
						'default' => 'second',
					),
					array(
						'id' => 'product_overview_image_zoom_effect',
						'type' => 'select',
						'options' => array(
							'in' => esc_html__( 'Zoom In', 'zuperla' ),
							'out' => esc_html__( 'Zoom Out', 'zuperla' ),
							'none' => esc_html__( 'None', 'zuperla' ),
						),
						'title' => esc_html__( 'Loop Image Zoom Effect', 'zuperla' ),
						'subtitle' => esc_html__( 'Choose the image zoom effect.', 'zuperla' ),
						'default' => 'none',
					),
					array(
						'id' => 'product_overview_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'zuperla' ),
							'square' => esc_html__( 'Square Small Crop', 'zuperla' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'zuperla' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'zuperla' ),
							'large' => esc_html__( 'Resize ( Large )', 'zuperla' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
						),
						'title' => esc_html__( 'Loop Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Choose the overview image size.', 'zuperla' ),
						'default' => 'default',
					),
					array(
						'id' => 'product_loop_columns',
						'type' => 'select',
						'options' => array(
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'5' => '5',
						),
						'default' => '4',
						'title' => esc_html__( 'Loop Columns', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the number of columns (Default is 4).', 'zuperla' ),
					),
					array(
						'id' => 'product_loop_shop_per_page',
						'type' => 'text',
						'default' => '12',
						'title' => esc_html__( 'Loop Products per Page', 'zuperla' ),
						'subtitle' => esc_html__( 'Select how many products per page you want to show (Default is 12).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_overview_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Title Tag', 'zuperla' ),
						'subtitle' => esc_html__( 'Select tag for your loop product title.', 'zuperla' ),
						'options' => $zuperla_eutf_headings_tag_selection,
						'default' => 'h3',
					),
					array(
						'id' => 'product_overview_heading',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Title Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select size and typography for your loop product title.', 'zuperla' ),
						'options' => $zuperla_eutf_headings_selection,
						'default' => 'h6',
					),
					array(
						'id' => 'product_overview_overlay_color',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'light',
					),
					array(
						'id' => 'product_overview_overlay_opacity',
						'type' => 'select',
						'options' => $zuperla_eutf_opacity_selection_simple,
						'title' => esc_html__( 'Overlay Opacity', 'zuperla' ),
						'subtitle' => esc_html__( 'Choose the opacity for the overlay.', 'zuperla' ),
						'default' => '90',
					),
					array(
						'id'   => 'info_style_product_extras',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Shop Extras', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for additional shop settings.', 'zuperla' ),
					),
					array(
						'id'=>'product_woo_quantity_buttons',
						'type' => 'switch',
						'title' => esc_html__( 'Product Quantity Buttons', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable -/+ quantity buttons.', 'zuperla' ),
						"default" => '1',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Product Settings', 'zuperla' ),
				'id' => 'eut_redux_section_single_product_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Products. Notice that most of them can be overridden when you create a single product.', 'zuperla' ),
				'submenu' => true,
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Product Custom Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'product_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Product Custom Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'product_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Products. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'product_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Products.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Product Sliding Area if you want.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_product_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Product Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'zuperla' ),
					),
					array(
						'id' => 'product_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your product header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'product_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single product.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Product Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default single product title.', 'zuperla' ),
					),
					array(
						'id' => 'product_title_style',
						'type' => 'select',
						'default' => 'simple',
						'title' => esc_html__( 'Title Style', 'zuperla' ),
						'subtitle' => esc_html__( 'Select Product Title Style', 'zuperla' ),
						'options' => $zuperla_eutf_title_style,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter product title height (Default is 60%).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter product title minimum height in px (Default is 200).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default product title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default product title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'product_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Product Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode,
						'default'  => 'color',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'product_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default product title.', 'zuperla' ),
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'product_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id'   => 'info_style_product_content_area',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Product Area/Product Content Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the product area and product content (Tabs).', 'zuperla' ),
					),
					array(
						'id' => 'product_area_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Product Area Full Width', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Product Content Area.', 'zuperla' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'zuperla' ),
							'fullwidth-element' => esc_html__( 'Yes', 'zuperla' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_area_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Area Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space above the area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_area_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Area bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space below the product area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Product Content Width', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Single Product Content width (only for Full Width Product Layout)', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selector,
						'default' => 'small',
					),
					array(
						'id'   => 'info_style_product_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per product.', 'zuperla' ),
					),
					array(
						'id' => 'product_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in products.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_product_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'zuperla' ),
					),
					array(
						'id'=>'product_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Product / Product Categories / Product Tags.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'product_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_product_image',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Product Image Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the single product image.', 'zuperla' ),
					),
					array(
						'id' => 'product_image_thumb_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Image / Thumbnails Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the style for the single product image and thumbnails. Note: some external plugins might not be compatible with Theme style.', 'zuperla' ),
						'options' => array(
							'theme' => esc_html__( 'Theme Style', 'zuperla' ),
							'woo' => esc_html__( 'Default WooCommerce Style', 'zuperla' ),
						),
						'default' => 'theme',
					),
					array(
						'id' => 'product_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Product Image effect', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the effect for the main product image', 'zuperla' ),
						'options' => array(
							'none' => esc_html__( 'None', 'zuperla' ),
							'zoom' => esc_html__( 'Zoom', 'zuperla' ),
						),
						'default' => 'none',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id' => 'product_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'zuperla' ),
							'square' => esc_html__( 'Square Small Crop', 'zuperla' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'zuperla' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'zuperla' ),
							'large' => esc_html__( 'Resize ( Large )', 'zuperla' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
						),
						'title' => esc_html__( 'Product Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Choose the product image size.', 'zuperla' ),
						'default' => 'default',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id' => 'product_gallery_mode',
						'type' => 'select',
						'title' => esc_html__( 'Product Gallery Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the mode for the single product gallery', 'zuperla' ),
						'options' => array(
							'none' => esc_html__( 'None', 'zuperla' ),
							'popup' => esc_html__( 'Magnific Popup', 'zuperla' ),
						),
						'default' => 'popup',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id' => 'product_gallery_title_caption',
						"type" => "select",
						"title" => esc_html__( "Product Gallery Image Title & Caption Visibility", "zuperla" ),
						"subtitle" => esc_html__( "Define the visibility for your image title - caption.", "zuperla" ),
						'options' => array(
							'none' => esc_html__( 'None' , 'zuperla' ),
							'title-caption' => esc_html__( 'Title and Caption' , 'zuperla' ),
							'title-only' => esc_html__( 'Title Only' , 'zuperla' ),
							'caption-only' => esc_html__( 'Caption Only' , 'zuperla' ),
						),
						'default' => 'none',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id' => 'product_image_middle',
						'type' => 'switch',
						'title' => esc_html__( 'Product Image Middle Content', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable/Disable middle content for product image/thumbs and product summary.', 'zuperla' ),
						'default' => 1,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id'=>'product_gallery_woo_zoom',
						'type' => 'switch',
						'title' => esc_html__( 'Zoom Effect', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable image zoom effect.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id'=>'product_gallery_woo_lightbox',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Lightbox', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery lightbox.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id'=>'product_gallery_woo_slider',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Slider', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery slider.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id'   => 'info_style_product_social',
						'type' => 'info',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Socials Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Socials.', 'zuperla' ),
					),
					array(
						'id' => 'product_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Product.', 'zuperla' ),
						'options' => $zuperla_eutf_product_social_options,
						'default' => 0,
					),
					array(
						'id'   => 'info_style_product_nav',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Navigation Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'zuperla' ),
					),
					array(
						'id'=>'product_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Product Navigation Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the products navigation.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'product_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Product Navigation Same Term', 'zuperla' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'zuperla' ),
						'default' => 0,
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'product_backlink_id',
						'type' => 'select',
						'title' => esc_html__( 'Product Backlink', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the overview page for your product backlink.', 'zuperla' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'product_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'zuperla' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'zuperla' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'zuperla'),
						'default'        => array(
							'padding-top'     => '60px',
							'padding-bottom'  => '60px',
							'units'           => 'px',
						),
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Product Search Settings', 'zuperla' ),
				'id' => 'eut_redux_section_product_search_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Product Search.', 'zuperla' ),
				'submenu' => true,
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_search_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Search Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the layout for the product search page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'product_search_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Search Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the product search page in case you do not use full width layout.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'product_search_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Search Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-calendar',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Events Calendar Options', 'zuperla'),
				'id' => 'eut_redux_section_event_calendar_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the Events Calendar here.', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'event_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Taxonomy Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default layout for the Event Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'event_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Event Taxonomy.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Event Taxonomy.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_event_tax_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Event Taxonomy Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default Event Taxonomy header.', 'zuperla' ),
					),
					array(
						'id' => 'event_tax_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your Event Taxonomy header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'event_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Event Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_event_tax_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Event Taxonomy Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the Event Taxonomy title.', 'zuperla' ),
					),
					array(
						'id' => 'event_tax_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Event Taxonomy title height (Default is 60%).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Event Taxonomy title minimum height in px (Default is 320).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'event_tax_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default Event Taxonomy title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Event Taxonomy title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'event_tax_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Event Taxonomy Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'event_tax_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default Event Taxonomy title.', 'zuperla' ),
						'required' => array( 'event_tax_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_tax_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'event_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_tax_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'event_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_tax_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'event_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_tax_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'event_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_event_overview',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Event Overview Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the event overview.', 'zuperla' ),
					),
					array(
						'id' => 'event_overview_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'zuperla' ),
							'square' => esc_html__( 'Square Small Crop', 'zuperla' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'zuperla' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'zuperla' ),
							'large' => esc_html__( 'Resize ( Large )', 'zuperla' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
						),
						'title' => esc_html__( 'Event Overview Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Choose the event overview image size.', 'zuperla' ),
						'default' => 'default',
					),
					array(
						'id' => 'event_overview_heading',
						'type' => 'select',
						'title' => esc_html__( 'Event Overview Title Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select size and typography for your event overview title.', 'zuperla' ),
						'options' => $zuperla_eutf_event_headings_selection,
						'default' => 'h2',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Event Settings', 'zuperla' ),
				'id' => 'eut_redux_section_single_event_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Events. Notice that most of them can be overridden when you create a single event.', 'zuperla' ),
				'submenu' => true,
				'icon' => 'el-icon-calendar',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Event Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Event Custom Top Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'event_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Event Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'zuperla' ),
						'options' => $zuperla_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Event Custom Bottom Padding', 'zuperla' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'zuperla' ),
						'required' => array( 'event_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Events. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'event_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Events.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Event Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Event Sliding Area if you want.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Event Content Width', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the Event Content width (only for Full Width Post Layout)', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selector,
						'default' => 'large',
					),
					array(
						'id'   => 'info_style_event_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Event Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'zuperla' ),
					),
					array(
						'id' => 'event_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Event Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your event header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'event_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Event Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Event Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single event.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_event_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Event Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default single event title.', 'zuperla' ),
					),
					array(
						'id' => 'event_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter event title height (Default is 60%).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter event title minimum height in px (Default is 200).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'event_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default event title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default event title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'event_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Event Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'event_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default event title.', 'zuperla' ),
						'required' => array( 'event_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_event_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per event.', 'zuperla' ),
					),
					array(
						'id' => 'event_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'event_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in events.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'   => 'info_style_event_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'zuperla' ),
					),
					array(
						'id'=>'event_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Event / Event Categories / Event Tags.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'event_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'zuperla' ),
						'validate' => 'numeric',
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'zuperla' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'zuperla' ),
							'square' => esc_html__( 'Square Small Crop', 'zuperla' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'zuperla' ),
							'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'zuperla' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'zuperla' ),
							'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'zuperla' ),
							'large' => esc_html__( 'Resize ( Large )', 'zuperla' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'zuperla' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'zuperla' ),
						),
						'title' => esc_html__( 'Event Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Choose the event image size.', 'zuperla' ),
						'default' => 'default',
					),
					array(
						'id'   => 'info_style_event_nav',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Navigation & Socials Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'zuperla' ),
					),
					array(
						'id'=>'event_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Event Navigation Visibility', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the events navigation.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id' => 'event_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Event Navigation Same Term', 'zuperla' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'zuperla' ),
						'default' => 0,
						'required' => array( 'event_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'event_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'zuperla' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'zuperla' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'zuperla'),
						'default'        => array(
							'padding-top'     => '60px',
							'padding-bottom'  => '60px',
							'units'           => 'px',
						),
					),
					array(
						'id' => 'event_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable or Disable social shares for the Single Event.', 'zuperla' ),
						'options' => $zuperla_eutf_event_social_options,
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-comment-alt',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'bbPress Forum Options', 'zuperla'),
				'id' => 'eut_redux_section_bbpress_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the bbPress here.', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'forum_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Forum Layout', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default layout for the Forum. Choose among Full Width, Left Sidebar or Right Sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'forum_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Forum.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Fixed Sidebar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'forum_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sliding Area Visibility', 'zuperla' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Forum.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'forum_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sliding Area Sidebar', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'zuperla' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_forum_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Forum Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default Forum header.', 'zuperla' ),
					),
					array(
						'id' => 'forum_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Forum Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your Forum header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'forum_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Forum Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Forum Header overlaps the content. Combine this option with the Light or Dark Header.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_forum_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Forum Title Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Forum title.', 'zuperla' ),
					),
					array(
						'id' => 'forum_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Forum title height (Default is 60%).', 'zuperla' ),
						'options' => $zuperla_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter Forum title minimum height in px (Default is 320).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'forum_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'zuperla' ),
						'options' => $zuperla_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your position for the default Forum title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Forum title/description.', 'zuperla' ),
						'options' => $zuperla_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'forum_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the Forum Title Background, Color or Image.', 'zuperla' ),
						'options' => $zuperla_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'forum_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image for the default Forum title.', 'zuperla' ),
						'required' => array( 'forum_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'zuperla' ),
						'options' => $zuperla_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
				)
			);


			$this->sections[] = array(
				'title' => esc_html__( 'Typography Options', 'zuperla' ),
				'id' => 'eut_redux_section_typography_options',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header/Body', 'zuperla' ),
				'id' => 'eut_redux_section_typography_header',
				'header' => '',
				'desc' => esc_html__( 'Define your main typography settings.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_body_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Main Body Fonts', 'zuperla' ),
					),
					array(
						'id' => 'body_font',
						'type' => 'typography',
						'title' => esc_html__( 'Body Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the body font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'default' => array(
							'font-size' => '16px',
							'line-height' => '30px',
							'font-family' => 'Nunito Sans',
							'font-weight' => '300',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'single_post_font',
						'type' => 'typography',
						'title' => esc_html__( 'Single Post & Product Body Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the single post & single product body font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'default' => array(
							'font-size' => '24px',
							'line-height' => '36px',
							'font-family' => 'Nunito Sans',
							'font-weight' => '300',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_logo_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo as text Fonts', 'zuperla' ),
					),
					array(
						'id' => 'logo_font',
						'type' => 'typography',
						'title' => esc_html__( 'Logo Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the logo font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height'=> false,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '36px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_menu_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Main Menu Fonts', 'zuperla' ),
					),
					array(
						'id' => 'main_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the menu font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '16px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'sub_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Submenu Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the submenu font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '12px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'description_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Description Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the Menu description font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '11px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_hidden_menu_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Hidden Menu Fonts', 'zuperla' ),
					),
					array(
						'id' => 'hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Menu Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the hidden menu font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '400',
							'font-size' => '18px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'sub_hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Submenu Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the hidden submenu font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '14px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'description_hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Menu Description Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the hidden menu description font properties.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '11px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Headings (H1-H6)', 'zuperla' ),
				'id' => 'eut_redux_section_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your Typography Headings ( H1-H6 ).', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_headers_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Headings Fonts', 'zuperla' ),
					),
					array(
						'id' => 'h1_font',
						'type' => 'typography',
						'title' => esc_html__( 'H1 Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the H1 font.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'h2_font',
						'type' => 'typography',
						'title' => esc_html__( 'H2 Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the H2 font.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '42px',
							'line-height' => '48px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'h3_font',
						'type' => 'typography',
						'title' => esc_html__( 'H3 Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the H3 font.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '36px',
							'line-height' => '42px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'h4_font',
						'type' => 'typography',
						'title' => esc_html__( 'H4 Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the H4 font.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '30px',
							'line-height' => '36px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'h5_font',
						'type' => 'typography',
						'title' => esc_html__( 'H5 Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the H5 font.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '24px',
							'line-height' => '30px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'h6_font',
						'type' => 'typography',
						'title' => esc_html__( 'H6 Font', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the H6 font.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '18px',
							'line-height' => '24px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Titles/Descriptions', 'zuperla' ),
				'id' => 'eut_redux_section_typography_titles',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for titles/descriptions.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_page_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Page/Blog Typography', 'zuperla' ),
					),
					array(
						'id' => 'page_title',
						'type' => 'typography',
						'title' => esc_html__( 'Page Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the default page titles and for the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'page_description',
						'type' => 'typography',
						'title' => esc_html__( 'Page Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify font for the page description and for the description of the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_post_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Post Typography', 'zuperla' ),
					),
					array(
						'id' => 'post_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'Post Simple Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the single post simple title.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '36px',
							'line-height' => '42px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'post_title',
						'type' => 'typography',
						'title' => esc_html__( 'Post Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the single post titles.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'text-transform' => 'none',
							'font-weight' => '700',
							'font-size' => '72px',
							'line-height' => '78px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'post_title_desc',
						'type' => 'typography',
						'title' => esc_html__( 'Post Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the single post description.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'post_title_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Meta', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for meta ( categories ) in the post title section.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '10px',
							'line-height' => '14px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'post_title_extra_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Extra Meta', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for extra meta ( Author/Date/Comments ) in the post title section.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '10px',
							'line-height' => '14px',
							'font-weight' => '400',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_portfolio_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Portfolio Typography', 'zuperla' ),
					),
					array(
						'id' => 'portfolio_title',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio titles.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'portfolio_description',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio description.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_forum_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'bbPress Forum Typography', 'zuperla' ),
					),
					array(
						'id' => 'forum_title',
						'type' => 'typography',
						'title' => esc_html__( 'Forum Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the forum titles.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '48px',
							'line-height' => '54px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_woocommerce_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'WooCommerce Typography', 'zuperla' ),
					),
					array(
						'id' => 'product_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Product Simple Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the product simple title', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '36px',
							'line-height' => '42px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'product_short_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Product Short Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the product short description', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '16px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'product_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the product titles', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'product_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify font for the product title description', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
										array(
						'id'   => 'info_events_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Events Calendar Typography', 'zuperla' ),
					),
					array(
						'id' => 'event_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'Events Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the event titles', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '48px',
							'line-height' => '54px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'event_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'Events Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify font for the events description', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Feature Section', 'zuperla' ),
				'id' => 'eut_redux_section_typography_feature_section',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for feature section.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_feature_typography_custom_height',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Feature Section Typography with Custom Height', 'zuperla' ),
					),
					array(
						'id' => 'feature_subheading_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Sub Heading', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the sub-heading in the feature section.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '10px',
							'line-height' => '14px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'feature_title_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the title in the feature section.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'feature_desc_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the description in the feature section.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_feature_typography_full',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Feature Section Typography with Fullscreen mode', 'zuperla' ),
					),
					array(
						'id' => 'feature_subheading_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Sub Heading', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the sub-heading in the feature section.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '12px',
							'line-height' => '16px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'feature_title_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the title in the feature section.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '72px',
							'line-height' => '78px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'feature_desc_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Description', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the font for the  description in the feature section.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '30px',
							'line-height' => '36px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Extras', 'zuperla' ),
				'id' => 'eut_redux_section_typography_extras',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for extra fields ( widgets, special texts, custom fonts .etc ).', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'widgets_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Widgets Typography', 'zuperla' ),
					),
					array(
						'id' => 'widget_title',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Title', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the style for the widget titles.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '12px',
							'line-height' => '30px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'widget_text',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the style for the widget texts.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '14px',
							'line-height' => '28px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_special_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Special Text Typography', 'zuperla' ),
					),
					array(
						'id' => 'leader_text',
						'type' => 'typography',
						'title' => esc_html__( 'Leader Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the style for the leader text. This is used in various elements (Text block, Testimonial...)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '36px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'subtitle_text',
						'type' => 'typography',
						'title' => esc_html__( 'Subtitle Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the style for the subtitle text. This is used in various elements (Slogan Subtitle...)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '10px',
							'line-height' => '14px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'small_text',
						'type' => 'typography',
						'title' => esc_html__( 'Small Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the style for the small text. This is used in various elements (Tags, Post Meta...)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '10px',
							'font-weight' => '400',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'link_text',
						'type' => 'typography',
						'title' => esc_html__( 'Link Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the style for the link text. This is used in various elements (Buttons, Read More...)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '10px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'pagination_text',
						'type' => 'typography',
						'title' => esc_html__( 'Pagination Text', 'zuperla' ),
						'subtitle' => esc_html__( 'Specify the pagination font.', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '300',
							'font-size' => '36px',
							'line-height' => '42px',
							'letter-spacing' => '',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id'   => 'info_custom_font_family',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Custom Font Family', 'zuperla' ),
					),
					array(
						'id' => 'custom_font_family_1',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 1', 'zuperla' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'custom_font_family_2',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 2', 'zuperla' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'custom_font_family_3',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 3', 'zuperla' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
					array(
						'id' => 'custom_font_family_4',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 4', 'zuperla' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'zuperla' ),
						'google' => $zuperla_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $zuperla_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Typography', 'zuperla' ),
				'id' => 'eut_redux_section_responsive_typography',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Headings', 'zuperla' ),
				'id' => 'eut_redux_section_responsive_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness for the Typography Headings ( H1-H6 ).', 'zuperla' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop_headings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape_headings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait_headings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile_headings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_mobile_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.7',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive First Group', 'zuperla' ),
				'id' => 'eut_redux_section_responsive_typography_first_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for the following elements: Page Title, Post Title, Portfolio Title, Product Title, Feature Section Title, Feature Section Description with Fullscreen mode.', 'zuperla' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.85',
					),
					array(
						'id'   => 'info_typography_mobile',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_mobile_threshold',
						'type' => 'text',
						'default' => '18',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 18).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.6',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Second Group', 'zuperla' ),
				'id' => 'eut_redux_section_responsive_typography_second_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for the following elements: Page Description, Post Description, Portfolio Description, Product Description, Feature Section Description with Custom Height, Leader Text, Subtitle Text, Link Texts, Menus and Buttons.', 'zuperla' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop2',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape2',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait2',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile2',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'zuperla' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'zuperla' ),
					),
					array(
						'id' => 'typography_mobile_threshold2',
						'type' => 'text',
						'default' => '13',
						'title' => esc_html__( 'Size Threshold', 'zuperla' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 13).', 'zuperla' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'zuperla' ),
						'options' => $zuperla_eutf_ratio_selection,
						'default' => '0.8',
					),
				),
			);

			$this->sections[] = array(
				'icon' => 'el-icon-file-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'CSS / JS Options', 'zuperla' ),
				'id' => 'eut_redux_section_css_js_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'css_code',
						'type' => 'ace_editor',
						'title' => esc_html__( 'CSS Code', 'zuperla' ),
						'subtitle' => esc_html__( 'Paste your CSS code here.', 'zuperla' ),
						'mode' => 'css',
						'theme' => 'monokai',
						'desc' => '',
						'default' => ''
					),
					array(
						'id' => 'custom_js',
						'type' => 'ace_editor',
						'mode' => 'javascript',
						'theme' => 'chrome',
						'title' => esc_html__( 'JS Code', 'zuperla' ),
						'subtitle' => esc_html__( 'Add your custom JavaScript code here. Please do not include any script tags.', 'zuperla' ),
						'desc' => '',
						'default' => ''
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Style Options', 'zuperla' ),
				'id' => 'eut_redux_section_style_options',
				'desc' => sprintf( wp_kses( __( 'To customize the color scheme, please use the <a href="%s">Live Color Customizer</a>.', 'zuperla' ), array( 'br' => array(), 'a' => array( 'href' => true, 'target' => true ) ) ), esc_url( admin_url('/customize.php') ) ),
				'customizer' => false,
				'fields' => array(
					array(
						'id'    => 'info_style_color_preset',
						'type'  => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Skin Presets', 'zuperla' ),
					),
					array(
						'id'        => 'skin_preset',
						'type'      => 'image_select',
						'presets'   => true,
						'title'     => esc_html__( 'Select your Skin', 'zuperla' ),
						'default'   => 0,
						'subtitle'  => esc_html__( 'Use the preset as you wish in order to customize your color scheme.', 'zuperla' ),
						'options'   => array(
							'palette-1'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-1.png', 'presets' => $zuperla_eutf_skin_palette_1 ),
							'palette-2'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-2.png', 'presets' => $zuperla_eutf_skin_palette_2 ),
							'palette-3'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-3.png', 'presets' => $zuperla_eutf_skin_palette_3 ),
							'palette-4'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-4.png', 'presets' => $zuperla_eutf_skin_palette_4 ),
							'palette-5'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-5.png', 'presets' => $zuperla_eutf_skin_palette_5 ),
							'palette-6'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-6.png', 'presets' => $zuperla_eutf_skin_palette_6 ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Top Bar', 'zuperla' ),
				'id' => 'eut_redux_section_colors_top_bar',
				'desc' => esc_html__( 'Set your color preferences for the TopBar (you will see the changes in the live preview only if TopBar is enabled).', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					//Top Bar Color Settings
					array(
						'id'          => 'top_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your Top Bar.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Font Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Font color for your Top Bar.', 'zuperla' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Link Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Link color for your Top Bar.', 'zuperla' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Hover color for your Top Bar.', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Header / Menu', 'zuperla' ),
				'id' => 'eut_redux_section_colors_header_menu',
				'desc' => esc_html__( 'Set your color preferences for the Header and Menu.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Default Header', 'zuperla' ),
				'id' => 'eut_redux_section_colors_default_header',
				'desc' => esc_html__( 'Set your color preferences for the Default Header. Keep in mind that the basic settings for the Default Header are in Theme Options > Header Options.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Default Header Color Settings
					array(
						'id'       => 'default_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'default_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a border color for the header.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '0',
					),
					//Menu Color Settings
					array(
						'id'          => 'default_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'zuperla' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu type. This will affect if you select the button or underline type.', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'default_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'zuperla' ),
						'default'     => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'zuperla' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_bg_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Hover/Active Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a background color for the hover or active sub menu.', 'zuperla' ),
						'default'     => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'zuperla' ),
						'default'     => '#333638',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_label_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Label Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a background color for the label.', 'zuperla' ),
						'default'     => '#454545',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_label_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Label Text Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a text color for the label.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Logo on Top Header', 'zuperla' ),
				'id' => 'eut_redux_section_colors_logotop_header',
				'desc' => esc_html__( 'Set your color preferences for the Logo on top Header. Keep in mind that the basic settings for the Logo on top Header are in Theme Options > Header Options.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'logo_top_header_logo_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Logo Area Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the logo area.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_logo_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Logo Area Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the logo area.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'logo_top_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a border color for the header.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '0.10',
					),
					array(
						'id'       => 'logo_top_header_menu_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Menu Area Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the menu area.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_menu_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Menu Area Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the menu area.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '1',
					),
					//Menu Color Settings
					array(
						'id'          => 'logo_top_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'zuperla' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu type. This will affect if you select the button or underline type.', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'logo_top_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'zuperla' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_bg_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Hover/Active Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a background color for the hover or active sub menu.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'zuperla' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Side Header', 'zuperla' ),
				'id' => 'eut_redux_section_colors_side_header',
				'desc' => esc_html__( 'Set your color preferences for the Side Header. Keep in mind that the basic settings for the Side Header are in Theme Options > Header Options.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'side_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'zuperla' ),
						'default'  => '#f7f7f7',
						'transparent' => false,
					),
					array(
						'id' => 'side_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '1',
					),
					//Menu Color Settings
					array(
						'id'          => 'side_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'side_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'zuperla' ),
						'default'     => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a border color.', 'zuperla' ),
						'default'     => '#323232',
						'transparent' => false,
					),
					array(
						'id' => 'side_header_border_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the borders.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '0.10',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sticky Header', 'zuperla' ),
				'id' => 'eut_redux_section_colors_sticky_header',
				'desc' => esc_html__( 'Set your color preferences for the Sticky Header. You can enable/disable, select the type and logo for the sticky header in Theme Options > Header Options > Sticky Header Options.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Sticky Header Color Settings
					array(
						'id'       => 'header_sticky_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a background color for the header.', 'zuperla' ),
						'default'  => '#101215',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'header_sticky_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a border color for the sticky header.', 'zuperla' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the sticky header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '0',
					),
					//Menu Color Settings
					array(
						'id'          => 'sticky_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'zuperla' ),
						'default'     => '#9c9c9c',
						'transparent' => false,
					),
					array(
						'id'          => 'sticky_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'zuperla' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'zuperla' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Light Header', 'zuperla' ),
				'id' => 'eut_redux_section_colors_light_header',
				'desc' => esc_html__( 'Notice that the Light Header is the transparent header with light fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'light_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'light_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'zuperla' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'light_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a border color for the light header.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'light_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the light header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '0',
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Dark Header', 'zuperla' ),
				'id' => 'eut_redux_section_colors_dark_header',
				'desc' => esc_html__( 'Notice that the Dark Header is the transparent header with dark fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'zuperla' ),
				'submenu' => false,
				'eut_colors' => true,
				'panel' => false,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'dark_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'dark_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'zuperla' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'dark_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a border color for the dark header.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'dark_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the dark header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '0',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive Header', 'zuperla' ),
				'id' => 'eut_redux_section_colors_responsive_header',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Header. These settings will affect when the responsive header appears, below 1024px.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_header_background_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Color Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the responsive header.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '1',
					),
					array(
						'id'          => 'responsive_header_elements_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements.', 'zuperla' ),
						'default'     => '#838383',
						'transparent' => false,
					),
					array(
						'id'          => 'responsive_header_elements_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements hover.', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive / Hidden Menu', 'zuperla' ),
				'id' => 'eut_redux_section_colors_responsive_menu',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Menu. These settings will also affect for the hidden menu.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the responsive menu.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the responsive menu.', 'zuperla' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the responsive menu.', 'zuperla' ),
						'default'  => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_close_btn_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Close Button Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the close button of the responsive menu.', 'zuperla' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the responsive menu.', 'zuperla' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when responsive menu opens.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_menu_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when responsive menu opens.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '0.90',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Anchor Menu', 'zuperla' ),
				'id' => 'eut_redux_section_colors_anchor_menu',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Anchor Menu in case you use one in any of your pages, posts items.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_anchor_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Background color for the Anchor Menu.', 'zuperla' ),
						'default'  => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Font color for the Anchor Menu.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Hover color for the Anchor Menu.', 'zuperla' ),
						'default'  => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_background_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Hover background color for the Anchor Menu.', 'zuperla' ),
						'default'  => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Border color for the Anchor Menu.', 'zuperla' ),
						'default'  => '#333638',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Main Content', 'zuperla' ),
				'id' => 'eut_redux_section_colors_main_content',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the main content area of your site.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'body_heading_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Headings Text Color (h1-h6)', 'zuperla' ),
						'subtitle'    => esc_html__( 'Pick a color for headings text.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the text.', 'zuperla' ),
						'default'  => '#272727',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the links.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for hover text.', 'zuperla' ),
						'default'  => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'       => 'body_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a border color.', 'zuperla' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'widget_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Widget Title Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for widget titles.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 1 Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for primary 1.', 'zuperla' ),
						'default'  => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_2_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 2 Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for primary 2.', 'zuperla' ),
						'default'  => '#1472DE',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_3_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 3 Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for primary 3.', 'zuperla' ),
						'default'  => '#fe3956',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_4_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 4 Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for primary 4.', 'zuperla' ),
						'default'  => '#411992',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_5_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 5 Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for primary 5.', 'zuperla' ),
						'default'  => '#355880',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_6_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 6 Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for primary 6.', 'zuperla' ),
						'default'  => '#db5111',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Blog /Post', 'zuperla' ),
				'id' => 'eut_redux_section_colors_blog_post',
				'desc' => esc_html__( 'Set your color preferences for your Blog / Post.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Blog Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_blog_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the blog title area and the color of the blog title. These settings will only affect in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'blog_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your blog title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'blog_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#f7f7f7',
						'required' => array( 'blog_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'blog_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'blog_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your blog title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'blog_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'blog_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your blog description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'blog_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'blog_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_post_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single post title area and the color of the post title. Notice that you can disable it, override it or even use the feature section when you edit your single posts.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your post title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'post_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#f7f7f7',
						'required' => array( 'post_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'post_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_subheading_color',
						'type' => 'select',
						'title' => esc_html__( 'Categories/Meta Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your post categories/meta.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'post_subheading_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Meta Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_subheading_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your post title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'post_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'post_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your post description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'post_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'post_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Bar', 'zuperla' ),
				'id' => 'eut_redux_section_colors_post_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single post.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'post_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Background color for the post bar.', 'zuperla' ),
						'default'  => '#f9f9f9',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'zuperla' ),
						'default'  => '#9b9b9b',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Page', 'zuperla' ),
				'id' => 'eut_redux_section_colors_page',
				'desc' => esc_html__( 'Set your color preferences for your page.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Page Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the predefined page title area and the color of the page title. Notice that you can disable it, override it or even use the feature section when you edit your single pages.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#f7f7f7',
						'required' => array( 'page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'page_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'page_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Search Page', 'zuperla' ),
				'id' => 'eut_redux_section_colors_search_page',
				'desc' => esc_html__( 'Set your color preferences for your search page.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Search Page Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_search_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the search page title area and the color of the page title.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'search_page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'search_page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#f7f7f7',
						'required' => array( 'search_page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'search_page_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'search_page_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'search_page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'search_page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'search_page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'search_page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Portfolio', 'zuperla' ),
				'id' => 'eut_redux_section_colors_portfolio',
				'desc' => esc_html__( 'Set your color preferences for your portfolio.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_portfolio_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single portfolio title area and the color of the portfolio title and description. Notice that you can disable it, override it or even use the feature section when you edit your single portfolio items.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'portfolio_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your portfolio title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'portfolio_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#f7f7f7',
						'required' => array( 'portfolio_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'portfolio_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your portfolio title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'portfolio_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'portfolio_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your portfolio description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'portfolio_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'portfolio_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Bar', 'zuperla' ),
				'id' => 'eut_redux_section_colors_portfolio_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single portfolio.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'portfolio_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Background color for the portfolio bar.', 'zuperla' ),
						'default'  => '#f9f9f9',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'zuperla' ),
						'default'  => '#9b9b9b',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Shop/Product', 'zuperla' ),
				'id' => 'eut_redux_section_colors_shop_product',
				'desc' => esc_html__( 'Set your color preferences for your Shop/Product.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Taxonomy Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_product_tax_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the product taxonomies title area and the color of the product taxonomies title and description.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_tax_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'product_tax_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'product_tax_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'product_tax_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_tax_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_tax_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_product_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single product title area and the color of the product title and description. Notice that you can disable it, override it or even use the feature section when you edit your single product items.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'product_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#f7f7f7',
						'required' => array( 'product_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'product_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'product_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Area', 'zuperla' ),
				'id' => 'eut_redux_section_colors_product_area',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the single product content area. Notice that you can override it when you edit your single product items.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'          => 'product_area_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your Product Area.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Headings color for your Product Area.', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Font color for your Product Area.', 'zuperla' ),
						'default'     => '#999999',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Link color for your Product Area.', 'zuperla' ),
						'default'     => '#FF7D88',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Hover color for your Product Area.', 'zuperla' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Border color for your Product Area.', 'zuperla' ),
						'default'     => '#e0e0e0',
						'transparent' => false,
					),
					array(
						'id'=>'product_area_button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the color of your Product Area Buttons.', 'zuperla' ),
						'options' => $zuperla_eutf_button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'product_area_button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the hover color of your Product Area Buttons.', 'zuperla' ),
						'options' => $zuperla_eutf_button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Bar', 'zuperla' ),
				'id' => 'eut_redux_section_colors_product_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single product.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'product_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Background color for the product bar.', 'zuperla' ),
						'default'  => '#f9f9f9',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'zuperla' ),
						'default'  => '#9b9b9b',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Events Calendar', 'zuperla' ),
				'id' => 'eut_redux_section_colors_events_calendar',
				'desc' => esc_html__( 'Set your color preferences for your Events.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Taxonomy Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_event_tax_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the event taxonomies title area and the color of the event taxonomies title and description.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_tax_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'event_tax_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#f7f7f7',
						'required' => array( 'event_tax_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_tax_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'event_tax_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_tax_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_tax_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_tax_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'event_tax_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_tax_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_tax_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'event_tax_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_event_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single event title area and the color of the event title and description. Notice that you can disable it, override it or even use the feature section when you edit your single event items.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'event_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#f7f7f7',
						'required' => array( 'event_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'event_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'event_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'event_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Bar', 'zuperla' ),
				'id' => 'eut_redux_section_colors_event_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single event.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'event_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Background color for the event bar.', 'zuperla' ),
						'default'  => '#f9f9f9',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'zuperla' ),
						'default'  => '#9b9b9b',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - bbPress Forum', 'zuperla' ),
				'id' => 'eut_redux_section_colors_bbpress',
				'desc' => esc_html__( 'Set your color preferences for your Forum.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Forum Title', 'zuperla' ),
				'id' => 'eut_redux_section_colors_forum_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the forum title area.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'forum_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_bg_color_selection_extra,
						'default' => 'primary-1',
					),
					array(
						'id'       => 'forum_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'forum_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'zuperla' ),
						'options' => $zuperla_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'forum_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'forum_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'zuperla' ),
						'options' => $zuperla_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'forum_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'zuperla' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'forum_title_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Footer', 'zuperla' ),
				'id' => 'eut_redux_section_colors_footer',
				'desc' => esc_html__( 'Set your color preferences for your Footer.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Area', 'zuperla' ),
				'id' => 'eut_redux_section_colors_footer_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Area. Define the Footer Area in Theme Options > Footer Options.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Area Color Settings
					array(
						'id'          => 'footer_widgets_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Area.', 'zuperla' ),
						'default'     => '#1E1E1E',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Headings color for your Footer Area.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Area.', 'zuperla' ),
						'default'     => '#808080',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Area.', 'zuperla' ),
						'default'     => '#808080',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Area.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Border color for your Footer Area.', 'zuperla' ),
						'default'     => '#1E1E1E',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Bar Area', 'zuperla' ),
				'id' => 'eut_redux_section_colors_footer_bar_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Bar Area(copyright area). Define the Footer Bar Area in Theme Options > Footer Options.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Bar Color Settings
					array(
						'id'          => 'footer_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Bar Area.', 'zuperla' ),
						'default'     => '#1E1E1E',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_bg_color_opacity',
						'type'        => 'select',
						'title'       => esc_html__('Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for your Footer Bar Area.', 'zuperla' ),
						'options'     => $zuperla_eutf_opacity_selection,
						"default"     => '1',
					),
					array(
						'id'          => 'footer_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Bar Area.', 'zuperla' ),
						'default'     => '#cecece',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Bar Area.', 'zuperla' ),
						'default'     => '#cecece',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'zuperla' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Bar Area.', 'zuperla' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Breadcrumbs', 'zuperla' ),
				'id' => 'eut_redux_section_colors_breadcrumbs',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Breadcrumbs in case you use then in any of your pages, posts or items.', 'zuperla' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_breadcrumbs_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Background color for the Breadcrumbs.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Font color for the Breadcrumbs.', 'zuperla' ),
						'default'  => '#6e6e6e',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Hover color for the Breadcrumbs.', 'zuperla' ),
						'default'  => '#2C0F73',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_divider_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Divider Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Divider color for the Breadcrumbs.', 'zuperla' ),
						'default'  => '#b2b2b2',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Border color for the Breadcrumbs.', 'zuperla' ),
						'default'  => '#e0e0e0',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sliding Area', 'zuperla' ),
				'id' => 'eut_redux_section_colors_sliding_area',
				'desc' => esc_html__( 'Set your color preferences for the Sliding Area.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'sliding_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the sliding area.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the sliding area.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the sliding area.', 'zuperla' ),
						'default'  => '#808080',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the sliding area.', 'zuperla' ),
						'default'  => '#808080',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the sliding area.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_close_btn_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Close Button Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the close button of the sliding area.', 'zuperla' ),
						'default'  => '#808080',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the sliding area.', 'zuperla' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when sliding area opens.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'sliding_area_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when sliding area opens.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '0',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Modals', 'zuperla' ),
				'id' => 'eut_redux_section_colors_modals',
				'desc' => esc_html__( 'Set your color preferences for the Modals.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'modal_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the modal.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the modal.', 'zuperla' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id' => 'modal_cursor_color_color',
						'type' => 'select',
						'title' => esc_html__( 'Navigation - Close Buttons Color', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select a color for the navigation and close buttons of the modal.', 'zuperla' ),
						'options' => array(
							'dark' => esc_html__( 'Dark', 'zuperla' ),
							'light' => esc_html__( 'Light', 'zuperla' ),
						),
						'default' => 'dark',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'modal_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the modal.', 'zuperla' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when modal opens.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'modal_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'zuperla' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when modal opens.', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						"default" => '1',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Back to Top', 'zuperla' ),
				'id' => 'eut_redux_section_colors_back_to_top',
				'desc' => esc_html__( 'Set your color preferences for Back to Top.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'back_to_top_icon_color',
						'type' => 'color',
						'title' => esc_html__( 'Back to Top Icon Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top icon.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'back_to_top_shape_color',
						'type' => 'color',
						'title' => esc_html__( 'Back to Top Icon Shape Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top shape.', 'zuperla' ),
						'default' => '#262829',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Privacy / Cookies', 'zuperla' ),
				'id' => 'eut_redux_section_colors_privacy_consent_bar',
				'desc' => esc_html__( 'Set your color preferences for Privacy / Cookies feature.', 'zuperla' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'privacy_bar_bg_color',
						'type' => 'color',
						'title' => esc_html__( 'Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the background color of Privacy Consent Info Bar.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'privacy_bar_bg_opacity',
						'type' => 'select',
						'title' => esc_html__( 'Background Opacity', 'zuperla' ),
						'options' => $zuperla_eutf_opacity_selection,
						'default' => '0.90',
					),
					array(
						'id'=>'privacy_bar_text_color',
						'type' => 'color',
						'title' => esc_html__( 'Text Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the color of Privacy Consent Info Bar Text.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_text_color',
						'type' => 'color',
						'title' => esc_html__( 'Button Text Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the color of Privacy Consent Info Bar Button Text.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_bg_color',
						'type' => 'color',
						'title' => esc_html__( 'Button Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the background color of Privacy Consent Info Bar Button.', 'zuperla' ),
						'default'  => '#2bc137',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_bg_hover_color',
						'type' => 'color',
						'title' => esc_html__( 'Button Background Hover Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the background hover color of Privacy Consent Info Bar Button.', 'zuperla' ),
						'default'  => '#17a523',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_text_color',
						'type' => 'color',
						'title' => esc_html__( 'Modal Button Text Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the color of Modal Button Text.', 'zuperla' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_bg_color',
						'type' => 'color',
						'title' => esc_html__( 'Modal Button Background Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the background color of Modal Button.', 'zuperla' ),
						'default'  => '#2bc137',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_bg_hover_color',
						'type' => 'color',
						'title' => esc_html__( 'Modal Button Background Hover Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the background hover color of Modal Button.', 'zuperla' ),
						'default'  => '#17a523',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Social Media', 'zuperla' ),
				'id' => 'eut_redux_section_social_media',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'social_options',
						'type' => 'sortable',
						'title' => esc_html__( 'Social URLs', 'zuperla' ),
						'subtitle' => esc_html__( 'Define and reorder your social URLs. Clear the input field for any social link you do not wish to display.', 'zuperla' ),
						'desc' => '',
						'label' => true,
						'options' => $zuperla_eutf_social_options,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-map-marker',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Map Options', 'zuperla' ),
				'id' => 'eut_redux_section_map_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'map_api_mode',
						'type' => 'button_set',
						'title' => esc_html__( 'Map API', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select the map API', 'zuperla' ),
						'options' => array(
							'google-maps' => esc_html__( 'Google Maps', 'zuperla' ),
							'openstreetmap' => esc_html__( 'OpenStreetMap', 'zuperla' ),
						),
						'default' => 'google-maps',
					),
					array(
						'id'=>'map_tile_url',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer URL', 'zuperla' ),
						'subtitle' => esc_html__( 'Define the Tile Layer. Used to load and display tile layers on the map.', 'zuperla' ),
						'desc' => sprintf( '%1$s: <a href="//wiki.openstreetmap.org/wiki/Tile_servers" target="_blank" rel="noopener noreferrer"> %2$s </a>', esc_html__('See more tile servers', 'zuperla'), esc_html__('here', 'zuperla') ),
						"default" => 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'=>'map_tile_url_subdomains',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer Subdomains', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define the Tile Layer subdomains.', 'zuperla' ),
						"default" => "abc",
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'=>'map_tile_attribution',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer Attribution', 'zuperla' ),
						'subtitle' => esc_html__( 'Enter the Tile Layer attribution', 'zuperla' ),
						"default" => '&copy; <a href="//www.openstreetmap.org/copyright">OpenStreetMap</a>',
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'       => 'gmap_api_key',
						'type'     => 'text',
						'title'    => esc_html__( 'Google API Key', 'zuperla' ),
						'subtitle' => $zuperla_gmap_api_key_link,
						'default'  => '',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id'=>'gmap_custom_enabled',
						'type' => 'button_set',
						'title' => esc_html__( 'Enable Custom Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to enable custom style for your map.', 'zuperla' ),
						'options' => array(
							'0' => esc_html__( 'No', 'zuperla' ),
							'1' => esc_html__( 'Custom', 'zuperla' ),
							'2' => esc_html__( 'Custom Code', 'zuperla' ),
						),
						'default' => '0',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id' => 'gmap_custom_code',
						'type' => 'textarea',
						'title' => esc_html__( 'Custom Code', 'zuperla' ),
						'subtitle' => esc_html__( 'Copy and paste the JSON here.', 'zuperla' ) . ' ' . $zuperla_gmap_style_link,
						'default' => '',
						'rows' => '30',
						'required' => array( 'gmap_custom_enabled', 'equals', '2' ),
					),
					array(
						'id'       => 'gmap_water_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Water color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for water', 'zuperla' ),
						'default'  => '#424242',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_landscape_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Landscape color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for landscape', 'zuperla' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_poi_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Point of interest color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for point of interest', 'zuperla' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_road_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Roads color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for roads', 'zuperla' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_label_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Label', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to enable labels for your map.', 'zuperla' ),
						'default' => 1,
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for labels', 'zuperla' ),
						'default'  => '#777777',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_stroke_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label Stroke color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a stroke color for labels', 'zuperla' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_country_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Country Stroke color', 'zuperla' ),
						'subtitle' => esc_html__( 'Pick a color for country stroke.', 'zuperla' ),
						'default'  => '#000000',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_zoom_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Zoom Control', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to enable zoom control for your map.', 'zuperla' ),
						'default' => 0,
						'required' => array( 'gmap_custom_enabled', 'not', '0' ),
					),
					array(
						'id' => 'gmap_type_control',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Map Type Control', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to enable map type control for your map.', 'zuperla' ),
						'default' => 0,
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id' => 'gmap_gesture_handling',
						'type' => 'select',
						'title' => esc_html__( 'Gesture Handling', 'zuperla' ),
						'subtitle'=> esc_html__( 'Control how the API handles gestures on the map. For mobile web in particular, users may swipe the touchscreen, intending to scroll the page, but change the scale of the map instead.', 'zuperla' ),
						'options' => array(
							'greedy' => esc_html__( 'Greedy', 'zuperla' ),
							'cooperative' => esc_html__( 'Cooperative', 'zuperla' ),
							'none' => esc_html__( 'None', 'zuperla' ),
							'auto' => esc_html__( 'Auto', 'zuperla' ),
						),
						'default' => 'auto',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-error',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( '404 Page', 'zuperla'),
				'id' => 'eut_redux_section_404',
				'subtitle' => esc_html__( 'You can find the settings for the 404 page here.', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_404_header',
						'type' => 'switch',
						'title' => esc_html__( 'Show Header', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show header.', 'zuperla' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_page_404_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Page 404 Header Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Set the style for the default page header.', 'zuperla' ),
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id' => 'page_404_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Header Style', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'zuperla' ),
						'options' => $zuperla_eutf_header_style,
						'default' => 'dark',
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id' => 'page_404_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Header Overlapping', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single page.', 'zuperla' ),
						'options' => $zuperla_eutf_enable_selection,
						'default' => 'yes',
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id'       => '404_content_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Page 404 Content Background Image / Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select a background image or color for the 404 page.', 'zuperla' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#ffffff',
						),
					),
					array(
						'id' => 'page_404_content',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Page 404 Content', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the content of your 404 page, you can also use shortcodes.', 'zuperla' ),
						'default' => '<h3><em>404 ERROR</em></h3><h1>Hey there mate!</h1><h2>Your lost treasure is not found here...</h2><p class="eut-leader-text">Sorry! The page you are looking for wasn\'t found!</p>',
					),
					array(
						'id' => 'page_404_search',
						'type' => 'checkbox',
						'title' => esc_html__( 'Show Search Box', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show a search box.', 'zuperla' ),
						'default' => 0,
					),
					array(
						'id' => 'page_404_home_button',
						'type' => 'checkbox',
						'title' => esc_html__( 'Show Back to home Button', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show a back to home button.', 'zuperla' ),
						'default' => 1,
					),
					array(
						'id' => 'page_404_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Show Footer', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show footer.', 'zuperla' ),
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Miscellaneous', 'zuperla' ),
				'id' => 'eut_redux_section_miscellaneous',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'       => 'feature_section_post_types',
						'type'     => 'select',
						'multi'    => true,
						'title'    => esc_html__( 'Feature Section Post Types', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the post types you wish to enable the Feature Section.', 'zuperla' ),
						'options' => $zuperla_eutf_feature_section_post_types_selection,
						'default' => array( 'page', 'portfolio' ),
					),
					array(
						'id'=>'wp_gallery_popup',
						'type' => 'switch',
						'title' => esc_html__( 'Lightbox for WordPress Gallery', 'zuperla' ),
						'subtitle'=> esc_html__( 'Toggle lightbox for native WordPress Gallery on or off.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
					array(
						'id'=>'wp_tagcloud',
						'type' => 'switch',
						'title' => esc_html__( 'Default WordPress Tag Cloud', 'zuperla' ),
						'subtitle'=> esc_html__( 'Toggle default tag cloud on or off.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
					array(
						'id'=>'logo_as_text_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Logo as text', 'zuperla' ),
						'subtitle'=> esc_html__( 'Toggle logo as text on or off. When on, all logo images will be replaced with site name.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
					array(
						'id'=>'logo_custom_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Logo Custom Link URL', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your logo. If empty homepage will be used instead.', 'zuperla' ),
						"default" => '',
					),
					array(
						'id'=>'menu_header_integration',
						'type' => 'select',
						'title' => esc_html__( 'Main Menu Integration', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the main menu integration method. Selection available for custom menu integration.', 'zuperla' ),
						'options' => $zuperla_eutf_header_menu_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'sidebar_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Sidebar Headings Tag', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Sidebar Titles.', 'zuperla' ),
						'options' => $zuperla_eutf_headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'footer_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Footer Sidebar Headings Tag', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Footer Sidebar Titles.', 'zuperla' ),
						'options' => $zuperla_eutf_headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'disable_seo_page_analysis',
						'type' => 'checkbox',
						'title' => esc_html__( 'Disable WordPress SEO Page Analysis', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to disable WordPress SEO page analysis.', 'zuperla' ),
						'default' => 0,
					),
					array(
						'id' => 'spinner_image',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Spinner Image', 'zuperla' ),
						'subtitle' => esc_html__( 'Upload a custom image if you want to replace the default graphic spinner.', 'zuperla' ),
					),
					array(
						'id'=>'placeholder_mode',
						'type' => 'select',
						'title' => esc_html__( 'Placeholder Mode', 'zuperla' ),
						'subtitle' => esc_html__( 'Select what images to display as placeholders.', 'zuperla' ),
						'options' => array(
							'dummy' => esc_html__( 'Theme Dummy Image', 'zuperla' ),
							'unsplash' => esc_html__( 'unsplash', 'zuperla' ),
							//'placehold' => esc_html__( 'placehold.it', 'zuperla' ),
						),
						'default' => 'dummy',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'device_animations',
						'type' => 'switch',
						'title' => esc_html__( 'Device Animations', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable/Disable animations for mobile devices.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
					array(
						'id'=>'device_hover_single_tap',
						'type' => 'switch',
						'title' => esc_html__( 'Device Single Tap', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable/Disable single tap for links/hovers on devices.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Builder Addons', 'zuperla' ),
				'desc' => esc_html__( 'Enable/Disable default Page Builder functionality.', 'zuperla' ),
				'id' => 'eut_redux_section_page_builder',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'vc_grid_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Grid Elements', 'zuperla' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Grid elements on or off.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
					array(
						'id'=>'vc_charts_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Charts Elements', 'zuperla' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Charts elements on or off.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
					array(
						'id'=>'vc_woo_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder WooCommerce Elements', 'zuperla' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder WooCommerce elements on or off.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
					array(
						'id'=>'vc_auto_updater',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Auto Updater', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable/Disable Page Builder Auto Updater ( Activation Required ).', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					),
/* 					array(
						'id'=>'vc_content_manager_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Theme Content Manager', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable/Disable Theme Content Manager.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__('On', 'zuperla' ),
						'off' => esc_html__('Off', 'zuperla' ),
					), */
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Button Settings', 'zuperla' ),
				'desc' => esc_html__( 'Set the style for the buttons.', 'zuperla' ),
				'id' => 'eut_redux_section_buttons',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'button_type',
						'type' => 'select',
						'title' => esc_html__( 'Button Type', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the type of your Buttons.', 'zuperla' ),
						'options' => $zuperla_eutf_button_type_selection,
						'default' => 'simple',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_shape',
						'type' => 'select',
						'title' => esc_html__( 'Button Shape', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the shape of your Buttons.', 'zuperla' ),
						'options' => $zuperla_eutf_button_shape_selection,
						'default' => 'extra-round',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the color of your Buttons.', 'zuperla' ),
						'options' => $zuperla_eutf_button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the hover color of your Buttons.', 'zuperla' ),
						'options' => $zuperla_eutf_button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Back To Top', 'zuperla' ),
				'desc' => esc_html__( 'Set the style for the back to top button.', 'zuperla' ),
				'id' => 'eut_redux_section_back_top_top',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'back_to_top_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Back to Top', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Back to Top button.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'back_to_top_shape',
						'type' => 'select',
						'title' => esc_html__( 'Back to Top Icon Shape', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the shape of Back to Top button.', 'zuperla' ),
						'options' => array(
							'none' => esc_html__( 'No Shape', 'zuperla' ),
							'square' => esc_html__( 'Square', 'zuperla' ),
							'round' => esc_html__( 'Round', 'zuperla' ),
							'circle' => esc_html__( 'Circle', 'zuperla' ),
						),
						'default' => 'circle',
						'validate' => 'not_empty',
						'required' => array( 'back_to_top_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Meta Tags', 'zuperla' ),
				'desc' => esc_html__( 'Configure your site meta tags.', 'zuperla' ),
				'id' => 'eut_redux_section_meta_tags',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'meta_viewport_responsive',
						'type' => 'switch',
						'title' => esc_html__( 'Responsive Viewport Meta', 'zuperla' ),
						'subtitle'=> esc_html__( 'Enable or Disable Responsive Viewport.', 'zuperla' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'meta_opengraph',
						'type' => 'switch',
						'title' => esc_html__( 'Open Graph Meta', 'zuperla' ),
						'subtitle'=> esc_html__( 'Generate open graph meta tags for social sharing ( e.g: Facebook, Google+, LinkedIn etc )', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'meta_twitter',
						'type' => 'switch',
						'title' => esc_html__( 'Twitter Card Meta', 'zuperla' ),
						'subtitle'=> esc_html__( 'Generate meta tags for Twitter', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-wrench',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Coming Soon', 'zuperla' ),
				'id' => 'eut_redux_section_coming_soon',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'coming_soon_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Coming Soon', 'zuperla' ),
						'subtitle'=> esc_html__( 'Toggle Coming Soon Redirect on or off.', 'zuperla' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'zuperla' ),
						'off' => esc_html__( 'Off', 'zuperla' ),
					),
					array(
						'id'=>'coming_soon_template',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Template', 'zuperla' ),
						'subtitle' => esc_html__( 'Select content only or use the defined page template.', 'zuperla' ),
						'options' => array(
							'content' => esc_html__( 'Content Only', 'zuperla' ),
							'template' => esc_html__( 'Use Page Template', 'zuperla' ),
						),
						'default' => 'content',
						'validate' => 'not_empty',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'coming_soon_page',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Page', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the page for your redirection.', 'zuperla' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),

				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-resize-small',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Media Sizes', 'zuperla' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'feature_section_bg_size',
						'type' => 'select',
						'title' => esc_html__( 'Feature Section Background Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select what background image to show for Feture Sections.', 'zuperla' ),
						'options' => array(
							'responsive' => esc_html__( 'Responsive', 'zuperla' ),
							'extra-extra-large' => esc_html__( 'Extra Extra Large', 'zuperla' ),
							'full' => esc_html__( 'Full', 'zuperla' ),
						),
						'default' => 'responsive',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'row_section_bg_size',
						'type' => 'select',
						'title' => esc_html__( 'Row Section Background Image Size', 'zuperla' ),
						'subtitle' => esc_html__( 'Select what background image to show for Row Sections.', 'zuperla' ),
						'options' => array(
							'responsive' => esc_html__( 'Responsive', 'zuperla' ),
							'extra-extra-large' => esc_html__( 'Extra Extra Large', 'zuperla' ),
							'full' => esc_html__( 'Full', 'zuperla' ),
						),
						'default' => 'responsive',
						'validate' => 'not_empty',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-lock',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Privacy / Cookies', 'zuperla' ),
				'desc' => esc_html__( 'The following shortcodes will allow your users to change certain behavior of your website regarding privacy.', 'zuperla' ) . '<br>' .
					'<ul>' .
					'<li><strong>zuperla_privacy_required</strong> - ' . esc_html__( 'displays a required content for your site e.g: Cloudlflare, CDN etc.', 'zuperla' ) . '</li>' .
					'<li><strong>zuperla_privacy_gtracking</strong> - ' . esc_html__( 'allows a user to enable/disable Google Analytics tracking code in the user\'s browser', 'zuperla' ) . '</li>' .
					'<li><strong>zuperla_privacy_gfonts</strong> - ' . esc_html__( 'allows a user to enable/disable the use of Google Fonts in the user\'s browser', 'zuperla' ) . '</li>' .
					'<li><strong>zuperla_privacy_gmaps</strong> - ' . esc_html__( 'allows a user to enable/disable the use of Google Maps in the user\'s browser', 'zuperla' ) . '</li>' .
					'<li><strong>zuperla_privacy_video_embeds</strong> - ' . esc_html__( 'allows a user to enable/disable video embeds in the user\'s browser', 'zuperla' ) . '</li>' .
					'<li><strong>zuperla_privacy_policy_page_link</strong> - ' . esc_html__( 'displays a link to the privacy policy page set from the WordPress admin panel', 'zuperla' ) . '</li>' .
					'<li><strong>zuperla_privacy_preferences_link</strong> - ' . esc_html__( 'displays a link to the privacy preferences as defined in the Privacy Consent Info Bar', 'zuperla' ) . '</li>' .
					'</ul>' .
					esc_html__( 'You can use any of them in your privacy policy or in any text area that allows shortcodes.', 'zuperla' ) . '<br><br>' .
					'<strong>[zuperla_privacy_required value="required"]For performance and security reasons we use Cloudflare[/zuperla_privacy_required]</strong><br>' .
					'<strong>[zuperla_privacy_gtracking]</strong><br>' .
					'<strong>[zuperla_privacy_gfonts]</strong><br>' .
					'<strong>[zuperla_privacy_gmaps]</strong><br>' .
					'<strong>[zuperla_privacy_video_embeds]</strong><br>' .
					'<strong>[zuperla_privacy_policy_page_link]</strong><br>' .
					'<strong>[zuperla_privacy_preferences_link]</strong><br><br>' .
					esc_html__( 'Note: To change the default text add your text inside the shortcode tags [shortcode]Your text[/shortcode]', 'zuperla' ),
				'id' => 'eut_redux_section_privacy_cookies',
				'submenu' => true,
				'customizer' => false,
				'class' => 'eut-redux-desc-full',
				'fields' => array(
					array(
						'id'   => 'info_style_blocking_content',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Privacy Content Blocking Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Configure the privacy content blocking settings.', 'zuperla' ) . '<br>' . esc_html__( 'Note: The usage of the Blocking content feature is not recommended if you have added caching plugins or page rules to cache static HTML content (aggressive cache). If you use this feature you might need to disable such type of caching.', 'zuperla' ),
					),
					array(
						'id' => 'privacy_content_blocking_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Privacy Content Blocking', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to enable/disable privacy content blocking.', 'zuperla' ) .'<br><br>' . esc_html__( 'Note: if you disable content blocking certain privacy shortcodes will be automatically disabled.', 'zuperla' ),
						'default' => 1,
					),
					array(
						'id'      => 'privacy_initial_state',
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Privacy Initial Blocking State', 'zuperla' ),
						'subtitle'    => esc_html__( 'Check if you want to block the content when the page loads.', 'zuperla' ),
						'options'  => array(
							'gtracking'     => 'Google Tracking',
							'gfonts' => 'Google Fonts',
							'gmaps' => 'Google Maps',
							'video-embeds'   => 'Embed Videos'
						),
						'default' => array(
							'gtracking'     => '0',
							'gfonts' => '0',
							'gmaps' => '0',
							'video-embeds'   => '0'
						),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_fallback_content',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Privacy Fallback Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Configure the privacy fallback info box.', 'zuperla' ),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_fallback_content',
						'type' => 'textarea',
						'rows' => '2',
						'title' => esc_html__( 'Privacy Fallback Content', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the fallback text when the content is blocked.', 'zuperla' ),
						'default' => 'This content is blocked. Please review your Privacy Preferences.',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'privacy_fallback_preferences_link_visibility',
						'type'     => 'checkbox',
						'title'    => esc_html__('Display Privacy Preferences link', 'zuperla'),
						'subtitle' => esc_html__('Select if you want to display the Privacy Preferences link ( if defined in the privacy consent bar ).', 'zuperla'),
						'default'  => '1',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'privacy_fallback_content_link_visibility',
						'type'     => 'checkbox',
						'title'    => esc_html__('Display redirect link of the blocked content', 'zuperla'),
						'subtitle' => esc_html__('Select if you want to display a redirect link of the blocked content ( blocked content will open in a new tab e.g: YouTube website ).', 'zuperla'),
						'default'  => '1',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_consent_bar',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Privacy Consent Info Bar Settings', 'zuperla' ),
						'subtitle'=> esc_html__( 'Configure the consent info bar.', 'zuperla' ),
					),
					array(
						'id' => 'privacy_consent_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Privacy Consent Info Bar', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to show a privacy consent info bar.', 'zuperla' ),
						'default' => 0,
					),
					array(
						'id' => 'privacy_consent_bar_position',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Privacy Consent Info Bar Position', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the position for Privacy Consent Info Bar', 'zuperla' ),
						'options' => array(
							'center' => esc_html__( 'Center', 'zuperla' ),
							'left' => esc_html__( 'Left', 'zuperla' ),
							'right' => esc_html__( 'Right', 'zuperla' ),
						),
						'default' => 'center',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_consent_bar_content',
						'type' => 'textarea',
						'rows' => '2',
						'title' => esc_html__( 'Privacy Info Bar Content', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the content of your consent info bar.', 'zuperla' ),
						'default' => 'Our website uses cookies, mainly from 3rd party services. Define your Privacy Preferences and/or agree to our use of cookies.',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'privacy_agreement_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Agreement Button Label', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy agreement button. Leave empty to remove.', 'zuperla' ),
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
						"default" => 'I Agree',
					),
					array(
						'id'=>'privacy_preferences_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Button Label', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy preferences button. Leave empty to remove.', 'zuperla' ),
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
						"default" => 'Privacy Preferences',
					),
					array(
						'id' => 'privacy_preferences_button_link',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Privacy Preferences Button Link Mode', 'zuperla' ),
						'subtitle' => esc_html__( 'Select the preferences button link mode: modal, privacy policy page or custom url.', 'zuperla' ),
						'options' => array(
							'modal' => esc_html__( 'Modal', 'zuperla' ),
							'privacy_page' => esc_html__( 'Privacy Policy Page', 'zuperla' ),
							'custom_url' => esc_html__( 'Custom URL', 'zuperla' ),
						),
						'default' => 'modal',
						'validate' => 'not_empty',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'privacy_preferences_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Custom Link URL', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your privacy preferences button.', 'zuperla' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '',
					),
					array(
						'id'=>'privacy_preferences_link_target',
						'type' => 'select',
						'title' => esc_html__( 'Privacy Preferences Custom Link Target', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define the target for your custom url, same or new page.', 'zuperla' ),
						'options' => array(
							'_self' => esc_html__( 'Same Page', 'zuperla' ),
							'_blank' => esc_html__( 'New page', 'zuperla' ),
						),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '_self',
					),
					array(
						'id' => 'privacy_consent_modal_content',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Privacy Modal Content', 'zuperla' ),
						'subtitle' => esc_html__( 'Type the content of your modal consent dialog.', 'zuperla' ),
						'default' => '<h5>Privacy Preferences</h5><p>When you visit our website, it may store information through your browser from specific services, usually in the form of cookies. Here you can change your Privacy preferences. It is worth noting that blocking some types of cookies may impact your experience on our website and the services we are able to offer.</p><div>[zuperla_privacy_gtracking][zuperla_privacy_gfonts][zuperla_privacy_gmaps][zuperla_privacy_video_embeds]</div>',
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'modal' ),
						),
					),
					array(
						'id'=>'privacy_refresh_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Refresh Button Label', 'zuperla' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy refresh button. Leave empty to remove.', 'zuperla' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'modal' ),
						),
						"default" => 'Save Preferences',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-cog',
				'title' => esc_html__( 'Utilities', 'zuperla' ),
				'id' => 'eut_redux_section_utilities',
				'submenu' => true,
				'customizer' => false,
				'fields' => array()
			);
			$this->sections[] = array(
				'icon' => 'el-icon-cogs',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Theme Performance', 'zuperla' ),
				'id' => 'eut_redux_section_advanced',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
 					array(
						'id'=>'combine_js',
						'type' => 'select',
						'title' => esc_html__( 'Combine/Compress Theme Scripts', 'zuperla' ),
						'subtitle'=> esc_html__( 'Select if you want to combine/compress theme scripts.', 'zuperla' ),
						'options' => array(
							'1' => esc_html__( 'Partial merge/compression of theme javascript files', 'zuperla' ),
							'0' => esc_html__( 'No merge/compression of theme javascript files', 'zuperla' ),
						),
						"default" => '1',
					),
				)
			);

			if ( class_exists( 'Envato_Market' ) ) {
				$envato_market_link = 'admin.php?page=envato-market';
			} else {
				$envato_market_link = 'admin.php?page=zuperla-tgmpa-install-plugins';
			}
			$update_message = esc_html__( "Envato official solution is recommended for theme updates using the new Envato Market API.", 'zuperla' ) .
					"<br/>" . esc_html__( "You can now update the theme using the", 'zuperla' ) . " " . "<a href='" . esc_url( admin_url() . $envato_market_link ) . "'>" . esc_html__( "Envato Market", 'zuperla' ) . "</a>" . " ". esc_html__( "plugin", 'zuperla' ) . "." .
					" " . esc_html__( "For more information read the related article in our", 'zuperla' ) . " " . "<a href='//docs.euthemians.com/tutorials/envato-market-wordpress-plugin-for-theme-updates/' target='_blank'>" . esc_html__( "documentation", 'zuperla' ) . "</a>.";
			$this->sections[] = array(
				'icon' => 'el-icon-repeat',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Theme Update', 'zuperla' ),
				'id' => 'eut_redux_section_theme_update',
				'desc' => $update_message,
				'submenu' => true,
				'customizer' => false,
				'fields' => array()
			);

			//Show Sections available only in customizer
			if ( ( defined( 'ZUPERLA_EUTF_THEME_REDUX_CUSTOM_PANEL' ) &&  true === ZUPERLA_EUTF_THEME_REDUX_CUSTOM_PANEL ) || $this->zuperla_eutf_redux_customizer_visibility() ) {
				foreach ( $this->sections as $k => $section ) {
					if ( isset( $section['eut_colors'] ) && isset( $section['panel'] ) ) {
						unset($this->sections[$k]['panel']);
					}
				}
			}

		}


		public function setArguments() {

			$theme = wp_get_theme();
			$theme_version = $theme->get('Version');
			if( is_child_theme() ) {
				$parent_theme = wp_get_theme( get_template() );
				$theme_version .= ' ( ' . $parent_theme->get('Name') .': ' . $parent_theme->get('Version') . ' )';
			}

			$this->args = array(
				// TYPICAL -> Change these values as you need/desire
				'opt_name' => 'zuperla_eutf_options', // This is where your data is stored in the database and also becomes your global variable name.
				'display_name' => ' ', // Name that appears at the top of your panel
				'display_version' => $theme_version, // Version that appears at the top of your panel
				'menu_type' => 'submenu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
				'allow_sub_menu' => false, // Show the sections below the admin menu item or not
				'menu_title' => esc_html__( 'Theme Options', 'zuperla' ),
				'page' => esc_html__( 'Theme Options', 'zuperla' ),
				'google_api_key' => '', // Must be defined to add google fonts to the typography module
				'admin_bar' => false, // Show the panel pages on the admin bar
				'global_variable' => 'zuperla_eutf_options', // Set a different name for your global variable other than the opt_name
				'dev_mode' => false, // Show the time the page took to load, etc
				'customizer' => true, // Enable basic customizer support
				'ajax_save' => true,
				'ajax_max_input' => true,
				'templates_path' => get_template_directory() . '/includes/admin/templates/panel', //Redux Template files

				// OPTIONAL -> Give you extra features
				'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
				'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
				'page_permissions' => 'manage_options', // Permissions needed to access the options panel.
				'menu_icon' => get_template_directory_uri() .'/includes/images/adminmenu/theme.png', // Specify a custom URL to an icon
				'last_tab' => '', // Force your panel to always open to a specific tab (by id)
				'page_icon' => 'icon-themes', // Icon displayed in the admin panel next to your menu_title
				'page_slug' => 'zuperla_eutf_options', // Page slug used to denote the panel
				'save_defaults' => true, // On load save the defaults to DB before user clicks save or not
				'default_show' => false, // If true, shows the default value next to each field that is not the default value.
				'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *

				// CAREFUL -> These options are for advanced use only
				'output_location' => array( 'frontend', 'admin' ),
				'use_cdn' => false,
				'transient_time' => 60 * MINUTE_IN_SECONDS,
				'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
				'output_tag' => true, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

				// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
				'database' => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
				'show_import_export' => true,
				'disable_tracking' => true,
				'allow_tracking' => false,
				'help_tabs' => array(),
				'help_sidebar' => '',
			);

			// Panel Intro text -> before the form
			$this->args['intro_text'] ='';

			// Add content after the form.
			$this->args['footer_text'] = '';
			$this->args['footer_credit'] = ' ';

		}

	}

	global $zuperla_eutf_redux_framework;
	$zuperla_eutf_redux_framework = new Zuperla_Eutf_Redux_Framework_config();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
