<?php

/*
*	Admin screen functions
*
* 	@version	1.0
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

function zuperla_eutf_admin_menu(){
	if ( current_user_can( 'edit_theme_options' ) ) {
		add_menu_page( 'Zuperla', 'Zuperla', 'edit_theme_options', 'zuperla', 'zuperla_eutf_admin_page_welcome', get_template_directory_uri() .'/includes/images/adminmenu/theme.png', 4 );
		add_submenu_page( 'zuperla', esc_html__('Welcome','zuperla'), esc_html__('Welcome','zuperla'), 'edit_theme_options', 'zuperla', 'zuperla_eutf_admin_page_welcome' );
		add_submenu_page( 'zuperla', esc_html__('Status','zuperla'), esc_html__('Status','zuperla'), 'edit_theme_options', 'zuperla-status', 'zuperla_eutf_admin_page_status' );
		add_submenu_page( 'zuperla', esc_html__( 'Custom Sidebars', 'zuperla' ), esc_html__( 'Custom Sidebars', 'zuperla' ), 'edit_theme_options','zuperla-sidebars','zuperla_eutf_admin_page_sidebars');
		add_submenu_page( 'zuperla', esc_html__( 'Import Demos', 'zuperla' ), esc_html__( 'Import Demos', 'zuperla' ), 'edit_theme_options','zuperla-import','zuperla_eutf_admin_page_import');
	}
}

add_action( 'admin_menu', 'zuperla_eutf_admin_menu' );


function zuperla_eutf_tgmpa_plugins_links(){
	zuperla_eutf_print_admin_links('plugins');
}
add_action( 'zuperla_eutf_before_tgmpa_plugins', 'zuperla_eutf_tgmpa_plugins_links' );

function zuperla_eutf_admin_page_welcome(){
	require_once get_template_directory() . '/includes/admin/pages/eut-admin-page-welcome.php';
}
function zuperla_eutf_admin_page_status(){
	require_once get_template_directory() . '/includes/admin/pages/eut-admin-page-status.php';
}
function zuperla_eutf_admin_page_sidebars(){
	require_once get_template_directory() . '/includes/admin/pages/eut-admin-page-sidebars.php';
}
function zuperla_eutf_admin_page_import(){
	require_once get_template_directory() . '/includes/admin/pages/eut-admin-page-import.php';
}

function zuperla_eutf_print_admin_links( $active_tab = 'status' ) {
?>
<h2 class="nav-tab-wrapper">
	<a href="?page=zuperla" class="nav-tab <?php echo 'welcome' == $active_tab ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Welcome','zuperla'); ?></a>
	<a href="?page=zuperla-status" class="nav-tab <?php echo 'status' == $active_tab ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Status','zuperla'); ?></a>
	<a href="?page=zuperla-sidebars" class="nav-tab <?php echo 'sidebars' == $active_tab ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Custom Sidebars','zuperla'); ?></a>
	<a href="?page=zuperla-import" class="nav-tab <?php echo 'import' == $active_tab ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Import Demos','zuperla'); ?></a>
	<a href="?page=zuperla-tgmpa-install-plugins" class="nav-tab <?php echo 'plugins' == $active_tab ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Theme Plugins','zuperla'); ?></a>
	<?php do_action( 'zuperla_eutf_admin_links', $active_tab ); ?>
</h2>
<?php
}

//Omit closing PHP tag to avoid accidental whitespace output errors.