<?php

/*
*	Admin functions and definitions
*
* 	@version	1.0
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

/**
 * Default hidden metaboxes for portfolio
 */
function zuperla_eutf_change_default_hidden( $hidden, $screen ) {
    if ( 'portfolio' == $screen->id ) {
        $hidden = array_flip( $hidden );
        unset( $hidden['portfolio_categorydiv'] ); //show portfolio category box
        $hidden = array_flip( $hidden );
        $hidden[] = 'postexcerpt';
		$hidden[] = 'postcustom';
		$hidden[] = 'commentstatusdiv';
		$hidden[] = 'commentsdiv';
		$hidden[] = 'authordiv';
    }
    return $hidden;
}
add_filter( 'default_hidden_meta_boxes', 'zuperla_eutf_change_default_hidden', 10, 2 );

/**
 * Enqueue scripts and styles for the back end.
 */
function zuperla_eutf_backend_scripts( $hook ) {
	global $post, $pagenow;

	wp_register_style( 'zuperla-eutf-page-feature-section', get_template_directory_uri() . '/includes/css/eut-page-feature-section.css', array(), time() );
	wp_register_style( 'zuperla-eutf-admin-meta', get_template_directory_uri() . '/includes/css/eut-admin-meta.css', array(), time() );
	wp_register_style( 'zuperla-eutf-custom-sidebars', get_template_directory_uri() . '/includes/css/eut-custom-sidebars.css', array(), time() );
	wp_register_style( 'zuperla-eutf-custom-nav-menu', get_template_directory_uri() . '/includes/css/eut-custom-nav-menu.css', array(), time() );
	wp_register_style( 'zuperla-eutf-status', get_template_directory_uri() . '/includes/css/eut-status.css', array(), time() );
	wp_register_style( 'zuperla-eutf-admin-panel', get_template_directory_uri() . '/includes/css/eut-admin-panel.css', array(), time() );

	$zuperla_eutf_upload_slider_texts = array(
		'modal_title' => esc_html__( 'Insert Images', 'zuperla' ),
		'modal_button_title' => esc_html__( 'Insert Images', 'zuperla' ),
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_post_titles' => wp_create_nonce( 'zuperla-eutf-get-post-titles' ),
		'nonce_post_titles_select_lookup' => wp_create_nonce( 'zuperla-eutf-post-select-lookup' ),
		'nonce_feature_slider_media' => wp_create_nonce( 'zuperla-eutf-get-feature-slider-media' ),
		'nonce_slider_media' => wp_create_nonce( 'zuperla-eutf-get-slider-media' ),
	);

	$zuperla_eutf_upload_image_replace_texts = array(
		'modal_title' => esc_html__( 'Replace Image', 'zuperla' ),
		'modal_button_title' => esc_html__( 'Replace Image', 'zuperla' ),
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_replace' => wp_create_nonce( 'zuperla-eutf-get-replaced-image' ),
	);

	$zuperla_eutf_upload_media_texts = array(
		'modal_title' => esc_html__( 'Insert Media', 'zuperla' ),
		'modal_button_title' => esc_html__( 'Insert Media', 'zuperla' ),
	);

	$zuperla_eutf_feature_section_texts = array(
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_map_point' => wp_create_nonce( 'zuperla-eutf-get-map-point' ),
	);

	$zuperla_eutf_custom_sidebar_texts = array(
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_custom_sidebar' => wp_create_nonce( 'zuperla-eutf-get-custom-sidebar' ),
	);

	wp_register_script( 'zuperla-eutf-status', get_template_directory_uri() . '/includes/js/eut-status.js', array( 'jquery'), time(), false );
	wp_register_script( 'zuperla-eutf-codes-script', get_template_directory_uri().'/includes/js/eut-codes.js', array( 'jquery'), time(), false );

	wp_register_script( 'zuperla-eutf-custom-sidebars', get_template_directory_uri() . '/includes/js/eut-custom-sidebars.js', array( 'jquery'), time(), false );
	wp_localize_script( 'zuperla-eutf-custom-sidebars', 'zuperla_eutf_custom_sidebar_texts', $zuperla_eutf_custom_sidebar_texts );

	wp_register_script( 'zuperla-eutf-upload-slider-script', get_template_directory_uri() . '/includes/js/eut-upload-slider.js', array( 'jquery'), time(), false );
	wp_localize_script( 'zuperla-eutf-upload-slider-script', 'zuperla_eutf_upload_slider_texts', $zuperla_eutf_upload_slider_texts );

	wp_register_script( 'zuperla-eutf-upload-feature-slider-script', get_template_directory_uri() . '/includes/js/eut-upload-feature-slider.js', array( 'jquery'), time(), false );
	wp_localize_script( 'zuperla-eutf-upload-feature-slider-script', 'zuperla_eutf_upload_feature_slider_texts', $zuperla_eutf_upload_slider_texts );

	wp_register_script( 'zuperla-eutf-upload-image-replace-script', get_template_directory_uri() . '/includes/js/eut-upload-image-replace.js', array( 'jquery'), time(), false );
	wp_localize_script( 'zuperla-eutf-upload-image-replace-script', 'zuperla_eutf_upload_image_replace_texts', $zuperla_eutf_upload_image_replace_texts );

	wp_register_script( 'zuperla-eutf-upload-simple-media-script', get_template_directory_uri() . '/includes/js/eut-upload-simple.js', array( 'jquery'), time(), false );
	wp_localize_script( 'zuperla-eutf-upload-simple-media-script', 'zuperla_eutf_upload_media_texts', $zuperla_eutf_upload_media_texts );

	wp_register_script( 'zuperla-eutf-page-feature-section-script', get_template_directory_uri() . '/includes/js/eut-page-feature-section.js', array( 'jquery', 'wp-color-picker' ), time(), false );
	wp_localize_script( 'zuperla-eutf-page-feature-section-script', 'zuperla_eutf_feature_section_texts', $zuperla_eutf_feature_section_texts );

	wp_register_script( 'zuperla-eutf-post-options-script', get_template_directory_uri() . '/includes/js/eut-post-options.js', array( 'jquery'), time(), false );
	wp_register_script( 'zuperla-eutf-portfolio-options-script', get_template_directory_uri() . '/includes/js/eut-portfolio-options.js', array( 'jquery'), time(), false );

	wp_register_script( 'zuperla-eutf-custom-nav-menu-script', get_template_directory_uri().'/includes/js/eut-custom-nav-menu.js', array( 'jquery'), time(), false );

	if ( $hook == 'post-new.php' || $hook == 'post.php' ) {

		$feature_section_post_types = zuperla_eutf_option( 'feature_section_post_types' );

		if ( !empty( $feature_section_post_types ) && in_array( $post->post_type, $feature_section_post_types ) && 'attachment' != $post->post_type ) {

			wp_enqueue_style( 'zuperla-eutf-admin-meta' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'zuperla-eutf-page-feature-section' );

			wp_enqueue_script( 'zuperla-eutf-upload-simple-media-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-slider-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-feature-slider-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-image-replace-script' );
			wp_enqueue_script( 'zuperla-eutf-page-feature-section-script' );
		}


		if ( 'post' === $post->post_type ) {

			wp_enqueue_style( 'zuperla-eutf-admin-meta' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'zuperla-eutf-page-feature-section' );

			wp_enqueue_script( 'zuperla-eutf-upload-simple-media-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-slider-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-feature-slider-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-image-replace-script' );
			wp_enqueue_script( 'zuperla-eutf-page-feature-section-script' );
			wp_enqueue_script( 'zuperla-eutf-post-options-script' );

		} else if ( 'page' === $post->post_type || 'portfolio' === $post->post_type || 'product' === $post->post_type || 'tribe_events' === $post->post_type ) {

			wp_enqueue_style( 'zuperla-eutf-admin-meta' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'zuperla-eutf-page-feature-section' );

			wp_enqueue_script( 'zuperla-eutf-upload-simple-media-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-slider-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-feature-slider-script' );
			wp_enqueue_script( 'zuperla-eutf-upload-image-replace-script' );
			wp_enqueue_script( 'zuperla-eutf-page-feature-section-script' );

			wp_enqueue_script( 'zuperla-eutf-portfolio-options-script' );

		} else if ( 'testimonial' === $post->post_type ) {

			wp_enqueue_style( 'zuperla-eutf-admin-meta' );

		}
	}

	if ( $hook == 'edit-tags.php' || $hook == 'term.php') {
		wp_enqueue_style( 'zuperla-eutf-admin-meta' );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style( 'zuperla-eutf-page-feature-section' );


		wp_enqueue_media();
		wp_enqueue_script( 'zuperla-eutf-page-feature-section-script' );
		wp_enqueue_script( 'zuperla-eutf-upload-image-replace-script' );

	}

	if ( $hook == 'nav-menus.php' ) {
		wp_enqueue_style( 'zuperla-eutf-custom-nav-menu' );

		wp_enqueue_media();
		wp_enqueue_script( 'zuperla-eutf-upload-simple-media-script' );
		wp_enqueue_script( 'zuperla-eutf-custom-nav-menu-script' );
	}

	//Admin Screens
	if ( isset( $_GET['page'] ) && ( 'zuperla' == $_GET['page'] ) ) {
		wp_enqueue_style( 'zuperla-eutf-admin-panel' );
	}
	if ( isset( $_GET['page'] ) && ( 'zuperla-sidebars' == $_GET['page'] ) ) {
		wp_enqueue_style( 'zuperla-eutf-custom-sidebars' );
		wp_enqueue_script( 'jquery-ui-sortable' );
		wp_enqueue_script( 'zuperla-eutf-custom-sidebars' );
	}
	if ( isset( $_GET['page'] ) && ( 'zuperla-status' == $_GET['page'] ) ) {
		wp_enqueue_style( 'zuperla-eutf-status' );
		wp_enqueue_script( 'zuperla-eutf-status' );
	}
	if ( isset( $_GET['page'] ) && ( 'zuperla-import' == $_GET['page'] ) ) {
		wp_enqueue_style( 'zuperla-eutf-admin-panel' );
	}

	if ( isset( $_GET['page'] ) && ( 'zuperla-codes' == $_GET['page'] ) ) {
		wp_enqueue_style( 'zuperla-eutf-admin-panel' );
		wp_enqueue_code_editor( array( 'type' => 'text/html' ) );
		wp_enqueue_script( 'zuperla-eutf-codes-script' );
	}

	wp_enqueue_style(
		'redux-custom-css',
		get_template_directory_uri() . '/includes/css/eut-redux-panel.css',
		array(),
		time(),
		'all'
	);

}
add_action( 'admin_enqueue_scripts', 'zuperla_eutf_backend_scripts', 10, 1 );

/**
 * Helper function to get custom fields with fallback
 */
function zuperla_eutf_post_meta( $id, $fallback = false ) {
	$post_id = get_the_ID();
	if ( $fallback == false ) $fallback = '';
	$post_meta = get_post_meta( $post_id, $id, true );
	$output = ( $post_meta !== '' ) ? $post_meta : $fallback;
	return $output;
}

function zuperla_eutf_admin_post_meta( $post_id, $id, $fallback = false ) {
	if ( $fallback == false ) $fallback = '';
	$post_meta = get_post_meta( $post_id, $id, true );
	$output = ( $post_meta !== '' ) ? $post_meta : $fallback;
	return $output;
}

function zuperla_eutf_get_term_meta( $term_id, $meta_key ) {
	$zuperla_eutf_term_meta  = '';

	if ( function_exists( 'get_term_meta' ) ) {
		$zuperla_eutf_term_meta = get_term_meta( $term_id, $meta_key, true );
	}
	if( empty ( $zuperla_eutf_term_meta ) ) {
		$zuperla_eutf_term_meta = array();
	}
	return $zuperla_eutf_term_meta;
}

function zuperla_eutf_update_term_meta( $term_id , $meta_key, $meta_value ) {

	if ( function_exists( 'update_term_meta' ) ) {
		update_term_meta( $term_id, $meta_key, $meta_value );
	}

}

/**
 * Helper function to get theme options with fallback
 */
function zuperla_eutf_option( $id, $fallback = false, $param = false ) {
	global $zuperla_eutf_options;
	if ( ! $zuperla_eutf_options ) {
		$zuperla_eutf_options = get_option( 'zuperla_eutf_options', array() );
	}	
	$eut_theme_options = $zuperla_eutf_options;

	if ( $fallback == false ) $fallback = '';
	$output = ( isset($eut_theme_options[$id]) && $eut_theme_options[$id] !== '' ) ? $eut_theme_options[$id] : $fallback;
	if ( !empty($eut_theme_options[$id]) && $param ) {
		$output = ( isset($eut_theme_options[$id][$param]) && $eut_theme_options[$id][$param] !== '' ) ? $eut_theme_options[$id][$param] : $fallback;
		if ( 'font-family' == $param ) {
			$output = urldecode( $output );
			if ( strpos($output, ' ') && !strpos($output, ',') ) {
				$output = '"' . $output . '"';
			}
		}
	}
	return $output;
}

/**
 * Helper function to print css code if not empty
 */
function zuperla_eutf_css_option( $id, $fallback = false, $param = false ) {
	$option = zuperla_eutf_option( $id, $fallback, $param );
	if ( !empty( $option ) && 0 !== $option && $param ) {
		return $param . ': ' . $option . ';';
	}
}

/**
 * Helper function to get array value with fallback
 */
function zuperla_eutf_array_value( $input_array, $id, $fallback = false, $param = false ) {

	if ( $fallback == false ) $fallback = '';
	$output = ( isset($input_array[$id]) && $input_array[$id] !== '' ) ? $input_array[$id] : $fallback;
	if ( !empty($input_array[$id]) && $param ) {
		$output = ( isset($input_array[$id][$param]) && $input_array[$id][$param] !== '' ) ? $input_array[$id][$param] : $fallback;
	}
	return $output;
}

/**
 * Helper function to return trimmed css code
 */
if ( ! function_exists( 'zuperla_eutf_compress_css' ) ) {
	function zuperla_eutf_compress_css( $css ) {
		$css_trim =  preg_replace( '/\s+/', ' ', $css );
		return $css_trim;
	}
}

/**
 * Helper functions to set/get current template
 */
function zuperla_eutf_set_current_view( $id ) {
	global $zuperla_eutf_options;
	$zuperla_eutf_options['current_view'] = $id;
}
function zuperla_eutf_get_current_view( $fallback = '' ) {
	global $zuperla_eutf_options;
	$zuperla_eutf_theme_options = $zuperla_eutf_options;

	if ( $fallback == false ) $fallback = '';
	$output = ( isset($zuperla_eutf_theme_options['current_view']) && $zuperla_eutf_theme_options['current_view'] !== '' ) ? $zuperla_eutf_theme_options['current_view'] : $fallback;
	return $output;
}

/**
 * Helper function convert hex to rgb
 */
function zuperla_eutf_hex2rgb( $hex ) {
	$hex = str_replace("#", "", $hex);

	if(strlen($hex) == 3) {
		$r = hexdec( substr( $hex, 0, 1 ).substr( $hex, 0, 1) );
		$g = hexdec( substr( $hex, 1, 1 ).substr( $hex, 1, 1) );
		$b = hexdec( substr( $hex, 2, 1 ).substr( $hex, 2, 1) );
	} else {
		$r = hexdec( substr( $hex, 0, 2) );
		$g = hexdec( substr( $hex, 2, 2) );
		$b = hexdec( substr( $hex, 4, 2) );
	}
	$rgb = array($r, $g, $b);
	return implode(",", $rgb);
}

/**
 * Helper function to get theme visibility options
 */
function zuperla_eutf_visibility( $id, $fallback = '' ) {
	$visibility = zuperla_eutf_option( $id, $fallback  );
	if ( '1' == $visibility ) {
		return true;
	}
	return false;
}

/**
 * Get Color
 */
function zuperla_eutf_get_color( $color = 'dark', $color_custom = '#000000' ) {

	switch( $color ) {

		case 'none':
		case 'transparent':
			$color_custom = 'transparent';
			break;
		case 'dark':
			$color_custom = '#000000';
			break;
		case 'light':
			$color_custom = '#ffffff';
			break;
		case 'primary-1':
			$color_custom = zuperla_eutf_option( 'body_primary_1_color' );
			break;
		case 'primary-2':
			$color_custom = zuperla_eutf_option( 'body_primary_2_color' );
			break;
		case 'primary-3':
			$color_custom = zuperla_eutf_option( 'body_primary_3_color' );
			break;
		case 'primary-4':
			$color_custom = zuperla_eutf_option( 'body_primary_4_color' );
			break;
		case 'primary-5':
			$color_custom = zuperla_eutf_option( 'body_primary_5_color' );
			break;
		case 'primary-6':
			$color_custom = zuperla_eutf_option( 'body_primary_6_color' );
			break;
	}

	return $color_custom;
}

/**
 * Backend Theme Activation Actions
 */
function zuperla_eutf_backend_theme_activation() {
	global $pagenow;

	if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {

		$catalog = array(
			'width'   => '500',    // px
			'height'  => '500',    // px
			'crop'	  => 1,        // true
		);

		$single = array(
			'width'   => '800',    // px
			'height'  => '800',    // px
			'crop'    => 1,        // true
		);

		$thumbnail = array(
			'width'   => '120',    // px
			'height'  => '120',    // px
			'crop'    => 1,        // true
		);

		update_option( 'shop_catalog_image_size', $catalog );
		update_option( 'shop_single_image_size', $single );
		update_option( 'shop_thumbnail_image_size', $thumbnail );
		update_option( 'woocommerce_enable_lightbox', false );

		//Redirect to Welcome
		header( 'Location: ' . esc_url( admin_url() ) . 'admin.php?page=zuperla' ) ;
	}
}

add_action('admin_init','zuperla_eutf_backend_theme_activation');

/**
 * Check if Revolution slider is active
 */

/**
 * Check if to replace Backend Logo
 */
function zuperla_eutf_admin_login_logo() {
	$replace_logo = zuperla_eutf_option( 'replace_admin_logo' );
	if ( $replace_logo ) {
		$admin_logo = zuperla_eutf_option( 'admin_logo','','url' );
		$admin_logo_height = zuperla_eutf_option( 'admin_logo_height','84');
		$admin_logo_height = preg_match('/(px|em|\%|pt|cm)$/', $admin_logo_height) ? $admin_logo_height : $admin_logo_height . 'px';
		if( empty( $admin_logo ) ) {
			$admin_logo = zuperla_eutf_option( 'logo','','url' );
		}
		if ( !empty( $admin_logo ) ) {
			$admin_logo = str_replace( array( 'http:', 'https:' ), '', $admin_logo );
			echo "
			<style>
			.login h1 a {
				background-image: url('" . esc_url( $admin_logo ) . "');
				width: 100%;
				max-width: 300px;
				background-size: auto " . esc_attr( $admin_logo_height ) . ";
				height: " . esc_attr( $admin_logo_height ) . ";
			}
			</style>
			";
		}
	}

}
add_action( 'login_head', 'zuperla_eutf_admin_login_logo' );

function zuperla_eutf_login_headerurl( $url ){
	$replace_logo = zuperla_eutf_option( 'replace_admin_logo' );
	if ( $replace_logo ) {
		return esc_url( home_url( '/' ) );
	}
	return esc_url( $url );
}
add_filter('login_headerurl', 'zuperla_eutf_login_headerurl');

function zuperla_eutf_login_headertitle( $title ) {
	$replace_logo = zuperla_eutf_option( 'replace_admin_logo' );
	if ( $replace_logo ) {
		return esc_attr( get_bloginfo( 'name' ) );
	}
	return esc_attr( $title );
}
add_filter('login_headertext', 'zuperla_eutf_login_headertitle' );

/**
 * Disable SEO Page Analysis
 */
function zuperla_eutf_disable_page_analysis( $bool ) {
	if( '1' == zuperla_eutf_option( 'disable_seo_page_analysis', '0' ) ) {
		return false;
	}
	return $bool;
}
add_filter( 'wpseo_use_page_analysis', 'zuperla_eutf_disable_page_analysis' );

/**
 * Scroll Check
 */
if ( ! function_exists( 'zuperla_eutf_scroll_check' ) ) {
	function zuperla_eutf_scroll_check() {
		$scroll_mode = zuperla_eutf_option( 'scroll_mode', 'auto' );
		if ( 'on' == $scroll_mode ) {
			return true;
		} elseif ( 'off' == $scroll_mode ) {
			return false;
		} else {
			return zuperla_eutf_browser_webkit_check();
		}
	}
}

/**
 * Browser Webkit Check
 */
if ( ! function_exists( 'zuperla_eutf_browser_webkit_check' ) ) {
	function zuperla_eutf_browser_webkit_check() {
		if ( function_exists( 'zuperla_ext_browser_webkit_check' ) ) {
			return zuperla_ext_browser_webkit_check();
		} else {
			return false;
		}
	}
}
/**
 * Add Hooks for Page Redirect ( Coming Soon )
 */
add_filter( 'template_include', 'zuperla_eutf_redirect_page_template', 99 );

if ( ! function_exists( 'zuperla_eutf_redirect_page_template' ) ) {
	function zuperla_eutf_redirect_page_template( $template ) {
		if ( zuperla_eutf_visibility('coming_soon_enabled' )  && !is_user_logged_in() ) {
			$redirect_page = zuperla_eutf_option( 'coming_soon_page' );
			$redirect_template = zuperla_eutf_option( 'coming_soon_template' );
			if ( !empty( $redirect_page ) && 'content' == $redirect_template ) {
				$new_template = get_template_directory() . '/page-templates/template-content-only.php';
				return $new_template ;
			}
		}
		return $template;
	}
}

add_filter( 'template_redirect', 'zuperla_eutf_redirect' );

if ( ! function_exists( 'zuperla_eutf_redirect' ) ) {
	function zuperla_eutf_redirect() {
		if ( zuperla_eutf_visibility('coming_soon_enabled' ) && !is_user_logged_in() ) {
			$redirect_page = zuperla_eutf_option( 'coming_soon_page' );
			if ( !empty( $redirect_page )
				&& !in_array( $GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php') )
				&& !is_admin()
				&& !is_page( $redirect_page ) ) {
				wp_redirect( get_permalink( $redirect_page ) );
				exit();
			}
		}
		return false;
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
