<?php
/**
* Single Image Shortcode
*/

if( !function_exists( 'zuperla_ext_vce_single_image_shortcode' ) ) {

	function zuperla_ext_vce_single_image_shortcode( $attr, $content ) {

		$output = $data = $retina_data = $el_class = $image_srcset = '' ;

		extract(
			shortcode_atts(
				array(
					'image' => '',
					'image_mode' => '',
					'retina_image' => '',
					'image_type' => 'image',
					'ids' => '',
					'image_popup_size' => 'extra-extra-large',
					'image_popup_title_caption' => 'none',
					'image_column_space' => 'auto',
					'inherit_align' => 'center',
					'title_heading_tag' => 'h3',
					'title_heading' => 'h3',
					'title_custom_font_family' => '',
					'custom_title' => '',
					'custom_caption' => '',
					'image_hover_style' => 'hover-style-1',
					'image_shape' => 'square',
					'zoom_effect' => 'in',
					'grayscale_effect' => 'none',
					'content_bg_color' => 'white',
					'overlay_color' => 'dark',
					'overlay_opacity' => '60',
					'link' => '',
					'link_class' => '',
					'video_link' => 'https://www.youtube.com/watch?v=C9tsrkRSw-Q',
					'animation' => '',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$attr
			)
		);

		$has_link = zuperla_ext_vce_has_link( $link );

		$single_image_classes = array( 'eut-element', 'eut-image' );

		if ( !empty( $animation ) ) {
			array_push( $single_image_classes, 'eut-animated-item' );
			array_push( $single_image_classes, $animation);
			array_push( $single_image_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}
		if( 'none' != $grayscale_effect ){
			array_push( $single_image_classes, 'eut-' . $grayscale_effect);
		}
		if ( !empty( $el_class ) ) {
			array_push( $single_image_classes, $el_class);
		}

		array_push( $single_image_classes, 'eut-align-' . $inherit_align );
		if( 'image-caption' == $image_type || 'image-popup-caption' == $image_type  ) {
			array_push( $single_image_classes, 'eut-hover-item' );
			array_push( $single_image_classes, 'eut-' . $image_hover_style );
		}

		if ( 'auto' != $image_column_space ) {
			array_push( $single_image_classes, 'eut-image-space-' . $image_column_space );
			array_push( $single_image_classes, 'eut-image-expand-width' );
		}

		$single_image_classes_string = implode( ' ', $single_image_classes );

		$image_classes = array();

		if( 'image-caption' != $image_type && 'image-popup-caption' != $image_type  ) {
			if ( 'square' != $image_shape ) {
				$image_classes[] = 'eut-' . $image_shape;
			}
		}

		$image_mode_size = zuperla_ext_vce_get_image_size( $image_mode );
		$image_classes[] = 'attachment-' . $image_mode_size;
		$image_classes[] = 'size-' . $image_mode_size;

		$image_class_string = implode( ' ', $image_classes );

		if( 'image-caption' == $image_type || 'image-popup-caption' == $image_type  ) {
			$image_class_string = '';
		}

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$output .= '<div class="' . esc_attr( $single_image_classes_string ) . '" style="' . $style . '"' . $data . '>';
		$output .= '  <div class="eut-image-wrapper">';


		//Image Title & Caption Color
		$text_color = 'white';
		$title_color = 'white';
		if( 'hover-style-1' == $image_hover_style ){
			$text_color = 'inherit';
			$title_color = 'inherit';
		} elseif( 'hover-style-2' == $image_hover_style || 'hover-style-3' == $image_hover_style ){
			if( 'light' == $overlay_color ) {
				$text_color = 'content';
				$title_color = 'black';
			}
		}
		if( 'hover-style-4' == $image_hover_style || 'hover-style-5' == $image_hover_style || 'hover-style-7' == $image_hover_style ){
			$text_color = 'inherit';
			if( 'white' == $content_bg_color ){
				$title_color = 'black';
			} else {
				$title_color = 'white';
			}
		}

		$image_content_classes = array( 'eut-content' );
		if ( !empty( $custom_title ) || !empty( $custom_caption ) ) {
			if( 'hover-style-7' == $image_hover_style ){
				array_push( $image_content_classes, 'eut-align-left');
			} else {
				array_push( $image_content_classes, 'eut-align-center');
			}
			if( 'hover-style-4' == $image_hover_style || 'hover-style-5' == $image_hover_style || 'hover-style-7' == $image_hover_style ){
				array_push( $image_content_classes, 'eut-box-item eut-bg-' . $content_bg_color );
			}
			if( 'hover-style-6' == $image_hover_style ){
				array_push( $image_content_classes, 'eut-gradient-overlay' );
			}
		}
		$image_content_class_string = implode( ' ', $image_content_classes );

		$image_popup_size_mode = zuperla_ext_vce_get_image_size( $image_popup_size );

		if ( !empty( $image ) ) {
			$id = preg_replace('/[^\d]/', '', $image);
			$thumb_src = wp_get_attachment_image_src( $id, $image_mode_size );
			$thumb_url = $thumb_src[0];
			$image_srcset = '';
			$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );
			$full_url = $full_src[0];

			if ( !empty( $retina_image ) && empty( $image_mode ) ) {
				$img_retina_id = preg_replace('/[^\d]/', '', $retina_image);
				$img_retina_src = wp_get_attachment_image_src( $img_retina_id, 'full' );
				$retina_url = $img_retina_src[0];
				$image_srcset = $thumb_url . ' 1x,' . $retina_url . ' 2x';
				$image_html = wp_get_attachment_image( $id, $image_mode_size , "", array( 'class' => $image_class_string, 'srcset'=> $image_srcset ) );
			} else {
				$image_html = wp_get_attachment_image( $id, $image_mode_size , "", array( 'class' => $image_class_string ) );
			}

		} else {
			$full_url = zuperla_ext_vce_get_fallback_image( $image_popup_size_mode, 'url' );
			$image_html = zuperla_ext_vce_get_fallback_image( $image_mode_size, "", array( 'class' => $image_class_string ) );
		}

		if ( 'image-popup' == $image_type ) {
			$image_title = get_post_field( 'post_title', $id );
			$image_caption = get_post_field( 'post_excerpt', $id );
			$data = "";
			if ( !empty( $image_title ) && 'none' != $image_popup_title_caption && 'caption-only' != $image_popup_title_caption ) {
				$data .= ' data-title="' . esc_attr( $image_title ) . '"';
			}
			if ( !empty( $image_caption ) && 'none' != $image_popup_title_caption && 'title-only' != $image_popup_title_caption ) {
				$data .= ' data-desc="' . esc_attr( $image_caption ) . '"';
			}

			$output .= '<a class="eut-image-popup" href="' . esc_url( $full_url ) . '"' . $data . '>';
			$output .= $image_html;
			$output .= '</a>';
		} else if ( 'gallery-popup' == $image_type ) {
			$output .= '<div class="eut-gallery-popup">';

			$attachments = explode( ",", $ids );
			if ( !empty( $ids ) && !empty( $attachments ) ) {
				$first_image_data = "";
				$first_image_url = "#";
				$index = 0;

				$gallery_links = "";
				$gallery_links .= '<div class="eut-hidden">';
				foreach ( $attachments as $id ) {
					$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );
					$full_url = $full_src[0];
					$image_title = get_post_field( 'post_title', $id );
					$image_caption = get_post_field( 'post_excerpt', $id );
					$data = "";
					if ( !empty( $image_title ) && 'none' != $image_popup_title_caption && 'caption-only' != $image_popup_title_caption ) {
						$data .= ' data-title="' . esc_attr( $image_title ) . '"';
					}
					if ( !empty( $image_caption ) && 'none' != $image_popup_title_caption && 'title-only' != $image_popup_title_caption ) {
						$data .= ' data-desc="' . esc_attr( $image_caption ) . '"';
					}
					if ( 0 == $index ) {
						$first_image_data = $data;
						$first_image_url= $full_url;
					} else {
						$gallery_links .= '<a href="' . esc_url( $full_url ) . '"' . $data . '"></a>';
					}
					$index ++;
				}
				$gallery_links .= '</div>';

				$output .= '<a href="' . esc_url( $first_image_url ) . '"' . $first_image_data . '>';
				$output .= $image_html;
				$output .= '</a>';
				$output .= $gallery_links;
			} else {
				$output .= $image_html;
			}

			$output .= '</div>';
		} else if ( 'image-link' == $image_type ) {
			$link_attributes = zuperla_ext_vce_get_link_attributes( $link, $link_class );
			$output .= '<a ' . implode( ' ', $link_attributes ) . '>';
			$output .= $image_html;
			$output .= '</a>';
		} else if ( 'image-video-popup' == $image_type ) {
			if ( !empty( $video_link ) ) {
				$output .= '<div class="eut-media eut-paraller-wrapper">';
				$output .= '	<a class="eut-video-popup eut-video-icon eut-icon-video eut-bg-white" href="' . esc_url( $video_link ) . '"></a>';
				$output .= $image_html;
				$output .= '</div>';
			} else {
				$output .= '<div class="eut-media">';
				$output .= $image_html;
				$output .= '</div>';
			}
		} else if ( 'image-caption' == $image_type || 'image-popup-caption' == $image_type ) {

			$title_classes = array( 'eut-title' );
			$title_classes[]  = 'eut-' . $title_heading;
			$title_classes[]  = 'eut-text-' . $title_color;
			if ( !empty( $title_custom_font_family ) ) {
				$title_classes[]  = 'eut-' . $title_custom_font_family;
			}
			$title_class_string = implode( ' ', $title_classes );

			if ( 'hover-style-1' == $image_hover_style ) {
				$output .= '<figure class="eut-image-hover eut-media eut-zoom-' . esc_attr( $zoom_effect ) . '">';
				if ( 'image-caption' == $image_type && $has_link ) {
					$link_class_string = 'eut-item-url ' . esc_attr( $link_class );
					$link_attributes = zuperla_ext_vce_get_link_attributes( $link, $link_class_string );
					$output .= '<a ' . implode( ' ', $link_attributes ) . '></a>';
				} elseif ( 'image-popup-caption' == $image_type ) {
					$data = "";
					if ( !empty( $custom_title ) && 'none' != $image_popup_title_caption && 'caption-only' != $image_popup_title_caption ) {
						$data .= ' data-title="' . esc_attr( $custom_title ) . '"';
					}
					if ( !empty( $custom_caption ) && 'none' != $image_popup_title_caption && 'title-only' != $image_popup_title_caption ) {
						$data .= ' data-desc="' . esc_attr( $custom_caption ) . '"';
					}
					$output .= '<a class="eut-item-url eut-image-popup" href="' . esc_url( $full_url ) . '"' . $data . '></a>';
				}
				$output .= '<div class="eut-bg-' . esc_attr( $overlay_color ) . ' eut-hover-overlay  eut-opacity-' . esc_attr( $overlay_opacity )  . '"></div>';
				$output .= $image_html;
				$output .= '<figcaption></figcaption>';
				$output .= '</figure>';
				if ( !empty( $custom_title ) || !empty( $custom_caption ) ) {
					$output .= '<div class="' . esc_attr( $image_content_class_string ) . '">';
					if ( !empty( $custom_title ) ) {
						$output .= '<' . tag_escape( $title_heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . esc_html( $custom_title ) . '</' . tag_escape( $title_heading_tag ) . '>';
					}
					if ( !empty( $custom_caption ) ) {
						$output .= '<span class="eut-description eut-link-text eut-text-content">' . wp_kses_post( $custom_caption ) . '</span>';
					}
					$output .= '</div>';
				}
			} else {
				$output .= '<figure class="eut-image-hover eut-media eut-zoom-' . esc_attr( $zoom_effect ) . '">';
				if ( 'image-caption' == $image_type && $has_link ) {
					$link_class_string = 'eut-item-url ' . esc_attr( $link_class );
					$link_attributes = zuperla_ext_vce_get_link_attributes( $link, $link_class_string );
					$output .= '<a ' . implode( ' ', $link_attributes ) . '></a>';
				} elseif ( 'image-popup-caption' == $image_type ) {
					$output .= '<a class="eut-item-url eut-image-popup" href="' . esc_url( $full_url ) . '"></a>';
				}
				$output .= '<div class="eut-bg-' . esc_attr( $overlay_color ) . ' eut-hover-overlay  eut-opacity-' . esc_attr( $overlay_opacity )  . '"></div>';
				$output .= $image_html;
				if ( !empty( $custom_title ) || !empty( $custom_caption ) ) {
					$output .= '<figcaption class="' . esc_attr( $image_content_class_string ) . '">';
					if ( !empty( $custom_title ) ) {
						$output .= '<' . tag_escape( $title_heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . esc_html( $custom_title ) . '</' . tag_escape( $title_heading_tag ) . '>';
					}
					if ( !empty( $custom_caption ) ) {
						$output .= '<span class="eut-description eut-small-text eut-text-' . esc_attr( $text_color ) . '">' . wp_kses_post( $custom_caption ) . '</span>';
					}
					$output .= '</figcaption>';
				} else {
					$output .= '<figcaption></figcaption>';
				}
				$output .= '</figure>';
			}

		} else {
			$output .= $image_html;
		}

		$output .= '  </div>';
		$output .= '</div>';

		return $output;

	}
	add_shortcode( 'zuperla_single_image', 'zuperla_ext_vce_single_image_shortcode' );

}

/**
* Add shortcode to Visual Composer
*/

if( !function_exists( 'zuperla_ext_vce_single_image_shortcode_params' ) ) {
	function zuperla_ext_vce_single_image_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Single Image", "zuperla-extension" ),
			"description" => esc_html__( "Image or Video popup in various uses", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-single-image",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Type", "zuperla-extension" ),
					"param_name" => "image_type",
					"value" => array(
						esc_html__( "Image", "zuperla-extension" ) => 'image',
						esc_html__( "Image Link", "zuperla-extension" ) => 'image-link',
						esc_html__( "Image Popup", "zuperla-extension" ) => 'image-popup',
						esc_html__( "Image Video Popup", "zuperla-extension" ) => 'image-video-popup',
						esc_html__( "Image With Caption", "zuperla-extension" ) => 'image-caption',
						esc_html__( "Image Popup With Caption", "zuperla-extension" ) => 'image-popup-caption',
						esc_html__( "Gallery Popup", "zuperla-extension" ) => 'gallery-popup',
					),
					"description" => esc_html__( "Select your image type.", "zuperla-extension" ),
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Size", "zuperla-extension" ),
					"param_name" => "image_mode",
					'value' => array(
						esc_html__( 'Full ( Custom )', 'zuperla-extension' ) => '',
						esc_html__( 'Square Small Crop', 'zuperla-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'zuperla-extension' ) => 'landscape',
						esc_html__( 'Portrait Small Crop', 'zuperla-extension' ) => 'portrait',
						esc_html__( 'Resize ( Extra Extra Large )', 'zuperla-extension' ) => 'extra-extra-large',
						esc_html__( 'Resize ( Large )', 'zuperla-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'zuperla-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'zuperla-extension' ) => 'medium',
						esc_html__( 'Thumbnail', 'zuperla-extension' ) => 'thumbnail',
					),
					'std' => '',
					"description" => esc_html__( "Select your Image Size.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Popup Size", "zuperla-extension" ),
					"param_name" => "image_popup_size",
					'value' => array(
						esc_html__( 'Large' , 'zuperla-extension' ) => 'large',
						esc_html__( 'Extra Extra Large' , 'zuperla-extension' ) => 'extra-extra-large',
						esc_html__( 'Full' , 'zuperla-extension' ) => 'full',
					),
					"std" => 'extra-extra-large',
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-popup', 'image-popup-caption', 'gallery-popup' ) ),
					"description" => esc_html__( "Select size for your popup image.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Popup Title & Caption Visibility", "zuperla-extension" ),
					"param_name" => "image_popup_title_caption",
					'value' => array(
						esc_html__( 'None' , 'zuperla-extension' ) => 'none',
						esc_html__( 'Title and Caption' , 'zuperla-extension' ) => 'title-caption',
						esc_html__( 'Title Only' , 'zuperla-extension' ) => 'title-only',
						esc_html__( 'Caption Only' , 'zuperla-extension' ) => 'caption-only',
					),
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-popup', 'image-popup-caption', 'gallery-popup' ) ),
					"description" => esc_html__( "Define the visibility for your popup image title - caption.", "zuperla-extension" ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Image", "zuperla-extension" ),
					"param_name" => "image",
					"value" => '',
					"description" => esc_html__( "Select an image.", "zuperla-extension" ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Retina Image", "zuperla-extension" ),
					"param_name" => "retina_image",
					"value" => '',
					"description" => esc_html__( "Select a 2x image.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_mode", 'value' => array( '' ) ),
				),
				array(
					"type"			=> "attach_images",
					"class"			=> "",
					"heading"		=> esc_html__( "Attach Images", "zuperla-extension" ),
					"param_name"	=> "ids",
					"value" => '',
					"description"	=> esc_html__( "Select your gallery images.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_type", 'value' => array( 'gallery-popup' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Column Space", "zuperla-extension" ),
					"param_name" => "image_column_space",
					"value" => array(
						esc_html__( "Auto", "zuperla-extension" ) => 'auto',
						esc_html__( "100%", "zuperla-extension" ) => '100',
						esc_html__( "125%", "zuperla-extension" ) => '125',
						esc_html__( "150%", "zuperla-extension" ) => '150',
						esc_html__( "175%", "zuperla-extension" ) => '175',
						esc_html__( "200%", "zuperla-extension" ) => '200',
						esc_html__( "225%", "zuperla-extension" ) => '225',
						esc_html__( "250%", "zuperla-extension" ) => '250',
					),
					"description" => esc_html__( "Define the max width of the image on this column. Setting percentage larger than 100% the image overflows out of the column. Default is the image resolution.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Alignment", "zuperla-extension" ),
					"param_name" => "inherit_align",
					"value" => array(
						esc_html__( "Inherit", "zuperla-extension" ) => 'inherit',
						esc_html__( "Left", "zuperla-extension" ) => 'left',
						esc_html__( "Right", "zuperla-extension" ) => 'right',
						esc_html__( "Center", "zuperla-extension" ) => 'center',
					),
					"description" => 'Inherits its value from its column text align definition.',
					"std" => 'center',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image shape", "zuperla-extension" ),
					"param_name" => "image_shape",
					"value" => array(
						esc_html__( "Square", "zuperla-extension" ) => 'square',
						esc_html__( "Round", "zuperla-extension" ) => 'extra-round',
						esc_html__( "Circle", "zuperla-extension" ) => 'circle',
					),
					"description" => '',
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image', 'image-link', 'image-popup', 'image-video-popup', 'gallery-popup' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Grayscale Effect", "zuperla-extension" ),
					"param_name" => "grayscale_effect",
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => 'none',
						esc_html__( "Grayscale Image", "zuperla-extension" ) => 'grayscale-image',
						esc_html__( "Colored on Hover", "zuperla-extension" ) => 'grayscale-image-hover',
					),
					"description" => esc_html__( "Choose the grayscale effect.", "zuperla-extension" ),
					'std' => 'none',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Video Link", "zuperla-extension" ),
					"param_name" => "video_link",
					"value" => "https://www.youtube.com/watch?v=C9tsrkRSw-Q",
					"description" => esc_html__( "Type video URL e.g Vimeo/YouTube.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-video-popup') ),
				),
				array(
					"type" => "vc_link",
					"heading" => esc_html__( "Link", "zuperla-extension" ),
					"param_name" => "link",
					"value" => "",
					"description" => esc_html__( "Enter link.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-link', 'image-caption' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Link Class", "zuperla-extension" ),
					"param_name" => "link_class",
					"value" => "",
					"description" => esc_html__( "Enter extra class name for your link.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-link', 'image-caption' ) ),
				),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "zuperla-extension" ),
					"param_name" => "title_heading_tag",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "div", "zuperla-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "zuperla-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-caption', 'image-popup-caption' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Size/Typography", "zuperla-extension" ),
					"param_name" => "title_heading",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "zuperla-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-caption', 'image-popup-caption' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Custom Font Family", "zuperla-extension" ),
					"param_name" => "title_custom_font_family",
					"value" => array(
						esc_html__( "Same as Typography", "zuperla-extension" ) => '',
						esc_html__( "Custom Font Family 1", "zuperla-extension" ) => 'custom-font-1',
						esc_html__( "Custom Font Family 2", "zuperla-extension" ) => 'custom-font-2',
						esc_html__( "Custom Font Family 3", "zuperla-extension" ) => 'custom-font-3',
						esc_html__( "Custom Font Family 4", "zuperla-extension" ) => 'custom-font-4',

					),
					"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "zuperla-extension" ),
					"std" => '',
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-caption', 'image-popup-caption' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "zuperla-extension" ),
					"param_name" => "custom_title",
					"value" => "",
					"description" => esc_html__( "Enter your title.", "zuperla-extension" ),
					"admin_label" => true,
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-caption', 'image-popup-caption' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Caption", "zuperla-extension" ),
					"param_name" => "custom_caption",
					"value" => "",
					"description" => esc_html__( "Enter your caption.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-caption', 'image-popup-caption' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Style - Hovers", "zuperla-extension" ),
					"param_name" => "image_hover_style",
					'value' => array(
						esc_html__( 'Content Below Image' , 'zuperla-extension' ) => 'hover-style-1',
						esc_html__( 'Top Down Animated Content' , 'zuperla-extension' ) => 'hover-style-2',
						esc_html__( 'Left Right Animated Content' , 'zuperla-extension' ) => 'hover-style-3',
						//esc_html__( 'Static Box Content' , 'zuperla-extension' ) => 'hover-style-4',
						esc_html__( 'Animated Box Content' , 'zuperla-extension' ) => 'hover-style-5',
						//esc_html__( 'Gradient Overlay' , 'zuperla-extension' ) => 'hover-style-6',
						//esc_html__( 'Animated Right Corner Box Content' , 'zuperla-extension' ) => 'hover-style-7',
					),
					"description" => esc_html__( "Select the hover style for the image.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-caption', 'image-popup-caption' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Content Background Color", "zuperla-extension" ),
					"param_name" => "content_bg_color",
					'value' => array(
						esc_html__( 'White' , 'zuperla-extension' ) => 'white',
						esc_html__( 'Black' , 'zuperla-extension' ) => 'black',
					),
					"description" => esc_html__( "Select the background color for image item content.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_hover_style", 'value' => array( 'hover-style-4', 'hover-style-5', 'hover-style-7' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Zoom Effect", "zuperla-extension" ),
					"param_name" => "zoom_effect",
					"value" => array(
						esc_html__( "Zoom In", "zuperla-extension" ) => 'in',
						esc_html__( "Zoom Out", "zuperla-extension" ) => 'out',
						esc_html__( "None", "zuperla-extension" ) => 'none',
					),
					"description" => esc_html__( "Choose the image zoom effect.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_type", 'value' => array( 'image-caption', 'image-popup-caption' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "zuperla-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Dark", "zuperla-extension" ) => 'dark',
						esc_html__( "Light", "zuperla-extension" ) => 'light',
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
					),
					"description" => esc_html__( "Choose the image color overlay.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_hover_style", 'value' => array( 'hover-style-1', 'hover-style-2', 'hover-style-3', 'hover-style-4', 'hover-style-5', 'hover-style-7' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "zuperla-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
					"std" => '80',
					"description" => esc_html__( "Choose the opacity for the overlay.", "zuperla-extension" ),
					"dependency" => array( 'element' => "image_hover_style", 'value' => array( 'hover-style-1', 'hover-style-2', 'hover-style-3', 'hover-style-4', 'hover-style-5', 'hover-style-7' ) ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_single_image', 'zuperla_ext_vce_single_image_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_single_image_shortcode_params( 'zuperla_single_image' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
