<?php
/**
 * Product Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_products_shortcode' ) ) {

	function zuperla_ext_vce_products_shortcode( $attr, $content ) {

		$product_row_start = $allow_filter = $class_fullwidth = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'title' => '',
					'text_style' => 'none',
					'align' => 'left',
					'categories' => '',
					'exclude_posts' => '',
					'include_posts' => '',
					'product_mode' => 'grid',
					'carousel_layout' => 'layout-1',
					'heading_tag' => 'h3',
					'heading' => 'h3',
					'custom_font_family' => '',
					'columns_large_screen' => '3',
					'columns' => '3',
					'columns_tablet_landscape' => '2',
					'columns_tablet_portrait' => '2',
					'columns_mobile' => '1',
					'grid_image_mode' => 'landscape',
					'carousel_image_mode' => 'landscape',
					'product_filter' => '',
					'filter_style' => 'simple',
					'filter_shape' => 'square',
					'filter_color' => 'primary-1',
					'product_filter_align' => 'left',
					'filter_order_by' => '',
					'filter_order' => 'ASC',
					'item_gutter' => 'yes',
					'gutter_size' => '30',
					'item_spinner' => 'no',
					'items_per_page' => '4',
					'items_to_show' => '12',
					'product_title_heading_tag' => 'h3',
					'product_title_heading' => 'h3',
					'product_style' => 'hover-style-1',
					'second_image_effect' => 'yes',
					'zoom_effect' => 'none',
					'grayscale_effect' => 'none',
					'overlay_color' => 'light',
					'overlay_opacity' => '90',
					'order_by' => 'date',
					'order' => 'DESC',
					'disable_pagination' => '',
					'slideshow_speed' => '3000',
					'auto_play' => 'yes',
					'navigation_type' => '1',
					'navigation_color' => 'dark',
					'pause_hover' => 'no',
					'carousel_pagination' => 'no',
					'carousel_pagination_speed' => '400',
					'animation' => 'eut-zoom-in',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$attr
			)
		);

		$product_classes = array( 'eut-element' );
		$data_string = '';

		switch( $product_mode ) {
			case 'carousel':
				$data_string = ' data-items="' . esc_attr( $items_per_page ) . '" data-slider-autoplay="' . esc_attr( $auto_play ) . '" data-slider-speed="' . esc_attr( $slideshow_speed ) . '" data-slider-pause="' . esc_attr( $pause_hover ) . '"';
				$data_string .= ' data-pagination-speed="' . esc_attr( $carousel_pagination_speed ) . '"';
				$data_string .= ' data-pagination="' . esc_attr( $carousel_pagination ) . '"';
				if ( 'yes' == $item_gutter ) {
					$data_string .= ' data-gutter-size="' . esc_attr( $gutter_size ) . '"';
				}
				array_push( $product_classes, 'eut-carousel' );
				array_push( $product_classes, 'eut-' . $carousel_layout );

				if ( 'yes' == $item_gutter ) {
					array_push( $product_classes, 'eut-with-gap' );
				}
				$disable_pagination = 'yes';
				break;
			case 'grid':
			default:
				$product_row_start = '<div class="eut-isotope-container">';

				$data_string = ' data-spinner="' . esc_attr( $item_spinner ) . '" data-columns="' . esc_attr( $columns ) . '" data-columns-large-screen="' . esc_attr( $columns_large_screen ) . '" data-columns-tablet-landscape="' . esc_attr( $columns_tablet_landscape ) . '" data-columns-tablet-portrait="' . esc_attr( $columns_tablet_portrait ) . '" data-columns-mobile="' . esc_attr( $columns_mobile ) . '" data-layout="fitRows"';
				if ( 'yes' == $item_gutter ) {
					$data_string .= ' data-gutter-size="' . esc_attr( $gutter_size ) . '"';
				}
				if ( 'yes' == $item_gutter ) {
					array_push( $product_classes, 'eut-with-gap' );
				}
				array_push( $product_classes, 'eut-product' );
				array_push( $product_classes, 'eut-isotope' );
				$allow_filter = 'yes';
				break;
		}

		$isotope_inner_item_classes = array( 'eut-isotope-item-inner', 'eut-hover-item' );

		if ( !empty( $animation ) ) {
			array_push( $isotope_inner_item_classes, $animation);
		}

		array_push( $isotope_inner_item_classes, 'eut-product-' . $product_style);

		$isotope_inner_item_class_string = implode( ' ', $isotope_inner_item_classes );

		// Image Effect
		$image_effect_classes = array( 'eut-image-hover' );
		if ( 'none' != $zoom_effect ) {
			array_push( $image_effect_classes, 'eut-zoom-' . $zoom_effect );
		}
		if ( 'none' != $grayscale_effect ) {
			array_push( $image_effect_classes, 'eut-' . $grayscale_effect );
		}

		if( 'hover-style-2' == $product_style && 'light' == $overlay_color ){
			array_push( $image_effect_classes, 'eut-text-black' );
		}

		$image_effect_class_string = implode( ' ', $image_effect_classes );


		if ( !empty ( $el_class ) ) {
			array_push( $product_classes, $el_class);
		}
		$product_class_string = implode( ' ', $product_classes );

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$product_cat = "";
		$product_category_ids = array();

		if( ! empty( $categories ) ) {
			$product_category_ids = explode( ",", $categories );
			foreach ( $product_category_ids as $category_id ) {
				$category_term = get_term( $category_id, 'product_cat' );
				if ( isset( $category_term) ) {
					$product_cat = $product_cat.$category_term->slug . ', ';
				}
			}
		}

		$paged = 1;

		if ( 'yes' != $disable_pagination ) {
			if ( get_query_var( 'paged' ) ) {
				$paged = get_query_var( 'paged' );
			} elseif ( get_query_var( 'page' ) ) {
				$paged = get_query_var( 'page' );
			}
		}

		$exclude_ids = array();
		if( !empty( $exclude_posts ) ){
			$exclude_ids = explode( ',', $exclude_posts );
		}

		$include_ids = array();
		if( !empty( $include_posts ) ){
			$include_ids = explode( ',', $include_posts );
			$args = array(
				'post_type' => 'product',
				'post_status'=>'publish',
				'paged' => $paged,
				'post__in' => $include_ids,
				'posts_per_page' => $items_to_show,
				'orderby' => $order_by,
				'order' => $order,
			);
			$product_filter = 'no';
		} else {
			$args = array(
				'post_type' => 'product',
				'post_status'=>'publish',
				'paged' => $paged,
				'product_cat' => $product_cat,
				'post__not_in' => $exclude_ids,
				'posts_per_page' => $items_to_show,
				'orderby' => $order_by,
				'order' => $order,
			);
		}

		$query = new WP_Query( $args );
		ob_start();
		if ( $query->have_posts() ) :
		?>
			<div class="<?php echo esc_attr( $product_class_string ); ?>" style="<?php echo $style; ?>"<?php echo $data_string; ?>>
		<?php

		if ( 'yes' == $product_filter && 'yes' == $allow_filter ) {

			$filter_classes = array( 'eut-filter' );

			array_push( $filter_classes, 'eut-filter-style-' . $filter_style );
			array_push( $filter_classes, 'eut-align-' . $product_filter_align);
			array_push( $filter_classes, 'eut-link-text');

			if ( 'button' == $filter_style ) {
				array_push( $filter_classes, 'eut-link-text');
				array_push( $filter_classes, 'eut-filter-shape-' . $filter_shape );
				array_push( $filter_classes, 'eut-filter-color-' . $filter_color );
			}

			$filter_class_string = implode( ' ', $filter_classes );

			$category_prefix = '.product_cat-';
			$category_filter_list = array();
			$category_filter_array = array();
			$all_string =  apply_filters( 'zuperla_eutf_vce_product_string_all_categories', esc_html__( 'All', 'zuperla-extension' ) );
			$category_filter_string = '<li data-filter="*" class="selected"><span>' . esc_html( $all_string ) . '</span></li>';
			$category_filter_add = false;
			while ( $query->have_posts() ) : $query->the_post();

				if ( $product_categories = get_the_terms( get_the_ID(), 'product_cat' ) ) {

					foreach($product_categories as $category_term){
						$category_filter_add = false;
						if ( !in_array($category_term->term_id, $category_filter_list) ) {
							if( ! empty( $product_category_ids ) ) {
								if ( in_array($category_term->term_id, $product_category_ids) ) {
									$category_filter_add = true;
								}
							} else {
								$category_filter_add = true;
							}
							if ( $category_filter_add ) {
								$category_filter_list[] = $category_term->term_id;
								if ( 'title' == $filter_order_by ) {
									$category_filter_array[$category_term->name] = $category_term;
								} elseif ( 'slug' == $filter_order_by )  {
									$category_filter_array[$category_term->slug] = $category_term;
								} else {
									$category_filter_array[$category_term->term_id] = $category_term;
								}
							}
						}
					}
				}

			endwhile;


			if ( count( $category_filter_array ) > 1 ) {
				if ( '' != $filter_order_by ) {
					if ( 'ASC' == $filter_order ) {
						ksort( $category_filter_array );
					} else {
						krsort( $category_filter_array );
					}
				}
				foreach($category_filter_array as $category_filter){
					$term_class = sanitize_html_class( $category_filter->slug, $category_filter->term_id );
					if ( is_numeric( $term_class ) || ! trim( $term_class, '-' ) ) {
						$term_class = $category_filter->term_id;
					}

					$category_filter_string .= '<li data-filter="' . $category_prefix . $term_class . '"><span>' . $category_filter->name . '</span></li>';
				}
		?>
				<div class="<?php echo esc_attr( $filter_class_string ); ?>">
					<ul>
						<?php echo $category_filter_string; ?>
					</ul>
				</div>
		<?php
			}
		}
		?>

			<?php echo $product_row_start; ?>

		<?php

		if ( 'carousel' == $product_mode ) {

			//Carousel Navigation
			if( 'layout-2' == $carousel_layout ){
				echo '<div class="eut-carousel-info-wrapper eut-align-' . esc_attr( $align ) . '">';
				echo '  <div class="eut-carousel-info">';
				if( !empty( $title ) ){
					$title_classes = array( 'eut-title' );
					$title_classes[]  = 'eut-' . $heading;
					if ( !empty( $custom_font_family ) ) {
						$title_classes[]  = 'eut-' . $custom_font_family;
					}
					$title_class_string = implode( ' ', $title_classes );
					echo'    <' . tag_escape( $heading_tag ) .' class="' . esc_attr( $title_class_string ) . '">' . $title . '</' . tag_escape( $heading_tag ) .'>';
				}
				if ( !empty( $content ) ) {
					echo '    <p class="eut-description eut-' . esc_attr( $text_style ) . '">' . zuperla_ext_vce_unautop( $content ) . '</p>';
				}
				echo '  </div>';
				echo zuperla_ext_vce_element_navigation( $navigation_type, $navigation_color, 'carousel' );
				echo '</div>';
			}
			echo '  <div class="eut-carousel-wrapper">';
			if( 'layout-1' == $carousel_layout ){
				echo zuperla_ext_vce_element_navigation( $navigation_type, $navigation_color, 'carousel' );
			}
?>
			<div class="eut-carousel-element eut-product owl-carousel"<?php echo $data_string; ?>>
<?php
		}

		$product_index = 0;

		while ( $query->have_posts() ) : $query->the_post();
			$image_size = 'zuperla-eutf-small-rect-horizontal';
			$product_index++;
			$product_extra_class = '';

			if ( 'carousel' != $product_mode ) {
				//Grid - Default
				$product_extra_class = 'eut-isotope-item eut-product-item ';
				$image_size = zuperla_ext_vce_get_image_size( $grid_image_mode );
			} else {
				//Carousel
				$image_size = zuperla_ext_vce_get_image_size( $carousel_image_mode );
				$product_extra_class = 'eut-product-item';
				echo '<div class="eut-carousel-item">';
			}

			//Second Image Classes
			$image_classes = array();
			$image_classes[] = 'attachment-' . $image_size;
			$image_classes[] = 'size-' . $image_size;
			$image_classes[] = 'eut-product-thumbnail-second';
			$image_class_string = implode( ' ', $image_classes );

			//Second Product Image
			global $product;
			if ( method_exists( $product, 'get_gallery_image_ids' ) ) {
				$attachment_ids = $product->get_gallery_image_ids();
			} else {
				$attachment_ids = $product->get_gallery_attachment_ids();
			}
			$product_thumb_second_id = '';

			if ( $attachment_ids ) {
				$loop = 0;
				foreach ( $attachment_ids as $attachment_id ) {
					$image_link = wp_get_attachment_url( $attachment_id );
					if (!$image_link) {
						continue;
					}
					$loop++;
					$product_thumb_second_id = $attachment_id;
					if ($loop == 1) {
						break;
					}
				}
			}

?>

					<article id="product-<?php the_ID(); ?><?php echo uniqid('-'); ?>" <?php post_class( $product_extra_class ); ?>>
						<?php
						if ( 'carousel' == $product_mode ) {
						?><div class="eut-carousel-item eut-hover-item"><?php
						} else {
						?><div class="<?php echo esc_attr( $isotope_inner_item_class_string ); ?>"><?php
						}
							if ( 'hover-style-1' == $product_style ) {
						?>
							<div class="eut-product-added-icon eut-icon-shop eut-bg-primary-1"></div>
							<figure class="<?php echo esc_attr( $image_effect_class_string ); ?>">
								<div class="eut-media">
									<div class="eut-add-cart-wrapper">
										<div class="eut-add-cart-button">
											<?php woocommerce_template_loop_add_to_cart(); ?>
										</div>
									</div>
									<a class="eut-item-url" href="<?php echo esc_url( get_permalink() ); ?>"></a>
									<div class="eut-bg-<?php echo esc_attr( $overlay_color ); ?> eut-hover-overlay eut-opacity-<?php echo esc_attr( $overlay_opacity ); ?>"></div>
									<?php
										woocommerce_show_product_loop_sale_flash();
										if ( has_post_thumbnail() ) {
											the_post_thumbnail( $image_size );
										} elseif ( wc_placeholder_img_src() ) {
											echo wc_placeholder_img( $image_size );
										}
										if ( 'yes' == $second_image_effect && !empty( $product_thumb_second_id ) ) {
											echo wp_get_attachment_image( $product_thumb_second_id, $image_size , "", array( 'class' => $image_class_string ) );
										}
									?>
								</div>
								<figcaption class="eut-content eut-align-center">
									<a href="<?php echo esc_url( get_permalink() ); ?>">
										<<?php echo tag_escape( $product_title_heading_tag ); ?> class="eut-title eut-<?php echo esc_attr( $product_title_heading ); ?>"><?php the_title(); ?></<?php echo tag_escape( $product_title_heading_tag ); ?>>
									</a>
									<?php woocommerce_template_loop_price(); ?>
								</figcaption>
							</figure>
						<?php
							} else {
						?>
							<figure class="<?php echo esc_attr( $image_effect_class_string ); ?>">
								<div class="eut-media">
									<div class="eut-add-cart-wrapper">
										<div class="eut-add-cart-button">
											<?php woocommerce_template_loop_add_to_cart(); ?>
										</div>
									</div>
									<a class="eut-item-url" href="<?php echo esc_url( get_permalink() ); ?>"></a>
									<div class="eut-bg-<?php echo esc_attr( $overlay_color ); ?> eut-hover-overlay eut-opacity-<?php echo esc_attr( $overlay_opacity ); ?>"></div>
									<?php
										woocommerce_show_product_loop_sale_flash();
										if ( has_post_thumbnail() ) {
											the_post_thumbnail( $image_size );
										} elseif ( wc_placeholder_img_src() ) {
											echo wc_placeholder_img( $image_size );
										}
										if ( 'yes' == $second_image_effect && !empty( $product_thumb_second_id ) ) {
											echo wp_get_attachment_image( $product_thumb_second_id, $image_size , "", array( 'class' => $image_class_string ) );
										}
									?>
								</div>
								<figcaption class="eut-content">
									<<?php echo tag_escape( $product_title_heading_tag ); ?> class="eut-title eut-<?php echo esc_attr( $product_title_heading ); ?>"><?php the_title(); ?></<?php echo tag_escape( $product_title_heading_tag ); ?>>
									<?php woocommerce_template_loop_price(); ?>
								</figcaption>
							</figure>

						<?php
							}
						?>

						</div>

					</article>
<?php
			if ( 'carousel' == $product_mode ) {
				echo '</div>';
			}

		endwhile;
			if ( 'carousel' == $product_mode ) {
				echo '</div>';
			}
		?>
				</div>
<?php
			if ( 'yes' != $disable_pagination ) {
				$total = $query->max_num_pages;
				$big = 999999999; // need an unlikely integer
				if( $total > 1 )  {
					 echo '<div class="eut-pagination eut-pagination-text eut-heading-color">';

					 if( get_option('permalink_structure') ) {
						 $format = 'page/%#%/';
					 } else {
						 $format = '&paged=%#%';
					 }
					 echo paginate_links(array(
						'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format'		=> $format,
						'current'		=> max( 1, $paged ),
						'total'			=> $total,
						'mid_size'		=> 2,
						'type'			=> 'list',
						'prev_text'	=> '<i class="eut-icon-nav-left"></i>',
						'next_text'	=> '<i class="eut-icon-nav-right"></i>',
						'add_args' => false,
					 ));
					 echo '</div>';
				}
			}
?>
			</div>

		<?php

		else :
		endif;
		wp_reset_postdata();

		return ob_get_clean();

	}
	add_shortcode( 'zuperla_products', 'zuperla_ext_vce_products_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_products_shortcode_params' ) ) {
	function zuperla_ext_vce_products_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Products", "zuperla-extension" ),
			"description" => esc_html__( "Display product element in multiple styles", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-product",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Product Mode", "zuperla-extension" ),
					"param_name" => "product_mode",
					"admin_label" => true,
					'value' => array(
						esc_html__( 'Grid' , 'zuperla-extension' ) => 'grid',
						esc_html__( 'Carousel' , 'zuperla-extension' ) => 'carousel',
					),
					"description" => esc_html__( "Select your product mode", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Layout", "zuperla-extension" ),
					"param_name" => "carousel_layout",
					"value" => array(
						esc_html__( "Classic", "zuperla-extension" ) => 'layout-1',
						esc_html__( "With title and description", "zuperla-extension" ) => 'layout-2',
					),
					"description" => 'Select your layout for Carousel Element',
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "zuperla-extension" ),
					"param_name" => "title",
					"value" => "Sample Title",
					"description" => esc_html__( "Enter your title here.", "zuperla-extension" ),
					"save_always" => true,
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "zuperla-extension" ),
					"param_name" => "heading_tag",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "div", "zuperla-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "zuperla-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Size/Typography", "zuperla-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "zuperla-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Title Custom Font Family", "zuperla-extension" ),
					"param_name" => "custom_font_family",
					"value" => array(
						esc_html__( "Same as Typography", "zuperla-extension" ) => '',
						esc_html__( "Custom Font Family 1", "zuperla-extension" ) => 'custom-font-1',
						esc_html__( "Custom Font Family 2", "zuperla-extension" ) => 'custom-font-2',
						esc_html__( "Custom Font Family 3", "zuperla-extension" ) => 'custom-font-3',
						esc_html__( "Custom Font Family 4", "zuperla-extension" ) => 'custom-font-4',

					),
					"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "zuperla-extension" ),
					"std" => '',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Text", "zuperla-extension" ),
					"param_name" => "content",
					"value" => "",
					"description" => esc_html__( "Type your text.", "zuperla-extension" ),
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Style", "zuperla-extension" ),
					"param_name" => "text_style",
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => '',
						esc_html__( "Leader", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle", "zuperla-extension" ) => 'subtitle',
					),
					"description" => 'Select your text style',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Alignment", "zuperla-extension" ),
					"param_name" => "align",
					"value" => array(
						esc_html__( "Left", "zuperla-extension" ) => 'left',
						esc_html__( "Right", "zuperla-extension" ) => 'right',
						esc_html__( "Center", "zuperla-extension" ) => 'center',
					),
					"description" => '',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Grid Image Size", "zuperla-extension" ),
					"param_name" => "grid_image_mode",
					'value' => array(
						esc_html__( 'Square Small Crop', 'zuperla-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'zuperla-extension' ) => 'landscape',
						esc_html__( 'Landscape Medium Crop', 'zuperla-extension' ) => 'landscape-medium',
						esc_html__( 'Portrait Small Crop', 'zuperla-extension' ) => 'portrait',
						esc_html__( 'Portrait Medium Crop', 'zuperla-extension' ) => 'portrait-medium',
						esc_html__( 'Resize ( Large )', 'zuperla-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'zuperla-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'zuperla-extension' ) => 'medium',
					),
					'std' => 'landscape',
					"description" => esc_html__( "Select your Grid Image Size.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Image Size", "zuperla-extension" ),
					"param_name" => "carousel_image_mode",
					'value' => array(
						esc_html__( 'Square Small Crop', 'zuperla-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'zuperla-extension' ) => 'landscape',
						esc_html__( 'Portrait Small Crop', 'zuperla-extension' ) => 'portrait',
					),
					'std' => 'landscape',
					"description" => esc_html__( "Select your Carousel Image Size.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Large Screen Columns", "zuperla-extension" ),
					"param_name" => "columns_large_screen",
					"value" => array( '2', '3', '4', '5' ),
					"std" => '3',
					"description" => esc_html__( "Select your Products Columns.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Columns", "zuperla-extension" ),
					"param_name" => "columns",
					"value" => array( '2', '3', '4', '5' ),
					"std" => '3',
					"description" => esc_html__( "Select your Products Columns.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Landscape Columns", "zuperla-extension" ),
					"param_name" => "columns_tablet_landscape",
					"value" => array( '2', '3', '4' ),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, landscape orientation.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Portrait Columns", "zuperla-extension" ),
					"param_name" => "columns_tablet_portrait",
					"value" => array( '2', '3', '4' ),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, portrait orientation.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Mobile Columns", "zuperla-extension" ),
					"param_name" => "columns_mobile",
					"value" => array( '1', '2' ),
					"std" => '1',
					"description" => esc_html__( "Select responsive column on mobile devices.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items per page", "zuperla-extension" ),
					"param_name" => "items_per_page",
					"value" => array( '3', '4', '5' ),
					"description" => esc_html__( "Number of images per page", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
					"std" => '4',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between images", "zuperla-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among images.", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "zuperla-extension" ),
					"param_name" => "gutter_size",
					"value" => '30',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items to show", "zuperla-extension" ),
					"param_name" => "items_to_show",
					"value" => '12',
					"description" => esc_html__( "Maximum product Items to Show", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "zuperla-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Slideshow Speed", "zuperla-extension" ),
					"param_name" => "slideshow_speed",
					"value" => '3000',
					"description" => esc_html__( "Slideshow Speed in ms.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Pause on Hover", "zuperla-extension" ),
					"param_name" => "pause_hover",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"std" => "no",
					"description" => esc_html__( "If selected, carousel will be paused on hover", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Navigation Type", "zuperla-extension" ),
					"param_name" => "navigation_type",
					'value' => array(
						esc_html__( 'Style 1' , 'zuperla-extension' ) => '1',
						esc_html__( 'No Navigation' , 'zuperla-extension' ) => '0',
					),
					"description" => esc_html__( "Select your Navigation type.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Navigation Color", "zuperla-extension" ),
					"param_name" => "navigation_color",
					'value' => array(
						esc_html__( 'Dark' , 'zuperla-extension' ) => 'dark',
						esc_html__( 'Light' , 'zuperla-extension' ) => 'light',
					),
					"description" => esc_html__( "Select the background Navigation color.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Pagination", "zuperla-extension" ),
					"param_name" => "carousel_pagination",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => 'no',
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
					),
					"std" => "no",
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Carousel Pagination Speed", "zuperla-extension" ),
					"param_name" => "carousel_pagination_speed",
					"value" => '400',
					"description" => esc_html__( "Pagination Speed in ms.", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'carousel' ) ),
				),
				zuperla_ext_vce_add_order_by(),
				zuperla_ext_vce_add_order(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "zuperla-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => '',
						esc_html__( "Fade In", "zuperla-extension" ) => "eut-fade-in",
						esc_html__( "Fade In Up", "zuperla-extension" ) => "eut-fade-in-up",
						esc_html__( "Fade In Down", "zuperla-extension" ) => "eut-fade-in-down",
						esc_html__( "Fade In Left", "zuperla-extension" ) => "eut-fade-in-left",
						esc_html__( "Fade In Right", "zuperla-extension" ) => "eut-fade-in-right",
						esc_html__( "Zoom In", "zuperla-extension" ) => "eut-zoom-in",
					),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "zuperla-extension" ),
					"std" => "eut-zoom-in",
				),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Product Title Tag", "zuperla-extension" ),
					"param_name" => "product_title_heading_tag",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "div", "zuperla-extension" ) => 'div',
					),
					"description" => esc_html__( "product Title Tag for SEO", "zuperla-extension" ),
					"std" => 'h3',
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Product Title Size/Typography", "zuperla-extension" ),
					"param_name" => "product_title_heading",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "product Title size and typography, defined in Theme Options - Typography Options", "zuperla-extension" ),
					"std" => 'h3',
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Product Style - Hovers", "zuperla-extension" ),
					"param_name" => "product_style",
					'value' => array(
						esc_html__( 'Content Below Image' , 'zuperla-extension' ) => 'hover-style-1',
						esc_html__( 'Top Down Animated Content' , 'zuperla-extension' ) => 'hover-style-2',
					),
					"description" => esc_html__( "Select the hover style for the product overview.", "zuperla-extension" ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Second Image Effect", "zuperla-extension" ),
					"param_name" => "second_image_effect",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"description" => esc_html__( "Choose if you want second image effect.", "zuperla-extension" ),
					'std' => 'yes',
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Zoom Effect", "zuperla-extension" ),
					"param_name" => "zoom_effect",
					"value" => array(
						esc_html__( "Zoom In", "zuperla-extension" ) => 'in',
						esc_html__( "Zoom Out", "zuperla-extension" ) => 'out',
						esc_html__( "None", "zuperla-extension" ) => 'none',
					),
					"description" => esc_html__( "Choose the image zoom effect.", "zuperla-extension" ),
					'std' => 'none',
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Grayscale Effect", "zuperla-extension" ),
					"param_name" => "grayscale_effect",
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => 'none',
						esc_html__( "Grayscale Image", "zuperla-extension" ) => 'grayscale-image',
						esc_html__( "Colored on Hover", "zuperla-extension" ) => 'grayscale-image-hover',
					),
					"description" => esc_html__( "Choose the grayscale effect.", "zuperla-extension" ),
					'std' => 'none',
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Color", "zuperla-extension" ),
					"param_name" => "overlay_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Light", "zuperla-extension" ) => 'light',
						esc_html__( "Dark", "zuperla-extension" ) => 'dark',
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
					),
					"description" => esc_html__( "Choose the image color overlay.", "zuperla-extension" ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Enable Loader", "zuperla-extension" ),
					"param_name" => "item_spinner",
					"description" => esc_html__( "If selected, this will enable a graphic spinner before load.", "zuperla-extension" ),
					"value" => array( esc_html__( "Enable Loader.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Disable Pagination", "zuperla-extension" ),
					"param_name" => "disable_pagination",
					"description" => esc_html__( "If selected, pagination will not be shown.", "zuperla-extension" ),
					"value" => array( esc_html__( "Disable Pagination.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Overlay Opacity", "zuperla-extension" ),
					"param_name" => "overlay_opacity",
					"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
					"std" => '90',
					"description" => esc_html__( "Choose the opacity for the overlay.", "zuperla-extension" ),
					"group" => esc_html__( "Titles & Hovers", "zuperla-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Filter", "zuperla-extension" ),
					"param_name" => "product_filter",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => '',
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
					),
					"description" => esc_html__( "If selected, an isotope filter will be displayed.", "zuperla-extension" ) . " " . esc_html__( "Enable product Filter ( Only for All or Multiple Categories )", "zuperla-extension" ),
					"dependency" => array( 'element' => "product_mode", 'value' => array( 'grid' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Order By", "zuperla-extension" ),
					"param_name" => "filter_order_by",
					"value" => array(
						esc_html__( "Default ( Unordered )", "zuperla-extension" ) => '',
						esc_html__( "ID", "zuperla-extension" ) => 'id',
						esc_html__( "Slug", "zuperla-extension" ) => 'slug',
						esc_html__( "Title", "zuperla-extension" ) => 'title',
					),
					"description" => '',
					"dependency" => array( 'element' => "product_filter", 'value' => array( 'yes' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Order", "zuperla-extension" ),
					"param_name" => "filter_order",
					"value" => array(
						esc_html__( "Ascending", "zuperla-extension" ) => 'ASC',
						esc_html__( "Descending", "zuperla-extension" ) => 'DESC',
					),
					"dependency" => array( 'element' => "product_filter", 'value' => array( 'yes' ) ),
					"description" => '',
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Style", "zuperla-extension" ),
					"param_name" => "filter_style",
					"value" => array(
						esc_html__( "Simple", "zuperla-extension" ) => 'simple',
						esc_html__( "Button", "zuperla-extension" ) => 'button',

					),
					"dependency" => array( 'element' => "product_filter", 'value' => array( 'yes' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Alignment", "zuperla-extension" ),
					"param_name" => "product_filter_align",
					"value" => array(
						esc_html__( "Left", "zuperla-extension" ) => 'left',
						esc_html__( "Right", "zuperla-extension" ) => 'right',
						esc_html__( "Center", "zuperla-extension" ) => 'center',
					),
					"description" => '',
					"dependency" => array( 'element' => "product_filter", 'value' => array( 'yes' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "zuperla-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "zuperla_ext_multi_checkbox",
					"heading" => __("Product Categories", "zuperla-extension" ),
					"param_name" => "categories",
					"value" => zuperla_ext_vce_get_product_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "zuperla-extension" ),
					"admin_label" => true,
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "zuperla-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_products', 'zuperla_ext_vce_products_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_products_shortcode_params( 'zuperla_products' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
