<?php
/**
 * Icon Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_icon_shortcode' ) ) {

	function zuperla_ext_vce_icon_shortcode( $atts, $content ) {

		$output = $link_start = $link_end = $retina_data = $text_style_class = $data = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'icon_type' => 'icon',
					'icon_library' => 'fontawesome',
					'icon_fontawesome' => 'fa fa-adjust',
					'icon_openiconic' => 'vc-oi vc-oi-dial',
					'icon_typicons' => 'typcn typcn-adjust-brightness',
					'icon_entypo' => 'entypo-icon entypo-icon-note',
					'icon_linecons' => 'vc_li vc_li-heart',
					'icon_simplelineicons' => 'smp-icon-user',
					'icon_etlineicons' => 'et-icon-mobile',
					'icon_size' => 'medium',
					'icon_shape' => 'no-shape',
					'shape_type' => 'simple',
					'icon_svg' => '',
					'icon_svg_animation_duration' => '100',
					'icon_color' => 'primary-1',
					'icon_shape_color' => 'grey',
					'icon_animation' => 'no',
					'inherit_align' => 'inherit',
					'icon_hover_effect' => 'no',
					'link' => '',
					'link_class' => '',
					'animation' => '',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);

		$icon_element_classes = array( 'eut-element' );

		array_push( $icon_element_classes, 'eut-single-icon' );
		array_push( $icon_element_classes, 'eut-align-' . $inherit_align );
		array_push( $icon_element_classes, 'eut-' . $icon_size );

		if ( !empty( $animation ) ) {
			array_push( $icon_element_classes, 'eut-animated-item' );
			array_push( $icon_element_classes, $animation);
			array_push( $icon_element_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}

		if ( !empty ( $el_class ) ) {
			array_push( $icon_element_classes, $el_class);
		}

		if( 'yes' == $icon_hover_effect && 'no-shape' != $icon_shape ) {
			array_push( $icon_element_classes, 'eut-hover-effect' );
		}

		$icon_wrapper_classes = array( 'eut-wrapper-icon' );
		$icon_classes = array();

		if ( 'no-shape' != $icon_shape ) {
			array_push( $icon_wrapper_classes, 'eut-' . $shape_type );
			array_push( $icon_element_classes, 'eut-with-shape' );
		}
		array_push( $icon_wrapper_classes, 'eut-' . $icon_shape );

		if ( 'no-shape' != $icon_shape && 'outline' != $shape_type ) {
			array_push( $icon_wrapper_classes, 'eut-bg-' . $icon_shape_color );
		} else {
			array_push( $icon_wrapper_classes, 'eut-text-' . $icon_shape_color );
		}

		$icon_class = isset( ${"icon_" . $icon_library} ) ? esc_attr( ${"icon_" . $icon_library} ) : 'fa fa-adjust';
		if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ) {
			vc_icon_element_fonts_enqueue( $icon_library );
		}
		array_push( $icon_classes, $icon_class );
		array_push( $icon_classes, 'eut-text-' . $icon_color );

		$icon_element_class_string = implode( ' ', $icon_element_classes );
		$icon_wrapper_class_string = implode( ' ', $icon_wrapper_classes );
		$icon_class_string = implode( ' ', $icon_classes );


		if ( zuperla_ext_vce_has_link( $link ) ) {
			$link_attributes = zuperla_ext_vce_get_link_attributes( $link, $link_class );
			$link_start = '<a ' . implode( ' ', $link_attributes ) . '>';
			$link_end = '</a>';
		}

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$output .= '<div class="' . esc_attr( $icon_element_class_string ) . '" style="' . $style . '"' . $data . '>';
		$output .= $link_start;
		if( 'icon_svg' == $icon_type ) {
			$empty_image_url = ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/images/empty/default-icon.svg';

			if ( !empty( $icon_svg ) ) {
				$img_id = preg_replace('/[^\d]/', '', $icon_svg);
				$img_src = wp_get_attachment_image_src( $img_id, 'full' );
				$img_url = $img_src[0];
				$parts = pathinfo( $img_url );
				if ( !isset( $parts['extension'] ) || 'svg' != $parts['extension'] ) {
					$img_url = $empty_image_url;
				}
			} else {
				$img_url = $empty_image_url;
			}			
			$output .= '<div class="' . esc_attr( $icon_wrapper_class_string ) . '">';
			$output .= '<div id="' . uniqid('eut-svg-') . '" data-file="' . esc_url( $img_url ) . '" data-duration="' . esc_attr( $icon_svg_animation_duration ) . '" class="eut-svg-icon eut-text-' . esc_attr( $icon_color ) . '"></div>';
			$output .= '</div>';
		} else {
			$output .= '  <div class="' . esc_attr( $icon_wrapper_class_string ) . '"><i class="'. esc_attr( $icon_class_string ) . '"></i></div>';
		}
		$output .= $link_end;
		$output .= '</div>';

		return $output;
	}
	add_shortcode( 'zuperla_icon', 'zuperla_ext_vce_icon_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_icon_shortcode_params' ) ) {
	function zuperla_ext_vce_icon_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Icon", "zuperla-extension" ),
			"description" => esc_html__( "Add an icon", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-icon",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Type", "zuperla-extension" ),
					"param_name" => "icon_type",
					"value" => array(
						esc_html__( "Icon", "zuperla-extension" ) => 'icon',
						esc_html__( "Animated SVG", "zuperla-extension" ) => 'icon_svg',
					),
					"description" => '',
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon size", "zuperla-extension" ),
					"param_name" => "icon_size",
					"value" => array(
						esc_html__( "Extra Large", "zuperla-extension" ) => 'extra-large',
						esc_html__( "Large", "zuperla-extension" ) => 'large',
						esc_html__( "Medium", "zuperla-extension" ) => 'medium',
						esc_html__( "Small", "zuperla-extension" ) => 'small',
					),
					"std" => 'medium',
					"description" => '',
				),
				zuperla_ext_vce_add_inherit_align(),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon library', 'zuperla-extension' ),
					'value' => array(
						esc_html__( 'Font Awesome', 'zuperla-extension' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'zuperla-extension' ) => 'openiconic',
						esc_html__( 'Typicons', 'zuperla-extension' ) => 'typicons',
						esc_html__( 'Entypo', 'zuperla-extension' ) => 'entypo',
						esc_html__( 'Linecons', 'zuperla-extension' ) => 'linecons',
						esc_html__( 'Simple Line Icons', 'zuperla-extension' ) => 'simplelineicons',
						esc_html__( 'Elegant Line Icons', 'zuperla-extension' ) => 'etlineicons',
					),
					'param_name' => 'icon_library',
					'description' => esc_html__( 'Select icon library.', 'zuperla-extension' ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon' ) ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fa fa-adjust',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 300, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_simplelineicons',
					'value' => 'smp-icon-user',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'simplelineicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'simplelineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_etlineicons',
					'value' => 'et-icon-mobile',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'etlineicons',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'etlineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Icon SVG", "zuperla-extension" ),
					"param_name" => "icon_svg",
					"value" => '',
					"description" => esc_html__( "Select an svg icon. Note: SVG mime type must be enabled in WordPress", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon_svg' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__('SVG Animation Duration', 'zuperla-extension'),
					"param_name" => "icon_svg_animation_duration",
					"value" => '100',
					"description" => esc_html__( "Add delay in milliseconds.", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon_svg' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Color", "zuperla-extension" ),
					"param_name" => "icon_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					"description" => esc_html__( "Color of the icon.", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon', 'icon_svg' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon shape", "zuperla-extension" ),
					"param_name" => "icon_shape",
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => 'no-shape',
						esc_html__( "Square", "zuperla-extension" ) => 'square',
						esc_html__( "Round", "zuperla-extension" ) => 'round',
						esc_html__( "Circle", "zuperla-extension" ) => 'circle',
					),
					"description" => '',
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon', 'icon_svg' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shape type", "zuperla-extension" ),
					"param_name" => "shape_type",
					"value" => array(
						esc_html__( "Simple", "zuperla-extension" ) => 'simple',
						esc_html__( "Outline", "zuperla-extension" ) => 'outline',
					),
					"description" => esc_html__( "Select shape type.", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Shape Color", "zuperla-extension" ),
					"param_name" => "icon_shape_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					'std' => 'grey',
					"description" => esc_html__( "This affects to the Background of the simple shape type. Alternatively, affects to the line shape type.", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Enable Hover Effect", "zuperla-extension" ),
					"param_name" => "icon_hover_effect",
					"value" => array( esc_html__( "If selected, you will have hover effect.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					"type" => "vc_link",
					"heading" => esc_html__( "Link", "zuperla-extension" ),
					"param_name" => "link",
					"value" => "",
					"description" => esc_html__( "Enter link.", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Link Class", "zuperla-extension" ),
					"param_name" => "link_class",
					"value" => "",
					"description" => esc_html__( "Enter extra class name for your link.", "zuperla-extension" ),
				),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_icon', 'zuperla_ext_vce_icon_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_icon_shortcode_params( 'zuperla_icon' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
