<?php
/**
 * Typed Text Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_countdown_shortcode' ) ) {

	function zuperla_ext_vce_countdown_shortcode( $atts, $content ) {

		$output = $el_class = $data = '';

		extract(
			shortcode_atts(
				array(
					'final_date' => '',
					'countdown_format' => 'D|H|M|S',
					'countdown_style' => '1',
					'numbers_size' => 'h3',
					'text_size' => 'small-text',
					'numbers_color' => 'black',
					'text_color' => 'black',
					'animation' => '',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);

		$countdown_classes = array( 'eut-element' , 'eut-countdown' );

		array_push( $countdown_classes, 'eut-style-' . $countdown_style );

		if ( !empty( $animation ) ) {
			array_push( $countdown_classes, 'eut-animated-item' );
			array_push( $countdown_classes, $animation);
			array_push( $countdown_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}

		if ( !empty ( $el_class ) ) {
			array_push( $countdown_classes, $el_class);
		}

		$countdown_class_string = implode( ' ', $countdown_classes );


		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );


		$output .= '<div class="' . esc_attr( $countdown_class_string ) . '" style="' . $style . '" data-countdown="' . esc_attr( $final_date ) . '" data-countdown-format="' . esc_attr( $countdown_format ) . '" data-numbers-size="' . esc_attr( $numbers_size ) . '" data-text-size="' . esc_attr( $text_size ) . '" data-numbers-color="' . esc_attr( $numbers_color ) . '" data-text-color="' . esc_attr( $text_color ) . '"' . $data . '></div>';


		return $output;
	}
	add_shortcode( 'zuperla_countdown', 'zuperla_ext_vce_countdown_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_countdown_shortcode_params' ) ) {
	function zuperla_ext_vce_countdown_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Countdown", "zuperla-extension" ),
			"description" => esc_html__( "Add a countdown element", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-countdown",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Final Date", "zuperla-extension" ),
					"param_name" => "final_date",
					"value" => "",
					"description" => esc_html__( "Accepted formats: YYYY/MM/DD , MM/DD/YYYY , YYYY/MM/DD hh:mm:ss , MM/DD/YYYY hh:mm:ss ( e.g: 2016/05/12 )", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Countdown Display", "zuperla-extension" ),
					"param_name" => "countdown_format",
					"value" => array(
						esc_html__( "Days Hours Minutes Seconds", "zuperla-extension" ) => 'D|H|M|S',
						esc_html__( "Weeks Days Hours Minutes Seconds", "zuperla-extension" ) => 'w|d|H|M|S',
					),
					'std' => 'D|H|M|S',
					"description" => esc_html__( "Select the countdown display.", "zuperla-extension" ),
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Countdown Style", "zuperla-extension" ),
					"param_name" => "countdown_style",
					"value" => array(
						esc_html__( "Style 1", "zuperla-extension" ) => '1',
						esc_html__( "Style 2", "zuperla-extension" ) => '2',
						esc_html__( "Style 3", "zuperla-extension" ) => '3',
					),
					'std' => '1',
					"description" => esc_html__( "Select the countdown style.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Numbers size", "zuperla-extension" ),
					"param_name" => "numbers_size",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Numbers size and typography", "zuperla-extension" ),
					"std" => 'h3',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text size", "zuperla-extension" ),
					"param_name" => "text_size",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Text size and typography", "zuperla-extension" ),
					"std" => 'small-text',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Numbers Color", "zuperla-extension" ),
					"param_name" => "numbers_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					'std' => 'black',
					"description" => esc_html__( "Color of the numbers.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "zuperla-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					'std' => 'black',
					"description" => esc_html__( "Color of the text.", "zuperla-extension" ),
				),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_countdown', 'zuperla_ext_vce_countdown_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_countdown_shortcode_params( 'zuperla_countdown' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
