<?php
/**
 * Blog Leader Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_blog_leader_shortcode' ) ) {

	function zuperla_ext_vce_blog_leader_shortcode( $atts, $content ) {

		$output = $el_class = $data_string = $auto_excerpt = '';

		extract(
			shortcode_atts(
				array(
					'categories' => '',
					'exclude_posts' => '',
					'include_posts' => '',
					'blog_leader_style' => '',
					'leader_bg_color' => 'black',
					'leader_bg_opacity' => '70',
					'heading_tag' => 'h2',
					'heading' => 'auto',
					'blog_image_mode' => 'landscape',
					'excerpt_length' => '30',
					'excerpt_more' => '',
					'hide_author' => '',
					'hide_date' => '',
					'hide_comments' => '',
					'hide_like' => '',
					'posts_per_page' => '4',
					'order_by' => 'date',
					'order' => 'DESC',
					'animation' => 'eut-zoom-in',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);

		$blog_mode = 'leader';
		$blog_image_prio = 'yes';

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$blog_classes = array( 'eut-element', 'eut-blog-leader', 'eut-layout-1' );

		if ( !empty ( $el_class ) ) {
			array_push( $blog_classes, $el_class);
		}

		if( 'zuperla' == $blog_leader_style ) {
			array_push( $blog_classes, 'eut-zuperla-style' );
		}
		array_push( $blog_classes, 'eut-blog-items-' . $posts_per_page );


		$blog_class_string = implode( ' ', $blog_classes );

		$exclude_ids = array();
		if( !empty( $exclude_posts ) ){
			$exclude_ids = explode( ',', $exclude_posts );
		}

		$include_ids = array();
		if( !empty( $include_posts ) ){
			$include_ids = explode( ',', $include_posts );
			$args = array(
				'post_type' => 'post',
				'post_status'=>'publish',
				'posts_per_page' => $posts_per_page,
				'post__in' => $include_ids,
				'paged' => 1,
				'ignore_sticky_posts' => 1,
				'orderby' => $order_by,
				'order' => $order,
			);
		} else {
			$args = array(
				'post_type' => 'post',
				'post_status'=>'publish',
				'posts_per_page' => $posts_per_page,
				'post__not_in' => $exclude_ids,
				'cat' => $categories,
				'paged' => 1,
				'ignore_sticky_posts' => 1,
				'orderby' => $order_by,
				'order' => $order,
			);
		}

		$query = new WP_Query( $args );


		ob_start();

		if ( $query->have_posts() ) :

?>
		<div class="<?php echo esc_attr( $blog_class_string ); ?>" style="<?php echo $style; ?>">
<?php

		$animation_class  = '';
		if ( !empty( $animation ) ) {
			$animation_class = 'eut-animated-item ' . esc_attr( $animation );
		}

		$index = 0;

		$total = $query->post_count;

		while ( $query->have_posts() ) : $query->the_post();


			$post_format = get_post_format();
			$bg_post_mode = zuperla_ext_vce_is_post_bg( $blog_mode, $post_format );

			$index++;
			$zuperla_ext_post_class = 'eut-blog-item';
			$zuperla_leader_class = 'eut-post-leader';

			if( 1 == $index  ) {
				if( 'zuperla' == $blog_leader_style && 'primary-1' == $leader_bg_color ) {
					$zuperla_leader_class .= ' eut-with-primary-bg';
				}
				if( 1 == $total ) {
					$zuperla_leader_class .= ' eut-post-leader-only';
				}
				echo '<div class="' . esc_attr( $zuperla_leader_class ) . '">';
			} else if( 2 == $index ) {
				echo '<div class="eut-post-list">';
			}
?>

				<article <?php post_class( $zuperla_ext_post_class ); ?> itemscope itemType="http://schema.org/BlogPosting">
					<div class="eut-blog-item-inner <?php echo esc_attr( $animation_class ); ?>">

							<?php
								if( 1 == $index && 'zuperla' == $blog_leader_style ) {
									$bg_options = array(
										'bg_color' => $leader_bg_color,
										'bg_opacity' => $leader_bg_opacity,
									);
									zuperla_ext_vce_post_bg_image_container( $bg_options );
								} else {
									zuperla_ext_vce_print_post_feature_media( $blog_mode, $post_format, $blog_image_mode, $blog_image_prio );
								}

							?>
							<div class="eut-post-content">
								<div class="eut-post-header">
									<?php if( 1 == $index ) { ?>
										<?php zuperla_ext_vce_print_post_title( $blog_mode, $post_format, $heading_tag, $heading ); ?>
										<?php zuperla_ext_vce_print_structured_data(); ?>
										<?php if ( 'yes' != $hide_date || 'yes' != $hide_author || 'yes' != $hide_comments || 'yes' != $hide_like ) { ?>
											<ul class="eut-post-meta">
											<?php
												if ( 'yes' != $hide_author ) {
													zuperla_ext_vce_print_post_author_by( $blog_mode );
												}
												if ( 'yes' != $hide_date ) {
													zuperla_ext_vce_print_post_date('list');
												}
												if ( 'yes' != $hide_comments ) {
													zuperla_ext_vce_print_post_comments();
												}
												if( 'yes' != $hide_like && function_exists( 'zuperla_eutf_print_like_counter' ) ) {
													zuperla_eutf_print_like_counter();
												}
											?>
											</ul>
										<?php } ?>
									<?php } else { ?>
										<?php zuperla_ext_vce_print_post_title( $blog_mode, $post_format, $heading_tag, 'h5' ); ?>
										<?php zuperla_ext_vce_print_structured_data(); ?>
										<?php if ( 'yes' != $hide_date ) { ?>
											<ul class="eut-post-meta">
											<?php
												if ( 'yes' != $hide_date ) {
													zuperla_ext_vce_print_post_date('list');
												}
											?>
											</ul>
										<?php } ?>
									<?php } ?>

								</div>
								<?php zuperla_ext_vce_print_post_excerpt( $blog_mode, $post_format, $auto_excerpt, $excerpt_length, $excerpt_more ); ?>
							</div>

					</div>
				</article>

<?php
		if( 1 == $index ){
			echo '</div>';
		}

		endwhile;

		if( $index > 1 ){
			echo '</div>';
		}
?>
		</div>
<?php
		else :
		endif;

		wp_reset_postdata();

		return ob_get_clean();


	}
	add_shortcode( 'zuperla_blog_leader', 'zuperla_ext_vce_blog_leader_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_blog_leader_shortcode_params' ) ) {
	function zuperla_ext_vce_blog_leader_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Blog Leader", "zuperla-extension" ),
			"description" => esc_html__( "Display a Blog element in leader style", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-blog-leader",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Number of Posts", "zuperla-extension" ),
					"param_name" => "posts_per_page",
					"value" => array(
						esc_html__( "Leader Only", "zuperla-extension" ) => '1',
						esc_html__( "Leader + 2 columns", "zuperla-extension" ) => '3',
						esc_html__( "Leader + 3 columns", "zuperla-extension" ) => '4',
						esc_html__( "Leader + 4 columns", "zuperla-extension" ) => '5',
					),
					"description" => esc_html__( "Enter how many posts you want to display.", "zuperla-extension" ),
					"std" => '4',
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Mode", "zuperla-extension" ),
					"param_name" => "blog_image_mode",
					'value' => array(
						esc_html__( 'Landscape Small Crop', 'zuperla-extension' ) => 'landscape',
						esc_html__( 'Resize ( Large )', 'zuperla-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'zuperla-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'zuperla-extension' ) => 'medium',
					),
					"description" => esc_html__( "Select your Blog Image Mode.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Leader Style", "zuperla-extension" ),
					"param_name" => "blog_leader_style",
					'value' => array(
						esc_html__( 'Classic', 'zuperla-extension' ) => '',
						esc_html__( 'Zuperla', 'zuperla-extension' ) => 'zuperla',
					),
					"description" => esc_html__( "Select your Post Leader Style.", "zuperla-extension" ),
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Leader Background Color", "zuperla-extension" ),
					"param_name" => "leader_bg_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
					),
					'std' => 'black',
					"description" => esc_html__( "This affects the Background of the item.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_leader_style", 'value' => array( 'zuperla' ) ),
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Leader Background Opacity", "zuperla-extension" ),
					"param_name" => "leader_bg_opacity",
					"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
					"std" => '70',
					"description" => esc_html__( "Choose the opacity for the overlay.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_leader_style", 'value' => array( 'zuperla' ) ),
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				//Titles & Styles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Tag", "zuperla-extension" ),
					"param_name" => "heading_tag",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "div", "zuperla-extension" ) => 'div',
					),
					"description" => esc_html__( "Post Title Tag for SEO", "zuperla-extension" ),
					"std" => 'h2',
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Size/Typography", "zuperla-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "Auto", "zuperla-extension" ) => 'auto',
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Post Title size and typography, defined in Theme Options - Typography Options", "zuperla-extension" ),
					"std" => 'auto',
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Author", "zuperla-extension" ),
					"param_name" => "hide_author",
					"description" => esc_html__( "If selected, blog overview will not show author.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Author.", "zuperla-extension" ) => 'yes' ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Date", "zuperla-extension" ),
					"param_name" => "hide_date",
					"description" => esc_html__( "If selected, blog overview will not show date.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Date.", "zuperla-extension" ) => 'yes' ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Comments", "zuperla-extension" ),
					"param_name" => "hide_comments",
					"description" => esc_html__( "If selected, blog overview will not show comments.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Comments.", "zuperla-extension" ) => 'yes' ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Like", "zuperla-extension" ),
					"param_name" => "hide_like",
					"description" => esc_html__( "If selected, blog overview will not show like.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Like.", "zuperla-extension" ) => 'yes' ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Excerpt length", "zuperla-extension" ),
					"param_name" => "excerpt_length",
					"description" => esc_html__( "Type how many words you want to display in your post excerpts.", "zuperla-extension" ),
					"value" => '30',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "zuperla-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => '',
						esc_html__( "Fade In", "zuperla-extension" ) => "eut-fade-in",
						esc_html__( "Fade In Up", "zuperla-extension" ) => "eut-fade-in-up",
						esc_html__( "Fade In Down", "zuperla-extension" ) => "eut-fade-in-down",
						esc_html__( "Fade In Left", "zuperla-extension" ) => "eut-fade-in-left",
						esc_html__( "Fade In Right", "zuperla-extension" ) => "eut-fade-in-right",
						esc_html__( "Zoom In", "zuperla-extension" ) => "eut-zoom-in",
					),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "zuperla-extension" ),
					"std" => "eut-zoom-in",
				),
				zuperla_ext_vce_add_order_by(),
				zuperla_ext_vce_add_order(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "zuperla-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "zuperla_ext_multi_checkbox",
					"heading" => esc_html__( "Categories", "zuperla-extension" ),
					"param_name" => "categories",
					"value" => zuperla_ext_vce_get_post_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "zuperla-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_blog_leader', 'zuperla_ext_vce_blog_leader_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_blog_leader_shortcode_params( 'zuperla_blog_leader' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
