<?php
/*
*	Admin Functions
*
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function zuperla_ext_admin_menu(){
	if ( current_user_can( 'edit_theme_options' ) ) {
		if ( function_exists( 'zuperla_eutf_info') ) {
			add_submenu_page( 'zuperla', esc_html__('Custom Codes','zuperla-extension'), esc_html__('Custom Codes','zuperla-extension'), 'edit_theme_options', 'zuperla-codes', 'zuperla_ext_admin_page_html_codes' );
		} else {
			add_menu_page( 'Zuperla', 'Zuperla', 'edit_theme_options', 'zuperla', 'zuperla_ext_admin_page_html_codes', ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/images/adminmenu/theme.png', 4 );
			add_submenu_page( 'zuperla', esc_html__('Custom Codes','zuperla-extension'), esc_html__('Custom Codes','zuperla-extension'), 'edit_theme_options', 'zuperla-codes', 'zuperla_ext_admin_page_html_codes' );
		}
	}
}
add_action( 'admin_menu', 'zuperla_ext_admin_menu', 11 );


function zuperla_ext_admin_page_html_codes(){
	require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/admin/zuperla-ext-admin-page-codes.php';
}

function zuperla_ext_admin_links( $active_tab = 'status' ){
?>
	<a href="?page=zuperla-codes" class="nav-tab <?php echo 'codes' == $active_tab ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Custom Codes','zuperla-extension'); ?></a>
<?php
}
add_action( 'zuperla_eutf_admin_links', 'zuperla_ext_admin_links' );

function zuperla_ext_add_settings() {

	if ( isset( $_POST['_zuperla_ext_options_nonce_save'] ) && wp_verify_nonce( $_POST['_zuperla_ext_options_nonce_save'], 'zuperla_ext_options_nonce_save' ) ) {

		if ( isset( $_POST['zuperla_eutf_ext_options'] ) ) {
			$options = get_option('zuperla_eutf_ext_options');

			$keys = array_keys( $_POST['zuperla_eutf_ext_options'] );
			foreach ( $keys as $key ) {
				if ( isset( $_POST['zuperla_eutf_ext_options'][$key] ) ) {
					$options[$key] = $_POST['zuperla_eutf_ext_options'][$key];
				}
			}
			if ( empty( $options ) ) {
				delete_option( 'zuperla_eutf_ext_options' );
			} else {
				update_option( 'zuperla_eutf_ext_options', $options );
			}
		}
		wp_safe_redirect( 'admin.php?page=zuperla-codes&ext-settings=saved' );
	}
}
add_action( 'admin_menu', 'zuperla_ext_add_settings' );



if ( !function_exists('zuperla_ext_print_head_code') ) {
	function zuperla_ext_print_head_code() {
		$options = get_option('zuperla_eutf_ext_options');
		$code = zuperla_ext_vce_array_value( $options, 'head_code' );
		if ( !empty( $code ) ) {
			echo wp_unslash( $code );
		}
	}
}
add_action('wp_head', 'zuperla_ext_print_head_code');

if ( !function_exists('zuperla_ext_print_body_code') ) {
	function zuperla_ext_print_body_code() {
		$options = get_option('zuperla_eutf_ext_options');
		$code = zuperla_ext_vce_array_value( $options, 'body_code' );
		if ( !empty( $code ) ) {
			echo wp_unslash( $code );
		}
	}
}
add_action('zuperla_eutf_body_top', 'zuperla_ext_print_body_code');


if ( !function_exists('zuperla_ext_print_footer_code') ) {
	function zuperla_ext_print_footer_code() {
		$options = get_option('zuperla_eutf_ext_options');
		$code = zuperla_ext_vce_array_value( $options, 'footer_code' );
		if ( !empty( $code ) ) {
			echo wp_unslash( $code );
		}
	}
}
add_action('wp_footer', 'zuperla_ext_print_footer_code');

//Omit closing PHP tag to avoid accidental whitespace output errors.
