/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-02-01 10:12:12 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=1031 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5560 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=6540 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Un commentateur ou commentatrice WordPress", "wapuu@wordpress.example", "https://fr.wordpress.org/", "", "2023-01-23 10:46:37", "2023-01-23 09:46:37", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://fr.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "17", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 08:28:14", "2017-07-22 08:28:14", "<strong>Ex omnis sanctus corrumpit vim,</strong> aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "17", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 08:28:39", "2017-07-22 08:28:39", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. <em>Nec ea eros percipit maluisset</em>, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "23", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:48:02", "2017-07-22 07:48:02", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones.. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "23", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:48:25", "2017-07-22 07:48:25", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.\n<code>\n.eut-line {\n    position: relative;\n    overflow: hidden;\n    padding: 0;\n}</code>", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "27", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:46:10", "2017-07-22 07:46:10", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. <del>Eu cum oblique adversarium definitiones..</del> Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "27", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:47:06", "2017-07-22 07:47:06", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. <strong>Cum partem denique an, mei an soleat postea tamquam,</strong> nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones.. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.\n\nEx omnis sanctus corrumpit vim, aeque legere possim mel ne. <em>Cum partem denique an, mei an soleat postea tamquam</em>, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones.. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "30", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:45:02", "2017-07-22 07:45:02", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. <del>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</del> Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "30", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:45:28", "2017-07-22 07:45:28", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. <strong>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</strong> Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "40", "Euthemians", "aaa@bbb.com", "", "85.75.31.216", "2015-06-21 13:47:32", "2015-06-21 13:47:32", "<strong>Ex omnis sanctus corrumpit vim,</strong> aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "40", "Alex Smith", "abc@def.com", "", "85.75.31.216", "2015-06-21 13:49:01", "2015-06-21 13:49:01", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. <del>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</del> Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "40", "Euthemians", "aaa@bbb.com", "", "85.75.31.216", "2015-06-21 13:50:31", "2015-06-21 13:50:31", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.\n<code>\n.eut-line {\n    position: relative;\n    overflow: hidden;\n    padding: 0;\n}</code>", "0", "1", "", "comment", "11", "0");
INSERT INTO `wp_comments` VALUES("13", "40", "Alex Smith", "abc@zzz.com", "", "85.75.31.216", "2015-06-21 13:51:43", "2015-06-21 13:51:43", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne.<del>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</del>Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "43", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:42:51", "2017-07-22 07:42:51", "<strong>Ex omnis sanctus corrumpit vim,</strong> aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "43", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:43:12", "2017-07-22 07:43:12", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.\n<code>\n.eut-line {\n    position: relative;\n    overflow: hidden;\n    padding: 0;\n}</code>", "0", "1", "", "comment", "14", "0");
INSERT INTO `wp_comments` VALUES("16", "43", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:44:36", "2017-07-22 07:44:36", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. <del>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</del> Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "390", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 08:05:00", "2017-07-22 08:05:00", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. <del>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</del> Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "390", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 08:05:24", "2017-07-22 08:05:24", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.\n<code>\n.eut-line {\n    position: relative;\n    overflow: hidden;\n    padding: 0;\n}</code>", "0", "1", "", "comment", "17", "0");
INSERT INTO `wp_comments` VALUES("19", "6354", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:40:47", "2017-07-22 07:40:47", "<strong>Ex omnis sanctus corrumpit vim,</strong> aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "6359", "Euthemians", "aaa@bbb.com", "", "85.75.31.216", "2015-06-21 13:47:32", "2015-06-21 13:47:32", "<strong>Ex omnis sanctus corrumpit vim,</strong> aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "6359", "Alex Smith", "abc@def.com", "", "85.75.31.216", "2015-06-21 13:49:01", "2015-06-21 13:49:01", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. <del>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</del> Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "6359", "Euthemians", "aaa@bbb.com", "", "85.75.31.216", "2015-06-21 13:50:31", "2015-06-21 13:50:31", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.\n<code>\n.eut-line {\n    position: relative;\n    overflow: hidden;\n    padding: 0;\n}</code>", "0", "1", "", "comment", "21", "0");
INSERT INTO `wp_comments` VALUES("23", "6359", "Alex Smith", "abc@euthemians.com", "", "85.75.31.216", "2015-06-21 13:51:43", "2015-06-21 13:51:43", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne.<del>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</del>Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "6361", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:39:13", "2017-07-22 07:39:13", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne.<del>Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea.</del>Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("25", "6361", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:39:53", "2017-07-22 07:39:53", "Ex omnis sanctus corrumpit vim, aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.\n<code>\n.eut-line {\n    position: relative;\n    overflow: hidden;\n    padding: 0;\n}</code>", "0", "1", "", "comment", "24", "0");
INSERT INTO `wp_comments` VALUES("26", "6361", "Euthemians", "bbb@euthemians.com", "", "2a02:587:3a1d:3800:6143:7368:c2c:f4ba", "2017-07-22 07:40:17", "2017-07-22 07:40:17", "<strong>Ex omnis sanctus corrumpit vim,</strong> aeque legere possim mel ne. Cum partem denique an, mei an soleat postea tamquam, nam tritani dissentiet ea. Ut esse minim quodsi eum, est partem utroque splendide ut. Eu cum oblique adversarium definitiones. Nec ea eros percipit maluisset, et elit nominavi salutatus eam, an ius saepe commodo principes. Eu nonumy senserit duo.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20230201_prime", "a968dd1fa2dc414c8979_20230201101154", "21", "2023-02-01 10:12:12", "prime2", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-02-01 10:11:54\";s:7:\"Version\";s:5:\"1.5.2\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.4.21\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:14:\"20230201_prime\";s:4:\"Hash\";s:35:\"a968dd1fa2dc414c8979_20230201101154\";s:8:\"NameHash\";s:50:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:60:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.8\";s:6:\"WPUser\";s:6:\"prime2\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:62:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:32:\"/Applications/MAMP/htdocs/prime2\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1092;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11150;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-02-01 10:11:54\";s:7:\"Version\";s:5:\"1.5.2\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.4.21\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"20230201_prime\";s:4:\"Hash\";s:35:\"a968dd1fa2dc414c8979_20230201101154\";s:8:\"NameHash\";s:50:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:68:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:1;s:14:\"OptsSecurePass\";s:8:\"cHJpbWUy\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:46:\"/Applications/MAMP/htdocs/prime2/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:63:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:128:\"/Applications/MAMP/htdocs/prime2/wp-content/backups-dup-lite/tmp/20230201_prime_a968dd1fa2dc414c8979_20230201101154_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:41:\"/Applications/MAMP/htdocs/prime2/wp-admin\";i:1;s:44:\"/Applications/MAMP/htdocs/prime2/wp-includes\";i:2;s:53:\"/Applications/MAMP/htdocs/prime2/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:32:\"/Applications/MAMP/htdocs/prime2\";i:1;s:32:\"/Applications/MAMP/htdocs/prime2\";i:2;s:43:\"/Applications/MAMP/htdocs/prime2/wp-content\";i:3;s:51:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads\";i:4;s:51:\"/Applications/MAMP/htdocs/prime2/wp-content/plugins\";i:5;s:54:\"/Applications/MAMP/htdocs/prime2/wp-content/mu-plugins\";i:6;s:50:\"/Applications/MAMP/htdocs/prime2/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:64:\"/Applications/MAMP/htdocs/prime2/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://localhost:8888/prime2", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://localhost:8888/prime2", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Prime", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Le service de gravure", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "fp@unbrindecampagne.fr", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G\\hi", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "d F Y G\\hi", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:178:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:56:\"portfolio_field/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio_field=$matches[1]&feed=$matches[2]\";s:51:\"portfolio_field/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio_field=$matches[1]&feed=$matches[2]\";s:32:\"portfolio_field/([^/]+)/embed/?$\";s:48:\"index.php?portfolio_field=$matches[1]&embed=true\";s:44:\"portfolio_field/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?portfolio_field=$matches[1]&paged=$matches[2]\";s:26:\"portfolio_field/([^/]+)/?$\";s:37:\"index.php?portfolio_field=$matches[1]\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"testimonial_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial_category=$matches[1]&feed=$matches[2]\";s:56:\"testimonial_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial_category=$matches[1]&feed=$matches[2]\";s:37:\"testimonial_category/([^/]+)/embed/?$\";s:53:\"index.php?testimonial_category=$matches[1]&embed=true\";s:49:\"testimonial_category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?testimonial_category=$matches[1]&paged=$matches[2]\";s:31:\"testimonial_category/([^/]+)/?$\";s:42:\"index.php?testimonial_category=$matches[1]\";s:37:\"area-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"area-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"area-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"area-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"area-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"area-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"area-item/([^/]+)/embed/?$\";s:42:\"index.php?area-item=$matches[1]&embed=true\";s:30:\"area-item/([^/]+)/trackback/?$\";s:36:\"index.php?area-item=$matches[1]&tb=1\";s:38:\"area-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?area-item=$matches[1]&paged=$matches[2]\";s:45:\"area-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?area-item=$matches[1]&cpage=$matches[2]\";s:34:\"area-item/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?area-item=$matches[1]&page=$matches[2]\";s:26:\"area-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"area-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"area-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"area-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"area-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"area-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=3642&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:7:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:31:\"envato-market/envato-market.php\";i:3;s:27:\"js_composer/js_composer.php\";i:4;s:23:\"revslider/revslider.php\";i:5;s:49:\"zuperla-dummy-importer/zuperla-dummy-importer.php\";i:6;s:39:\"zuperla-extension/zuperla-extension.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "zuperla", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "zuperla", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:278:\"Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "3642", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "6488", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1690019197", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fr_FR", "yes");
INSERT INTO `wp_options` VALUES("103", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"eut-default-sidebar\";a:0:{}s:28:\"eut-single-portfolio-sidebar\";a:0:{}s:20:\"eut-footer-1-sidebar\";a:1:{i:0;s:6:\"text-2\";}s:20:\"eut-footer-2-sidebar\";a:0:{}s:20:\"eut-footer-3-sidebar\";a:0:{}s:20:\"eut-footer-4-sidebar\";a:0:{}s:13:\"array_version\";i:3;s:34:\"zuperla_eutf_sidebar_595ca5b31bd95\";a:2:{i:0;s:19:\"eut-sticky-widget-2\";i:1;s:25:\"eut-widget-latest-posts-2\";}s:34:\"zuperla_eutf_sidebar_5973040faf968\";a:3:{i:0;s:19:\"eut-sticky-widget-3\";i:1;s:25:\"eut-widget-latest-posts-3\";i:2;s:19:\"eut-widget-social-2\";}s:34:\"zuperla_eutf_sidebar_59156adb12bf5\";a:1:{i:0;s:24:\"eut-widget-social-list-2\";}s:34:\"zuperla_eutf_sidebar_592be7efdf481\";a:3:{i:0;s:19:\"eut-sticky-widget-4\";i:1;s:25:\"eut-widget-latest-posts-4\";i:2;s:11:\"tag_cloud-2\";}s:34:\"zuperla_eutf_sidebar_595a3a0bf0220\";a:1:{i:0;s:10:\"nav_menu-2\";}s:34:\"zuperla_eutf_sidebar_595a3a1944102\";a:1:{i:0;s:10:\"nav_menu-3\";}s:34:\"zuperla_eutf_sidebar_595a3ac6f085d\";a:1:{i:0;s:24:\"eut-widget-social-list-3\";}}", "yes");
INSERT INTO `wp_options` VALUES("106", "cron", "a:7:{i:1675248397;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1675287997;a:4:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1675288078;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1675331197;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1675331347;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1675763197;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_tag_cloud", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_nav_menu", "a:3:{i:2;a:2:{s:5:\"title\";s:10:\"Who we are\";s:8:\"nav_menu\";i:71;}i:3;a:2:{s:5:\"title\";s:7:\"Support\";s:8:\"nav_menu\";i:70;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("121", "https_detection_errors", "a:1:{s:20:\"https_request_failed\";a:1:{i:0;s:28:\"La demande HTTPS a échoué.\";}}", "yes");
INSERT INTO `wp_options` VALUES("127", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1674467470;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("136", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("137", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("148", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("151", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"fp@unbrindecampagne.fr\";s:7:\"version\";s:5:\"6.1.1\";s:9:\"timestamp\";i:1674467218;}", "no");
INSERT INTO `wp_options` VALUES("164", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("166", "current_theme", "Zuperla", "yes");
INSERT INTO `wp_options` VALUES("167", "theme_mods_zuperla", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:18:\"zuperla_header_nav\";i:16;}s:18:\"custom_css_post_id\";i:-1;s:20:\"zuperla_eutf_options\";a:18:{s:26:\"body_text_link_hover_color\";s:7:\"#f4cd1d\";s:20:\"body_primary_1_color\";s:7:\"#f4cd1d\";s:20:\"body_primary_2_color\";s:7:\"#f4cd1d\";s:20:\"body_primary_4_color\";s:7:\"#f4cd1d\";s:20:\"body_primary_5_color\";s:7:\"#f4cd1d\";s:18:\"top_bar_font_color\";s:7:\"#f4cd1d\";s:18:\"top_bar_link_color\";s:7:\"#f4cd1d\";s:19:\"top_bar_hover_color\";s:7:\"#f4cd1d\";s:23:\"page_title_color_custom\";s:7:\"#f4cd1d\";s:32:\"responsive_menu_link_hover_color\";s:7:\"#f4cd1d\";s:36:\"default_header_menu_text_hover_color\";s:7:\"#f4cd1d\";s:36:\"default_header_menu_type_color_hover\";s:7:\"#f4cd1d\";s:39:\"default_header_submenu_text_hover_color\";s:7:\"#f4cd1d\";s:30:\"default_header_menu_text_color\";s:7:\"#f4cd1d\";s:31:\"default_header_submenu_bg_color\";s:7:\"#000000\";s:42:\"default_header_submenu_text_bg_hover_color\";s:7:\"#110b0b\";s:18:\"body_heading_color\";s:7:\"#110000\";s:33:\"page_breadcrumbs_text_hover_color\";s:7:\"#f4cd1d\";}}", "yes");
INSERT INTO `wp_options` VALUES("168", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("169", "zuperla_eutf_theme_migration", "2.0", "yes");
INSERT INTO `wp_options` VALUES("170", "zuperla_eutf_theme_version", "2.3.10", "yes");
INSERT INTO `wp_options` VALUES("171", "zuperla_eutf_options", "a:862:{s:8:\"last_tab\";s:0:\"\";s:12:\"theme_layout\";s:9:\"stretched\";s:10:\"boxed_size\";s:4:\"1220\";s:10:\"frame_size\";s:2:\"30\";s:11:\"frame_color\";s:7:\"#ffffff\";s:14:\"container_size\";s:4:\"1390\";s:15:\"body_background\";a:7:{s:16:\"background-color\";s:7:\"#171A1D\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:18:\"content_background\";a:7:{s:16:\"background-color\";s:7:\"#ffffff\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:12:\"theme_loader\";s:1:\"0\";s:12:\"show_spinner\";s:1:\"1\";s:15:\"page_transition\";s:4:\"none\";s:18:\"replace_admin_logo\";s:1:\"1\";s:10:\"admin_logo\";a:5:{s:3:\"url\";s:109:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/cropped-PRIME_-_logo-removebg-preview-1-270x270-1.png\";s:2:\"id\";s:4:\"6492\";s:6:\"height\";s:3:\"270\";s:5:\"width\";s:3:\"270\";s:9:\"thumbnail\";s:117:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/cropped-PRIME_-_logo-removebg-preview-1-270x270-1-150x150.png\";}s:17:\"admin_logo_height\";s:2:\"84\";s:4:\"logo\";a:5:{s:3:\"url\";s:86:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/Prime-Monochrome-263x300-1.png\";s:2:\"id\";s:4:\"6531\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"263\";s:9:\"thumbnail\";s:94:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/Prime-Monochrome-263x300-1-150x150.png\";}s:10:\"logo_light\";a:5:{s:3:\"url\";s:91:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/PRIME_-_logo-removebg-preview-1.png\";s:2:\"id\";s:4:\"6528\";s:6:\"height\";s:3:\"533\";s:5:\"width\";s:3:\"468\";s:9:\"thumbnail\";s:99:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/PRIME_-_logo-removebg-preview-1-150x150.png\";}s:9:\"logo_dark\";a:5:{s:3:\"url\";s:86:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/Prime-Monochrome-263x300-1.png\";s:2:\"id\";s:4:\"6531\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"263\";s:9:\"thumbnail\";s:94:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/Prime-Monochrome-263x300-1-150x150.png\";}s:9:\"logo_side\";a:5:{s:3:\"url\";s:82:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/logo-inverse-259x300-1.png\";s:2:\"id\";s:4:\"6497\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"259\";s:9:\"thumbnail\";s:90:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/logo-inverse-259x300-1-150x150.png\";}s:11:\"logo_sticky\";a:5:{s:3:\"url\";s:86:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/Prime-Monochrome-263x300-1.png\";s:2:\"id\";s:4:\"6531\";s:6:\"height\";s:3:\"300\";s:5:\"width\";s:3:\"263\";s:9:\"thumbnail\";s:94:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/Prime-Monochrome-263x300-1-150x150.png\";}s:15:\"logo_responsive\";a:5:{s:3:\"url\";s:91:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/PRIME_-_logo-removebg-preview-1.png\";s:2:\"id\";s:4:\"6528\";s:6:\"height\";s:3:\"533\";s:5:\"width\";s:3:\"468\";s:9:\"thumbnail\";s:99:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/PRIME_-_logo-removebg-preview-1-150x150.png\";}s:15:\"top_bar_enabled\";s:1:\"0\";s:15:\"top_bar_spacing\";a:2:{s:11:\"padding-top\";s:4:\"15px\";s:14:\"padding-bottom\";s:4:\"15px\";}s:20:\"top_bar_section_type\";s:17:\"fullwidth-element\";s:20:\"top_bar_left_enabled\";s:1:\"0\";s:20:\"top_bar_left_options\";a:6:{s:4:\"menu\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"search\";s:0:\"\";s:8:\"language\";s:0:\"\";s:4:\"form\";s:0:\"\";s:6:\"social\";s:0:\"\";}s:17:\"top_bar_left_text\";s:0:\"\";s:22:\"top_bar_left_type_form\";s:12:\"contact-form\";s:17:\"top_bar_left_form\";s:0:\"\";s:27:\"top_bar_left_social_options\";a:31:{s:7:\"twitter\";s:7:\"Twitter\";s:8:\"facebook\";s:8:\"Facebook\";s:9:\"instagram\";s:9:\"Instagram\";s:8:\"linkedin\";s:8:\"LinkedIn\";s:6:\"tumblr\";s:6:\"Tumblr\";s:9:\"pinterest\";s:9:\"Pinterest\";s:6:\"github\";s:6:\"Github\";s:8:\"dribbble\";s:8:\"Dribbble\";s:6:\"reddit\";s:6:\"reddit\";s:6:\"flickr\";s:6:\"Flickr\";s:5:\"skype\";s:5:\"Skype\";s:7:\"youtube\";s:7:\"YouTube\";s:5:\"vimeo\";s:5:\"Vimeo\";s:10:\"soundcloud\";s:10:\"SoundCloud\";s:6:\"wechat\";s:6:\"WeChat\";s:5:\"weibo\";s:5:\"Weibo\";s:6:\"renren\";s:6:\"Renren\";s:2:\"qq\";s:2:\"QQ\";s:4:\"xing\";s:4:\"XING\";s:3:\"rss\";s:3:\"RSS\";s:2:\"vk\";s:2:\"VK\";s:7:\"behance\";s:7:\"Behance\";s:10:\"foursquare\";s:10:\"Foursquare\";s:5:\"steam\";s:5:\"Steam\";s:6:\"twitch\";s:6:\"Twitch\";s:5:\"houzz\";s:5:\"Houzz\";s:4:\"yelp\";s:4:\"Yelp\";s:8:\"snapchat\";s:8:\"Snapchat\";s:6:\"medium\";s:6:\"Medium\";s:11:\"tripadvisor\";s:11:\"TripAdvisor\";s:8:\"whatsapp\";s:0:\"\";}s:21:\"top_bar_right_enabled\";s:1:\"0\";s:21:\"top_bar_right_options\";a:6:{s:4:\"menu\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"search\";s:0:\"\";s:8:\"language\";s:0:\"\";s:4:\"form\";s:0:\"\";s:6:\"social\";s:0:\"\";}s:18:\"top_bar_right_text\";s:0:\"\";s:23:\"top_bar_right_type_form\";s:12:\"contact-form\";s:18:\"top_bar_right_form\";s:0:\"\";s:28:\"top_bar_right_social_options\";a:31:{s:7:\"twitter\";s:7:\"Twitter\";s:8:\"facebook\";s:8:\"Facebook\";s:9:\"instagram\";s:9:\"Instagram\";s:8:\"linkedin\";s:8:\"LinkedIn\";s:6:\"tumblr\";s:6:\"Tumblr\";s:9:\"pinterest\";s:9:\"Pinterest\";s:6:\"github\";s:6:\"Github\";s:8:\"dribbble\";s:8:\"Dribbble\";s:6:\"reddit\";s:6:\"reddit\";s:6:\"flickr\";s:6:\"Flickr\";s:5:\"skype\";s:5:\"Skype\";s:7:\"youtube\";s:7:\"YouTube\";s:5:\"vimeo\";s:5:\"Vimeo\";s:10:\"soundcloud\";s:10:\"SoundCloud\";s:6:\"wechat\";s:6:\"WeChat\";s:5:\"weibo\";s:5:\"Weibo\";s:6:\"renren\";s:6:\"Renren\";s:2:\"qq\";s:2:\"QQ\";s:4:\"xing\";s:4:\"XING\";s:3:\"rss\";s:3:\"RSS\";s:2:\"vk\";s:2:\"VK\";s:7:\"behance\";s:7:\"Behance\";s:10:\"foursquare\";s:10:\"Foursquare\";s:5:\"steam\";s:5:\"Steam\";s:6:\"twitch\";s:6:\"Twitch\";s:5:\"houzz\";s:5:\"Houzz\";s:4:\"yelp\";s:4:\"Yelp\";s:8:\"snapchat\";s:8:\"Snapchat\";s:6:\"medium\";s:6:\"Medium\";s:11:\"tripadvisor\";s:11:\"TripAdvisor\";s:8:\"whatsapp\";s:0:\"\";}s:11:\"header_mode\";s:7:\"default\";s:16:\"header_menu_mode\";s:7:\"default\";s:24:\"split_menu_item_position\";s:5:\"right\";s:13:\"header_height\";s:3:\"200\";s:17:\"header_side_width\";s:3:\"300\";s:19:\"header_side_spacing\";a:2:{s:13:\"padding-right\";s:4:\"30px\";s:12:\"padding-left\";s:4:\"30px\";}s:19:\"header_side_bg_mode\";s:5:\"color\";s:20:\"header_side_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:23:\"header_side_bg_position\";s:13:\"center-center\";s:27:\"header_side_pattern_overlay\";s:4:\"none\";s:25:\"header_side_color_overlay\";s:4:\"dark\";s:27:\"header_side_opacity_overlay\";s:1:\"0\";s:16:\"header_fullwidth\";s:1:\"0\";s:11:\"logo_height\";s:3:\"140\";s:22:\"header_top_logo_height\";s:2:\"18\";s:17:\"header_top_height\";s:3:\"180\";s:21:\"header_top_logo_align\";s:6:\"center\";s:23:\"header_side_logo_height\";s:2:\"36\";s:22:\"header_side_logo_align\";s:6:\"center\";s:24:\"header_side_logo_spacing\";a:3:{s:11:\"padding-top\";s:5:\"100px\";s:14:\"padding-bottom\";s:5:\"100px\";s:5:\"units\";s:2:\"px\";}s:9:\"menu_type\";s:7:\"classic\";s:10:\"menu_align\";s:5:\"right\";s:20:\"header_bottom_height\";s:2:\"60\";s:25:\"header_top_logo_menu_type\";s:7:\"classic\";s:21:\"header_top_menu_align\";s:6:\"center\";s:15:\"submenu_pointer\";s:5:\"arrow\";s:20:\"submenu_top_position\";s:3:\"100\";s:21:\"header_menu_open_type\";s:6:\"toggle\";s:22:\"header_side_menu_align\";s:6:\"center\";s:27:\"header_menu_options_enabled\";s:1:\"1\";s:19:\"header_menu_options\";a:5:{s:6:\"search\";s:0:\"\";s:4:\"form\";s:0:\"\";s:8:\"language\";s:0:\"\";s:4:\"cart\";s:0:\"\";s:6:\"social\";s:1:\"1\";}s:21:\"header_menu_type_form\";s:12:\"contact-form\";s:16:\"header_menu_form\";s:0:\"\";s:23:\"header_menu_social_mode\";s:6:\"single\";s:26:\"header_menu_social_options\";a:31:{s:7:\"twitter\";s:7:\"Twitter\";s:8:\"facebook\";s:8:\"Facebook\";s:9:\"instagram\";s:1:\"1\";s:8:\"linkedin\";s:1:\"1\";s:6:\"tumblr\";s:6:\"Tumblr\";s:9:\"pinterest\";s:9:\"Pinterest\";s:6:\"github\";s:6:\"Github\";s:8:\"dribbble\";s:8:\"Dribbble\";s:6:\"reddit\";s:6:\"reddit\";s:6:\"flickr\";s:6:\"Flickr\";s:5:\"skype\";s:5:\"Skype\";s:7:\"youtube\";s:7:\"YouTube\";s:5:\"vimeo\";s:5:\"Vimeo\";s:10:\"soundcloud\";s:10:\"SoundCloud\";s:6:\"wechat\";s:6:\"WeChat\";s:5:\"weibo\";s:5:\"Weibo\";s:6:\"renren\";s:6:\"Renren\";s:2:\"qq\";s:2:\"QQ\";s:4:\"xing\";s:4:\"XING\";s:3:\"rss\";s:3:\"RSS\";s:2:\"vk\";s:2:\"VK\";s:7:\"behance\";s:7:\"Behance\";s:10:\"foursquare\";s:10:\"Foursquare\";s:5:\"steam\";s:5:\"Steam\";s:6:\"twitch\";s:6:\"Twitch\";s:5:\"houzz\";s:5:\"Houzz\";s:4:\"yelp\";s:4:\"Yelp\";s:8:\"snapchat\";s:8:\"Snapchat\";s:6:\"medium\";s:6:\"Medium\";s:11:\"tripadvisor\";s:11:\"TripAdvisor\";s:8:\"whatsapp\";s:0:\"\";}s:21:\"header_sticky_enabled\";s:1:\"1\";s:18:\"header_sticky_type\";s:6:\"shrink\";s:27:\"header_sticky_shrink_height\";s:3:\"100\";s:32:\"header_sticky_shrink_logo_height\";s:2:\"50\";s:29:\"header_sticky_devices_enabled\";s:1:\"1\";s:27:\"responsive_header_threshold\";s:4:\"1024\";s:24:\"responsive_header_height\";s:2:\"70\";s:29:\"responsive_header_overlapping\";s:3:\"yes\";s:22:\"responsive_logo_height\";s:2:\"30\";s:32:\"menu_responsive_toggle_selection\";s:4:\"icon\";s:27:\"menu_responsive_toggle_text\";s:4:\"Menu\";s:25:\"menu_responsive_open_type\";s:5:\"slide\";s:21:\"menu_responsive_align\";s:4:\"left\";s:21:\"menu_responsive_width\";s:5:\"small\";s:20:\"menu_responsive_text\";s:0:\"\";s:13:\"sticky_footer\";s:1:\"1\";s:15:\"bottom_bar_area\";s:4:\"3092\";s:14:\"footer_bg_mode\";s:5:\"color\";s:15:\"footer_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"footer_bg_position\";s:13:\"center-center\";s:22:\"footer_pattern_overlay\";s:4:\"none\";s:20:\"footer_color_overlay\";s:4:\"dark\";s:22:\"footer_opacity_overlay\";s:1:\"0\";s:25:\"footer_widgets_visibility\";s:1:\"0\";s:21:\"footer_widgets_layout\";s:8:\"footer-1\";s:19:\"footer_section_type\";s:20:\"fullwidth-background\";s:29:\"footer_padding_top_multiplier\";s:2:\"3x\";s:32:\"footer_padding_bottom_multiplier\";s:2:\"3x\";s:21:\"footer_bar_visibility\";s:1:\"0\";s:23:\"footer_bar_section_type\";s:20:\"fullwidth-background\";s:23:\"footer_bar_align_center\";s:3:\"yes\";s:27:\"footer_copyright_visibility\";s:1:\"1\";s:21:\"footer_copyright_text\";s:189:\"<p>With <i class=\"eut-text-primary-1 fa fa-heart\"></i> by <a href=\"//themeforest.net/user/euthemians/portfolio\" target=\"_blank\" rel=\"noopener noreferrer\">Euthemians</a> - Premium Themes</p>\";s:22:\"second_area_visibility\";s:1:\"1\";s:28:\"footer_second_copyright_text\";s:0:\"\";s:21:\"footer_social_display\";s:4:\"text\";s:21:\"footer_social_options\";a:31:{s:7:\"twitter\";s:7:\"Twitter\";s:8:\"facebook\";s:8:\"Facebook\";s:9:\"instagram\";s:9:\"Instagram\";s:8:\"linkedin\";s:8:\"LinkedIn\";s:6:\"tumblr\";s:6:\"Tumblr\";s:9:\"pinterest\";s:9:\"Pinterest\";s:6:\"github\";s:6:\"Github\";s:8:\"dribbble\";s:8:\"Dribbble\";s:6:\"reddit\";s:6:\"reddit\";s:6:\"flickr\";s:6:\"Flickr\";s:5:\"skype\";s:5:\"Skype\";s:7:\"youtube\";s:7:\"YouTube\";s:5:\"vimeo\";s:5:\"Vimeo\";s:10:\"soundcloud\";s:10:\"SoundCloud\";s:6:\"wechat\";s:6:\"WeChat\";s:5:\"weibo\";s:5:\"Weibo\";s:6:\"renren\";s:6:\"Renren\";s:2:\"qq\";s:2:\"QQ\";s:4:\"xing\";s:4:\"XING\";s:3:\"rss\";s:3:\"RSS\";s:2:\"vk\";s:2:\"VK\";s:7:\"behance\";s:7:\"Behance\";s:10:\"foursquare\";s:10:\"Foursquare\";s:5:\"steam\";s:5:\"Steam\";s:6:\"twitch\";s:6:\"Twitch\";s:5:\"houzz\";s:5:\"Houzz\";s:4:\"yelp\";s:4:\"Yelp\";s:8:\"snapchat\";s:8:\"Snapchat\";s:6:\"medium\";s:6:\"Medium\";s:11:\"tripadvisor\";s:11:\"TripAdvisor\";s:8:\"whatsapp\";s:0:\"\";}s:11:\"blog_layout\";s:5:\"right\";s:12:\"blog_sidebar\";s:19:\"eut-default-sidebar\";s:18:\"blog_fixed_sidebar\";s:2:\"no\";s:24:\"blog_sidearea_visibility\";s:2:\"no\";s:21:\"blog_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:9:\"blog_mode\";s:5:\"large\";s:17:\"blog_shadow_style\";s:11:\"shadow-mode\";s:15:\"blog_media_area\";s:1:\"1\";s:15:\"blog_image_mode\";s:20:\"landscape-large-wide\";s:20:\"blog_grid_image_mode\";s:9:\"landscape\";s:23:\"blog_masonry_image_mode\";s:6:\"medium\";s:15:\"blog_image_prio\";s:2:\"no\";s:25:\"blog_columns_large_screen\";s:1:\"3\";s:12:\"blog_columns\";s:1:\"3\";s:29:\"blog_columns_tablet_landscape\";s:1:\"2\";s:28:\"blog_columns_tablet_portrait\";s:1:\"2\";s:19:\"blog_columns_mobile\";s:1:\"1\";s:11:\"blog_gutter\";s:3:\"yes\";s:16:\"blog_gutter_size\";s:2:\"30\";s:14:\"blog_animation\";s:4:\"none\";s:16:\"blog_heading_tag\";s:4:\"auto\";s:12:\"blog_heading\";s:4:\"auto\";s:17:\"blog_item_spinner\";s:2:\"no\";s:25:\"blog_excerpt_length_small\";s:2:\"30\";s:17:\"blog_auto_excerpt\";s:1:\"0\";s:19:\"blog_excerpt_length\";s:2:\"55\";s:17:\"blog_excerpt_more\";s:1:\"1\";s:24:\"blog_comments_visibility\";s:1:\"1\";s:22:\"blog_author_visibility\";s:1:\"1\";s:20:\"blog_date_visibility\";s:1:\"1\";s:20:\"blog_like_visibility\";s:1:\"0\";s:26:\"blog_categories_visibility\";s:1:\"1\";s:17:\"blog_header_style\";s:5:\"light\";s:23:\"blog_header_overlapping\";s:3:\"yes\";s:10:\"blog_title\";s:9:\"sitetitle\";s:17:\"blog_custom_title\";s:0:\"\";s:23:\"blog_custom_description\";s:0:\"\";s:17:\"blog_title_height\";s:5:\"large\";s:21:\"blog_title_min_height\";s:3:\"200\";s:25:\"blog_title_container_size\";s:7:\"default\";s:23:\"blog_title_content_size\";s:5:\"large\";s:28:\"blog_title_content_alignment\";s:6:\"center\";s:27:\"blog_title_content_position\";s:13:\"center-center\";s:28:\"blog_title_content_animation\";s:10:\"fade-in-up\";s:18:\"blog_title_bg_mode\";s:5:\"color\";s:19:\"blog_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:22:\"blog_title_bg_position\";s:13:\"center-center\";s:26:\"blog_title_pattern_overlay\";s:4:\"none\";s:24:\"blog_title_color_overlay\";s:4:\"dark\";s:26:\"blog_title_opacity_overlay\";s:1:\"0\";s:27:\"post_padding_top_multiplier\";s:2:\"3x\";s:16:\"post_padding_top\";s:0:\"\";s:30:\"post_padding_bottom_multiplier\";s:2:\"3x\";s:19:\"post_padding_bottom\";s:0:\"\";s:11:\"post_layout\";s:4:\"none\";s:12:\"post_sidebar\";s:19:\"eut-default-sidebar\";s:18:\"post_fixed_sidebar\";s:2:\"no\";s:18:\"post_content_width\";s:0:\"\";s:24:\"post_sidearea_visibility\";s:2:\"no\";s:21:\"post_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:29:\"post_feature_image_visibility\";s:1:\"0\";s:19:\"post_tag_visibility\";s:1:\"1\";s:24:\"post_category_visibility\";s:1:\"1\";s:22:\"post_author_visibility\";s:1:\"0\";s:26:\"post_author_info_link_text\";s:16:\"All stories by :\";s:24:\"post_comments_visibility\";s:1:\"1\";s:17:\"post_header_style\";s:5:\"light\";s:23:\"post_header_overlapping\";s:3:\"yes\";s:16:\"post_title_style\";s:8:\"advanced\";s:17:\"post_title_height\";s:2:\"80\";s:21:\"post_title_min_height\";s:3:\"200\";s:25:\"post_title_container_size\";s:7:\"default\";s:23:\"post_title_content_size\";s:6:\"medium\";s:28:\"post_title_content_alignment\";s:4:\"left\";s:27:\"post_title_content_position\";s:13:\"center-bottom\";s:28:\"post_title_content_animation\";s:10:\"fade-in-up\";s:18:\"post_title_bg_mode\";s:8:\"featured\";s:19:\"post_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:22:\"post_title_bg_position\";s:13:\"center-center\";s:26:\"post_title_pattern_overlay\";s:4:\"none\";s:24:\"post_title_color_overlay\";s:4:\"dark\";s:26:\"post_title_opacity_overlay\";s:4:\"0.70\";s:23:\"post_anchor_menu_height\";s:2:\"60\";s:26:\"post_anchor_menu_alignment\";s:4:\"left\";s:26:\"post_anchor_menu_fullwidth\";s:1:\"0\";s:24:\"post_breadcrumbs_enabled\";s:1:\"0\";s:23:\"post_breadcrumbs_height\";s:2:\"60\";s:26:\"post_breadcrumbs_alignment\";s:4:\"left\";s:26:\"post_breadcrumbs_fullwidth\";s:1:\"0\";s:11:\"post_social\";a:7:{s:5:\"email\";s:1:\"1\";s:7:\"twitter\";s:1:\"1\";s:8:\"facebook\";s:1:\"1\";s:8:\"linkedin\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:9:\"eut-likes\";s:1:\"1\";}s:23:\"post_related_visibility\";s:1:\"1\";s:24:\"post_related_title_first\";s:19:\"You might also like\";s:25:\"post_related_title_second\";s:0:\"\";s:19:\"post_nav_visibility\";s:1:\"1\";s:18:\"post_nav_same_term\";s:1:\"0\";s:16:\"post_backlink_id\";s:0:\"\";s:16:\"post_nav_spacing\";a:2:{s:11:\"padding-top\";s:4:\"60px\";s:14:\"padding-bottom\";s:4:\"60px\";}s:27:\"page_padding_top_multiplier\";s:4:\"none\";s:16:\"page_padding_top\";s:0:\"\";s:30:\"page_padding_bottom_multiplier\";s:4:\"none\";s:19:\"page_padding_bottom\";s:0:\"\";s:11:\"page_layout\";s:4:\"none\";s:12:\"page_sidebar\";s:19:\"eut-default-sidebar\";s:18:\"page_fixed_sidebar\";s:2:\"no\";s:24:\"page_sidearea_visibility\";s:2:\"no\";s:21:\"page_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:24:\"page_comments_visibility\";s:1:\"1\";s:17:\"page_header_style\";s:5:\"light\";s:23:\"page_header_overlapping\";s:3:\"yes\";s:17:\"page_title_height\";s:5:\"large\";s:21:\"page_title_min_height\";s:3:\"200\";s:25:\"page_title_container_size\";s:7:\"default\";s:23:\"page_title_content_size\";s:5:\"large\";s:28:\"page_title_content_alignment\";s:6:\"center\";s:27:\"page_title_content_position\";s:13:\"center-center\";s:28:\"page_title_content_animation\";s:10:\"fade-in-up\";s:18:\"page_title_bg_mode\";s:5:\"color\";s:19:\"page_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:22:\"page_title_bg_position\";s:13:\"center-center\";s:26:\"page_title_pattern_overlay\";s:4:\"none\";s:24:\"page_title_color_overlay\";s:4:\"dark\";s:26:\"page_title_opacity_overlay\";s:1:\"0\";s:23:\"page_anchor_menu_height\";s:2:\"60\";s:26:\"page_anchor_menu_alignment\";s:4:\"left\";s:26:\"page_anchor_menu_fullwidth\";s:1:\"0\";s:24:\"page_breadcrumbs_enabled\";s:1:\"0\";s:23:\"page_breadcrumbs_height\";s:2:\"60\";s:26:\"page_breadcrumbs_alignment\";s:4:\"left\";s:26:\"page_breadcrumbs_fullwidth\";s:1:\"0\";s:18:\"search_page_layout\";s:4:\"none\";s:19:\"search_page_sidebar\";s:19:\"eut-default-sidebar\";s:25:\"search_page_fixed_sidebar\";s:2:\"no\";s:24:\"search_page_header_style\";s:5:\"light\";s:30:\"search_page_header_overlapping\";s:3:\"yes\";s:24:\"search_page_title_height\";s:5:\"large\";s:28:\"search_page_title_min_height\";s:3:\"200\";s:32:\"search_page_title_container_size\";s:7:\"default\";s:30:\"search_page_title_content_size\";s:5:\"large\";s:35:\"search_page_title_content_alignment\";s:6:\"center\";s:34:\"search_page_title_content_position\";s:13:\"center-center\";s:35:\"search_page_title_content_animation\";s:10:\"fade-in-up\";s:25:\"search_page_title_bg_mode\";s:5:\"color\";s:26:\"search_page_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:29:\"search_page_title_bg_position\";s:13:\"center-center\";s:33:\"search_page_title_pattern_overlay\";s:4:\"none\";s:31:\"search_page_title_color_overlay\";s:4:\"dark\";s:33:\"search_page_title_opacity_overlay\";s:1:\"0\";s:16:\"search_page_mode\";s:7:\"masonry\";s:24:\"search_page_shadow_style\";s:11:\"shadow-mode\";s:22:\"search_page_show_image\";s:3:\"yes\";s:17:\"search_image_mode\";s:9:\"landscape\";s:25:\"search_masonry_image_mode\";s:6:\"medium\";s:32:\"search_page_columns_large_screen\";s:1:\"3\";s:19:\"search_page_columns\";s:1:\"3\";s:36:\"search_page_columns_tablet_landscape\";s:1:\"2\";s:35:\"search_page_columns_tablet_portrait\";s:1:\"2\";s:26:\"search_page_columns_mobile\";s:1:\"1\";s:23:\"search_page_heading_tag\";s:2:\"h4\";s:19:\"search_page_heading\";s:2:\"h4\";s:32:\"search_page_excerpt_length_small\";s:2:\"30\";s:24:\"search_page_excerpt_more\";s:1:\"1\";s:17:\"search_modal_text\";s:12:\"Start Typing\";s:24:\"search_modal_button_text\";s:15:\"Start Searching\";s:26:\"search_page_not_found_text\";s:174:\"<h3 class=\"eut-align-center eut-subtitle-text\">Maybe you should check again your spelling.</h3>\r\n<h3 class=\"eut-align-center\">This is not the page you are looking for...</h3>\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:32:\"portfolio_padding_top_multiplier\";s:4:\"none\";s:21:\"portfolio_padding_top\";s:0:\"\";s:35:\"portfolio_padding_bottom_multiplier\";s:4:\"none\";s:24:\"portfolio_padding_bottom\";s:0:\"\";s:16:\"portfolio_layout\";s:4:\"none\";s:17:\"portfolio_sidebar\";s:19:\"eut-default-sidebar\";s:23:\"portfolio_fixed_sidebar\";s:2:\"no\";s:29:\"portfolio_sidearea_visibility\";s:2:\"no\";s:26:\"portfolio_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:22:\"portfolio_details_text\";s:15:\"Project Details\";s:29:\"portfolio_details_heading_tag\";s:3:\"div\";s:27:\"portfolio_details_link_text\";s:12:\"View Project\";s:29:\"portfolio_comments_visibility\";s:1:\"0\";s:22:\"portfolio_header_style\";s:5:\"light\";s:28:\"portfolio_header_overlapping\";s:3:\"yes\";s:22:\"portfolio_title_height\";s:5:\"large\";s:26:\"portfolio_title_min_height\";s:3:\"200\";s:30:\"portfolio_title_container_size\";s:7:\"default\";s:28:\"portfolio_title_content_size\";s:5:\"large\";s:33:\"portfolio_title_content_alignment\";s:6:\"center\";s:32:\"portfolio_title_content_position\";s:13:\"center-center\";s:33:\"portfolio_title_content_animation\";s:7:\"fade-in\";s:23:\"portfolio_title_bg_mode\";s:5:\"color\";s:24:\"portfolio_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"portfolio_title_bg_position\";s:13:\"center-center\";s:31:\"portfolio_title_pattern_overlay\";s:4:\"none\";s:29:\"portfolio_title_color_overlay\";s:4:\"dark\";s:31:\"portfolio_title_opacity_overlay\";s:1:\"0\";s:28:\"portfolio_anchor_menu_height\";s:2:\"60\";s:31:\"portfolio_anchor_menu_alignment\";s:4:\"left\";s:31:\"portfolio_anchor_menu_fullwidth\";s:1:\"0\";s:29:\"portfolio_breadcrumbs_enabled\";s:1:\"0\";s:28:\"portfolio_breadcrumbs_height\";s:2:\"60\";s:31:\"portfolio_breadcrumbs_alignment\";s:4:\"left\";s:31:\"portfolio_breadcrumbs_fullwidth\";s:1:\"0\";s:27:\"portfolio_social_bar_layout\";s:8:\"layout-1\";s:16:\"portfolio_social\";a:8:{s:5:\"email\";s:0:\"\";s:7:\"twitter\";s:1:\"1\";s:8:\"facebook\";s:1:\"1\";s:8:\"linkedin\";s:0:\"\";s:9:\"pinterest\";s:1:\"1\";s:6:\"reddit\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:9:\"eut-likes\";s:1:\"1\";}s:28:\"portfolio_recents_visibility\";s:1:\"1\";s:22:\"portfolio_recent_title\";s:13:\"More Projects\";s:24:\"portfolio_nav_visibility\";s:1:\"1\";s:18:\"portfolio_nav_term\";s:4:\"none\";s:21:\"portfolio_backlink_id\";s:0:\"\";s:21:\"portfolio_nav_spacing\";a:2:{s:11:\"padding-top\";s:4:\"60px\";s:14:\"padding-bottom\";s:4:\"60px\";}s:18:\"product_tax_layout\";s:4:\"none\";s:19:\"product_tax_sidebar\";s:19:\"eut-default-sidebar\";s:25:\"product_tax_fixed_sidebar\";s:2:\"no\";s:31:\"product_tax_sidearea_visibility\";s:2:\"no\";s:28:\"product_tax_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:24:\"product_tax_header_style\";s:7:\"default\";s:30:\"product_tax_header_overlapping\";s:2:\"no\";s:24:\"product_tax_title_height\";s:2:\"60\";s:28:\"product_tax_title_min_height\";s:3:\"320\";s:32:\"product_tax_title_container_size\";s:7:\"default\";s:30:\"product_tax_title_content_size\";s:5:\"large\";s:35:\"product_tax_title_content_alignment\";s:6:\"center\";s:34:\"product_tax_title_content_position\";s:13:\"center-center\";s:35:\"product_tax_title_content_animation\";s:7:\"fade-in\";s:25:\"product_tax_title_bg_mode\";s:5:\"color\";s:26:\"product_tax_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:29:\"product_tax_title_bg_position\";s:13:\"center-center\";s:33:\"product_tax_title_pattern_overlay\";s:4:\"none\";s:31:\"product_tax_title_color_overlay\";s:4:\"dark\";s:33:\"product_tax_title_opacity_overlay\";s:1:\"0\";s:28:\"product_overview_hover_style\";s:13:\"hover-style-1\";s:29:\"product_overview_image_effect\";s:6:\"second\";s:34:\"product_overview_image_zoom_effect\";s:4:\"none\";s:27:\"product_overview_image_size\";s:7:\"default\";s:20:\"product_loop_columns\";s:1:\"4\";s:26:\"product_loop_shop_per_page\";s:2:\"12\";s:28:\"product_overview_heading_tag\";s:2:\"h3\";s:24:\"product_overview_heading\";s:2:\"h6\";s:30:\"product_overview_overlay_color\";s:5:\"light\";s:32:\"product_overview_overlay_opacity\";s:2:\"90\";s:28:\"product_woo_quantity_buttons\";s:1:\"1\";s:30:\"product_padding_top_multiplier\";s:2:\"3x\";s:19:\"product_padding_top\";s:0:\"\";s:33:\"product_padding_bottom_multiplier\";s:2:\"3x\";s:22:\"product_padding_bottom\";s:0:\"\";s:14:\"product_layout\";s:4:\"none\";s:15:\"product_sidebar\";s:19:\"eut-default-sidebar\";s:21:\"product_fixed_sidebar\";s:2:\"no\";s:27:\"product_sidearea_visibility\";s:2:\"no\";s:24:\"product_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:20:\"product_header_style\";s:7:\"default\";s:26:\"product_header_overlapping\";s:2:\"no\";s:19:\"product_title_style\";s:6:\"simple\";s:20:\"product_title_height\";s:2:\"60\";s:24:\"product_title_min_height\";s:3:\"200\";s:28:\"product_title_container_size\";s:7:\"default\";s:26:\"product_title_content_size\";s:5:\"large\";s:31:\"product_title_content_alignment\";s:6:\"center\";s:30:\"product_title_content_position\";s:13:\"center-center\";s:31:\"product_title_content_animation\";s:7:\"fade-in\";s:21:\"product_title_bg_mode\";s:5:\"color\";s:22:\"product_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"product_title_bg_position\";s:13:\"center-center\";s:29:\"product_title_pattern_overlay\";s:4:\"none\";s:27:\"product_title_color_overlay\";s:4:\"dark\";s:29:\"product_title_opacity_overlay\";s:1:\"0\";s:25:\"product_area_section_type\";s:20:\"fullwidth-background\";s:35:\"product_area_padding_top_multiplier\";s:2:\"3x\";s:38:\"product_area_padding_bottom_multiplier\";s:2:\"3x\";s:21:\"product_content_width\";s:0:\"\";s:26:\"product_anchor_menu_height\";s:2:\"60\";s:29:\"product_anchor_menu_alignment\";s:4:\"left\";s:29:\"product_anchor_menu_fullwidth\";s:1:\"0\";s:27:\"product_breadcrumbs_enabled\";s:1:\"0\";s:26:\"product_breadcrumbs_height\";s:2:\"60\";s:29:\"product_breadcrumbs_alignment\";s:4:\"left\";s:29:\"product_breadcrumbs_fullwidth\";s:1:\"0\";s:25:\"product_image_thumb_style\";s:5:\"theme\";s:20:\"product_image_effect\";s:4:\"zoom\";s:18:\"product_image_size\";s:7:\"default\";s:20:\"product_gallery_mode\";s:5:\"popup\";s:29:\"product_gallery_title_caption\";s:4:\"none\";s:20:\"product_image_middle\";s:1:\"1\";s:24:\"product_gallery_woo_zoom\";s:1:\"1\";s:28:\"product_gallery_woo_lightbox\";s:1:\"1\";s:26:\"product_gallery_woo_slider\";s:1:\"1\";s:14:\"product_social\";a:7:{s:5:\"email\";s:0:\"\";s:7:\"twitter\";s:0:\"\";s:8:\"facebook\";s:0:\"\";s:8:\"linkedin\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:9:\"eut-likes\";s:0:\"\";}s:22:\"product_nav_visibility\";s:1:\"1\";s:21:\"product_nav_same_term\";s:1:\"0\";s:19:\"product_backlink_id\";s:0:\"\";s:19:\"product_nav_spacing\";a:2:{s:11:\"padding-top\";s:4:\"60px\";s:14:\"padding-bottom\";s:4:\"60px\";}s:21:\"product_search_layout\";s:4:\"none\";s:22:\"product_search_sidebar\";s:19:\"eut-default-sidebar\";s:28:\"product_search_fixed_sidebar\";s:2:\"no\";s:16:\"event_tax_layout\";s:4:\"none\";s:17:\"event_tax_sidebar\";s:19:\"eut-default-sidebar\";s:23:\"event_tax_fixed_sidebar\";s:2:\"no\";s:29:\"event_tax_sidearea_visibility\";s:2:\"no\";s:26:\"event_tax_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:22:\"event_tax_header_style\";s:7:\"default\";s:28:\"event_tax_header_overlapping\";s:2:\"no\";s:22:\"event_tax_title_height\";s:2:\"60\";s:26:\"event_tax_title_min_height\";s:3:\"320\";s:30:\"event_tax_title_container_size\";s:7:\"default\";s:28:\"event_tax_title_content_size\";s:5:\"large\";s:33:\"event_tax_title_content_alignment\";s:6:\"center\";s:32:\"event_tax_title_content_position\";s:13:\"center-center\";s:33:\"event_tax_title_content_animation\";s:7:\"fade-in\";s:23:\"event_tax_title_bg_mode\";s:5:\"color\";s:24:\"event_tax_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"event_tax_title_bg_position\";s:13:\"center-center\";s:31:\"event_tax_title_pattern_overlay\";s:4:\"none\";s:29:\"event_tax_title_color_overlay\";s:4:\"dark\";s:31:\"event_tax_title_opacity_overlay\";s:1:\"0\";s:25:\"event_overview_image_size\";s:7:\"default\";s:22:\"event_overview_heading\";s:2:\"h2\";s:28:\"event_padding_top_multiplier\";s:2:\"3x\";s:17:\"event_padding_top\";s:0:\"\";s:31:\"event_padding_bottom_multiplier\";s:2:\"3x\";s:20:\"event_padding_bottom\";s:0:\"\";s:12:\"event_layout\";s:5:\"right\";s:13:\"event_sidebar\";s:19:\"eut-default-sidebar\";s:19:\"event_fixed_sidebar\";s:2:\"no\";s:25:\"event_sidearea_visibility\";s:2:\"no\";s:22:\"event_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:19:\"event_content_width\";s:0:\"\";s:18:\"event_header_style\";s:7:\"default\";s:24:\"event_header_overlapping\";s:2:\"no\";s:18:\"event_title_height\";s:2:\"60\";s:22:\"event_title_min_height\";s:3:\"200\";s:26:\"event_title_container_size\";s:7:\"default\";s:24:\"event_title_content_size\";s:5:\"large\";s:29:\"event_title_content_alignment\";s:6:\"center\";s:28:\"event_title_content_position\";s:13:\"center-center\";s:29:\"event_title_content_animation\";s:7:\"fade-in\";s:19:\"event_title_bg_mode\";s:5:\"color\";s:20:\"event_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:23:\"event_title_bg_position\";s:13:\"center-center\";s:27:\"event_title_pattern_overlay\";s:4:\"none\";s:25:\"event_title_color_overlay\";s:4:\"dark\";s:27:\"event_title_opacity_overlay\";s:1:\"0\";s:24:\"event_anchor_menu_height\";s:2:\"60\";s:27:\"event_anchor_menu_alignment\";s:4:\"left\";s:27:\"event_anchor_menu_fullwidth\";s:1:\"0\";s:25:\"event_breadcrumbs_enabled\";s:1:\"0\";s:24:\"event_breadcrumbs_height\";s:2:\"60\";s:27:\"event_breadcrumbs_alignment\";s:4:\"left\";s:27:\"event_breadcrumbs_fullwidth\";s:1:\"0\";s:16:\"event_image_size\";s:7:\"default\";s:20:\"event_nav_visibility\";s:1:\"1\";s:19:\"event_nav_same_term\";s:1:\"0\";s:17:\"event_nav_spacing\";a:2:{s:11:\"padding-top\";s:4:\"60px\";s:14:\"padding-bottom\";s:4:\"60px\";}s:12:\"event_social\";a:7:{s:5:\"email\";s:0:\"\";s:7:\"twitter\";s:0:\"\";s:8:\"facebook\";s:0:\"\";s:8:\"linkedin\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:9:\"eut-likes\";s:0:\"\";}s:12:\"forum_layout\";s:4:\"none\";s:13:\"forum_sidebar\";s:19:\"eut-default-sidebar\";s:19:\"forum_fixed_sidebar\";s:2:\"no\";s:25:\"forum_sidearea_visibility\";s:2:\"no\";s:22:\"forum_sidearea_sidebar\";s:19:\"eut-default-sidebar\";s:18:\"forum_header_style\";s:7:\"default\";s:24:\"forum_header_overlapping\";s:2:\"no\";s:18:\"forum_title_height\";s:2:\"60\";s:22:\"forum_title_min_height\";s:3:\"320\";s:26:\"forum_title_container_size\";s:7:\"default\";s:24:\"forum_title_content_size\";s:5:\"large\";s:29:\"forum_title_content_alignment\";s:6:\"center\";s:28:\"forum_title_content_position\";s:13:\"center-center\";s:29:\"forum_title_content_animation\";s:7:\"fade-in\";s:19:\"forum_title_bg_mode\";s:5:\"color\";s:20:\"forum_title_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:23:\"forum_title_bg_position\";s:13:\"center-center\";s:27:\"forum_title_pattern_overlay\";s:4:\"none\";s:25:\"forum_title_color_overlay\";s:4:\"dark\";s:27:\"forum_title_opacity_overlay\";s:1:\"0\";s:9:\"body_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:3:\"0px\";}s:16:\"single_post_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:9:\"logo_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"36px\";s:14:\"letter-spacing\";s:0:\"\";}s:14:\"main_menu_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"16px\";s:14:\"letter-spacing\";s:0:\"\";}s:13:\"sub_menu_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"12px\";s:14:\"letter-spacing\";s:0:\"\";}s:21:\"description_menu_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"11px\";s:14:\"letter-spacing\";s:0:\"\";}s:16:\"hidden_menu_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"16px\";s:14:\"letter-spacing\";s:0:\"\";}s:20:\"sub_hidden_menu_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"12px\";s:14:\"letter-spacing\";s:0:\"\";}s:28:\"description_hidden_menu_font\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"11px\";s:14:\"letter-spacing\";s:0:\"\";}s:7:\"h1_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"54px\";s:14:\"letter-spacing\";s:0:\"\";}s:7:\"h2_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"42px\";s:11:\"line-height\";s:4:\"48px\";s:14:\"letter-spacing\";s:0:\"\";}s:7:\"h3_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"36px\";s:11:\"line-height\";s:4:\"42px\";s:14:\"letter-spacing\";s:0:\"\";}s:7:\"h4_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"30px\";s:11:\"line-height\";s:4:\"36px\";s:14:\"letter-spacing\";s:0:\"\";}s:7:\"h5_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"200\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:7:\"h6_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:4:\"24px\";s:14:\"letter-spacing\";s:0:\"\";}s:10:\"page_title\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"54px\";s:14:\"letter-spacing\";s:0:\"\";}s:16:\"page_description\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:17:\"post_simple_title\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"36px\";s:11:\"line-height\";s:4:\"42px\";s:14:\"letter-spacing\";s:0:\"\";}s:10:\"post_title\";a:10:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"72px\";s:11:\"line-height\";s:4:\"78px\";s:14:\"letter-spacing\";s:0:\"\";}s:15:\"post_title_desc\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:15:\"post_title_meta\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"10px\";s:11:\"line-height\";s:4:\"14px\";s:14:\"letter-spacing\";s:3:\"1px\";}s:21:\"post_title_extra_meta\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"10px\";s:11:\"line-height\";s:4:\"14px\";s:14:\"letter-spacing\";s:3:\"1px\";}s:15:\"portfolio_title\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"54px\";s:14:\"letter-spacing\";s:0:\"\";}s:21:\"portfolio_description\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:11:\"forum_title\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"54px\";s:14:\"letter-spacing\";s:0:\"\";}s:20:\"product_simple_title\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"36px\";s:11:\"line-height\";s:4:\"42px\";s:14:\"letter-spacing\";s:0:\"\";}s:25:\"product_short_description\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:17:\"product_tax_title\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"54px\";s:14:\"letter-spacing\";s:0:\"\";}s:23:\"product_tax_description\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:15:\"event_tax_title\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"54px\";s:14:\"letter-spacing\";s:0:\"\";}s:21:\"event_tax_description\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:30:\"feature_subheading_custom_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"10px\";s:11:\"line-height\";s:4:\"14px\";s:14:\"letter-spacing\";s:3:\"1px\";}s:25:\"feature_title_custom_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"54px\";s:14:\"letter-spacing\";s:0:\"\";}s:24:\"feature_desc_custom_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:0:\"\";}s:28:\"feature_subheading_full_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"16px\";s:14:\"letter-spacing\";s:3:\"1px\";}s:23:\"feature_title_full_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"72px\";s:11:\"line-height\";s:4:\"78px\";s:14:\"letter-spacing\";s:0:\"\";}s:22:\"feature_desc_full_font\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"30px\";s:11:\"line-height\";s:4:\"36px\";s:14:\"letter-spacing\";s:0:\"\";}s:12:\"widget_title\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"30px\";s:14:\"letter-spacing\";s:3:\"1px\";}s:11:\"widget_text\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"28px\";s:14:\"letter-spacing\";s:0:\"\";}s:11:\"leader_text\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"36px\";s:14:\"letter-spacing\";s:0:\"\";}s:13:\"subtitle_text\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"10px\";s:11:\"line-height\";s:4:\"14px\";s:14:\"letter-spacing\";s:3:\"1px\";}s:10:\"small_text\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"10px\";s:14:\"letter-spacing\";s:3:\"1px\";}s:9:\"link_text\";a:9:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:4:\"10px\";s:14:\"letter-spacing\";s:3:\"1px\";}s:15:\"pagination_text\";a:10:{s:11:\"font-family\";s:11:\"Nunito Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:4:\"36px\";s:11:\"line-height\";s:4:\"42px\";s:14:\"letter-spacing\";s:0:\"\";}s:20:\"custom_font_family_1\";a:8:{s:11:\"font-family\";s:15:\"Source Sans Pro\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:14:\"letter-spacing\";s:0:\"\";}s:20:\"custom_font_family_2\";a:8:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:14:\"letter-spacing\";s:0:\"\";}s:20:\"custom_font_family_3\";a:8:{s:11:\"font-family\";s:9:\"Rock Salt\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:5:\"latin\";s:14:\"text-transform\";s:4:\"none\";s:14:\"letter-spacing\";s:0:\"\";}s:20:\"custom_font_family_4\";a:8:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:14:\"letter-spacing\";s:0:\"\";}s:43:\"typography_small_desktop_threshold_headings\";s:2:\"20\";s:39:\"typography_small_desktop_ratio_headings\";s:1:\"1\";s:46:\"typography_tablet_landscape_threshold_headings\";s:2:\"20\";s:42:\"typography_tablet_landscape_ratio_headings\";s:3:\"0.9\";s:45:\"typography_tablet_portrait_threshold_headings\";s:2:\"20\";s:41:\"typography_tablet_portrait_ratio_headings\";s:3:\"0.8\";s:36:\"typography_mobile_threshold_headings\";s:2:\"20\";s:32:\"typography_mobile_ratio_headings\";s:3:\"0.7\";s:34:\"typography_small_desktop_threshold\";s:2:\"20\";s:30:\"typography_small_desktop_ratio\";s:3:\"0.7\";s:37:\"typography_tablet_landscape_threshold\";s:2:\"20\";s:33:\"typography_tablet_landscape_ratio\";s:3:\"0.8\";s:36:\"typography_tablet_portrait_threshold\";s:2:\"20\";s:32:\"typography_tablet_portrait_ratio\";s:4:\"0.85\";s:27:\"typography_mobile_threshold\";s:2:\"18\";s:23:\"typography_mobile_ratio\";s:3:\"0.5\";s:35:\"typography_small_desktop_threshold2\";s:2:\"14\";s:31:\"typography_small_desktop_ratio2\";s:3:\"0.8\";s:38:\"typography_tablet_landscape_threshold2\";s:2:\"14\";s:34:\"typography_tablet_landscape_ratio2\";s:3:\"0.9\";s:37:\"typography_tablet_portrait_threshold2\";s:2:\"14\";s:33:\"typography_tablet_portrait_ratio2\";s:3:\"0.8\";s:28:\"typography_mobile_threshold2\";s:2:\"13\";s:24:\"typography_mobile_ratio2\";s:3:\"0.8\";s:8:\"css_code\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:14:\"social_options\";a:31:{s:7:\"twitter\";s:0:\"\";s:8:\"facebook\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:8:\"linkedin\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:6:\"github\";s:0:\"\";s:8:\"dribbble\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:5:\"skype\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:10:\"soundcloud\";s:0:\"\";s:6:\"wechat\";s:0:\"\";s:5:\"weibo\";s:0:\"\";s:6:\"renren\";s:0:\"\";s:2:\"qq\";s:0:\"\";s:4:\"xing\";s:0:\"\";s:3:\"rss\";s:0:\"\";s:2:\"vk\";s:0:\"\";s:7:\"behance\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";s:5:\"steam\";s:0:\"\";s:6:\"twitch\";s:0:\"\";s:5:\"houzz\";s:0:\"\";s:4:\"yelp\";s:0:\"\";s:8:\"snapchat\";s:0:\"\";s:6:\"medium\";s:0:\"\";s:11:\"tripadvisor\";s:0:\"\";s:8:\"whatsapp\";s:0:\"\";}s:12:\"map_api_mode\";s:11:\"google-maps\";s:12:\"map_tile_url\";s:50:\"https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png\";s:23:\"map_tile_url_subdomains\";s:3:\"abc\";s:20:\"map_tile_attribution\";s:64:\"© <a href=\"//www.openstreetmap.org/copyright\">OpenStreetMap</a>\";s:12:\"gmap_api_key\";s:0:\"\";s:19:\"gmap_custom_enabled\";s:1:\"1\";s:16:\"gmap_custom_code\";s:0:\"\";s:16:\"gmap_water_color\";s:7:\"#ffffff\";s:20:\"gmap_landscape_color\";s:7:\"#f7f7f7\";s:14:\"gmap_poi_color\";s:7:\"#f7f7f7\";s:15:\"gmap_road_color\";s:7:\"#dddddd\";s:18:\"gmap_label_enabled\";s:1:\"0\";s:16:\"gmap_label_color\";s:7:\"#777777\";s:23:\"gmap_label_stroke_color\";s:7:\"#1a1a1a\";s:18:\"gmap_country_color\";s:7:\"#000000\";s:17:\"gmap_zoom_enabled\";s:1:\"0\";s:17:\"gmap_type_control\";s:1:\"0\";s:21:\"gmap_gesture_handling\";s:4:\"auto\";s:15:\"page_404_header\";s:1:\"0\";s:21:\"page_404_header_style\";s:4:\"dark\";s:27:\"page_404_header_overlapping\";s:3:\"yes\";s:22:\"404_content_background\";a:7:{s:16:\"background-color\";s:7:\"#ffffff\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:16:\"page_404_content\";s:185:\"<h3><em>404 ERROR</em></h3>\r\n<h1>Hey there mate!</h1>\r\n<h2>Your lost treasure is not found here...</h2>\r\n<p class=\"eut-leader-text\">Sorry! The page you are looking for wasn\'t found!</p>\";s:15:\"page_404_search\";s:1:\"0\";s:20:\"page_404_home_button\";s:1:\"1\";s:15:\"page_404_footer\";s:1:\"0\";s:26:\"feature_section_post_types\";a:2:{i:0;s:4:\"page\";i:1;s:9:\"portfolio\";}s:16:\"wp_gallery_popup\";s:1:\"0\";s:11:\"wp_tagcloud\";s:1:\"0\";s:20:\"logo_as_text_enabled\";s:1:\"0\";s:20:\"logo_custom_link_url\";s:0:\"\";s:23:\"menu_header_integration\";s:7:\"default\";s:19:\"sidebar_heading_tag\";s:3:\"div\";s:18:\"footer_heading_tag\";s:3:\"div\";s:25:\"disable_seo_page_analysis\";s:1:\"0\";s:13:\"spinner_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"placeholder_mode\";s:5:\"dummy\";s:17:\"device_animations\";s:1:\"0\";s:23:\"device_hover_single_tap\";s:1:\"0\";s:18:\"vc_grid_visibility\";s:1:\"0\";s:20:\"vc_charts_visibility\";s:1:\"0\";s:17:\"vc_woo_visibility\";s:1:\"0\";s:15:\"vc_auto_updater\";s:1:\"0\";s:11:\"button_type\";s:6:\"simple\";s:12:\"button_shape\";s:11:\"extra-round\";s:12:\"button_color\";s:5:\"black\";s:18:\"button_hover_color\";s:4:\"grey\";s:19:\"back_to_top_enabled\";s:1:\"1\";s:17:\"back_to_top_shape\";s:6:\"circle\";s:24:\"meta_viewport_responsive\";s:1:\"1\";s:14:\"meta_opengraph\";s:1:\"0\";s:12:\"meta_twitter\";s:1:\"0\";s:19:\"coming_soon_enabled\";s:1:\"0\";s:20:\"coming_soon_template\";s:7:\"content\";s:16:\"coming_soon_page\";s:0:\"\";s:23:\"feature_section_bg_size\";s:10:\"responsive\";s:19:\"row_section_bg_size\";s:10:\"responsive\";s:32:\"privacy_content_blocking_enabled\";s:1:\"1\";s:21:\"privacy_initial_state\";a:4:{s:9:\"gtracking\";s:0:\"\";s:6:\"gfonts\";s:0:\"\";s:5:\"gmaps\";s:0:\"\";s:12:\"video-embeds\";s:0:\"\";}s:24:\"privacy_fallback_content\";s:64:\"This content is blocked. Please review your Privacy Preferences.\";s:44:\"privacy_fallback_preferences_link_visibility\";s:1:\"1\";s:40:\"privacy_fallback_content_link_visibility\";s:1:\"1\";s:27:\"privacy_consent_bar_enabled\";s:1:\"0\";s:28:\"privacy_consent_bar_position\";s:6:\"center\";s:27:\"privacy_consent_bar_content\";s:125:\"Our website uses cookies, mainly from 3rd party services. Define your Privacy Preferences and/or agree to our use of cookies.\";s:30:\"privacy_agreement_button_label\";s:7:\"I Agree\";s:32:\"privacy_preferences_button_label\";s:19:\"Privacy Preferences\";s:31:\"privacy_preferences_button_link\";s:5:\"modal\";s:28:\"privacy_preferences_link_url\";s:0:\"\";s:31:\"privacy_preferences_link_target\";s:5:\"_self\";s:29:\"privacy_consent_modal_content\";s:465:\"<h5>Privacy Preferences</h5>\r\n<p>When you visit our website, it may store information through your browser from specific services, usually in the form of cookies. Here you can change your Privacy preferences. It is worth noting that blocking some types of cookies may impact your experience on our website and the services we are able to offer.</p>\r\n<div>[zuperla_privacy_gtracking][zuperla_privacy_gfonts][zuperla_privacy_gmaps][zuperla_privacy_video_embeds]</div>\";s:28:\"privacy_refresh_button_label\";s:16:\"Save Preferences\";s:10:\"combine_js\";s:1:\"1\";s:16:\"top_bar_bg_color\";s:7:\"#ffffff\";s:18:\"top_bar_font_color\";s:7:\"#f4cd1d\";s:18:\"top_bar_link_color\";s:7:\"#f4cd1d\";s:19:\"top_bar_hover_color\";s:7:\"#f4cd1d\";s:31:\"default_header_background_color\";s:7:\"#ffffff\";s:39:\"default_header_background_color_opacity\";s:1:\"1\";s:27:\"default_header_border_color\";s:7:\"#000000\";s:35:\"default_header_border_color_opacity\";s:1:\"0\";s:30:\"default_header_menu_text_color\";s:7:\"#f4cd1d\";s:36:\"default_header_menu_text_hover_color\";s:7:\"#f4cd1d\";s:30:\"default_header_menu_type_color\";s:7:\"#eef1f6\";s:36:\"default_header_menu_type_color_hover\";s:7:\"#f4cd1d\";s:31:\"default_header_submenu_bg_color\";s:7:\"#000000\";s:33:\"default_header_submenu_text_color\";s:7:\"#777777\";s:39:\"default_header_submenu_text_hover_color\";s:7:\"#f4cd1d\";s:42:\"default_header_submenu_text_bg_hover_color\";s:7:\"#110b0b\";s:40:\"default_header_submenu_column_text_color\";s:7:\"#ffffff\";s:46:\"default_header_submenu_column_text_hover_color\";s:7:\"#ffffff\";s:35:\"default_header_submenu_border_color\";s:7:\"#333638\";s:29:\"default_header_label_bg_color\";s:7:\"#454545\";s:31:\"default_header_label_text_color\";s:7:\"#ffffff\";s:42:\"logo_top_header_logo_area_background_color\";s:7:\"#ffffff\";s:50:\"logo_top_header_logo_area_background_color_opacity\";s:1:\"1\";s:28:\"logo_top_header_border_color\";s:7:\"#000000\";s:36:\"logo_top_header_border_color_opacity\";s:4:\"0.10\";s:42:\"logo_top_header_menu_area_background_color\";s:7:\"#ffffff\";s:50:\"logo_top_header_menu_area_background_color_opacity\";s:1:\"1\";s:31:\"logo_top_header_menu_text_color\";s:7:\"#000000\";s:37:\"logo_top_header_menu_text_hover_color\";s:7:\"#1472DE\";s:31:\"logo_top_header_menu_type_color\";s:7:\"#eef1f6\";s:37:\"logo_top_header_menu_type_color_hover\";s:7:\"#1472DE\";s:32:\"logo_top_header_submenu_bg_color\";s:7:\"#ffffff\";s:34:\"logo_top_header_submenu_text_color\";s:7:\"#777777\";s:40:\"logo_top_header_submenu_text_hover_color\";s:7:\"#1472DE\";s:43:\"logo_top_header_submenu_text_bg_hover_color\";s:7:\"#ffffff\";s:41:\"logo_top_header_submenu_column_text_color\";s:7:\"#000000\";s:47:\"logo_top_header_submenu_column_text_hover_color\";s:7:\"#1472DE\";s:36:\"logo_top_header_submenu_border_color\";s:7:\"#eef1f6\";s:28:\"side_header_background_color\";s:7:\"#f7f7f7\";s:36:\"side_header_background_color_opacity\";s:1:\"1\";s:27:\"side_header_menu_text_color\";s:7:\"#000000\";s:33:\"side_header_menu_text_hover_color\";s:7:\"#1472DE\";s:30:\"side_header_submenu_text_color\";s:7:\"#000000\";s:36:\"side_header_submenu_text_hover_color\";s:7:\"#1472DE\";s:24:\"side_header_border_color\";s:7:\"#323232\";s:26:\"side_header_border_opacity\";s:4:\"0.10\";s:30:\"header_sticky_background_color\";s:7:\"#101215\";s:38:\"header_sticky_background_color_opacity\";s:1:\"1\";s:26:\"header_sticky_border_color\";s:7:\"#eef1f6\";s:34:\"header_sticky_border_color_opacity\";s:1:\"0\";s:22:\"sticky_menu_text_color\";s:7:\"#9c9c9c\";s:28:\"sticky_menu_text_hover_color\";s:7:\"#ffffff\";s:29:\"header_sticky_menu_type_color\";s:7:\"#eef1f6\";s:35:\"header_sticky_menu_type_color_hover\";s:7:\"#eef1f6\";s:27:\"light_menu_text_hover_color\";s:7:\"#ffffff\";s:27:\"light_menu_type_color_hover\";s:7:\"#eef1f6\";s:25:\"light_header_border_color\";s:7:\"#ffffff\";s:33:\"light_header_border_color_opacity\";s:1:\"0\";s:26:\"dark_menu_text_hover_color\";s:7:\"#000000\";s:26:\"dark_menu_type_color_hover\";s:7:\"#eef1f6\";s:24:\"dark_header_border_color\";s:7:\"#000000\";s:32:\"dark_header_border_color_opacity\";s:1:\"0\";s:34:\"responsive_header_background_color\";s:7:\"#ffffff\";s:36:\"responsive_header_background_opacity\";s:1:\"1\";s:32:\"responsive_header_elements_color\";s:7:\"#838383\";s:38:\"responsive_header_elements_hover_color\";s:7:\"#000000\";s:32:\"responsive_menu_background_color\";s:7:\"#ffffff\";s:26:\"responsive_menu_link_color\";s:7:\"#777777\";s:32:\"responsive_menu_link_hover_color\";s:7:\"#f4cd1d\";s:31:\"responsive_menu_close_btn_color\";s:7:\"#777777\";s:28:\"responsive_menu_border_color\";s:7:\"#eef1f6\";s:41:\"responsive_menu_overflow_background_color\";s:7:\"#000000\";s:49:\"responsive_menu_overflow_background_color_opacity\";s:4:\"0.90\";s:33:\"page_anchor_menu_background_color\";s:7:\"#171a1d\";s:27:\"page_anchor_menu_text_color\";s:7:\"#ffffff\";s:33:\"page_anchor_menu_text_hover_color\";s:7:\"#1472DE\";s:39:\"page_anchor_menu_background_hover_color\";s:7:\"#171a1d\";s:29:\"page_anchor_menu_border_color\";s:7:\"#333638\";s:18:\"body_heading_color\";s:7:\"#110000\";s:15:\"body_text_color\";s:7:\"#888888\";s:20:\"body_text_link_color\";s:7:\"#000000\";s:26:\"body_text_link_hover_color\";s:7:\"#f4cd1d\";s:17:\"body_border_color\";s:7:\"#e9e9e9\";s:18:\"widget_title_color\";s:7:\"#000000\";s:20:\"body_primary_1_color\";s:7:\"#f4cd1d\";s:20:\"body_primary_2_color\";s:7:\"#f4cd1d\";s:20:\"body_primary_3_color\";s:7:\"#fe3956\";s:20:\"body_primary_4_color\";s:7:\"#f4cd1d\";s:20:\"body_primary_5_color\";s:7:\"#f4cd1d\";s:20:\"body_primary_6_color\";s:7:\"#696969\";s:19:\"blog_title_bg_color\";s:9:\"primary-2\";s:26:\"blog_title_bg_color_custom\";s:7:\"#f7f7f7\";s:27:\"blog_title_content_bg_color\";s:4:\"none\";s:34:\"blog_title_content_bg_color_custom\";s:7:\"#ffffff\";s:16:\"blog_title_color\";s:5:\"light\";s:23:\"blog_title_color_custom\";s:7:\"#000000\";s:22:\"blog_description_color\";s:5:\"light\";s:29:\"blog_description_color_custom\";s:7:\"#9B9B9B\";s:19:\"post_title_bg_color\";s:4:\"dark\";s:26:\"post_title_bg_color_custom\";s:7:\"#f7f7f7\";s:27:\"post_title_content_bg_color\";s:4:\"none\";s:34:\"post_title_content_bg_color_custom\";s:7:\"#ffffff\";s:21:\"post_subheading_color\";s:5:\"light\";s:28:\"post_subheading_color_custom\";s:7:\"#ffffff\";s:16:\"post_title_color\";s:5:\"light\";s:23:\"post_title_color_custom\";s:7:\"#000000\";s:22:\"post_description_color\";s:5:\"light\";s:29:\"post_description_color_custom\";s:7:\"#9B9B9B\";s:25:\"post_bar_background_color\";s:7:\"#f9f9f9\";s:24:\"post_bar_nav_title_color\";s:7:\"#9b9b9b\";s:20:\"post_bar_arrow_color\";s:7:\"#000000\";s:19:\"page_title_bg_color\";s:9:\"primary-1\";s:26:\"page_title_bg_color_custom\";s:7:\"#f7f7f7\";s:27:\"page_title_content_bg_color\";s:4:\"none\";s:34:\"page_title_content_bg_color_custom\";s:7:\"#ffffff\";s:16:\"page_title_color\";s:5:\"light\";s:23:\"page_title_color_custom\";s:7:\"#f4cd1d\";s:22:\"page_description_color\";s:5:\"light\";s:29:\"page_description_color_custom\";s:7:\"#9B9B9B\";s:26:\"search_page_title_bg_color\";s:9:\"primary-2\";s:33:\"search_page_title_bg_color_custom\";s:7:\"#f7f7f7\";s:34:\"search_page_title_content_bg_color\";s:4:\"none\";s:41:\"search_page_title_content_bg_color_custom\";s:7:\"#ffffff\";s:23:\"search_page_title_color\";s:5:\"light\";s:30:\"search_page_title_color_custom\";s:7:\"#000000\";s:29:\"search_page_description_color\";s:5:\"light\";s:36:\"search_page_description_color_custom\";s:7:\"#9B9B9B\";s:24:\"portfolio_title_bg_color\";s:9:\"primary-2\";s:31:\"portfolio_title_bg_color_custom\";s:7:\"#f7f7f7\";s:32:\"portfolio_title_content_bg_color\";s:4:\"none\";s:39:\"portfolio_title_content_bg_color_custom\";s:7:\"#ffffff\";s:21:\"portfolio_title_color\";s:5:\"light\";s:28:\"portfolio_title_color_custom\";s:7:\"#000000\";s:27:\"portfolio_description_color\";s:5:\"light\";s:34:\"portfolio_description_color_custom\";s:7:\"#9B9B9B\";s:30:\"portfolio_bar_background_color\";s:7:\"#f9f9f9\";s:29:\"portfolio_bar_nav_title_color\";s:7:\"#9b9b9b\";s:25:\"portfolio_bar_arrow_color\";s:7:\"#000000\";s:26:\"product_tax_title_bg_color\";s:9:\"primary-2\";s:33:\"product_tax_title_bg_color_custom\";s:7:\"#000000\";s:34:\"product_tax_title_content_bg_color\";s:4:\"none\";s:41:\"product_tax_title_content_bg_color_custom\";s:7:\"#ffffff\";s:23:\"product_tax_title_color\";s:5:\"light\";s:30:\"product_tax_title_color_custom\";s:7:\"#ffffff\";s:29:\"product_tax_description_color\";s:5:\"light\";s:36:\"product_tax_description_color_custom\";s:7:\"#ffffff\";s:22:\"product_title_bg_color\";s:9:\"primary-2\";s:29:\"product_title_bg_color_custom\";s:7:\"#f7f7f7\";s:30:\"product_title_content_bg_color\";s:4:\"none\";s:37:\"product_title_content_bg_color_custom\";s:7:\"#ffffff\";s:19:\"product_title_color\";s:5:\"light\";s:26:\"product_title_color_custom\";s:7:\"#ffffff\";s:25:\"product_description_color\";s:5:\"light\";s:32:\"product_description_color_custom\";s:7:\"#9B9B9B\";s:21:\"product_area_bg_color\";s:7:\"#ffffff\";s:27:\"product_area_headings_color\";s:7:\"#000000\";s:23:\"product_area_font_color\";s:7:\"#999999\";s:23:\"product_area_link_color\";s:7:\"#FF7D88\";s:24:\"product_area_hover_color\";s:7:\"#000000\";s:25:\"product_area_border_color\";s:7:\"#e0e0e0\";s:25:\"product_area_button_color\";s:9:\"primary-1\";s:31:\"product_area_button_hover_color\";s:5:\"black\";s:28:\"product_bar_background_color\";s:7:\"#f9f9f9\";s:27:\"product_bar_nav_title_color\";s:7:\"#9b9b9b\";s:23:\"product_bar_arrow_color\";s:7:\"#000000\";s:24:\"event_tax_title_bg_color\";s:9:\"primary-2\";s:31:\"event_tax_title_bg_color_custom\";s:7:\"#f7f7f7\";s:32:\"event_tax_title_content_bg_color\";s:4:\"none\";s:39:\"event_tax_title_content_bg_color_custom\";s:7:\"#ffffff\";s:21:\"event_tax_title_color\";s:5:\"light\";s:28:\"event_tax_title_color_custom\";s:7:\"#000000\";s:27:\"event_tax_description_color\";s:5:\"light\";s:34:\"event_tax_description_color_custom\";s:7:\"#9B9B9B\";s:20:\"event_title_bg_color\";s:9:\"primary-2\";s:27:\"event_title_bg_color_custom\";s:7:\"#f7f7f7\";s:28:\"event_title_content_bg_color\";s:4:\"none\";s:35:\"event_title_content_bg_color_custom\";s:7:\"#ffffff\";s:17:\"event_title_color\";s:5:\"light\";s:24:\"event_title_color_custom\";s:7:\"#000000\";s:23:\"event_description_color\";s:5:\"light\";s:30:\"event_description_color_custom\";s:7:\"#9B9B9B\";s:26:\"event_bar_background_color\";s:7:\"#f9f9f9\";s:25:\"event_bar_nav_title_color\";s:7:\"#9b9b9b\";s:21:\"event_bar_arrow_color\";s:7:\"#000000\";s:20:\"forum_title_bg_color\";s:9:\"primary-2\";s:27:\"forum_title_bg_color_custom\";s:7:\"#000000\";s:28:\"forum_title_content_bg_color\";s:4:\"none\";s:35:\"forum_title_content_bg_color_custom\";s:7:\"#ffffff\";s:17:\"forum_title_color\";s:5:\"light\";s:24:\"forum_title_color_custom\";s:7:\"#ffffff\";s:23:\"footer_widgets_bg_color\";s:7:\"#1E1E1E\";s:29:\"footer_widgets_headings_color\";s:7:\"#ffffff\";s:25:\"footer_widgets_font_color\";s:7:\"#808080\";s:25:\"footer_widgets_link_color\";s:7:\"#808080\";s:26:\"footer_widgets_hover_color\";s:7:\"#ffffff\";s:27:\"footer_widgets_border_color\";s:7:\"#1E1E1E\";s:19:\"footer_bar_bg_color\";s:7:\"#1E1E1E\";s:27:\"footer_bar_bg_color_opacity\";s:1:\"1\";s:21:\"footer_bar_font_color\";s:7:\"#808080\";s:21:\"footer_bar_link_color\";s:7:\"#808080\";s:22:\"footer_bar_hover_color\";s:7:\"#ffffff\";s:33:\"page_breadcrumbs_background_color\";s:7:\"#ffffff\";s:27:\"page_breadcrumbs_text_color\";s:7:\"#6e6e6e\";s:33:\"page_breadcrumbs_text_hover_color\";s:7:\"#f4cd1d\";s:30:\"page_breadcrumbs_divider_color\";s:7:\"#b2b2b2\";s:29:\"page_breadcrumbs_border_color\";s:7:\"#e0e0e0\";s:29:\"sliding_area_background_color\";s:7:\"#ffffff\";s:24:\"sliding_area_title_color\";s:7:\"#000000\";s:23:\"sliding_area_text_color\";s:7:\"#808080\";s:23:\"sliding_area_link_color\";s:7:\"#808080\";s:29:\"sliding_area_link_hover_color\";s:7:\"#000000\";s:28:\"sliding_area_close_btn_color\";s:7:\"#808080\";s:25:\"sliding_area_border_color\";s:7:\"#e9e9e9\";s:38:\"sliding_area_overflow_background_color\";s:7:\"#000000\";s:46:\"sliding_area_overflow_background_color_opacity\";s:1:\"0\";s:17:\"modal_title_color\";s:7:\"#000000\";s:16:\"modal_text_color\";s:7:\"#777777\";s:24:\"modal_cursor_color_color\";s:4:\"dark\";s:18:\"modal_border_color\";s:7:\"#e9e9e9\";s:31:\"modal_overflow_background_color\";s:7:\"#ffffff\";s:39:\"modal_overflow_background_color_opacity\";s:1:\"1\";s:22:\"back_to_top_icon_color\";s:7:\"#ffffff\";s:23:\"back_to_top_shape_color\";s:7:\"#262829\";s:20:\"privacy_bar_bg_color\";s:7:\"#000000\";s:22:\"privacy_bar_bg_opacity\";s:4:\"0.90\";s:22:\"privacy_bar_text_color\";s:7:\"#ffffff\";s:29:\"privacy_bar_button_text_color\";s:7:\"#ffffff\";s:27:\"privacy_bar_button_bg_color\";s:7:\"#2bc137\";s:33:\"privacy_bar_button_bg_hover_color\";s:7:\"#17a523\";s:31:\"privacy_modal_button_text_color\";s:7:\"#ffffff\";s:29:\"privacy_modal_button_bg_color\";s:7:\"#2bc137\";s:35:\"privacy_modal_button_bg_hover_color\";s:7:\"#17a523\";s:25:\"top_bar_left_gravity_form\";s:0:\"\";s:26:\"top_bar_right_gravity_form\";s:0:\"\";s:24:\"header_menu_gravity_form\";s:0:\"\";s:11:\"skin_preset\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("172", "zuperla_eutf_options-transients", "a:2:{s:14:\"changed_values\";a:1:{s:11:\"logo_sticky\";a:5:{s:3:\"url\";s:91:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/PRIME_-_logo-removebg-preview-1.png\";s:2:\"id\";s:4:\"6528\";s:6:\"height\";s:3:\"533\";s:5:\"width\";s:3:\"468\";s:9:\"thumbnail\";s:99:\"http://localhost:8888/prime2/wp-content/uploads/2023/01/PRIME_-_logo-removebg-preview-1-150x150.png\";}}s:9:\"last_save\";i:1675173005;}", "yes");
INSERT INTO `wp_options` VALUES("173", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("174", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("175", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"120\";s:6:\"height\";s:3:\"120\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("179", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.7.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1674467681;s:7:\"version\";s:5:\"5.7.2\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("180", "envato_market", "a:2:{s:16:\"is_plugin_active\";s:1:\"1\";s:17:\"installed_version\";s:5:\"2.0.7\";}", "yes");
INSERT INTO `wp_options` VALUES("181", "revslider_servers", "a:7:{i:0;s:22:\"themepunch-ext-c.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:16:\"themepunch.tools\";i:4;s:22:\"themepunch-ext-a.tools\";i:5;s:22:\"themepunch-ext-b.tools\";i:6;s:16:\"themepunch.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("182", "revslider_server_refresh", "1674467681", "yes");
INSERT INTO `wp_options` VALUES("183", "revslider-update-check-short", "1675246199", "yes");
INSERT INTO `wp_options` VALUES("184", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("185", "revslider-update-hash", "05528f4d30a289dc1b48ab4561cd2981", "yes");
INSERT INTO `wp_options` VALUES("186", "revslider-latest-version", "6.6.10", "yes");
INSERT INTO `wp_options` VALUES("187", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("188", "revslider-notices", "a:5:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:546:\"<div style=\"display: block; background: #fff;text-align: center; height: 250px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 960px; height: 250px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"https://sliderrevolution.com/wp-content/uploads/2021/07/adminpremiumvid4.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6511-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.9.9\";s:4:\"text\";s:562:\"<div style=\"display: block; background: #fff;text-align: center; \nheight: 300px;\"><a \nhref=\"https://www.sliderrevolution.com/slider-revolution-visual-editor-version-6-6/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=update66\"\n target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: \ncover; background-size: cover; opacity: 1; width: 920px; height: 300px; \ndisplay: inline-block;\" muted loop autoplay \npreload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/rs60/update66videobanner2.mp4\" type=\"video/mp4\"></video></a></div>\n\";s:4:\"code\";s:8:\"TPRSV663\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:537:\"<div style=\"display: block; background: #fff;text-align: center; height: 300px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium2\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 920px; height: 300px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/videobanner_premium2.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6518-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:402:\"<div style=\"display: block; background:#fff;text-align: center; height: 250px;\"><a href=\"https://www.sliderrevolution.com/wordpress-hosting/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getwphosting\" target=\"_blank\" rel=\"noopener\"><img style=\"width: 960px; height: 250px; display: inline-block;\"  src=\"//updates.themepunch-ext-c.tools//banners/rs60/wphostingadmin.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPRSV6518-02\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"registered\";b:1;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:8:\"TPRSV668\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"registered\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("189", "revslider-additions", "O:8:\"stdClass\":1:{s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("190", "rs-addons-counter", "34", "yes");
INSERT INTO `wp_options` VALUES("191", "revslider-addons", "O:8:\"stdClass\":34:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.0.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-01-02\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particlewave.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"3.0.7\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"481\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2023-01-02\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_cluster.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2022-12-23\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_transition.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"499\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.7\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"500\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2022-04-12\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_lottie.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2021-08-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.png\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2021-07-17\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:84:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"498\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2021-07-08\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:80:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-c.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2022-02-19\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2021-06-12\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2022-01-31\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2021-06-12\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2021-05-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2021-05-28\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}}", "yes");
INSERT INTO `wp_options` VALUES("192", "revslider-library-check", "1674467681", "yes");
INSERT INTO `wp_options` VALUES("193", "revslider-library-hash", "dae3de1eb57eeeee008b70e9a23844b5", "yes");
INSERT INTO `wp_options` VALUES("194", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("195", "revslider-templates-check", "1675068706", "yes");
INSERT INTO `wp_options` VALUES("196", "revslider-templates-hash", "2d6e79b6d6daa2ac74c01b13a29a7c26", "yes");
INSERT INTO `wp_options` VALUES("197", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("198", "rs-templates", "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", "no");
INSERT INTO `wp_options` VALUES("199", "rs-templates-counter", "2", "no");
INSERT INTO `wp_options` VALUES("200", "revslider_table_version", "1.0.12", "yes");
INSERT INTO `wp_options` VALUES("203", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("204", "revslider_update_version", "6.6.0", "yes");
INSERT INTO `wp_options` VALUES("205", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("206", "widget_eut-widget-contact-info", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("207", "widget_eut-widget-latest-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("208", "widget_eut-widget-latest-portfolio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("209", "widget_eut-widget-latest-posts", "a:4:{i:2;a:4:{s:5:\"title\";s:11:\"Latest Post\";s:12:\"num_of_posts\";s:1:\"3\";s:10:\"show_image\";s:1:\"1\";s:10:\"categories\";N;}i:3;a:4:{s:5:\"title\";s:12:\"Latest Posts\";s:12:\"num_of_posts\";s:1:\"3\";s:10:\"show_image\";s:0:\"\";s:10:\"categories\";N;}i:4;a:4:{s:5:\"title\";s:12:\"Latest Posts\";s:12:\"num_of_posts\";s:1:\"3\";s:10:\"show_image\";s:1:\"1\";s:10:\"categories\";N;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("210", "widget_eut-widget-social-list", "a:3:{i:2;a:35:{s:5:\"title\";s:0:\"\";s:9:\"list_type\";s:10:\"horizontal\";s:9:\"font_size\";s:9:\"link-text\";s:10:\"list_align\";s:4:\"left\";s:11:\"twitter_url\";s:1:\"#\";s:12:\"facebook_url\";s:1:\"#\";s:14:\"googleplus_url\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:10:\"tumblr_url\";s:0:\"\";s:13:\"pinterest_url\";s:0:\"\";s:10:\"github_url\";s:0:\"\";s:12:\"dribbble_url\";s:0:\"\";s:10:\"reddit_url\";s:0:\"\";s:10:\"flickr_url\";s:0:\"\";s:9:\"skype_url\";s:0:\"\";s:11:\"youtube_url\";s:1:\"#\";s:9:\"vimeo_url\";s:0:\"\";s:14:\"soundcloud_url\";s:0:\"\";s:10:\"wechat_url\";s:0:\"\";s:9:\"weibo_url\";s:0:\"\";s:10:\"renren_url\";s:0:\"\";s:6:\"qq_url\";s:0:\"\";s:8:\"xing_url\";s:0:\"\";s:7:\"rss_url\";s:0:\"\";s:6:\"vk_url\";s:0:\"\";s:11:\"behance_url\";s:0:\"\";s:14:\"foursquare_url\";s:0:\"\";s:9:\"steam_url\";s:0:\"\";s:10:\"twitch_url\";s:0:\"\";s:9:\"houzz_url\";s:0:\"\";s:8:\"yelp_url\";s:0:\"\";s:12:\"snapchat_url\";s:0:\"\";s:10:\"medium_url\";s:0:\"\";s:15:\"tripadvisor_url\";s:0:\"\";}i:3;a:35:{s:5:\"title\";s:9:\"Follow us\";s:9:\"list_type\";s:8:\"vertical\";s:9:\"font_size\";s:14:\"paragraph-text\";s:10:\"list_align\";s:4:\"left\";s:11:\"twitter_url\";s:1:\"#\";s:12:\"facebook_url\";s:1:\"#\";s:14:\"googleplus_url\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:10:\"tumblr_url\";s:0:\"\";s:13:\"pinterest_url\";s:0:\"\";s:10:\"github_url\";s:0:\"\";s:12:\"dribbble_url\";s:0:\"\";s:10:\"reddit_url\";s:0:\"\";s:10:\"flickr_url\";s:0:\"\";s:9:\"skype_url\";s:0:\"\";s:11:\"youtube_url\";s:1:\"#\";s:9:\"vimeo_url\";s:0:\"\";s:14:\"soundcloud_url\";s:0:\"\";s:10:\"wechat_url\";s:0:\"\";s:9:\"weibo_url\";s:0:\"\";s:10:\"renren_url\";s:0:\"\";s:6:\"qq_url\";s:0:\"\";s:8:\"xing_url\";s:0:\"\";s:7:\"rss_url\";s:0:\"\";s:6:\"vk_url\";s:0:\"\";s:11:\"behance_url\";s:1:\"#\";s:14:\"foursquare_url\";s:0:\"\";s:9:\"steam_url\";s:0:\"\";s:10:\"twitch_url\";s:0:\"\";s:9:\"houzz_url\";s:0:\"\";s:8:\"yelp_url\";s:0:\"\";s:12:\"snapchat_url\";s:0:\"\";s:10:\"medium_url\";s:0:\"\";s:15:\"tripadvisor_url\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("211", "widget_eut-widget-social", "a:2:{i:2;a:37:{s:5:\"title\";s:9:\"Follow us\";s:9:\"icon_size\";s:6:\"medium\";s:10:\"icon_color\";s:5:\"white\";s:5:\"shape\";s:6:\"circle\";s:10:\"shape_type\";s:6:\"simple\";s:11:\"shape_color\";s:9:\"primary-1\";s:11:\"twitter_url\";s:30:\"https://twitter.com/euthemians\";s:12:\"facebook_url\";s:1:\"#\";s:14:\"googleplus_url\";s:0:\"\";s:13:\"instagram_url\";s:1:\"#\";s:12:\"linkedin_url\";s:0:\"\";s:10:\"tumblr_url\";s:0:\"\";s:13:\"pinterest_url\";s:0:\"\";s:10:\"github_url\";s:0:\"\";s:12:\"dribbble_url\";s:0:\"\";s:10:\"reddit_url\";s:0:\"\";s:10:\"flickr_url\";s:0:\"\";s:9:\"skype_url\";s:0:\"\";s:11:\"youtube_url\";s:0:\"\";s:9:\"vimeo_url\";s:0:\"\";s:14:\"soundcloud_url\";s:0:\"\";s:10:\"wechat_url\";s:0:\"\";s:9:\"weibo_url\";s:0:\"\";s:10:\"renren_url\";s:0:\"\";s:6:\"qq_url\";s:0:\"\";s:8:\"xing_url\";s:0:\"\";s:7:\"rss_url\";s:0:\"\";s:6:\"vk_url\";s:0:\"\";s:11:\"behance_url\";s:0:\"\";s:14:\"foursquare_url\";s:0:\"\";s:9:\"steam_url\";s:0:\"\";s:10:\"twitch_url\";s:0:\"\";s:9:\"houzz_url\";s:0:\"\";s:8:\"yelp_url\";s:0:\"\";s:12:\"snapchat_url\";s:0:\"\";s:10:\"medium_url\";s:0:\"\";s:15:\"tripadvisor_url\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("212", "widget_eut-sticky-widget", "a:4:{i:2;a:0:{}i:3;a:0:{}i:4;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("213", "vc_version", "6.10.0", "yes");
INSERT INTO `wp_options` VALUES("214", "envato_market_state", "activated", "yes");
INSERT INTO `wp_options` VALUES("215", "rs_cache_overlay", "6.6.5", "yes");
INSERT INTO `wp_options` VALUES("216", "revslider_update_revision_current", "6.6.0", "yes");
INSERT INTO `wp_options` VALUES("217", "wpb_license_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("226", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("231", "_zuperla_eutf_custom_sidebars", "a:7:{i:0;a:2:{s:2:\"id\";s:34:\"zuperla_eutf_sidebar_595ca5b31bd95\";s:4:\"name\";s:14:\"Demo Sidebar 1\";}i:1;a:2:{s:2:\"id\";s:34:\"zuperla_eutf_sidebar_5973040faf968\";s:4:\"name\";s:14:\"Demo Sidebar 2\";}i:2;a:2:{s:2:\"id\";s:34:\"zuperla_eutf_sidebar_59156adb12bf5\";s:4:\"name\";s:14:\"Demo Sidebar 1\";}i:3;a:2:{s:2:\"id\";s:34:\"zuperla_eutf_sidebar_592be7efdf481\";s:4:\"name\";s:14:\"Demo Sidebar 2\";}i:4;a:2:{s:2:\"id\";s:34:\"zuperla_eutf_sidebar_595a3a0bf0220\";s:4:\"name\";s:14:\"Demo Sidebar 3\";}i:5;a:2:{s:2:\"id\";s:34:\"zuperla_eutf_sidebar_595a3a1944102\";s:4:\"name\";s:14:\"Demo Sidebar 4\";}i:6;a:2:{s:2:\"id\";s:34:\"zuperla_eutf_sidebar_595a3ac6f085d\";s:4:\"name\";s:14:\"Demo Sidebar 5\";}}", "yes");
INSERT INTO `wp_options` VALUES("237", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("238", "portfolio_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("239", "portfolio_field_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("240", "testimonial_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("241", "rs_image_meta_todo", "a:21:{i:6399;s:85:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-bg-011.jpg\";i:6400;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-01-img-041.png\";i:6401;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-01-img-011.png\";i:6402;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-01-img-021.png\";i:6403;s:85:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-bg-051.jpg\";i:6404;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-05-img-031.png\";i:6405;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-05-img-021.png\";i:6406;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-05-img-011.png\";i:6407;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-05-img-041.png\";i:6408;s:85:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-bg-021.jpg\";i:6409;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-02-img-051.png\";i:6410;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-02-img-031.png\";i:6411;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-02-img-021.png\";i:6412;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-02-img-011.png\";i:6413;s:85:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-bg-041.jpg\";i:6414;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-04-img-041.png\";i:6415;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-04-img-011.png\";i:6416;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-04-img-021.png\";i:6417;s:95:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider//zuperla-rev-slide-04-img-031.png\";i:6418;s:81:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider/alias/nav-prev1.png\";i:6419;s:81:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads/revslider/alias/nav-next1.png\";}", "yes");
INSERT INTO `wp_options` VALUES("292", "wpb_js_templates", "a:3:{s:21:\"imagetitre_1577561176\";a:2:{s:4:\"name\";s:11:\"image+titre\";s:8:\"template\";s:1027:\"[vc_row padding_top_multiplier=\"6x\" padding_bottom_multiplier=\"6x\" tablet_sm_columns_vertical_gap=\"30\"][vc_column width=\"2/3\" tablet_sm_width=\"1\"][zuperla_single_image image_mode=\"large\" image=\"3917\" animation=\"eut-fade-in-left-big\" image_full_column=\"yes\"][/vc_column][vc_column width=\"1/3\" vertical_content_position=\"middle\" tablet_sm_width=\"1\" rc_font_color=\"#ffffff\"][vc_row_inner padding_top_multiplier=\"\" padding_bottom_multiplier=\"\"][vc_column_inner column_custom_position=\"yes\" position_left=\"minus-6x\" tablet_portrait_column_positions=\"none\" mobile_column_positions=\"none\"][zuperla_title heading_tag=\"h1\" heading=\"h1\" animation=\"eut-fade-in-right-big\"]<span style=\"color: #4ffbff;\"> We value your complaints about our services.</span>[/zuperla_title][/vc_column_inner][/vc_row_inner][vc_column_text animation=\"eut-fade-in-right-big\"]Vidit quodsi fuisset ut vim, et elitr saperet qualisque mel. Id eum duis aeterno docendi, sed habeo oporteat cu, et quot praesent comprehensam usu.[/vc_column_text][/vc_column][/vc_row]\";}s:29:\"fp-modelimagetexte_1748826507\";a:2:{s:4:\"name\";s:18:\"fp-modelimagetexte\";s:8:\"template\";s:1027:\"[vc_row padding_top_multiplier=\"6x\" padding_bottom_multiplier=\"6x\" tablet_sm_columns_vertical_gap=\"30\"][vc_column width=\"2/3\" tablet_sm_width=\"1\"][zuperla_single_image image_mode=\"large\" image=\"3917\" animation=\"eut-fade-in-left-big\" image_full_column=\"yes\"][/vc_column][vc_column width=\"1/3\" vertical_content_position=\"middle\" tablet_sm_width=\"1\" rc_font_color=\"#ffffff\"][vc_row_inner padding_top_multiplier=\"\" padding_bottom_multiplier=\"\"][vc_column_inner column_custom_position=\"yes\" position_left=\"minus-6x\" tablet_portrait_column_positions=\"none\" mobile_column_positions=\"none\"][zuperla_title heading_tag=\"h1\" heading=\"h1\" animation=\"eut-fade-in-right-big\"]<span style=\"color: #4ffbff;\"> We value your complaints about our services.</span>[/zuperla_title][/vc_column_inner][/vc_row_inner][vc_column_text animation=\"eut-fade-in-right-big\"]Vidit quodsi fuisset ut vim, et elitr saperet qualisque mel. Id eum duis aeterno docendi, sed habeo oporteat cu, et quot praesent comprehensam usu.[/vc_column_text][/vc_column][/vc_row]\";}s:19:\"titlebig_1452188182\";a:2:{s:4:\"name\";s:8:\"TITLEBIG\";s:8:\"template\";s:524:\"[vc_row height_ratio=\"70\" padding_top_multiplier=\"2x\" padding_bottom_multiplier=\"2x\"][vc_column vertical_content_position=\"middle\" text_align=\"center\" column_effect=\"vertical-parallax\" column_effect_limit=\"none\" mobile_column_effect=\"none\"][zuperla_title heading_tag=\"h2\" heading=\"h1\" increase_heading=\"200\" custom_font_family=\"custom-font-2\" animation=\"eut-fade-in-up\" align=\"center\"]<span style=\"color: #fe3956;\">*</span> Prodigious work ethics by support nothing less than prodigious.[/zuperla_title][/vc_column][/vc_row]\";}}", "no");
INSERT INTO `wp_options` VALUES("687", "revslider-update-check", "1675246223", "yes");
INSERT INTO `wp_options` VALUES("688", "revslider_update_info", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("775", "_transient_health-check-site-status-result", "{\"good\":13,\"recommended\":8,\"critical\":0}", "yes");
INSERT INTO `wp_options` VALUES("975", "_site_transient_timeout_php_check_20f4df878f211a5689e76acb3f9067a8", "1675774828", "no");
INSERT INTO `wp_options` VALUES("976", "_site_transient_php_check_20f4df878f211a5689e76acb3f9067a8", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("1010", "_site_transient_timeout_envato_market_plugins", "1675249852", "no");
INSERT INTO `wp_options` VALUES("1011", "_site_transient_envato_market_plugins", "a:4:{s:9:\"purchased\";a:0:{}s:6:\"active\";a:0:{}s:9:\"installed\";a:0:{}s:7:\"install\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1012", "_site_transient_timeout_available_translations", "1675257001", "no");
INSERT INTO `wp_options` VALUES("1013", "_site_transient_available_translations", "a:130:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-04 13:58:35\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-31 21:31:35\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.22/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-16 13:00:35\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-10-31 08:48:37\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-24 12:03:10\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-13 14:46:37\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-25 20:56:45\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-14 15:48:08\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-10 08:19:28\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-16 12:27:22\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-03-17 12:58:14\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-16 12:27:34\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.1.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-17 17:06:48\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-17 17:02:15\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.1.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-31 21:42:00\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-16 06:36:35\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2021-12-24 12:36:39\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-10 21:58:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-31 12:11:44\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-04-01 22:35:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-18 21:56:09\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-01 03:10:20\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-17 14:28:26\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-16 13:13:32\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-10 19:19:07\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-10 18:26:21\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.17/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-11 23:25:26\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-07-22 14:08:10\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-15 05:47:03\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-19 05:14:04\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-17 08:19:07\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-07 05:25:25\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-12 18:38:54\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-23 13:11:21\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2018-01-29 17:32:35\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-03 10:28:43\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-09-14 12:33:48\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.29\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.29/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-02 09:16:06\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-11-06 12:34:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-15 19:56:23\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-07-18 19:40:10\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-23 17:09:07\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-29 15:17:58\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-30 17:30:13\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-06 07:11:58\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-24 08:01:09\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-21 21:13:06\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.17/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-21 23:01:12\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-12-07 16:32:30\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.6/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-24 03:51:58\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-06 16:38:45\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-02 15:24:05\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.11\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.11/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-11 01:42:08\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-24 12:00:31\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-05 12:28:58\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.1.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-31 09:04:37\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-26 10:11:03\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-30 18:34:57\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.30\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.30/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-09 08:47:14\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-08-09 12:26:21\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.1.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-10-01 12:16:29\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-08 13:50:14\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-05 04:37:02\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-25 17:58:11\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.12/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-20 04:27:59\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-06 09:43:42\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-11 12:48:55\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-18 19:47:58\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-08-01 21:21:06\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-24 23:38:28\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.14\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.14/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.6/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.21/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-04 13:32:22\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2021-07-03 18:41:33\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-11 15:51:48\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.12/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-17 10:13:02\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-15 22:21:52\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-18 06:20:30\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "no");
INSERT INTO `wp_options` VALUES("1014", "_site_transient_timeout_theme_roots", "1675248003", "no");
INSERT INTO `wp_options` VALUES("1015", "_site_transient_theme_roots", "a:5:{s:12:\"twentytwenty\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";s:7:\"zuperla\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("1016", "_site_transient_timeout_envato_market_themes", "1675249852", "no");
INSERT INTO `wp_options` VALUES("1017", "_site_transient_envato_market_themes", "a:4:{s:9:\"purchased\";a:0:{}s:6:\"active\";a:0:{}s:9:\"installed\";a:0:{}s:7:\"install\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1020", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1675257024", "no");
INSERT INTO `wp_options` VALUES("1021", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:5948;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4809;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2781;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2652;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2046;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1901;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1898;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1617;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1560;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1543;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1542;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1516;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1502;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1460;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1357;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1267;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1176;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1156;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1141;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1042;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1013;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:993;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:963;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:900;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:870;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:870;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:867;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:864;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:862;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:861;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:813;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:790;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:779;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:770;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:769;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:764;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:757;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:732;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:728;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:720;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:720;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:716;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:682;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:681;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:681;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:674;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:666;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:627;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:620;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:611;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:606;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:606;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:604;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:592;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:590;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:587;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:585;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:574;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:569;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:568;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:560;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:553;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:551;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:541;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:539;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:539;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:529;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:527;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:526;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:520;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:514;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:509;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:509;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:507;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:498;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:475;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:475;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:466;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:464;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:450;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:448;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:444;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:435;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:430;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:426;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:424;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:420;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:418;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:416;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:414;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:414;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:409;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:401;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:400;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:397;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:394;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:390;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:389;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:386;}}", "no");
INSERT INTO `wp_options` VALUES("1023", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.1.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.1.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.1.1\";s:7:\"version\";s:5:\"6.1.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1675246251;s:15:\"version_checked\";s:5:\"6.1.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1024", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1675246252;s:8:\"response\";a:3:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.0.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.0.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"5.2\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.7.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.3.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=2279696\";s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";b:0;}s:31:\"envato-market/envato-market.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:13:\"envato-market\";s:6:\"plugin\";s:31:\"envato-market/envato-market.php\";s:11:\"new_version\";s:5:\"2.0.8\";s:3:\"url\";s:42:\"https://github.com/envato/wp-envato-market\";s:7:\"package\";s:63:\"http://envato.github.io/wp-envato-market/dist/envato-market.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.5.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.5.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2605836\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2605835\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}s:7:\"checked\";a:9:{s:19:\"akismet/akismet.php\";s:5:\"5.0.1\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.7.2\";s:25:\"duplicator/duplicator.php\";s:5:\"1.5.2\";s:31:\"envato-market/envato-market.php\";s:5:\"2.0.7\";s:9:\"hello.php\";s:5:\"1.7.2\";s:23:\"revslider/revslider.php\";s:5:\"6.6.5\";s:27:\"js_composer/js_composer.php\";s:6:\"6.10.0\";s:49:\"zuperla-dummy-importer/zuperla-dummy-importer.php\";s:5:\"2.3.1\";s:39:\"zuperla-extension/zuperla-extension.php\";s:5:\"2.3.9\";}}", "no");
INSERT INTO `wp_options` VALUES("1025", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1675246252;s:7:\"checked\";a:5:{s:12:\"twentytwenty\";s:3:\"2.0\";s:15:\"twentytwentyone\";s:3:\"1.6\";s:17:\"twentytwentythree\";s:3:\"1.0\";s:15:\"twentytwentytwo\";s:3:\"1.2\";s:7:\"zuperla\";s:6:\"2.3.10\";}s:8:\"response\";a:3:{s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.2.1.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.7.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.3.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:1:{s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.0.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1026", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.5.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1027", "duplicator_version_plugin", "1.5.2", "yes");
INSERT INTO `wp_options` VALUES("1028", "duplicator_activated", "a:1:{s:4:\"lite\";i:1675246252;}", "yes");
INSERT INTO `wp_options` VALUES("1029", "duplicator_ui_view_state", "a:3:{s:22:\"dup-pack-storage-panel\";s:1:\"0\";s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("1030", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-02-01 10:11:54\";s:7:\"Version\";s:5:\"1.5.2\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.4.21\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"20230201_prime\";s:4:\"Hash\";s:35:\"a968dd1fa2dc414c8979_20230201101154\";s:8:\"NameHash\";s:50:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:60:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:32:\"/Applications/MAMP/htdocs/prime2\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1092;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11150;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-02-01 10:11:54\";s:7:\"Version\";s:5:\"1.5.2\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.4.21\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"20230201_prime\";s:4:\"Hash\";s:35:\"a968dd1fa2dc414c8979_20230201101154\";s:8:\"NameHash\";s:50:\"20230201_prime_a968dd1fa2dc414c8979_20230201101154\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:1;s:14:\"OptsSecurePass\";s:8:\"cHJpbWUy\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:46:\"/Applications/MAMP/htdocs/prime2/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:41:\"/Applications/MAMP/htdocs/prime2/wp-admin\";i:1;s:44:\"/Applications/MAMP/htdocs/prime2/wp-includes\";i:2;s:53:\"/Applications/MAMP/htdocs/prime2/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:32:\"/Applications/MAMP/htdocs/prime2\";i:1;s:32:\"/Applications/MAMP/htdocs/prime2\";i:2;s:43:\"/Applications/MAMP/htdocs/prime2/wp-content\";i:3;s:51:\"/Applications/MAMP/htdocs/prime2/wp-content/uploads\";i:4;s:51:\"/Applications/MAMP/htdocs/prime2/wp-content/plugins\";i:5;s:54:\"/Applications/MAMP/htdocs/prime2/wp-content/mu-plugins\";i:6;s:50:\"/Applications/MAMP/htdocs/prime2/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:64:\"/Applications/MAMP/htdocs/prime2/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:143;}", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3", "5", "_form", "<label> Your name\n    [text* your-name autocomplete:name] </label>\n\n<label> Your email\n    [email* your-email autocomplete:email] </label>\n\n<label> Subject\n    [text* your-subject] </label>\n\n<label> Your message (optional)\n    [textarea your-message] </label>\n\n[submit \"Submit\"]");
INSERT INTO `wp_postmeta` VALUES("4", "5", "_mail", "a:8:{s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:38:\"[_site_title] <fp@unbrindecampagne.fr>\";s:4:\"body\";s:163:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on [_site_title] ([_site_url])\";s:9:\"recipient\";s:19:\"[_site_admin_email]\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("5", "5", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:38:\"[_site_title] <fp@unbrindecampagne.fr>\";s:4:\"body\";s:105:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on [_site_title] ([_site_url])\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:29:\"Reply-To: [_site_admin_email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("6", "5", "_messages", "a:12:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:27:\"Please fill out this field.\";s:16:\"invalid_too_long\";s:32:\"This field has a too long input.\";s:17:\"invalid_too_short\";s:33:\"This field has a too short input.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:31:\"The uploaded file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";}");
INSERT INTO `wp_postmeta` VALUES("7", "5", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("8", "5", "_locale", "fr_FR");
INSERT INTO `wp_postmeta` VALUES("9", "437", "_wp_attached_file", "2017/07/zuperla-banner.jpg");
INSERT INTO `wp_postmeta` VALUES("10", "437", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2340;s:6:\"height\";i:300;s:4:\"file\";s:26:\"2017/07/zuperla-banner.jpg\";s:8:\"filesize\";i:86006;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"zuperla-banner-300x38.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:38;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3141;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"zuperla-banner-1024x131.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:131;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16873;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"zuperla-banner-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5340;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"zuperla-banner-768x98.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:98;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10987;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:27:\"zuperla-banner-1536x197.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29238;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:27:\"zuperla-banner-2048x263.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:263;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42528;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:27:\"zuperla-banner-1390x300.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38154;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21626;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21626;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21626;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:26:\"zuperla-banner-900x300.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31932;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:26:\"zuperla-banner-900x300.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31932;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:26:\"zuperla-banner-840x300.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30401;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11", "437", "_wp_attached_file", "2017/07/zuperla-banner.jpg");
INSERT INTO `wp_postmeta` VALUES("12", "437", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2340;s:6:\"height\";i:300;s:4:\"file\";s:26:\"2017/07/zuperla-banner.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"zuperla-banner-400x51.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:51;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"zuperla-banner-768x98.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:98;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"zuperla-banner-1024x131.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:131;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:27:\"zuperla-banner-1390x300.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-900x300.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-900x300.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-840x300.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:27:\"zuperla-banner-1920x246.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("13", "437", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.465474576141334;s:5:\"bytes\";i:24710;s:11:\"size_before\";i:261054;s:10:\"size_after\";i:236344;s:4:\"time\";d:0.64;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.51;s:5:\"bytes\";i:668;s:11:\"size_before\";i:5340;s:10:\"size_after\";i:4672;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.56;s:5:\"bytes\";i:328;s:11:\"size_before\";i:4341;s:10:\"size_after\";i:4013;s:4:\"time\";d:0.01;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.73;s:5:\"bytes\";i:1070;s:11:\"size_before\";i:10994;s:10:\"size_after\";i:9924;s:4:\"time\";d:0.01;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.82;s:5:\"bytes\";i:1824;s:11:\"size_before\";i:16851;s:10:\"size_after\";i:15027;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.67;s:5:\"bytes\";i:4949;s:11:\"size_before\";i:36209;s:10:\"size_after\";i:31260;s:4:\"time\";d:0.15;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.4;s:5:\"bytes\";i:2900;s:11:\"size_before\";i:21637;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18737;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.01;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18737;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.04;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.23;s:5:\"bytes\";i:4223;s:11:\"size_before\";i:31926;s:10:\"size_after\";i:27703;s:4:\"time\";d:0.02;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:27703;s:10:\"size_after\";i:27703;s:4:\"time\";d:0.18;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.3;s:5:\"bytes\";i:4041;s:11:\"size_before\";i:30374;s:10:\"size_after\";i:26333;s:4:\"time\";d:0.03;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.32;s:5:\"bytes\";i:4707;s:11:\"size_before\";i:38205;s:10:\"size_after\";i:33498;s:4:\"time\";d:0.08;}}}");
INSERT INTO `wp_postmeta` VALUES("14", "443", "_wp_attached_file", "2017/07/zuperla-category-01.jpg");
INSERT INTO `wp_postmeta` VALUES("15", "443", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-01.jpg\";s:8:\"filesize\";i:46681;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"zuperla-category-01-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17787;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"zuperla-category-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7772;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("16", "443", "_wp_attached_file", "2017/07/zuperla-category-01.jpg");
INSERT INTO `wp_postmeta` VALUES("17", "443", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-01.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"zuperla-category-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("18", "443", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:10.957104381527952;s:5:\"bytes\";i:6672;s:11:\"size_before\";i:60892;s:10:\"size_after\";i:54220;s:4:\"time\";d:0.07;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.28;s:5:\"bytes\";i:564;s:11:\"size_before\";i:7750;s:10:\"size_after\";i:7186;s:4:\"time\";d:0.03;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.49;s:5:\"bytes\";i:6108;s:11:\"size_before\";i:53142;s:10:\"size_after\";i:47034;s:4:\"time\";d:0.04;}}}");
INSERT INTO `wp_postmeta` VALUES("19", "444", "_wp_attached_file", "2017/07/zuperla-category-01@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("20", "444", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-01@2x.jpg\";s:8:\"filesize\";i:158079;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"zuperla-category-01@2x-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18898;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"zuperla-category-01@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8008;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64488;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48913;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64488;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("21", "444", "_wp_attached_file", "2017/07/zuperla-category-01@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("22", "444", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-01@2x.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-400x299.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:299;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("23", "444", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.060055020561272;s:5:\"bytes\";i:23328;s:11:\"size_before\";i:384947;s:10:\"size_after\";i:361619;s:4:\"time\";d:0.37;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.2;s:5:\"bytes\";i:575;s:11:\"size_before\";i:7983;s:10:\"size_after\";i:7408;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.39;s:5:\"bytes\";i:1566;s:11:\"size_before\";i:29035;s:10:\"size_after\";i:27469;s:4:\"time\";d:0.04;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.8;s:5:\"bytes\";i:3081;s:11:\"size_before\";i:64204;s:10:\"size_after\";i:61123;s:4:\"time\";d:0.1;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.7;s:5:\"bytes\";i:2288;s:11:\"size_before\";i:48705;s:10:\"size_after\";i:46417;s:4:\"time\";d:0.12;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:61123;s:10:\"size_after\";i:61123;s:4:\"time\";d:0.04;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.1;s:5:\"bytes\";i:15818;s:11:\"size_before\";i:173897;s:10:\"size_after\";i:158079;s:4:\"time\";d:0.06;}}}");
INSERT INTO `wp_postmeta` VALUES("24", "447", "_wp_attached_file", "2017/07/zuperla-category-02.jpg");
INSERT INTO `wp_postmeta` VALUES("25", "447", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-02.jpg\";s:8:\"filesize\";i:28625;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"zuperla-category-02-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11418;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"zuperla-category-02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5490;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26", "447", "_wp_attached_file", "2017/07/zuperla-category-02.jpg");
INSERT INTO `wp_postmeta` VALUES("27", "447", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-02.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"zuperla-category-02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("28", "447", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.208456637073768;s:5:\"bytes\";i:3454;s:11:\"size_before\";i:37509;s:10:\"size_after\";i:34055;s:4:\"time\";d:0.04;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.52;s:5:\"bytes\";i:247;s:11:\"size_before\";i:5468;s:10:\"size_after\";i:5221;s:4:\"time\";d:0.02;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.01;s:5:\"bytes\";i:3207;s:11:\"size_before\";i:32041;s:10:\"size_after\";i:28834;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("29", "448", "_wp_attached_file", "2017/07/zuperla-category-02@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("30", "448", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-02@2x.jpg\";s:8:\"filesize\";i:90351;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"zuperla-category-02@2x-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11741;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"zuperla-category-02@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5593;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38005;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28499;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38005;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("31", "448", "_wp_attached_file", "2017/07/zuperla-category-02@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("32", "448", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-02@2x.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-400x299.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:299;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("33", "448", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.9524539739761284;s:5:\"bytes\";i:8815;s:11:\"size_before\";i:223026;s:10:\"size_after\";i:214211;s:4:\"time\";d:0.41000000000000003;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67;s:5:\"bytes\";i:260;s:11:\"size_before\";i:5569;s:10:\"size_after\";i:5309;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:3;s:5:\"bytes\";i:519;s:11:\"size_before\";i:17291;s:10:\"size_after\";i:16772;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.47;s:5:\"bytes\";i:937;s:11:\"size_before\";i:37951;s:10:\"size_after\";i:37014;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.38;s:5:\"bytes\";i:676;s:11:\"size_before\";i:28427;s:10:\"size_after\";i:27751;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:37014;s:10:\"size_after\";i:37014;s:4:\"time\";d:0.13;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.64;s:5:\"bytes\";i:6423;s:11:\"size_before\";i:96774;s:10:\"size_after\";i:90351;s:4:\"time\";d:0.16;}}}");
INSERT INTO `wp_postmeta` VALUES("34", "449", "_wp_attached_file", "2017/07/zuperla-category-03.jpg");
INSERT INTO `wp_postmeta` VALUES("35", "449", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-03.jpg\";s:8:\"filesize\";i:48245;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"zuperla-category-03-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19092;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"zuperla-category-03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8261;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("36", "449", "_wp_attached_file", "2017/07/zuperla-category-03.jpg");
INSERT INTO `wp_postmeta` VALUES("37", "449", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-03.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"zuperla-category-03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("38", "449", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.674478125249939;s:5:\"bytes\";i:6048;s:11:\"size_before\";i:62515;s:10:\"size_after\";i:56467;s:4:\"time\";d:0.05;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.73;s:5:\"bytes\";i:389;s:11:\"size_before\";i:8231;s:10:\"size_after\";i:7842;s:4:\"time\";d:0.03;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.42;s:5:\"bytes\";i:5659;s:11:\"size_before\";i:54284;s:10:\"size_after\";i:48625;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("39", "450", "_wp_attached_file", "2017/07/zuperla-category-03@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("40", "450", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-03@2x.jpg\";s:8:\"filesize\";i:182798;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"zuperla-category-03@2x-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20591;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"zuperla-category-03@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8522;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:83265;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58927;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:83265;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("41", "450", "_wp_attached_file", "2017/07/zuperla-category-03@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("42", "450", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-03@2x.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-400x299.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:299;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("43", "450", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.740765448304802;s:5:\"bytes\";i:31324;s:11:\"size_before\";i:464695;s:10:\"size_after\";i:433371;s:4:\"time\";d:0.35000000000000003;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.58;s:5:\"bytes\";i:389;s:11:\"size_before\";i:8501;s:10:\"size_after\";i:8112;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.88;s:5:\"bytes\";i:1624;s:11:\"size_before\";i:33258;s:10:\"size_after\";i:31634;s:4:\"time\";d:0.05;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.38;s:5:\"bytes\";i:5292;s:11:\"size_before\";i:82983;s:10:\"size_after\";i:77691;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.7;s:5:\"bytes\";i:3353;s:11:\"size_before\";i:58798;s:10:\"size_after\";i:55445;s:4:\"time\";d:0.04;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:77691;s:10:\"size_after\";i:77691;s:4:\"time\";d:0.12;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.16;s:5:\"bytes\";i:20666;s:11:\"size_before\";i:203464;s:10:\"size_after\";i:182798;s:4:\"time\";d:0.08;}}}");
INSERT INTO `wp_postmeta` VALUES("44", "468", "_wp_attached_file", "2017/07/zuperla-footer-logo.png");
INSERT INTO `wp_postmeta` VALUES("45", "468", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:60;s:6:\"height\";i:60;s:4:\"file\";s:31:\"2017/07/zuperla-footer-logo.png\";s:8:\"filesize\";i:714;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("46", "468", "_wp_attached_file", "2017/07/zuperla-footer-logo.png");
INSERT INTO `wp_postmeta` VALUES("47", "468", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:60;s:6:\"height\";i:60;s:4:\"file\";s:31:\"2017/07/zuperla-footer-logo.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("48", "468", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:39.94190268700073;s:5:\"bytes\";i:550;s:11:\"size_before\";i:1377;s:10:\"size_after\";i:827;s:4:\"time\";d:0.02;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:39.94;s:5:\"bytes\";i:550;s:11:\"size_before\";i:1377;s:10:\"size_after\";i:827;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("49", "469", "_wp_attached_file", "2017/07/zuperla-footer-logo@2x.png");
INSERT INTO `wp_postmeta` VALUES("50", "469", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:34:\"2017/07/zuperla-footer-logo@2x.png\";s:8:\"filesize\";i:1767;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("51", "469", "_wp_attached_file", "2017/07/zuperla-footer-logo@2x.png");
INSERT INTO `wp_postmeta` VALUES("52", "469", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:34:\"2017/07/zuperla-footer-logo@2x.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("53", "469", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:37.58389261744966;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:2831;s:10:\"size_after\";i:1767;s:4:\"time\";d:0.05;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:37.58;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:2831;s:10:\"size_after\";i:1767;s:4:\"time\";d:0.05;}}}");
INSERT INTO `wp_postmeta` VALUES("54", "437", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.465474576141334;s:5:\"bytes\";i:24710;s:11:\"size_before\";i:261054;s:10:\"size_after\";i:236344;s:4:\"time\";d:0.64;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.51;s:5:\"bytes\";i:668;s:11:\"size_before\";i:5340;s:10:\"size_after\";i:4672;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.56;s:5:\"bytes\";i:328;s:11:\"size_before\";i:4341;s:10:\"size_after\";i:4013;s:4:\"time\";d:0.01;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.73;s:5:\"bytes\";i:1070;s:11:\"size_before\";i:10994;s:10:\"size_after\";i:9924;s:4:\"time\";d:0.01;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.82;s:5:\"bytes\";i:1824;s:11:\"size_before\";i:16851;s:10:\"size_after\";i:15027;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.67;s:5:\"bytes\";i:4949;s:11:\"size_before\";i:36209;s:10:\"size_after\";i:31260;s:4:\"time\";d:0.15;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.4;s:5:\"bytes\";i:2900;s:11:\"size_before\";i:21637;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18737;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.01;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18737;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.04;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.23;s:5:\"bytes\";i:4223;s:11:\"size_before\";i:31926;s:10:\"size_after\";i:27703;s:4:\"time\";d:0.02;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:27703;s:10:\"size_after\";i:27703;s:4:\"time\";d:0.18;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.3;s:5:\"bytes\";i:4041;s:11:\"size_before\";i:30374;s:10:\"size_after\";i:26333;s:4:\"time\";d:0.03;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.32;s:5:\"bytes\";i:4707;s:11:\"size_before\";i:38205;s:10:\"size_after\";i:33498;s:4:\"time\";d:0.08;}}}");
INSERT INTO `wp_postmeta` VALUES("55", "443", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:10.957104381527952;s:5:\"bytes\";i:6672;s:11:\"size_before\";i:60892;s:10:\"size_after\";i:54220;s:4:\"time\";d:0.07;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.28;s:5:\"bytes\";i:564;s:11:\"size_before\";i:7750;s:10:\"size_after\";i:7186;s:4:\"time\";d:0.03;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.49;s:5:\"bytes\";i:6108;s:11:\"size_before\";i:53142;s:10:\"size_after\";i:47034;s:4:\"time\";d:0.04;}}}");
INSERT INTO `wp_postmeta` VALUES("56", "444", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.060055020561272;s:5:\"bytes\";i:23328;s:11:\"size_before\";i:384947;s:10:\"size_after\";i:361619;s:4:\"time\";d:0.37;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.2;s:5:\"bytes\";i:575;s:11:\"size_before\";i:7983;s:10:\"size_after\";i:7408;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.39;s:5:\"bytes\";i:1566;s:11:\"size_before\";i:29035;s:10:\"size_after\";i:27469;s:4:\"time\";d:0.04;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.8;s:5:\"bytes\";i:3081;s:11:\"size_before\";i:64204;s:10:\"size_after\";i:61123;s:4:\"time\";d:0.1;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.7;s:5:\"bytes\";i:2288;s:11:\"size_before\";i:48705;s:10:\"size_after\";i:46417;s:4:\"time\";d:0.12;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:61123;s:10:\"size_after\";i:61123;s:4:\"time\";d:0.04;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.1;s:5:\"bytes\";i:15818;s:11:\"size_before\";i:173897;s:10:\"size_after\";i:158079;s:4:\"time\";d:0.06;}}}");
INSERT INTO `wp_postmeta` VALUES("57", "447", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.208456637073768;s:5:\"bytes\";i:3454;s:11:\"size_before\";i:37509;s:10:\"size_after\";i:34055;s:4:\"time\";d:0.04;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.52;s:5:\"bytes\";i:247;s:11:\"size_before\";i:5468;s:10:\"size_after\";i:5221;s:4:\"time\";d:0.02;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.01;s:5:\"bytes\";i:3207;s:11:\"size_before\";i:32041;s:10:\"size_after\";i:28834;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("58", "448", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.9524539739761284;s:5:\"bytes\";i:8815;s:11:\"size_before\";i:223026;s:10:\"size_after\";i:214211;s:4:\"time\";d:0.41000000000000003;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67;s:5:\"bytes\";i:260;s:11:\"size_before\";i:5569;s:10:\"size_after\";i:5309;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:3;s:5:\"bytes\";i:519;s:11:\"size_before\";i:17291;s:10:\"size_after\";i:16772;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.47;s:5:\"bytes\";i:937;s:11:\"size_before\";i:37951;s:10:\"size_after\";i:37014;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.38;s:5:\"bytes\";i:676;s:11:\"size_before\";i:28427;s:10:\"size_after\";i:27751;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:37014;s:10:\"size_after\";i:37014;s:4:\"time\";d:0.13;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.64;s:5:\"bytes\";i:6423;s:11:\"size_before\";i:96774;s:10:\"size_after\";i:90351;s:4:\"time\";d:0.16;}}}");
INSERT INTO `wp_postmeta` VALUES("59", "467", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("60", "467", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("62", "416", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("63", "416", "_zuperla_eutf_feature_section", "a:5:{s:16:\"feature_settings\";a:7:{s:7:\"element\";s:6:\"slider\";s:4:\"size\";s:0:\"\";s:6:\"height\";s:2:\"60\";s:10:\"min_height\";s:3:\"200\";s:15:\"header_position\";s:5:\"above\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#eef1f6\";}s:15:\"revslider_alias\";s:0:\"\";s:11:\"single_item\";a:48:{s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:3:\"div\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:11:\"caption_tag\";s:3:\"div\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"large\";s:13:\"content_align\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:3:\"150\";s:35:\"content_image_responsive_max_height\";s:2:\"50\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:1:\"0\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"image_effect\";s:0:\"\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:12:\"video_effect\";s:0:\"\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595c9c4a82812\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595c9c4a82d39\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}s:12:\"slider_items\";a:3:{i:0;a:44:{s:2:\"id\";s:13:\"595c9c8330359\";s:4:\"type\";s:4:\"post\";s:7:\"post_id\";s:3:\"390\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"header_style\";s:5:\"light\";s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:6:\"custom\";s:20:\"caption_color_custom\";s:7:\"#696969\";s:11:\"caption_tag\";s:2:\"h2\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"small\";s:13:\"content_align\";s:4:\"left\";s:16:\"content_position\";s:11:\"left-center\";s:17:\"content_animation\";s:12:\"fade-in-left\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:0:\"\";s:35:\"content_image_responsive_max_height\";s:0:\"\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:1:\"0\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595c9c83315d6\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595c9c8331aa7\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}i:1;a:44:{s:2:\"id\";s:13:\"595c9c8333ff1\";s:4:\"type\";s:4:\"post\";s:7:\"post_id\";s:2:\"17\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"header_style\";s:5:\"light\";s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:6:\"custom\";s:20:\"caption_color_custom\";s:7:\"#696969\";s:11:\"caption_tag\";s:2:\"h2\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"small\";s:13:\"content_align\";s:4:\"left\";s:16:\"content_position\";s:11:\"left-center\";s:17:\"content_animation\";s:10:\"fade-in-up\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:0:\"\";s:35:\"content_image_responsive_max_height\";s:0:\"\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:4:\"0.80\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595c9c83360f0\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595c9c8336a0f\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}i:2;a:44:{s:2:\"id\";s:13:\"595c9c8332071\";s:4:\"type\";s:4:\"post\";s:7:\"post_id\";s:2:\"12\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"header_style\";s:4:\"dark\";s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:4:\"dark\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:3:\"div\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:4:\"dark\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:11:\"caption_tag\";s:3:\"div\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:4:\"dark\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"large\";s:13:\"content_align\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"zoom-in\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:0:\"\";s:35:\"content_image_responsive_max_height\";s:0:\"\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:1:\"0\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595c9c83331a8\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595c9c833370f\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}}s:15:\"slider_settings\";a:6:{s:15:\"slideshow_speed\";s:4:\"5500\";s:13:\"direction_nav\";s:1:\"1\";s:12:\"slider_pause\";s:2:\"no\";s:10:\"transition\";s:5:\"slide\";s:13:\"slider_effect\";s:13:\"fixed-section\";s:10:\"pagination\";s:3:\"yes\";}}");
INSERT INTO `wp_postmeta` VALUES("64", "416", "_zuperla_eutf_scrolling_speed", "1000");
INSERT INTO `wp_postmeta` VALUES("65", "416", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("66", "416", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("67", "416", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("68", "416", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("69", "416", "_zuperla_eutf_disable_title", "yes");
INSERT INTO `wp_postmeta` VALUES("70", "416", "_zuperla_eutf_header_overlapping", "yes");
INSERT INTO `wp_postmeta` VALUES("71", "416", "_zuperla_eutf_header_style", "light");
INSERT INTO `wp_postmeta` VALUES("72", "449", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.674478125249939;s:5:\"bytes\";i:6048;s:11:\"size_before\";i:62515;s:10:\"size_after\";i:56467;s:4:\"time\";d:0.05;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.73;s:5:\"bytes\";i:389;s:11:\"size_before\";i:8231;s:10:\"size_after\";i:7842;s:4:\"time\";d:0.03;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.42;s:5:\"bytes\";i:5659;s:11:\"size_before\";i:54284;s:10:\"size_after\";i:48625;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("73", "450", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.740765448304802;s:5:\"bytes\";i:31324;s:11:\"size_before\";i:464695;s:10:\"size_after\";i:433371;s:4:\"time\";d:0.35000000000000003;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.58;s:5:\"bytes\";i:389;s:11:\"size_before\";i:8501;s:10:\"size_after\";i:8112;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.88;s:5:\"bytes\";i:1624;s:11:\"size_before\";i:33258;s:10:\"size_after\";i:31634;s:4:\"time\";d:0.05;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.38;s:5:\"bytes\";i:5292;s:11:\"size_before\";i:82983;s:10:\"size_after\";i:77691;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.7;s:5:\"bytes\";i:3353;s:11:\"size_before\";i:58798;s:10:\"size_after\";i:55445;s:4:\"time\";d:0.04;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:77691;s:10:\"size_after\";i:77691;s:4:\"time\";d:0.12;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.16;s:5:\"bytes\";i:20666;s:11:\"size_before\";i:203464;s:10:\"size_after\";i:182798;s:4:\"time\";d:0.08;}}}");
INSERT INTO `wp_postmeta` VALUES("74", "468", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:39.94190268700073;s:5:\"bytes\";i:550;s:11:\"size_before\";i:1377;s:10:\"size_after\";i:827;s:4:\"time\";d:0.02;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:39.94;s:5:\"bytes\";i:550;s:11:\"size_before\";i:1377;s:10:\"size_after\";i:827;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("75", "469", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:37.58389261744966;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:2831;s:10:\"size_after\";i:1767;s:4:\"time\";d:0.05;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:37.58;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:2831;s:10:\"size_after\";i:1767;s:4:\"time\";d:0.05;}}}");
INSERT INTO `wp_postmeta` VALUES("76", "416", "_edit_lock", "1674467681:1");
INSERT INTO `wp_postmeta` VALUES("77", "393", "_wp_attached_file", "2016/11/zuperla-feature-01.jpg");
INSERT INTO `wp_postmeta` VALUES("78", "393", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-01.jpg\";s:8:\"filesize\";i:893132;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-01-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5251;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-01-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37553;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3158;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-01-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22528;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-01-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:77339;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-01-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:133573;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-01-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:56479;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-01-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22589;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-01-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15576;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-01-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31459;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-01-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52919;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-01-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35433;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-01-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64427;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("79", "393", "_wp_attached_file", "2016/11/zuperla-feature-01.jpg");
INSERT INTO `wp_postmeta` VALUES("80", "393", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-01.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-01-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-01-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-01-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-01-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-01-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-01-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-01-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-01-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-01-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-01-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-01-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("81", "393", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:12.994693518669889;s:5:\"bytes\";i:58821;s:11:\"size_before\";i:452654;s:10:\"size_after\";i:393833;s:4:\"time\";d:1.1;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.63;s:5:\"bytes\";i:241;s:11:\"size_before\";i:3158;s:10:\"size_after\";i:2917;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.81;s:5:\"bytes\";i:850;s:11:\"size_before\";i:7866;s:10:\"size_after\";i:7016;s:4:\"time\";d:0.04;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.67;s:5:\"bytes\";i:3076;s:11:\"size_before\";i:22507;s:10:\"size_after\";i:19431;s:4:\"time\";d:0.05;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.73;s:5:\"bytes\";i:5528;s:11:\"size_before\";i:37541;s:10:\"size_after\";i:32013;s:4:\"time\";d:0.1;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:15.31;s:5:\"bytes\";i:6396;s:11:\"size_before\";i:41789;s:10:\"size_after\";i:35393;s:4:\"time\";d:0.08;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.45;s:5:\"bytes\";i:2361;s:11:\"size_before\";i:22589;s:10:\"size_after\";i:20228;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.46;s:5:\"bytes\";i:1941;s:11:\"size_before\";i:15582;s:10:\"size_after\";i:13641;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.85;s:5:\"bytes\";i:3098;s:11:\"size_before\";i:31451;s:10:\"size_after\";i:28353;s:4:\"time\";d:0.08;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.62;s:5:\"bytes\";i:6152;s:11:\"size_before\";i:52932;s:10:\"size_after\";i:46780;s:4:\"time\";d:0.1;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.91;s:5:\"bytes\";i:4928;s:11:\"size_before\";i:35430;s:10:\"size_after\";i:30502;s:4:\"time\";d:0.04;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.45;s:5:\"bytes\";i:6734;s:11:\"size_before\";i:64420;s:10:\"size_after\";i:57686;s:4:\"time\";d:0.24;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.92;s:5:\"bytes\";i:17516;s:11:\"size_before\";i:117389;s:10:\"size_after\";i:99873;s:4:\"time\";d:0.28;}}}");
INSERT INTO `wp_postmeta` VALUES("82", "394", "_wp_attached_file", "2016/11/zuperla-feature-02.jpg");
INSERT INTO `wp_postmeta` VALUES("83", "394", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-02.jpg\";s:8:\"filesize\";i:786906;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-02-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10914;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-02-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70773;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5460;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-02-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45342;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-02-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:131178;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-02-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:205027;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-02-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:96344;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-02-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38424;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-02-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31164;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-02-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47173;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-02-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79710;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-02-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64298;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-02-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86384;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("84", "394", "_wp_attached_file", "2016/11/zuperla-feature-02.jpg");
INSERT INTO `wp_postmeta` VALUES("85", "394", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-02.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-02-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-02-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-02-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-02-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-02-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-02-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-02-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-02-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-02-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-02-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-02-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("86", "394", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:4.657229066664165;s:5:\"bytes\";i:34744;s:11:\"size_before\";i:746023;s:10:\"size_after\";i:711279;s:4:\"time\";d:1.57;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.89;s:5:\"bytes\";i:322;s:11:\"size_before\";i:5463;s:10:\"size_after\";i:5141;s:4:\"time\";d:0.04;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.84;s:5:\"bytes\";i:651;s:11:\"size_before\";i:16973;s:10:\"size_after\";i:16322;s:4:\"time\";d:0.04;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.4;s:5:\"bytes\";i:1990;s:11:\"size_before\";i:45272;s:10:\"size_after\";i:43282;s:4:\"time\";d:0.03;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.62;s:5:\"bytes\";i:3278;s:11:\"size_before\";i:70951;s:10:\"size_after\";i:67673;s:4:\"time\";d:0.12;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.31;s:5:\"bytes\";i:3211;s:11:\"size_before\";i:74512;s:10:\"size_after\";i:71301;s:4:\"time\";d:0.24;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.25;s:5:\"bytes\";i:1630;s:11:\"size_before\";i:38343;s:10:\"size_after\";i:36713;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.02;s:5:\"bytes\";i:1256;s:11:\"size_before\";i:31211;s:10:\"size_after\";i:29955;s:4:\"time\";d:0.03;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.16;s:5:\"bytes\";i:1957;s:11:\"size_before\";i:47083;s:10:\"size_after\";i:45126;s:4:\"time\";d:0.11;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.47;s:5:\"bytes\";i:3568;s:11:\"size_before\";i:79764;s:10:\"size_after\";i:76196;s:4:\"time\";d:0.26;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.52;s:5:\"bytes\";i:2902;s:11:\"size_before\";i:64253;s:10:\"size_after\";i:61351;s:4:\"time\";d:0.12;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.51;s:5:\"bytes\";i:3890;s:11:\"size_before\";i:86345;s:10:\"size_after\";i:82455;s:4:\"time\";d:0.35;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.43;s:5:\"bytes\";i:10089;s:11:\"size_before\";i:185853;s:10:\"size_after\";i:175764;s:4:\"time\";d:0.16;}}}");
INSERT INTO `wp_postmeta` VALUES("87", "396", "_wp_attached_file", "2016/11/zuperla-feature-03.jpg");
INSERT INTO `wp_postmeta` VALUES("88", "396", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-03.jpg\";s:8:\"filesize\";i:897964;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-03-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18199;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-03-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:168754;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8621;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-03-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:99826;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-03-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:357778;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-03-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:607631;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-03-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:255685;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-03-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86572;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-03-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64241;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-03-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:114091;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-03-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:206783;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-03-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:152567;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-03-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:241819;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("89", "396", "_wp_attached_file", "2016/11/zuperla-feature-03.jpg");
INSERT INTO `wp_postmeta` VALUES("90", "396", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-03.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-03-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-03-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-03-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-03-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-03-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-03-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-03-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-03-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-03-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-03-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-03-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("91", "396", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:5.962521832453021;s:5:\"bytes\";i:113338;s:11:\"size_before\";i:1900840;s:10:\"size_after\";i:1787502;s:4:\"time\";d:1.1099999999999999;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.36;s:5:\"bytes\";i:375;s:11:\"size_before\";i:8608;s:10:\"size_after\";i:8233;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.4;s:5:\"bytes\";i:1346;s:11:\"size_before\";i:30610;s:10:\"size_after\";i:29264;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.15;s:5:\"bytes\";i:6128;s:11:\"size_before\";i:99719;s:10:\"size_after\";i:93591;s:4:\"time\";d:0.1;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.17;s:5:\"bytes\";i:10390;s:11:\"size_before\";i:168457;s:10:\"size_after\";i:158067;s:4:\"time\";d:0.08;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.9;s:5:\"bytes\";i:10985;s:11:\"size_before\";i:186114;s:10:\"size_after\";i:175129;s:4:\"time\";d:0.07;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.26;s:5:\"bytes\";i:5416;s:11:\"size_before\";i:86459;s:10:\"size_after\";i:81043;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.52;s:5:\"bytes\";i:3543;s:11:\"size_before\";i:64131;s:10:\"size_after\";i:60588;s:4:\"time\";d:0.07;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.02;s:5:\"bytes\";i:6857;s:11:\"size_before\";i:113963;s:10:\"size_after\";i:107106;s:4:\"time\";d:0.05;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.94;s:5:\"bytes\";i:12259;s:11:\"size_before\";i:206341;s:10:\"size_after\";i:194082;s:4:\"time\";d:0.09;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.27;s:5:\"bytes\";i:9545;s:11:\"size_before\";i:152341;s:10:\"size_after\";i:142796;s:4:\"time\";d:0.18;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.65;s:5:\"bytes\";i:13631;s:11:\"size_before\";i:241197;s:10:\"size_after\";i:227566;s:4:\"time\";d:0.14;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.05;s:5:\"bytes\";i:32863;s:11:\"size_before\";i:542900;s:10:\"size_after\";i:510037;s:4:\"time\";d:0.26;}}}");
INSERT INTO `wp_postmeta` VALUES("92", "398", "_wp_attached_file", "2016/11/zuperla-feature-04.jpg");
INSERT INTO `wp_postmeta` VALUES("93", "398", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-04.jpg\";s:8:\"filesize\";i:879158;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-04-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17689;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-04-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140993;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8103;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-04-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:84319;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-04-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:289806;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-04-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:488637;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-04-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:206912;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-04-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66351;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-04-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53614;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-04-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85405;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-04-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:154427;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-04-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:122185;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-04-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:177292;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("94", "398", "_wp_attached_file", "2016/11/zuperla-feature-04.jpg");
INSERT INTO `wp_postmeta` VALUES("95", "398", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-04.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-04-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-04-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-04-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-04-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-04-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-04-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-04-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-04-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-04-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-04-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-04-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("96", "398", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:5.062486298316854;s:5:\"bytes\";i:76436;s:11:\"size_before\";i:1509851;s:10:\"size_after\";i:1433415;s:4:\"time\";d:2;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.42;s:5:\"bytes\";i:600;s:11:\"size_before\";i:8087;s:10:\"size_after\";i:7487;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.65;s:5:\"bytes\";i:1602;s:11:\"size_before\";i:28340;s:10:\"size_after\";i:26738;s:4:\"time\";d:0.11;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.74;s:5:\"bytes\";i:3989;s:11:\"size_before\";i:84189;s:10:\"size_after\";i:80200;s:4:\"time\";d:0.14;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.92;s:5:\"bytes\";i:6921;s:11:\"size_before\";i:140747;s:10:\"size_after\";i:133826;s:4:\"time\";d:0.17;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.85;s:5:\"bytes\";i:7446;s:11:\"size_before\";i:153582;s:10:\"size_after\";i:146136;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.94;s:5:\"bytes\";i:3272;s:11:\"size_before\";i:66239;s:10:\"size_after\";i:62967;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.03;s:5:\"bytes\";i:2690;s:11:\"size_before\";i:53519;s:10:\"size_after\";i:50829;s:4:\"time\";d:0.03;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.9;s:5:\"bytes\";i:4181;s:11:\"size_before\";i:85264;s:10:\"size_after\";i:81083;s:4:\"time\";d:0.06;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.92;s:5:\"bytes\";i:7587;s:11:\"size_before\";i:154265;s:10:\"size_after\";i:146678;s:4:\"time\";d:0.26;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.89;s:5:\"bytes\";i:5971;s:11:\"size_before\";i:121997;s:10:\"size_after\";i:116026;s:4:\"time\";d:0.08;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.1;s:5:\"bytes\";i:9031;s:11:\"size_before\";i:177007;s:10:\"size_after\";i:167976;s:4:\"time\";d:0.18;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.3;s:5:\"bytes\";i:23146;s:11:\"size_before\";i:436615;s:10:\"size_after\";i:413469;s:4:\"time\";d:0.86;}}}");
INSERT INTO `wp_postmeta` VALUES("97", "400", "_wp_attached_file", "2016/11/zuperla-feature-05.jpg");
INSERT INTO `wp_postmeta` VALUES("98", "400", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-05.jpg\";s:8:\"filesize\";i:987053;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-05-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16879;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-05-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:122171;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6991;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-05-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76733;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-05-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:226079;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-05-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:347662;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-05-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:168143;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-05-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57114;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-05-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50700;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-05-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64000;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-05-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:121318;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-05-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109604;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-05-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:117728;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("99", "400", "_wp_attached_file", "2016/11/zuperla-feature-05.jpg");
INSERT INTO `wp_postmeta` VALUES("100", "400", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-05.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-05-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-05-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-05-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-05-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-05-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-05-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-05-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-05-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-05-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-05-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-05-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("101", "400", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.7929464065614047;s:5:\"bytes\";i:45390;s:11:\"size_before\";i:1196695;s:10:\"size_after\";i:1151305;s:4:\"time\";d:1.1199999999999999;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.82;s:5:\"bytes\";i:407;s:11:\"size_before\";i:6997;s:10:\"size_after\";i:6590;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.82;s:5:\"bytes\";i:1275;s:11:\"size_before\";i:26432;s:10:\"size_after\";i:25157;s:4:\"time\";d:0.05;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.61;s:5:\"bytes\";i:3534;s:11:\"size_before\";i:76594;s:10:\"size_after\";i:73060;s:4:\"time\";d:0.1;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.25;s:5:\"bytes\";i:5190;s:11:\"size_before\";i:121992;s:10:\"size_after\";i:116802;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.14;s:5:\"bytes\";i:5341;s:11:\"size_before\";i:129152;s:10:\"size_after\";i:123811;s:4:\"time\";d:0.17;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.43;s:5:\"bytes\";i:2529;s:11:\"size_before\";i:57047;s:10:\"size_after\";i:54518;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.58;s:5:\"bytes\";i:2319;s:11:\"size_before\";i:50602;s:10:\"size_after\";i:48283;s:4:\"time\";d:0.03;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.69;s:5:\"bytes\";i:2360;s:11:\"size_before\";i:63906;s:10:\"size_after\";i:61546;s:4:\"time\";d:0.1;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.46;s:5:\"bytes\";i:4190;s:11:\"size_before\";i:121123;s:10:\"size_after\";i:116933;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.41;s:5:\"bytes\";i:4824;s:11:\"size_before\";i:109429;s:10:\"size_after\";i:104605;s:4:\"time\";d:0.12;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.68;s:5:\"bytes\";i:3156;s:11:\"size_before\";i:117569;s:10:\"size_after\";i:114413;s:4:\"time\";d:0.16;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.25;s:5:\"bytes\";i:10265;s:11:\"size_before\";i:315852;s:10:\"size_after\";i:305587;s:4:\"time\";d:0.19;}}}");
INSERT INTO `wp_postmeta` VALUES("102", "402", "_wp_attached_file", "2016/11/zuperla-feature-06.jpg");
INSERT INTO `wp_postmeta` VALUES("103", "402", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-06.jpg\";s:8:\"filesize\";i:838469;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-06-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10574;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-06-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62195;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-06-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5896;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-06-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39568;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-06-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:124181;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-06-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:218652;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-06-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:88059;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-06-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34720;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-06-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27771;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-06-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42145;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-06-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:74990;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-06-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57206;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-06-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85888;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("104", "402", "_wp_attached_file", "2016/11/zuperla-feature-06.jpg");
INSERT INTO `wp_postmeta` VALUES("105", "402", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-06.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-06-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-06-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-06-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-06-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-06-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-06-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-06-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-06-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-06-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-06-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-06-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-06-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("106", "402", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:4.243357347862527;s:5:\"bytes\";i:29821;s:11:\"size_before\";i:702769;s:10:\"size_after\";i:672948;s:4:\"time\";d:1.44;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.67;s:5:\"bytes\";i:333;s:11:\"size_before\";i:5869;s:10:\"size_after\";i:5536;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.49;s:5:\"bytes\";i:540;s:11:\"size_before\";i:15487;s:10:\"size_after\";i:14947;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.41;s:5:\"bytes\";i:1345;s:11:\"size_before\";i:39497;s:10:\"size_after\";i:38152;s:4:\"time\";d:0.06;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.58;s:5:\"bytes\";i:2222;s:11:\"size_before\";i:62145;s:10:\"size_after\";i:59923;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87;s:5:\"bytes\";i:2562;s:11:\"size_before\";i:66221;s:10:\"size_after\";i:63659;s:4:\"time\";d:0.17;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.07;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:34639;s:10:\"size_after\";i:33575;s:4:\"time\";d:0.02;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.31;s:5:\"bytes\";i:915;s:11:\"size_before\";i:27677;s:10:\"size_after\";i:26762;s:4:\"time\";d:0.07;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.81;s:5:\"bytes\";i:1181;s:11:\"size_before\";i:42077;s:10:\"size_after\";i:40896;s:4:\"time\";d:0.03;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.7;s:5:\"bytes\";i:2773;s:11:\"size_before\";i:74850;s:10:\"size_after\";i:72077;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.69;s:5:\"bytes\";i:2107;s:11:\"size_before\";i:57129;s:10:\"size_after\";i:55022;s:4:\"time\";d:0.09;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.33;s:5:\"bytes\";i:3715;s:11:\"size_before\";i:85790;s:10:\"size_after\";i:82075;s:4:\"time\";d:0.3;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.78;s:5:\"bytes\";i:11064;s:11:\"size_before\";i:191388;s:10:\"size_after\";i:180324;s:4:\"time\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES("107", "404", "_wp_attached_file", "2016/11/zuperla-feature-07.jpg");
INSERT INTO `wp_postmeta` VALUES("108", "404", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-07.jpg\";s:8:\"filesize\";i:945051;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-07-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9373;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-07-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57897;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-07-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5109;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-07-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35348;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-07-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127536;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-07-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:249292;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-07-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85496;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-07-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29642;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-07-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24845;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-07-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36654;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-07-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:69989;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-07-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53435;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-07-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79516;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("109", "404", "_wp_attached_file", "2016/11/zuperla-feature-07.jpg");
INSERT INTO `wp_postmeta` VALUES("110", "404", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-07.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-07-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-07-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-07-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-07-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-07-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-07-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-07-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-07-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-07-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-07-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-07-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-07-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("111", "404", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.673393650648894;s:5:\"bytes\";i:45369;s:11:\"size_before\";i:679849;s:10:\"size_after\";i:634480;s:4:\"time\";d:1.26;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.1;s:5:\"bytes\";i:260;s:11:\"size_before\";i:5099;s:10:\"size_after\";i:4839;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.42;s:5:\"bytes\";i:472;s:11:\"size_before\";i:13807;s:10:\"size_after\";i:13335;s:4:\"time\";d:0.04;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.77;s:5:\"bytes\";i:1332;s:11:\"size_before\";i:35318;s:10:\"size_after\";i:33986;s:4:\"time\";d:0.08;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.96;s:5:\"bytes\";i:2868;s:11:\"size_before\";i:57869;s:10:\"size_after\";i:55001;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.8;s:5:\"bytes\";i:3580;s:11:\"size_before\";i:61764;s:10:\"size_after\";i:58184;s:4:\"time\";d:0.16;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.42;s:5:\"bytes\";i:1011;s:11:\"size_before\";i:29583;s:10:\"size_after\";i:28572;s:4:\"time\";d:0.08;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.39;s:5:\"bytes\";i:840;s:11:\"size_before\";i:24814;s:10:\"size_after\";i:23974;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.54;s:5:\"bytes\";i:1664;s:11:\"size_before\";i:36616;s:10:\"size_after\";i:34952;s:4:\"time\";d:0.03;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:6;s:5:\"bytes\";i:4198;s:11:\"size_before\";i:69946;s:10:\"size_after\";i:65748;s:4:\"time\";d:0.25;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.77;s:5:\"bytes\";i:2550;s:11:\"size_before\";i:53411;s:10:\"size_after\";i:50861;s:4:\"time\";d:0.13;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.35;s:5:\"bytes\";i:5843;s:11:\"size_before\";i:79516;s:10:\"size_after\";i:73673;s:4:\"time\";d:0.17;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.78;s:5:\"bytes\";i:20751;s:11:\"size_before\";i:212106;s:10:\"size_after\";i:191355;s:4:\"time\";d:0.22;}}}");
INSERT INTO `wp_postmeta` VALUES("112", "406", "_wp_attached_file", "2016/11/zuperla-feature-08.jpg");
INSERT INTO `wp_postmeta` VALUES("113", "406", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-08.jpg\";s:8:\"filesize\";i:991742;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-08-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17918;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-08-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:172874;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-08-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7916;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-08-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:99992;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-08-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:359121;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-08-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:583643;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-08-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:255179;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-08-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85854;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-08-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63448;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-08-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:118087;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-08-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:211423;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-08-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:155289;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-08-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:247742;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("114", "406", "_wp_attached_file", "2016/11/zuperla-feature-08.jpg");
INSERT INTO `wp_postmeta` VALUES("115", "406", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-08.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-08-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-08-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-08-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-08-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-08-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-08-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-08-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-08-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-08-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-08-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-08-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-08-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("116", "406", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:5.060954557713478;s:5:\"bytes\";i:96454;s:11:\"size_before\";i:1905846;s:10:\"size_after\";i:1809392;s:4:\"time\";d:1.9100000000000001;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.9;s:5:\"bytes\";i:546;s:11:\"size_before\";i:7912;s:10:\"size_after\";i:7366;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.98;s:5:\"bytes\";i:1797;s:11:\"size_before\";i:30059;s:10:\"size_after\";i:28262;s:4:\"time\";d:0.03;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.23;s:5:\"bytes\";i:5221;s:11:\"size_before\";i:99871;s:10:\"size_after\";i:94650;s:4:\"time\";d:0.06;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.03;s:5:\"bytes\";i:8676;s:11:\"size_before\";i:172624;s:10:\"size_after\";i:163948;s:4:\"time\";d:0.2;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.94;s:5:\"bytes\";i:9257;s:11:\"size_before\";i:187319;s:10:\"size_after\";i:178062;s:4:\"time\";d:0.19;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.59;s:5:\"bytes\";i:4789;s:11:\"size_before\";i:85725;s:10:\"size_after\";i:80936;s:4:\"time\";d:0.11;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.55;s:5:\"bytes\";i:3517;s:11:\"size_before\";i:63351;s:10:\"size_after\";i:59834;s:4:\"time\";d:0.1;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.67;s:5:\"bytes\";i:6688;s:11:\"size_before\";i:117894;s:10:\"size_after\";i:111206;s:4:\"time\";d:0.15;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.34;s:5:\"bytes\";i:11276;s:11:\"size_before\";i:211074;s:10:\"size_after\";i:199798;s:4:\"time\";d:0.09;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.12;s:5:\"bytes\";i:7932;s:11:\"size_before\";i:155008;s:10:\"size_after\";i:147076;s:4:\"time\";d:0.16;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.27;s:5:\"bytes\";i:13024;s:11:\"size_before\";i:247329;s:10:\"size_after\";i:234305;s:4:\"time\";d:0.24;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.5;s:5:\"bytes\";i:23731;s:11:\"size_before\";i:527680;s:10:\"size_after\";i:503949;s:4:\"time\";d:0.57;}}}");
INSERT INTO `wp_postmeta` VALUES("117", "408", "_wp_attached_file", "2016/11/zuperla-feature-09.jpg");
INSERT INTO `wp_postmeta` VALUES("118", "408", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-09.jpg\";s:8:\"filesize\";i:715639;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-09-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13010;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-09-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:107290;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-09-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5316;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-09-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63587;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-09-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:231174;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-09-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:417078;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-09-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:162048;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-09-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47107;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-09-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40841;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-09-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58941;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-09-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115028;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-09-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:92663;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-09-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:130539;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("119", "408", "_wp_attached_file", "2016/11/zuperla-feature-09.jpg");
INSERT INTO `wp_postmeta` VALUES("120", "408", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/11/zuperla-feature-09.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-09-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-09-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-09-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-09-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-09-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-09-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-09-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-09-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-09-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-09-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-09-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-09-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("121", "408", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:10.401866931411533;s:5:\"bytes\";i:121328;s:11:\"size_before\";i:1166406;s:10:\"size_after\";i:1045078;s:4:\"time\";d:1.39;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.28;s:5:\"bytes\";i:646;s:11:\"size_before\";i:5259;s:10:\"size_after\";i:4613;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:18.92;s:5:\"bytes\";i:4090;s:11:\"size_before\";i:21616;s:10:\"size_after\";i:17526;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.46;s:5:\"bytes\";i:9180;s:11:\"size_before\";i:63497;s:10:\"size_after\";i:54317;s:4:\"time\";d:0.16;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.76;s:5:\"bytes\";i:12599;s:11:\"size_before\";i:107123;s:10:\"size_after\";i:94524;s:4:\"time\";d:0.09;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.47;s:5:\"bytes\";i:13600;s:11:\"size_before\";i:118601;s:10:\"size_after\";i:105001;s:4:\"time\";d:0.31;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.12;s:5:\"bytes\";i:5702;s:11:\"size_before\";i:47062;s:10:\"size_after\";i:41360;s:4:\"time\";d:0.11;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:15.94;s:5:\"bytes\";i:6490;s:11:\"size_before\";i:40721;s:10:\"size_after\";i:34231;s:4:\"time\";d:0.1;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.22;s:5:\"bytes\";i:6024;s:11:\"size_before\";i:58924;s:10:\"size_after\";i:52900;s:4:\"time\";d:0.08;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.37;s:5:\"bytes\";i:10759;s:11:\"size_before\";i:114874;s:10:\"size_after\";i:104115;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.67;s:5:\"bytes\";i:10797;s:11:\"size_before\";i:92500;s:10:\"size_after\";i:81703;s:4:\"time\";d:0.05;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.59;s:5:\"bytes\";i:11207;s:11:\"size_before\";i:130450;s:10:\"size_after\";i:119243;s:4:\"time\";d:0.18;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.27;s:5:\"bytes\";i:30234;s:11:\"size_before\";i:365779;s:10:\"size_after\";i:335545;s:4:\"time\";d:0.2;}}}");
INSERT INTO `wp_postmeta` VALUES("122", "410", "_wp_attached_file", "2016/10/zuperla-feature-10.jpg");
INSERT INTO `wp_postmeta` VALUES("123", "410", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1709;s:4:\"file\";s:30:\"2016/10/zuperla-feature-10.jpg\";s:8:\"filesize\";i:983836;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-10-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11575;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-10-1024x684.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:684;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:96681;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5729;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-10-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57586;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-10-1536x1025.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1025;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:203328;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-10-2048x1367.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1367;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:347357;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-10-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:147556;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-10-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50291;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-10-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36737;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-10-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68402;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-10-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:117116;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-10-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85699;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-10-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140347;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("124", "410", "_wp_attached_file", "2016/10/zuperla-feature-10.jpg");
INSERT INTO `wp_postmeta` VALUES("125", "410", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1709;s:4:\"file\";s:30:\"2016/10/zuperla-feature-10.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-10-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-10-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-10-1024x684.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:684;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-10-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-10-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-10-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-10-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-10-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-10-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-10-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-10-1920x1282.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1282;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("126", "410", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:4.5022643875914845;s:5:\"bytes\";i:49250;s:11:\"size_before\";i:1093894;s:10:\"size_after\";i:1044644;s:4:\"time\";d:1.2;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.79;s:5:\"bytes\";i:332;s:11:\"size_before\";i:5733;s:10:\"size_after\";i:5401;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.96;s:5:\"bytes\";i:735;s:11:\"size_before\";i:18544;s:10:\"size_after\";i:17809;s:4:\"time\";d:0.08;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.26;s:5:\"bytes\";i:2449;s:11:\"size_before\";i:57486;s:10:\"size_after\";i:55037;s:4:\"time\";d:0.04;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.5;s:5:\"bytes\";i:4342;s:11:\"size_before\";i:96582;s:10:\"size_after\";i:92240;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.64;s:5:\"bytes\";i:5002;s:11:\"size_before\";i:107780;s:10:\"size_after\";i:102778;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.44;s:5:\"bytes\";i:2233;s:11:\"size_before\";i:50246;s:10:\"size_after\";i:48013;s:4:\"time\";d:0.09;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.17;s:5:\"bytes\";i:1529;s:11:\"size_before\";i:36682;s:10:\"size_after\";i:35153;s:4:\"time\";d:0.06;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.29;s:5:\"bytes\";i:2930;s:11:\"size_before\";i:68289;s:10:\"size_after\";i:65359;s:4:\"time\";d:0.09;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.29;s:5:\"bytes\";i:5024;s:11:\"size_before\";i:117048;s:10:\"size_after\";i:112024;s:4:\"time\";d:0.1;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.49;s:5:\"bytes\";i:3844;s:11:\"size_before\";i:85682;s:10:\"size_after\";i:81838;s:4:\"time\";d:0.16;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.13;s:5:\"bytes\";i:5797;s:11:\"size_before\";i:140292;s:10:\"size_after\";i:134495;s:4:\"time\";d:0.24;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.86;s:5:\"bytes\";i:15033;s:11:\"size_before\";i:309530;s:10:\"size_after\";i:294497;s:4:\"time\";d:0.22;}}}");
INSERT INTO `wp_postmeta` VALUES("127", "412", "_wp_attached_file", "2016/10/zuperla-feature-11.jpg");
INSERT INTO `wp_postmeta` VALUES("128", "412", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/10/zuperla-feature-11.jpg\";s:8:\"filesize\";i:990170;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-11-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6167;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-11-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39351;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3864;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-11-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23162;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-11-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:90895;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-11-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:178102;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-11-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62465;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-11-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21828;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-11-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16215;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-11-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28716;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-11-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53234;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-11-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36132;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-11-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63320;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("129", "412", "_wp_attached_file", "2016/10/zuperla-feature-11.jpg");
INSERT INTO `wp_postmeta` VALUES("130", "412", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/10/zuperla-feature-11.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-11-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-11-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-11-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-11-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-11-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-11-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-11-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-11-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-11-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-11-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-11-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("131", "412", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.18449560540202;s:5:\"bytes\";i:45028;s:11:\"size_before\";i:490261;s:10:\"size_after\";i:445233;s:4:\"time\";d:1.1199999999999999;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.84;s:5:\"bytes\";i:148;s:11:\"size_before\";i:3855;s:10:\"size_after\";i:3707;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.5;s:5:\"bytes\";i:229;s:11:\"size_before\";i:9149;s:10:\"size_after\";i:8920;s:4:\"time\";d:0.05;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.27;s:5:\"bytes\";i:1218;s:11:\"size_before\";i:23120;s:10:\"size_after\";i:21902;s:4:\"time\";d:0.03;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.87;s:5:\"bytes\";i:3087;s:11:\"size_before\";i:39246;s:10:\"size_after\";i:36159;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.32;s:5:\"bytes\";i:4097;s:11:\"size_before\";i:43946;s:10:\"size_after\";i:39849;s:4:\"time\";d:0.12;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.57;s:5:\"bytes\";i:994;s:11:\"size_before\";i:21765;s:10:\"size_after\";i:20771;s:4:\"time\";d:0.02;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.88;s:5:\"bytes\";i:628;s:11:\"size_before\";i:16183;s:10:\"size_after\";i:15555;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.97;s:5:\"bytes\";i:1709;s:11:\"size_before\";i:28641;s:10:\"size_after\";i:26932;s:4:\"time\";d:0.06;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.52;s:5:\"bytes\";i:4529;s:11:\"size_before\";i:53164;s:10:\"size_after\";i:48635;s:4:\"time\";d:0.05;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.41;s:5:\"bytes\";i:2673;s:11:\"size_before\";i:36083;s:10:\"size_after\";i:33410;s:4:\"time\";d:0.11;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.64;s:5:\"bytes\";i:6094;s:11:\"size_before\";i:63209;s:10:\"size_after\";i:57115;s:4:\"time\";d:0.19;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.92;s:5:\"bytes\";i:19622;s:11:\"size_before\";i:151900;s:10:\"size_after\";i:132278;s:4:\"time\";d:0.41;}}}");
INSERT INTO `wp_postmeta` VALUES("132", "414", "_wp_attached_file", "2016/10/zuperla-feature-12.jpg");
INSERT INTO `wp_postmeta` VALUES("133", "414", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/10/zuperla-feature-12.jpg\";s:8:\"filesize\";i:874919;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15535;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-12-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:157958;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6391;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-12-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93564;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-12-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:314223;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-12-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:506576;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-12-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:223724;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-12-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:74695;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-12-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58689;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-12-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93158;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-12-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:173145;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-12-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:139209;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-12-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:184326;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("134", "414", "_wp_attached_file", "2016/10/zuperla-feature-12.jpg");
INSERT INTO `wp_postmeta` VALUES("135", "414", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:30:\"2016/10/zuperla-feature-12.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-12-400x267.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-12-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-12-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-12-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-12-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-12-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-12-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-12-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-12-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-12-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-12-1920x1280.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("136", "414", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.5022383900739187;s:5:\"bytes\";i:57187;s:11:\"size_before\";i:1632870;s:10:\"size_after\";i:1575683;s:4:\"time\";d:1.7700000000000002;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.76;s:5:\"bytes\";i:368;s:11:\"size_before\";i:6384;s:10:\"size_after\";i:6016;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.8;s:5:\"bytes\";i:1328;s:11:\"size_before\";i:27682;s:10:\"size_after\";i:26354;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.98;s:5:\"bytes\";i:3717;s:11:\"size_before\";i:93403;s:10:\"size_after\";i:89686;s:4:\"time\";d:0.14;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.67;s:5:\"bytes\";i:5781;s:11:\"size_before\";i:157683;s:10:\"size_after\";i:151902;s:4:\"time\";d:0.14;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.47;s:5:\"bytes\";i:5848;s:11:\"size_before\";i:168442;s:10:\"size_after\";i:162594;s:4:\"time\";d:0.19;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.93;s:5:\"bytes\";i:2935;s:11:\"size_before\";i:74588;s:10:\"size_after\";i:71653;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.27;s:5:\"bytes\";i:2499;s:11:\"size_before\";i:58493;s:10:\"size_after\";i:55994;s:4:\"time\";d:0.07;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.57;s:5:\"bytes\";i:3324;s:11:\"size_before\";i:93027;s:10:\"size_after\";i:89703;s:4:\"time\";d:0.09;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.46;s:5:\"bytes\";i:5984;s:11:\"size_before\";i:172934;s:10:\"size_after\";i:166950;s:4:\"time\";d:0.24;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.76;s:5:\"bytes\";i:5235;s:11:\"size_before\";i:139077;s:10:\"size_after\";i:133842;s:4:\"time\";d:0.14;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.16;s:5:\"bytes\";i:5811;s:11:\"size_before\";i:184110;s:10:\"size_after\";i:178299;s:4:\"time\";d:0.1;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.14;s:5:\"bytes\";i:14357;s:11:\"size_before\";i:457047;s:10:\"size_after\";i:442690;s:4:\"time\";d:0.55;}}}");
INSERT INTO `wp_postmeta` VALUES("137", "420", "_wp_attached_file", "2017/07/zuperla-logo-dark.png");
INSERT INTO `wp_postmeta` VALUES("138", "420", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:29:\"2017/07/zuperla-logo-dark.png\";s:8:\"filesize\";i:957;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("139", "420", "_wp_attached_file", "2017/07/zuperla-logo-dark.png");
INSERT INTO `wp_postmeta` VALUES("140", "420", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:29:\"2017/07/zuperla-logo-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("141", "420", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:40.92896174863388;s:5:\"bytes\";i:749;s:11:\"size_before\";i:1830;s:10:\"size_after\";i:1081;s:4:\"time\";d:0.06;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:40.93;s:5:\"bytes\";i:749;s:11:\"size_before\";i:1830;s:10:\"size_after\";i:1081;s:4:\"time\";d:0.06;}}}");
INSERT INTO `wp_postmeta` VALUES("142", "421", "_wp_attached_file", "2017/07/zuperla-logo-light.png");
INSERT INTO `wp_postmeta` VALUES("143", "421", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:30:\"2017/07/zuperla-logo-light.png\";s:8:\"filesize\";i:956;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("144", "421", "_wp_attached_file", "2017/07/zuperla-logo-light.png");
INSERT INTO `wp_postmeta` VALUES("145", "421", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:30:\"2017/07/zuperla-logo-light.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("146", "421", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:40.074906367041194;s:5:\"bytes\";i:749;s:11:\"size_before\";i:1869;s:10:\"size_after\";i:1120;s:4:\"time\";d:0.02;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:40.07;s:5:\"bytes\";i:749;s:11:\"size_before\";i:1869;s:10:\"size_after\";i:1120;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("147", "437", "_wp_attached_file", "2017/07/zuperla-banner.jpg");
INSERT INTO `wp_postmeta` VALUES("148", "437", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2340;s:6:\"height\";i:300;s:4:\"file\";s:26:\"2017/07/zuperla-banner.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"zuperla-banner-400x51.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:51;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"zuperla-banner-768x98.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:98;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"zuperla-banner-1024x131.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:131;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:27:\"zuperla-banner-1390x300.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-560x300.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-900x300.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-900x300.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:26:\"zuperla-banner-840x300.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:27:\"zuperla-banner-1920x246.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("149", "437", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.465474576141334;s:5:\"bytes\";i:24710;s:11:\"size_before\";i:261054;s:10:\"size_after\";i:236344;s:4:\"time\";d:0.64;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.51;s:5:\"bytes\";i:668;s:11:\"size_before\";i:5340;s:10:\"size_after\";i:4672;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.56;s:5:\"bytes\";i:328;s:11:\"size_before\";i:4341;s:10:\"size_after\";i:4013;s:4:\"time\";d:0.01;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.73;s:5:\"bytes\";i:1070;s:11:\"size_before\";i:10994;s:10:\"size_after\";i:9924;s:4:\"time\";d:0.01;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.82;s:5:\"bytes\";i:1824;s:11:\"size_before\";i:16851;s:10:\"size_after\";i:15027;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.67;s:5:\"bytes\";i:4949;s:11:\"size_before\";i:36209;s:10:\"size_after\";i:31260;s:4:\"time\";d:0.15;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.4;s:5:\"bytes\";i:2900;s:11:\"size_before\";i:21637;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18737;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.01;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18737;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.04;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.23;s:5:\"bytes\";i:4223;s:11:\"size_before\";i:31926;s:10:\"size_after\";i:27703;s:4:\"time\";d:0.02;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:27703;s:10:\"size_after\";i:27703;s:4:\"time\";d:0.18;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.3;s:5:\"bytes\";i:4041;s:11:\"size_before\";i:30374;s:10:\"size_after\";i:26333;s:4:\"time\";d:0.03;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.32;s:5:\"bytes\";i:4707;s:11:\"size_before\";i:38205;s:10:\"size_after\";i:33498;s:4:\"time\";d:0.08;}}}");
INSERT INTO `wp_postmeta` VALUES("150", "443", "_wp_attached_file", "2017/07/zuperla-category-01.jpg");
INSERT INTO `wp_postmeta` VALUES("151", "443", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-01.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"zuperla-category-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("152", "443", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:10.957104381527952;s:5:\"bytes\";i:6672;s:11:\"size_before\";i:60892;s:10:\"size_after\";i:54220;s:4:\"time\";d:0.07;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.28;s:5:\"bytes\";i:564;s:11:\"size_before\";i:7750;s:10:\"size_after\";i:7186;s:4:\"time\";d:0.03;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.49;s:5:\"bytes\";i:6108;s:11:\"size_before\";i:53142;s:10:\"size_after\";i:47034;s:4:\"time\";d:0.04;}}}");
INSERT INTO `wp_postmeta` VALUES("153", "444", "_wp_attached_file", "2017/07/zuperla-category-01@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("154", "444", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-01@2x.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-400x299.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:299;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:34:\"zuperla-category-01@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("155", "444", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.060055020561272;s:5:\"bytes\";i:23328;s:11:\"size_before\";i:384947;s:10:\"size_after\";i:361619;s:4:\"time\";d:0.37;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.2;s:5:\"bytes\";i:575;s:11:\"size_before\";i:7983;s:10:\"size_after\";i:7408;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.39;s:5:\"bytes\";i:1566;s:11:\"size_before\";i:29035;s:10:\"size_after\";i:27469;s:4:\"time\";d:0.04;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.8;s:5:\"bytes\";i:3081;s:11:\"size_before\";i:64204;s:10:\"size_after\";i:61123;s:4:\"time\";d:0.1;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.7;s:5:\"bytes\";i:2288;s:11:\"size_before\";i:48705;s:10:\"size_after\";i:46417;s:4:\"time\";d:0.12;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:61123;s:10:\"size_after\";i:61123;s:4:\"time\";d:0.04;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.1;s:5:\"bytes\";i:15818;s:11:\"size_before\";i:173897;s:10:\"size_after\";i:158079;s:4:\"time\";d:0.06;}}}");
INSERT INTO `wp_postmeta` VALUES("156", "447", "_wp_attached_file", "2017/07/zuperla-category-02.jpg");
INSERT INTO `wp_postmeta` VALUES("157", "447", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-02.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"zuperla-category-02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("158", "447", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.208456637073768;s:5:\"bytes\";i:3454;s:11:\"size_before\";i:37509;s:10:\"size_after\";i:34055;s:4:\"time\";d:0.04;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.52;s:5:\"bytes\";i:247;s:11:\"size_before\";i:5468;s:10:\"size_after\";i:5221;s:4:\"time\";d:0.02;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.01;s:5:\"bytes\";i:3207;s:11:\"size_before\";i:32041;s:10:\"size_after\";i:28834;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("159", "448", "_wp_attached_file", "2017/07/zuperla-category-02@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("160", "448", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-02@2x.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-400x299.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:299;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:34:\"zuperla-category-02@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("161", "448", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.9524539739761284;s:5:\"bytes\";i:8815;s:11:\"size_before\";i:223026;s:10:\"size_after\";i:214211;s:4:\"time\";d:0.41000000000000003;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67;s:5:\"bytes\";i:260;s:11:\"size_before\";i:5569;s:10:\"size_after\";i:5309;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:3;s:5:\"bytes\";i:519;s:11:\"size_before\";i:17291;s:10:\"size_after\";i:16772;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.47;s:5:\"bytes\";i:937;s:11:\"size_before\";i:37951;s:10:\"size_after\";i:37014;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.38;s:5:\"bytes\";i:676;s:11:\"size_before\";i:28427;s:10:\"size_after\";i:27751;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:37014;s:10:\"size_after\";i:37014;s:4:\"time\";d:0.13;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.64;s:5:\"bytes\";i:6423;s:11:\"size_before\";i:96774;s:10:\"size_after\";i:90351;s:4:\"time\";d:0.16;}}}");
INSERT INTO `wp_postmeta` VALUES("162", "449", "_wp_attached_file", "2017/07/zuperla-category-03.jpg");
INSERT INTO `wp_postmeta` VALUES("163", "449", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:370;s:6:\"height\";i:277;s:4:\"file\";s:31:\"2017/07/zuperla-category-03.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"zuperla-category-03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("164", "449", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.674478125249939;s:5:\"bytes\";i:6048;s:11:\"size_before\";i:62515;s:10:\"size_after\";i:56467;s:4:\"time\";d:0.05;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.73;s:5:\"bytes\";i:389;s:11:\"size_before\";i:8231;s:10:\"size_after\";i:7842;s:4:\"time\";d:0.03;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.42;s:5:\"bytes\";i:5659;s:11:\"size_before\";i:54284;s:10:\"size_after\";i:48625;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("165", "450", "_wp_attached_file", "2017/07/zuperla-category-03@2x.jpg");
INSERT INTO `wp_postmeta` VALUES("166", "450", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:740;s:6:\"height\";i:554;s:4:\"file\";s:34:\"2017/07/zuperla-category-03@2x.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-400x299.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:299;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:34:\"zuperla-category-03@2x-560x554.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("167", "450", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.740765448304802;s:5:\"bytes\";i:31324;s:11:\"size_before\";i:464695;s:10:\"size_after\";i:433371;s:4:\"time\";d:0.35000000000000003;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.58;s:5:\"bytes\";i:389;s:11:\"size_before\";i:8501;s:10:\"size_after\";i:8112;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.88;s:5:\"bytes\";i:1624;s:11:\"size_before\";i:33258;s:10:\"size_after\";i:31634;s:4:\"time\";d:0.05;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.38;s:5:\"bytes\";i:5292;s:11:\"size_before\";i:82983;s:10:\"size_after\";i:77691;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.7;s:5:\"bytes\";i:3353;s:11:\"size_before\";i:58798;s:10:\"size_after\";i:55445;s:4:\"time\";d:0.04;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:77691;s:10:\"size_after\";i:77691;s:4:\"time\";d:0.12;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.16;s:5:\"bytes\";i:20666;s:11:\"size_before\";i:203464;s:10:\"size_after\";i:182798;s:4:\"time\";d:0.08;}}}");
INSERT INTO `wp_postmeta` VALUES("168", "468", "_wp_attached_file", "2017/07/zuperla-footer-logo.png");
INSERT INTO `wp_postmeta` VALUES("169", "468", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:60;s:6:\"height\";i:60;s:4:\"file\";s:31:\"2017/07/zuperla-footer-logo.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("170", "468", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:39.94190268700073;s:5:\"bytes\";i:550;s:11:\"size_before\";i:1377;s:10:\"size_after\";i:827;s:4:\"time\";d:0.02;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:39.94;s:5:\"bytes\";i:550;s:11:\"size_before\";i:1377;s:10:\"size_after\";i:827;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("171", "469", "_wp_attached_file", "2017/07/zuperla-footer-logo@2x.png");
INSERT INTO `wp_postmeta` VALUES("172", "469", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:34:\"2017/07/zuperla-footer-logo@2x.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("173", "469", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:37.58389261744966;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:2831;s:10:\"size_after\";i:1767;s:4:\"time\";d:0.05;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:37.58;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:2831;s:10:\"size_after\";i:1767;s:4:\"time\";d:0.05;}}}");
INSERT INTO `wp_postmeta` VALUES("174", "472", "_wp_attached_file", "2017/07/zuperla-img-01.jpg");
INSERT INTO `wp_postmeta` VALUES("175", "472", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:854;s:4:\"file\";s:26:\"2017/07/zuperla-img-01.jpg\";s:8:\"filesize\";i:319176;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11509;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"zuperla-img-01-1024x767.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:767;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:119485;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4229;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-768x575.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71262;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:27:\"zuperla-img-01-1140x782.jpg\";s:5:\"width\";i:1140;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:156824;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48056;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39230;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54375;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-900x854.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127983;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:96427;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:26:\"zuperla-img-01-840x854.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:116728;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("176", "472", "_wp_attached_file", "2017/07/zuperla-img-01.jpg");
INSERT INTO `wp_postmeta` VALUES("177", "472", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:854;s:4:\"file\";s:26:\"2017/07/zuperla-img-01.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-400x300.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-768x575.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"zuperla-img-01-1024x767.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:767;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:27:\"zuperla-img-01-1140x782.jpg\";s:5:\"width\";i:1140;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-900x854.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:26:\"zuperla-img-01-840x854.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("178", "472", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:8.485494301397049;s:5:\"bytes\";i:70633;s:11:\"size_before\";i:832397;s:10:\"size_after\";i:761764;s:4:\"time\";d:0.7899999999999998;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:11:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.38;s:5:\"bytes\";i:270;s:11:\"size_before\";i:4231;s:10:\"size_after\";i:3961;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.94;s:5:\"bytes\";i:1590;s:11:\"size_before\";i:20018;s:10:\"size_after\";i:18428;s:4:\"time\";d:0.07;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.76;s:5:\"bytes\";i:6267;s:11:\"size_before\";i:71532;s:10:\"size_after\";i:65265;s:4:\"time\";d:0.09;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.65;s:5:\"bytes\";i:10346;s:11:\"size_before\";i:119675;s:10:\"size_after\";i:109329;s:4:\"time\";d:0.14;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.74;s:5:\"bytes\";i:11757;s:11:\"size_before\";i:134484;s:10:\"size_after\";i:122727;s:4:\"time\";d:0.1;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.93;s:5:\"bytes\";i:3822;s:11:\"size_before\";i:48211;s:10:\"size_after\";i:44389;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.45;s:5:\"bytes\";i:3314;s:11:\"size_before\";i:39242;s:10:\"size_after\";i:35928;s:4:\"time\";d:0.04;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.45;s:5:\"bytes\";i:4045;s:11:\"size_before\";i:54320;s:10:\"size_after\";i:50275;s:4:\"time\";d:0.08;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.51;s:5:\"bytes\";i:10861;s:11:\"size_before\";i:127690;s:10:\"size_after\";i:116829;s:4:\"time\";d:0.07;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.62;s:5:\"bytes\";i:8328;s:11:\"size_before\";i:96557;s:10:\"size_after\";i:88229;s:4:\"time\";d:0.08;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.62;s:5:\"bytes\";i:10033;s:11:\"size_before\";i:116437;s:10:\"size_after\";i:106404;s:4:\"time\";d:0.07;}}}");
INSERT INTO `wp_postmeta` VALUES("179", "491", "_wp_attached_file", "2017/07/zuperla-feature-13.jpg");
INSERT INTO `wp_postmeta` VALUES("180", "491", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1498;s:4:\"file\";s:30:\"2017/07/zuperla-feature-13.jpg\";s:8:\"filesize\";i:789569;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-13-300x176.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6825;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-13-1024x599.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:77339;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3633;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-13-768x449.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:449;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42099;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-13-1536x899.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:899;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:186808;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"zuperla-feature-13-2048x1198.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1198;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:337937;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-13-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:144825;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-13-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42623;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-13-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29271;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-13-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:60934;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-13-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:121192;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:30:\"zuperla-feature-13-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:82074;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:31:\"zuperla-feature-13-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:146921;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("181", "491", "_wp_attached_file", "2017/07/zuperla-feature-13.jpg");
INSERT INTO `wp_postmeta` VALUES("182", "491", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1498;s:4:\"file\";s:30:\"2017/07/zuperla-feature-13.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-13-400x234.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:234;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-13-768x449.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:449;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-13-1024x599.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-13-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-13-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-13-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-13-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-13-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:30:\"zuperla-feature-13-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:31:\"zuperla-feature-13-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:32:\"zuperla-feature-13-1920x1124.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1124;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("183", "491", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:7.144270145944239;s:5:\"bytes\";i:72591;s:11:\"size_before\";i:1016073;s:10:\"size_after\";i:943482;s:4:\"time\";d:1.4000000000000001;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.67;s:5:\"bytes\";i:242;s:11:\"size_before\";i:3629;s:10:\"size_after\";i:3387;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.62;s:5:\"bytes\";i:764;s:11:\"size_before\";i:11541;s:10:\"size_after\";i:10777;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.06;s:5:\"bytes\";i:3391;s:11:\"size_before\";i:42062;s:10:\"size_after\";i:38671;s:4:\"time\";d:0.05;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.99;s:5:\"bytes\";i:6177;s:11:\"size_before\";i:77322;s:10:\"size_after\";i:71145;s:4:\"time\";d:0.13;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.81;s:5:\"bytes\";i:7857;s:11:\"size_before\";i:100552;s:10:\"size_after\";i:92695;s:4:\"time\";d:0.21;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.67;s:5:\"bytes\";i:3266;s:11:\"size_before\";i:42601;s:10:\"size_after\";i:39335;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.13;s:5:\"bytes\";i:2378;s:11:\"size_before\";i:29254;s:10:\"size_after\";i:26876;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.85;s:5:\"bytes\";i:4781;s:11:\"size_before\";i:60938;s:10:\"size_after\";i:56157;s:4:\"time\";d:0.07;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.08;s:5:\"bytes\";i:8576;s:11:\"size_before\";i:121196;s:10:\"size_after\";i:112620;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.97;s:5:\"bytes\";i:6545;s:11:\"size_before\";i:82070;s:10:\"size_after\";i:75525;s:4:\"time\";d:0.05;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.47;s:5:\"bytes\";i:9511;s:11:\"size_before\";i:146912;s:10:\"size_after\";i:137401;s:4:\"time\";d:0.43;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.41;s:5:\"bytes\";i:19103;s:11:\"size_before\";i:297996;s:10:\"size_after\";i:278893;s:4:\"time\";d:0.27;}}}");
INSERT INTO `wp_postmeta` VALUES("184", "510", "_wp_attached_file", "2017/07/thumbnail.png");
INSERT INTO `wp_postmeta` VALUES("185", "510", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:21:\"2017/07/thumbnail.png\";s:8:\"filesize\";i:1698;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("186", "510", "_wp_attached_file", "2017/07/thumbnail.png");
INSERT INTO `wp_postmeta` VALUES("187", "510", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:21:\"2017/07/thumbnail.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("188", "393", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:12.994693518669889;s:5:\"bytes\";i:58821;s:11:\"size_before\";i:452654;s:10:\"size_after\";i:393833;s:4:\"time\";d:1.1;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.63;s:5:\"bytes\";i:241;s:11:\"size_before\";i:3158;s:10:\"size_after\";i:2917;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.81;s:5:\"bytes\";i:850;s:11:\"size_before\";i:7866;s:10:\"size_after\";i:7016;s:4:\"time\";d:0.04;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.67;s:5:\"bytes\";i:3076;s:11:\"size_before\";i:22507;s:10:\"size_after\";i:19431;s:4:\"time\";d:0.05;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.73;s:5:\"bytes\";i:5528;s:11:\"size_before\";i:37541;s:10:\"size_after\";i:32013;s:4:\"time\";d:0.1;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:15.31;s:5:\"bytes\";i:6396;s:11:\"size_before\";i:41789;s:10:\"size_after\";i:35393;s:4:\"time\";d:0.08;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.45;s:5:\"bytes\";i:2361;s:11:\"size_before\";i:22589;s:10:\"size_after\";i:20228;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.46;s:5:\"bytes\";i:1941;s:11:\"size_before\";i:15582;s:10:\"size_after\";i:13641;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.85;s:5:\"bytes\";i:3098;s:11:\"size_before\";i:31451;s:10:\"size_after\";i:28353;s:4:\"time\";d:0.08;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.62;s:5:\"bytes\";i:6152;s:11:\"size_before\";i:52932;s:10:\"size_after\";i:46780;s:4:\"time\";d:0.1;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.91;s:5:\"bytes\";i:4928;s:11:\"size_before\";i:35430;s:10:\"size_after\";i:30502;s:4:\"time\";d:0.04;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.45;s:5:\"bytes\";i:6734;s:11:\"size_before\";i:64420;s:10:\"size_after\";i:57686;s:4:\"time\";d:0.24;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.92;s:5:\"bytes\";i:17516;s:11:\"size_before\";i:117389;s:10:\"size_after\";i:99873;s:4:\"time\";d:0.28;}}}");
INSERT INTO `wp_postmeta` VALUES("189", "394", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:4.657229066664165;s:5:\"bytes\";i:34744;s:11:\"size_before\";i:746023;s:10:\"size_after\";i:711279;s:4:\"time\";d:1.57;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.89;s:5:\"bytes\";i:322;s:11:\"size_before\";i:5463;s:10:\"size_after\";i:5141;s:4:\"time\";d:0.04;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.84;s:5:\"bytes\";i:651;s:11:\"size_before\";i:16973;s:10:\"size_after\";i:16322;s:4:\"time\";d:0.04;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.4;s:5:\"bytes\";i:1990;s:11:\"size_before\";i:45272;s:10:\"size_after\";i:43282;s:4:\"time\";d:0.03;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.62;s:5:\"bytes\";i:3278;s:11:\"size_before\";i:70951;s:10:\"size_after\";i:67673;s:4:\"time\";d:0.12;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.31;s:5:\"bytes\";i:3211;s:11:\"size_before\";i:74512;s:10:\"size_after\";i:71301;s:4:\"time\";d:0.24;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.25;s:5:\"bytes\";i:1630;s:11:\"size_before\";i:38343;s:10:\"size_after\";i:36713;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.02;s:5:\"bytes\";i:1256;s:11:\"size_before\";i:31211;s:10:\"size_after\";i:29955;s:4:\"time\";d:0.03;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.16;s:5:\"bytes\";i:1957;s:11:\"size_before\";i:47083;s:10:\"size_after\";i:45126;s:4:\"time\";d:0.11;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.47;s:5:\"bytes\";i:3568;s:11:\"size_before\";i:79764;s:10:\"size_after\";i:76196;s:4:\"time\";d:0.26;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.52;s:5:\"bytes\";i:2902;s:11:\"size_before\";i:64253;s:10:\"size_after\";i:61351;s:4:\"time\";d:0.12;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.51;s:5:\"bytes\";i:3890;s:11:\"size_before\";i:86345;s:10:\"size_after\";i:82455;s:4:\"time\";d:0.35;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.43;s:5:\"bytes\";i:10089;s:11:\"size_before\";i:185853;s:10:\"size_after\";i:175764;s:4:\"time\";d:0.16;}}}");
INSERT INTO `wp_postmeta` VALUES("190", "396", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:5.962521832453021;s:5:\"bytes\";i:113338;s:11:\"size_before\";i:1900840;s:10:\"size_after\";i:1787502;s:4:\"time\";d:1.1099999999999999;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.36;s:5:\"bytes\";i:375;s:11:\"size_before\";i:8608;s:10:\"size_after\";i:8233;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.4;s:5:\"bytes\";i:1346;s:11:\"size_before\";i:30610;s:10:\"size_after\";i:29264;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.15;s:5:\"bytes\";i:6128;s:11:\"size_before\";i:99719;s:10:\"size_after\";i:93591;s:4:\"time\";d:0.1;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.17;s:5:\"bytes\";i:10390;s:11:\"size_before\";i:168457;s:10:\"size_after\";i:158067;s:4:\"time\";d:0.08;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.9;s:5:\"bytes\";i:10985;s:11:\"size_before\";i:186114;s:10:\"size_after\";i:175129;s:4:\"time\";d:0.07;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.26;s:5:\"bytes\";i:5416;s:11:\"size_before\";i:86459;s:10:\"size_after\";i:81043;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.52;s:5:\"bytes\";i:3543;s:11:\"size_before\";i:64131;s:10:\"size_after\";i:60588;s:4:\"time\";d:0.07;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.02;s:5:\"bytes\";i:6857;s:11:\"size_before\";i:113963;s:10:\"size_after\";i:107106;s:4:\"time\";d:0.05;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.94;s:5:\"bytes\";i:12259;s:11:\"size_before\";i:206341;s:10:\"size_after\";i:194082;s:4:\"time\";d:0.09;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.27;s:5:\"bytes\";i:9545;s:11:\"size_before\";i:152341;s:10:\"size_after\";i:142796;s:4:\"time\";d:0.18;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.65;s:5:\"bytes\";i:13631;s:11:\"size_before\";i:241197;s:10:\"size_after\";i:227566;s:4:\"time\";d:0.14;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.05;s:5:\"bytes\";i:32863;s:11:\"size_before\";i:542900;s:10:\"size_after\";i:510037;s:4:\"time\";d:0.26;}}}");
INSERT INTO `wp_postmeta` VALUES("191", "398", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:5.062486298316854;s:5:\"bytes\";i:76436;s:11:\"size_before\";i:1509851;s:10:\"size_after\";i:1433415;s:4:\"time\";d:2;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.42;s:5:\"bytes\";i:600;s:11:\"size_before\";i:8087;s:10:\"size_after\";i:7487;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.65;s:5:\"bytes\";i:1602;s:11:\"size_before\";i:28340;s:10:\"size_after\";i:26738;s:4:\"time\";d:0.11;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.74;s:5:\"bytes\";i:3989;s:11:\"size_before\";i:84189;s:10:\"size_after\";i:80200;s:4:\"time\";d:0.14;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.92;s:5:\"bytes\";i:6921;s:11:\"size_before\";i:140747;s:10:\"size_after\";i:133826;s:4:\"time\";d:0.17;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.85;s:5:\"bytes\";i:7446;s:11:\"size_before\";i:153582;s:10:\"size_after\";i:146136;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.94;s:5:\"bytes\";i:3272;s:11:\"size_before\";i:66239;s:10:\"size_after\";i:62967;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.03;s:5:\"bytes\";i:2690;s:11:\"size_before\";i:53519;s:10:\"size_after\";i:50829;s:4:\"time\";d:0.03;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.9;s:5:\"bytes\";i:4181;s:11:\"size_before\";i:85264;s:10:\"size_after\";i:81083;s:4:\"time\";d:0.06;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.92;s:5:\"bytes\";i:7587;s:11:\"size_before\";i:154265;s:10:\"size_after\";i:146678;s:4:\"time\";d:0.26;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.89;s:5:\"bytes\";i:5971;s:11:\"size_before\";i:121997;s:10:\"size_after\";i:116026;s:4:\"time\";d:0.08;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.1;s:5:\"bytes\";i:9031;s:11:\"size_before\";i:177007;s:10:\"size_after\";i:167976;s:4:\"time\";d:0.18;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.3;s:5:\"bytes\";i:23146;s:11:\"size_before\";i:436615;s:10:\"size_after\";i:413469;s:4:\"time\";d:0.86;}}}");
INSERT INTO `wp_postmeta` VALUES("192", "400", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.7929464065614047;s:5:\"bytes\";i:45390;s:11:\"size_before\";i:1196695;s:10:\"size_after\";i:1151305;s:4:\"time\";d:1.1199999999999999;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.82;s:5:\"bytes\";i:407;s:11:\"size_before\";i:6997;s:10:\"size_after\";i:6590;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.82;s:5:\"bytes\";i:1275;s:11:\"size_before\";i:26432;s:10:\"size_after\";i:25157;s:4:\"time\";d:0.05;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.61;s:5:\"bytes\";i:3534;s:11:\"size_before\";i:76594;s:10:\"size_after\";i:73060;s:4:\"time\";d:0.1;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.25;s:5:\"bytes\";i:5190;s:11:\"size_before\";i:121992;s:10:\"size_after\";i:116802;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.14;s:5:\"bytes\";i:5341;s:11:\"size_before\";i:129152;s:10:\"size_after\";i:123811;s:4:\"time\";d:0.17;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.43;s:5:\"bytes\";i:2529;s:11:\"size_before\";i:57047;s:10:\"size_after\";i:54518;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.58;s:5:\"bytes\";i:2319;s:11:\"size_before\";i:50602;s:10:\"size_after\";i:48283;s:4:\"time\";d:0.03;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.69;s:5:\"bytes\";i:2360;s:11:\"size_before\";i:63906;s:10:\"size_after\";i:61546;s:4:\"time\";d:0.1;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.46;s:5:\"bytes\";i:4190;s:11:\"size_before\";i:121123;s:10:\"size_after\";i:116933;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.41;s:5:\"bytes\";i:4824;s:11:\"size_before\";i:109429;s:10:\"size_after\";i:104605;s:4:\"time\";d:0.12;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.68;s:5:\"bytes\";i:3156;s:11:\"size_before\";i:117569;s:10:\"size_after\";i:114413;s:4:\"time\";d:0.16;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.25;s:5:\"bytes\";i:10265;s:11:\"size_before\";i:315852;s:10:\"size_after\";i:305587;s:4:\"time\";d:0.19;}}}");
INSERT INTO `wp_postmeta` VALUES("193", "402", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:4.243357347862527;s:5:\"bytes\";i:29821;s:11:\"size_before\";i:702769;s:10:\"size_after\";i:672948;s:4:\"time\";d:1.44;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.67;s:5:\"bytes\";i:333;s:11:\"size_before\";i:5869;s:10:\"size_after\";i:5536;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.49;s:5:\"bytes\";i:540;s:11:\"size_before\";i:15487;s:10:\"size_after\";i:14947;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.41;s:5:\"bytes\";i:1345;s:11:\"size_before\";i:39497;s:10:\"size_after\";i:38152;s:4:\"time\";d:0.06;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.58;s:5:\"bytes\";i:2222;s:11:\"size_before\";i:62145;s:10:\"size_after\";i:59923;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87;s:5:\"bytes\";i:2562;s:11:\"size_before\";i:66221;s:10:\"size_after\";i:63659;s:4:\"time\";d:0.17;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.07;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:34639;s:10:\"size_after\";i:33575;s:4:\"time\";d:0.02;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.31;s:5:\"bytes\";i:915;s:11:\"size_before\";i:27677;s:10:\"size_after\";i:26762;s:4:\"time\";d:0.07;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.81;s:5:\"bytes\";i:1181;s:11:\"size_before\";i:42077;s:10:\"size_after\";i:40896;s:4:\"time\";d:0.03;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.7;s:5:\"bytes\";i:2773;s:11:\"size_before\";i:74850;s:10:\"size_after\";i:72077;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.69;s:5:\"bytes\";i:2107;s:11:\"size_before\";i:57129;s:10:\"size_after\";i:55022;s:4:\"time\";d:0.09;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.33;s:5:\"bytes\";i:3715;s:11:\"size_before\";i:85790;s:10:\"size_after\";i:82075;s:4:\"time\";d:0.3;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.78;s:5:\"bytes\";i:11064;s:11:\"size_before\";i:191388;s:10:\"size_after\";i:180324;s:4:\"time\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES("194", "404", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.673393650648894;s:5:\"bytes\";i:45369;s:11:\"size_before\";i:679849;s:10:\"size_after\";i:634480;s:4:\"time\";d:1.26;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.1;s:5:\"bytes\";i:260;s:11:\"size_before\";i:5099;s:10:\"size_after\";i:4839;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.42;s:5:\"bytes\";i:472;s:11:\"size_before\";i:13807;s:10:\"size_after\";i:13335;s:4:\"time\";d:0.04;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.77;s:5:\"bytes\";i:1332;s:11:\"size_before\";i:35318;s:10:\"size_after\";i:33986;s:4:\"time\";d:0.08;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.96;s:5:\"bytes\";i:2868;s:11:\"size_before\";i:57869;s:10:\"size_after\";i:55001;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.8;s:5:\"bytes\";i:3580;s:11:\"size_before\";i:61764;s:10:\"size_after\";i:58184;s:4:\"time\";d:0.16;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.42;s:5:\"bytes\";i:1011;s:11:\"size_before\";i:29583;s:10:\"size_after\";i:28572;s:4:\"time\";d:0.08;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.39;s:5:\"bytes\";i:840;s:11:\"size_before\";i:24814;s:10:\"size_after\";i:23974;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.54;s:5:\"bytes\";i:1664;s:11:\"size_before\";i:36616;s:10:\"size_after\";i:34952;s:4:\"time\";d:0.03;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:6;s:5:\"bytes\";i:4198;s:11:\"size_before\";i:69946;s:10:\"size_after\";i:65748;s:4:\"time\";d:0.25;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.77;s:5:\"bytes\";i:2550;s:11:\"size_before\";i:53411;s:10:\"size_after\";i:50861;s:4:\"time\";d:0.13;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.35;s:5:\"bytes\";i:5843;s:11:\"size_before\";i:79516;s:10:\"size_after\";i:73673;s:4:\"time\";d:0.17;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.78;s:5:\"bytes\";i:20751;s:11:\"size_before\";i:212106;s:10:\"size_after\";i:191355;s:4:\"time\";d:0.22;}}}");
INSERT INTO `wp_postmeta` VALUES("195", "406", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:5.060954557713478;s:5:\"bytes\";i:96454;s:11:\"size_before\";i:1905846;s:10:\"size_after\";i:1809392;s:4:\"time\";d:1.9100000000000001;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.9;s:5:\"bytes\";i:546;s:11:\"size_before\";i:7912;s:10:\"size_after\";i:7366;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.98;s:5:\"bytes\";i:1797;s:11:\"size_before\";i:30059;s:10:\"size_after\";i:28262;s:4:\"time\";d:0.03;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.23;s:5:\"bytes\";i:5221;s:11:\"size_before\";i:99871;s:10:\"size_after\";i:94650;s:4:\"time\";d:0.06;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.03;s:5:\"bytes\";i:8676;s:11:\"size_before\";i:172624;s:10:\"size_after\";i:163948;s:4:\"time\";d:0.2;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.94;s:5:\"bytes\";i:9257;s:11:\"size_before\";i:187319;s:10:\"size_after\";i:178062;s:4:\"time\";d:0.19;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.59;s:5:\"bytes\";i:4789;s:11:\"size_before\";i:85725;s:10:\"size_after\";i:80936;s:4:\"time\";d:0.11;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.55;s:5:\"bytes\";i:3517;s:11:\"size_before\";i:63351;s:10:\"size_after\";i:59834;s:4:\"time\";d:0.1;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.67;s:5:\"bytes\";i:6688;s:11:\"size_before\";i:117894;s:10:\"size_after\";i:111206;s:4:\"time\";d:0.15;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.34;s:5:\"bytes\";i:11276;s:11:\"size_before\";i:211074;s:10:\"size_after\";i:199798;s:4:\"time\";d:0.09;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.12;s:5:\"bytes\";i:7932;s:11:\"size_before\";i:155008;s:10:\"size_after\";i:147076;s:4:\"time\";d:0.16;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.27;s:5:\"bytes\";i:13024;s:11:\"size_before\";i:247329;s:10:\"size_after\";i:234305;s:4:\"time\";d:0.24;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.5;s:5:\"bytes\";i:23731;s:11:\"size_before\";i:527680;s:10:\"size_after\";i:503949;s:4:\"time\";d:0.57;}}}");
INSERT INTO `wp_postmeta` VALUES("196", "408", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:10.401866931411533;s:5:\"bytes\";i:121328;s:11:\"size_before\";i:1166406;s:10:\"size_after\";i:1045078;s:4:\"time\";d:1.39;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.28;s:5:\"bytes\";i:646;s:11:\"size_before\";i:5259;s:10:\"size_after\";i:4613;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:18.92;s:5:\"bytes\";i:4090;s:11:\"size_before\";i:21616;s:10:\"size_after\";i:17526;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.46;s:5:\"bytes\";i:9180;s:11:\"size_before\";i:63497;s:10:\"size_after\";i:54317;s:4:\"time\";d:0.16;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.76;s:5:\"bytes\";i:12599;s:11:\"size_before\";i:107123;s:10:\"size_after\";i:94524;s:4:\"time\";d:0.09;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.47;s:5:\"bytes\";i:13600;s:11:\"size_before\";i:118601;s:10:\"size_after\";i:105001;s:4:\"time\";d:0.31;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.12;s:5:\"bytes\";i:5702;s:11:\"size_before\";i:47062;s:10:\"size_after\";i:41360;s:4:\"time\";d:0.11;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:15.94;s:5:\"bytes\";i:6490;s:11:\"size_before\";i:40721;s:10:\"size_after\";i:34231;s:4:\"time\";d:0.1;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.22;s:5:\"bytes\";i:6024;s:11:\"size_before\";i:58924;s:10:\"size_after\";i:52900;s:4:\"time\";d:0.08;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.37;s:5:\"bytes\";i:10759;s:11:\"size_before\";i:114874;s:10:\"size_after\";i:104115;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.67;s:5:\"bytes\";i:10797;s:11:\"size_before\";i:92500;s:10:\"size_after\";i:81703;s:4:\"time\";d:0.05;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.59;s:5:\"bytes\";i:11207;s:11:\"size_before\";i:130450;s:10:\"size_after\";i:119243;s:4:\"time\";d:0.18;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.27;s:5:\"bytes\";i:30234;s:11:\"size_before\";i:365779;s:10:\"size_after\";i:335545;s:4:\"time\";d:0.2;}}}");
INSERT INTO `wp_postmeta` VALUES("197", "410", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:4.5022643875914845;s:5:\"bytes\";i:49250;s:11:\"size_before\";i:1093894;s:10:\"size_after\";i:1044644;s:4:\"time\";d:1.2;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.79;s:5:\"bytes\";i:332;s:11:\"size_before\";i:5733;s:10:\"size_after\";i:5401;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.96;s:5:\"bytes\";i:735;s:11:\"size_before\";i:18544;s:10:\"size_after\";i:17809;s:4:\"time\";d:0.08;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.26;s:5:\"bytes\";i:2449;s:11:\"size_before\";i:57486;s:10:\"size_after\";i:55037;s:4:\"time\";d:0.04;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.5;s:5:\"bytes\";i:4342;s:11:\"size_before\";i:96582;s:10:\"size_after\";i:92240;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.64;s:5:\"bytes\";i:5002;s:11:\"size_before\";i:107780;s:10:\"size_after\";i:102778;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.44;s:5:\"bytes\";i:2233;s:11:\"size_before\";i:50246;s:10:\"size_after\";i:48013;s:4:\"time\";d:0.09;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.17;s:5:\"bytes\";i:1529;s:11:\"size_before\";i:36682;s:10:\"size_after\";i:35153;s:4:\"time\";d:0.06;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.29;s:5:\"bytes\";i:2930;s:11:\"size_before\";i:68289;s:10:\"size_after\";i:65359;s:4:\"time\";d:0.09;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.29;s:5:\"bytes\";i:5024;s:11:\"size_before\";i:117048;s:10:\"size_after\";i:112024;s:4:\"time\";d:0.1;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.49;s:5:\"bytes\";i:3844;s:11:\"size_before\";i:85682;s:10:\"size_after\";i:81838;s:4:\"time\";d:0.16;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.13;s:5:\"bytes\";i:5797;s:11:\"size_before\";i:140292;s:10:\"size_after\";i:134495;s:4:\"time\";d:0.24;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.86;s:5:\"bytes\";i:15033;s:11:\"size_before\";i:309530;s:10:\"size_after\";i:294497;s:4:\"time\";d:0.22;}}}");
INSERT INTO `wp_postmeta` VALUES("198", "412", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.18449560540202;s:5:\"bytes\";i:45028;s:11:\"size_before\";i:490261;s:10:\"size_after\";i:445233;s:4:\"time\";d:1.1199999999999999;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.84;s:5:\"bytes\";i:148;s:11:\"size_before\";i:3855;s:10:\"size_after\";i:3707;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.5;s:5:\"bytes\";i:229;s:11:\"size_before\";i:9149;s:10:\"size_after\";i:8920;s:4:\"time\";d:0.05;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.27;s:5:\"bytes\";i:1218;s:11:\"size_before\";i:23120;s:10:\"size_after\";i:21902;s:4:\"time\";d:0.03;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.87;s:5:\"bytes\";i:3087;s:11:\"size_before\";i:39246;s:10:\"size_after\";i:36159;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.32;s:5:\"bytes\";i:4097;s:11:\"size_before\";i:43946;s:10:\"size_after\";i:39849;s:4:\"time\";d:0.12;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.57;s:5:\"bytes\";i:994;s:11:\"size_before\";i:21765;s:10:\"size_after\";i:20771;s:4:\"time\";d:0.02;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.88;s:5:\"bytes\";i:628;s:11:\"size_before\";i:16183;s:10:\"size_after\";i:15555;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.97;s:5:\"bytes\";i:1709;s:11:\"size_before\";i:28641;s:10:\"size_after\";i:26932;s:4:\"time\";d:0.06;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.52;s:5:\"bytes\";i:4529;s:11:\"size_before\";i:53164;s:10:\"size_after\";i:48635;s:4:\"time\";d:0.05;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.41;s:5:\"bytes\";i:2673;s:11:\"size_before\";i:36083;s:10:\"size_after\";i:33410;s:4:\"time\";d:0.11;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.64;s:5:\"bytes\";i:6094;s:11:\"size_before\";i:63209;s:10:\"size_after\";i:57115;s:4:\"time\";d:0.19;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.92;s:5:\"bytes\";i:19622;s:11:\"size_before\";i:151900;s:10:\"size_after\";i:132278;s:4:\"time\";d:0.41;}}}");
INSERT INTO `wp_postmeta` VALUES("199", "414", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.5022383900739187;s:5:\"bytes\";i:57187;s:11:\"size_before\";i:1632870;s:10:\"size_after\";i:1575683;s:4:\"time\";d:1.7700000000000002;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.76;s:5:\"bytes\";i:368;s:11:\"size_before\";i:6384;s:10:\"size_after\";i:6016;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.8;s:5:\"bytes\";i:1328;s:11:\"size_before\";i:27682;s:10:\"size_after\";i:26354;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.98;s:5:\"bytes\";i:3717;s:11:\"size_before\";i:93403;s:10:\"size_after\";i:89686;s:4:\"time\";d:0.14;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.67;s:5:\"bytes\";i:5781;s:11:\"size_before\";i:157683;s:10:\"size_after\";i:151902;s:4:\"time\";d:0.14;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.47;s:5:\"bytes\";i:5848;s:11:\"size_before\";i:168442;s:10:\"size_after\";i:162594;s:4:\"time\";d:0.19;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.93;s:5:\"bytes\";i:2935;s:11:\"size_before\";i:74588;s:10:\"size_after\";i:71653;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.27;s:5:\"bytes\";i:2499;s:11:\"size_before\";i:58493;s:10:\"size_after\";i:55994;s:4:\"time\";d:0.07;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.57;s:5:\"bytes\";i:3324;s:11:\"size_before\";i:93027;s:10:\"size_after\";i:89703;s:4:\"time\";d:0.09;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.46;s:5:\"bytes\";i:5984;s:11:\"size_before\";i:172934;s:10:\"size_after\";i:166950;s:4:\"time\";d:0.24;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.76;s:5:\"bytes\";i:5235;s:11:\"size_before\";i:139077;s:10:\"size_after\";i:133842;s:4:\"time\";d:0.14;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.16;s:5:\"bytes\";i:5811;s:11:\"size_before\";i:184110;s:10:\"size_after\";i:178299;s:4:\"time\";d:0.1;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.14;s:5:\"bytes\";i:14357;s:11:\"size_before\";i:457047;s:10:\"size_after\";i:442690;s:4:\"time\";d:0.55;}}}");
INSERT INTO `wp_postmeta` VALUES("200", "420", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:40.92896174863388;s:5:\"bytes\";i:749;s:11:\"size_before\";i:1830;s:10:\"size_after\";i:1081;s:4:\"time\";d:0.06;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:40.93;s:5:\"bytes\";i:749;s:11:\"size_before\";i:1830;s:10:\"size_after\";i:1081;s:4:\"time\";d:0.06;}}}");
INSERT INTO `wp_postmeta` VALUES("201", "421", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:40.074906367041194;s:5:\"bytes\";i:749;s:11:\"size_before\";i:1869;s:10:\"size_after\";i:1120;s:4:\"time\";d:0.02;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:40.07;s:5:\"bytes\";i:749;s:11:\"size_before\";i:1869;s:10:\"size_after\";i:1120;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("202", "437", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.465474576141334;s:5:\"bytes\";i:24710;s:11:\"size_before\";i:261054;s:10:\"size_after\";i:236344;s:4:\"time\";d:0.64;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.51;s:5:\"bytes\";i:668;s:11:\"size_before\";i:5340;s:10:\"size_after\";i:4672;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.56;s:5:\"bytes\";i:328;s:11:\"size_before\";i:4341;s:10:\"size_after\";i:4013;s:4:\"time\";d:0.01;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.73;s:5:\"bytes\";i:1070;s:11:\"size_before\";i:10994;s:10:\"size_after\";i:9924;s:4:\"time\";d:0.01;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.82;s:5:\"bytes\";i:1824;s:11:\"size_before\";i:16851;s:10:\"size_after\";i:15027;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.67;s:5:\"bytes\";i:4949;s:11:\"size_before\";i:36209;s:10:\"size_after\";i:31260;s:4:\"time\";d:0.15;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.4;s:5:\"bytes\";i:2900;s:11:\"size_before\";i:21637;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18737;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.01;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18737;s:10:\"size_after\";i:18737;s:4:\"time\";d:0.04;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.23;s:5:\"bytes\";i:4223;s:11:\"size_before\";i:31926;s:10:\"size_after\";i:27703;s:4:\"time\";d:0.02;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:27703;s:10:\"size_after\";i:27703;s:4:\"time\";d:0.18;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.3;s:5:\"bytes\";i:4041;s:11:\"size_before\";i:30374;s:10:\"size_after\";i:26333;s:4:\"time\";d:0.03;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.32;s:5:\"bytes\";i:4707;s:11:\"size_before\";i:38205;s:10:\"size_after\";i:33498;s:4:\"time\";d:0.08;}}}");
INSERT INTO `wp_postmeta` VALUES("203", "443", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:10.957104381527952;s:5:\"bytes\";i:6672;s:11:\"size_before\";i:60892;s:10:\"size_after\";i:54220;s:4:\"time\";d:0.07;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.28;s:5:\"bytes\";i:564;s:11:\"size_before\";i:7750;s:10:\"size_after\";i:7186;s:4:\"time\";d:0.03;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.49;s:5:\"bytes\";i:6108;s:11:\"size_before\";i:53142;s:10:\"size_after\";i:47034;s:4:\"time\";d:0.04;}}}");
INSERT INTO `wp_postmeta` VALUES("204", "444", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.060055020561272;s:5:\"bytes\";i:23328;s:11:\"size_before\";i:384947;s:10:\"size_after\";i:361619;s:4:\"time\";d:0.37;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.2;s:5:\"bytes\";i:575;s:11:\"size_before\";i:7983;s:10:\"size_after\";i:7408;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.39;s:5:\"bytes\";i:1566;s:11:\"size_before\";i:29035;s:10:\"size_after\";i:27469;s:4:\"time\";d:0.04;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.8;s:5:\"bytes\";i:3081;s:11:\"size_before\";i:64204;s:10:\"size_after\";i:61123;s:4:\"time\";d:0.1;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.7;s:5:\"bytes\";i:2288;s:11:\"size_before\";i:48705;s:10:\"size_after\";i:46417;s:4:\"time\";d:0.12;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:61123;s:10:\"size_after\";i:61123;s:4:\"time\";d:0.04;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.1;s:5:\"bytes\";i:15818;s:11:\"size_before\";i:173897;s:10:\"size_after\";i:158079;s:4:\"time\";d:0.06;}}}");
INSERT INTO `wp_postmeta` VALUES("205", "447", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.208456637073768;s:5:\"bytes\";i:3454;s:11:\"size_before\";i:37509;s:10:\"size_after\";i:34055;s:4:\"time\";d:0.04;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.52;s:5:\"bytes\";i:247;s:11:\"size_before\";i:5468;s:10:\"size_after\";i:5221;s:4:\"time\";d:0.02;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.01;s:5:\"bytes\";i:3207;s:11:\"size_before\";i:32041;s:10:\"size_after\";i:28834;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("206", "448", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.9524539739761284;s:5:\"bytes\";i:8815;s:11:\"size_before\";i:223026;s:10:\"size_after\";i:214211;s:4:\"time\";d:0.41000000000000003;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67;s:5:\"bytes\";i:260;s:11:\"size_before\";i:5569;s:10:\"size_after\";i:5309;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:3;s:5:\"bytes\";i:519;s:11:\"size_before\";i:17291;s:10:\"size_after\";i:16772;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.47;s:5:\"bytes\";i:937;s:11:\"size_before\";i:37951;s:10:\"size_after\";i:37014;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.38;s:5:\"bytes\";i:676;s:11:\"size_before\";i:28427;s:10:\"size_after\";i:27751;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:37014;s:10:\"size_after\";i:37014;s:4:\"time\";d:0.13;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.64;s:5:\"bytes\";i:6423;s:11:\"size_before\";i:96774;s:10:\"size_after\";i:90351;s:4:\"time\";d:0.16;}}}");
INSERT INTO `wp_postmeta` VALUES("207", "467", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("208", "467", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("211", "34", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("212", "34", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("213", "34", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("214", "34", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("215", "34", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("216", "34", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("217", "34", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("218", "34", "eut_page_title_item", "a:11:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("219", "34", "eut_page_video_item", "a:36:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("220", "34", "_wp_old_slug", "post-quote");
INSERT INTO `wp_postmeta` VALUES("221", "34", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("222", "34", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("223", "34", "_wp_old_slug", "quote-post");
INSERT INTO `wp_postmeta` VALUES("224", "34", "eut_likes", "2");
INSERT INTO `wp_postmeta` VALUES("225", "34", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("226", "34", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("227", "34", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("228", "34", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("229", "34", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("230", "34", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("231", "34", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("232", "34", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("233", "34", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("234", "34", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("235", "34", "_zuperla_eutf_post_quote_bg_opacity", "none");
INSERT INTO `wp_postmeta` VALUES("236", "34", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("237", "34", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("238", "34", "_thumbnail_id", "414");
INSERT INTO `wp_postmeta` VALUES("239", "34", "_wp_old_slug", "heres-a-quick-way-to-write-a-blog");
INSERT INTO `wp_postmeta` VALUES("240", "34", "_zuperla_eutf_post_quote_text", "Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarks grove right at the coast of the Semantics, a large language ocean.  A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.");
INSERT INTO `wp_postmeta` VALUES("241", "34", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("242", "34", "_wp_old_slug", "heres-a-quick-blog-way-for-any-blogger");
INSERT INTO `wp_postmeta` VALUES("245", "37", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("246", "37", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("247", "37", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("248", "37", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("249", "37", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("250", "37", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("251", "37", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("252", "37", "eut_page_title_item", "a:11:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("253", "37", "eut_page_video_item", "a:36:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("254", "37", "eut_post_link_url", "http://euthemians.com");
INSERT INTO `wp_postmeta` VALUES("255", "37", "eut_post_link_new_window", "on");
INSERT INTO `wp_postmeta` VALUES("256", "37", "_wp_old_slug", "post-link");
INSERT INTO `wp_postmeta` VALUES("257", "37", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("258", "37", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("259", "37", "_wp_old_slug", "link-post");
INSERT INTO `wp_postmeta` VALUES("260", "37", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("261", "37", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("262", "37", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("263", "37", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("264", "37", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("265", "37", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("266", "37", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("267", "37", "_zuperla_eutf_post_link_bg_opacity", "none");
INSERT INTO `wp_postmeta` VALUES("268", "37", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("269", "37", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("270", "37", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("271", "37", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("272", "37", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("273", "37", "_thumbnail_id", "412");
INSERT INTO `wp_postmeta` VALUES("274", "37", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("277", "387", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("278", "387", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("279", "387", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("280", "387", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("281", "387", "eut_page_feature_header_integration", "yes");
INSERT INTO `wp_postmeta` VALUES("282", "387", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("283", "387", "eut_page_feature_header_style", "light");
INSERT INTO `wp_postmeta` VALUES("284", "387", "eut_page_title_item", "a:13:{s:5:\"title\";s:12:\"Post Builder\";s:7:\"caption\";s:67:\"Enable the page builder for your posts and use any element you wish\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:11:\"left-center\";s:14:\"text_animation\";s:10:\"fade-in-up\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("285", "387", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("286", "387", "eut_post_layout", "right");
INSERT INTO `wp_postmeta` VALUES("287", "387", "eut_post_sidebar", "eut_sidebar_5586c27b8f6d9");
INSERT INTO `wp_postmeta` VALUES("288", "387", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("289", "387", "eut_disable_title", "yes");
INSERT INTO `wp_postmeta` VALUES("290", "387", "eut_disable_meta_fields", "yes");
INSERT INTO `wp_postmeta` VALUES("291", "387", "eut_page_feature_element", "image");
INSERT INTO `wp_postmeta` VALUES("292", "387", "eut_page_feature_size", "custom");
INSERT INTO `wp_postmeta` VALUES("293", "387", "eut_page_feature_effect", "parallax");
INSERT INTO `wp_postmeta` VALUES("294", "387", "eut_page_image_item", "a:33:{s:2:\"id\";s:4:\"5644\";s:5:\"title\";s:24:\"Don\'t Do These 12 Things\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:11:\"left-center\";s:14:\"text_animation\";s:10:\"fade-in-up\";s:11:\"bg_position\";s:13:\"center-center\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:5:\"light\";s:13:\"caption_color\";s:5:\"light\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:15:\"opacity_overlay\";s:2:\"70\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("295", "387", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("296", "387", "_wp_old_slug", "builder-post");
INSERT INTO `wp_postmeta` VALUES("297", "387", "eut_likes", "11");
INSERT INTO `wp_postmeta` VALUES("298", "387", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("299", "387", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("300", "387", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("301", "387", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("302", "387", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("303", "387", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("304", "387", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("305", "387", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("306", "387", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("307", "387", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("308", "387", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("309", "387", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("310", "387", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("311", "387", "_thumbnail_id", "410");
INSERT INTO `wp_postmeta` VALUES("312", "387", "_wp_old_slug", "dont-do-these-12-things");
INSERT INTO `wp_postmeta` VALUES("313", "387", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("315", "416", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("316", "416", "_zuperla_eutf_feature_section", "a:5:{s:16:\"feature_settings\";a:7:{s:7:\"element\";s:6:\"slider\";s:4:\"size\";s:0:\"\";s:6:\"height\";s:2:\"60\";s:10:\"min_height\";s:3:\"200\";s:15:\"header_position\";s:5:\"above\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#eef1f6\";}s:15:\"revslider_alias\";s:0:\"\";s:11:\"single_item\";a:48:{s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:3:\"div\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:11:\"caption_tag\";s:3:\"div\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"large\";s:13:\"content_align\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:3:\"150\";s:35:\"content_image_responsive_max_height\";s:2:\"50\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:1:\"0\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"image_effect\";s:0:\"\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:12:\"video_effect\";s:0:\"\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595c9c4a82812\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595c9c4a82d39\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}s:12:\"slider_items\";a:3:{i:0;a:44:{s:2:\"id\";s:13:\"595c9c8330359\";s:4:\"type\";s:4:\"post\";s:7:\"post_id\";s:3:\"390\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"header_style\";s:5:\"light\";s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:6:\"custom\";s:20:\"caption_color_custom\";s:7:\"#696969\";s:11:\"caption_tag\";s:2:\"h2\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"small\";s:13:\"content_align\";s:4:\"left\";s:16:\"content_position\";s:11:\"left-center\";s:17:\"content_animation\";s:12:\"fade-in-left\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:0:\"\";s:35:\"content_image_responsive_max_height\";s:0:\"\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:1:\"0\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595c9c83315d6\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595c9c8331aa7\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}i:1;a:44:{s:2:\"id\";s:13:\"595c9c8333ff1\";s:4:\"type\";s:4:\"post\";s:7:\"post_id\";s:2:\"17\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"header_style\";s:5:\"light\";s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:6:\"custom\";s:20:\"caption_color_custom\";s:7:\"#696969\";s:11:\"caption_tag\";s:2:\"h2\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"small\";s:13:\"content_align\";s:4:\"left\";s:16:\"content_position\";s:11:\"left-center\";s:17:\"content_animation\";s:10:\"fade-in-up\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:0:\"\";s:35:\"content_image_responsive_max_height\";s:0:\"\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:4:\"0.80\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595c9c83360f0\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595c9c8336a0f\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}i:2;a:44:{s:2:\"id\";s:13:\"595c9c8332071\";s:4:\"type\";s:4:\"post\";s:7:\"post_id\";s:2:\"12\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"header_style\";s:4:\"dark\";s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:4:\"dark\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:3:\"div\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:4:\"dark\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:11:\"caption_tag\";s:3:\"div\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:4:\"dark\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"large\";s:13:\"content_align\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"zoom-in\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:0:\"\";s:35:\"content_image_responsive_max_height\";s:0:\"\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:1:\"0\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595c9c83331a8\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595c9c833370f\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}}s:15:\"slider_settings\";a:6:{s:15:\"slideshow_speed\";s:4:\"5500\";s:13:\"direction_nav\";s:1:\"1\";s:12:\"slider_pause\";s:2:\"no\";s:10:\"transition\";s:5:\"slide\";s:13:\"slider_effect\";s:13:\"fixed-section\";s:10:\"pagination\";s:3:\"yes\";}}");
INSERT INTO `wp_postmeta` VALUES("317", "416", "_zuperla_eutf_scrolling_speed", "1000");
INSERT INTO `wp_postmeta` VALUES("318", "416", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("319", "416", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("320", "416", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("321", "416", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("322", "416", "_zuperla_eutf_disable_title", "yes");
INSERT INTO `wp_postmeta` VALUES("323", "416", "_zuperla_eutf_header_overlapping", "yes");
INSERT INTO `wp_postmeta` VALUES("324", "416", "_zuperla_eutf_header_style", "light");
INSERT INTO `wp_postmeta` VALUES("325", "511", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("326", "511", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("327", "511", "_menu_item_object_id", "416");
INSERT INTO `wp_postmeta` VALUES("328", "511", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("329", "511", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("330", "511", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("331", "511", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("332", "511", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("333", "511", "_vc_post_settings", "s:30:\"a:1:{s:10:\"vc_grid_id\";a:0:{}}\";");
INSERT INTO `wp_postmeta` VALUES("334", "512", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("335", "512", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("336", "512", "_menu_item_object_id", "4");
INSERT INTO `wp_postmeta` VALUES("337", "512", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("338", "512", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("339", "512", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("340", "512", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("341", "512", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("342", "512", "_vc_post_settings", "s:30:\"a:1:{s:10:\"vc_grid_id\";a:0:{}}\";");
INSERT INTO `wp_postmeta` VALUES("343", "513", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("344", "513", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("345", "513", "_menu_item_object_id", "3");
INSERT INTO `wp_postmeta` VALUES("346", "513", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("347", "513", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("348", "513", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("349", "513", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("350", "513", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("351", "513", "_vc_post_settings", "s:30:\"a:1:{s:10:\"vc_grid_id\";a:0:{}}\";");
INSERT INTO `wp_postmeta` VALUES("352", "514", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("353", "514", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("354", "514", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("355", "514", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("356", "514", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("357", "514", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("358", "514", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("359", "514", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("360", "514", "_vc_post_settings", "s:30:\"a:1:{s:10:\"vc_grid_id\";a:0:{}}\";");
INSERT INTO `wp_postmeta` VALUES("361", "426", "_wpb_shortcodes_custom_css", ".vc_custom_1499244877134{padding-top: 30px !important;padding-right: 30px !important;padding-bottom: 30px !important;padding-left: 30px !important;}");
INSERT INTO `wp_postmeta` VALUES("363", "426", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("364", "426", "_zuperla_eutf_feature_section", "a:3:{s:16:\"feature_settings\";a:7:{s:7:\"element\";s:0:\"\";s:4:\"size\";s:0:\"\";s:6:\"height\";s:2:\"60\";s:10:\"min_height\";s:3:\"200\";s:15:\"header_position\";s:5:\"above\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#eef1f6\";}s:15:\"revslider_alias\";s:0:\"\";s:11:\"single_item\";a:48:{s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:3:\"div\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:11:\"caption_tag\";s:3:\"div\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"large\";s:13:\"content_align\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:3:\"150\";s:35:\"content_image_responsive_max_height\";s:2:\"50\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:1:\"0\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"image_effect\";s:0:\"\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:12:\"video_effect\";s:0:\"\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595ca0c8e8124\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595ca0c8e8604\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("365", "426", "_zuperla_eutf_scrolling_speed", "1000");
INSERT INTO `wp_postmeta` VALUES("366", "426", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("367", "426", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("368", "426", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("369", "426", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("370", "426", "_zuperla_eutf_disable_title", "yes");
INSERT INTO `wp_postmeta` VALUES("371", "426", "_wpb_shortcodes_custom_css", ".vc_custom_1499244877134{padding-top: 30px !important;padding-right: 30px !important;padding-bottom: 30px !important;padding-left: 30px !important;}");
INSERT INTO `wp_postmeta` VALUES("372", "426", "_zuperla_eutf_header_overlapping", "no");
INSERT INTO `wp_postmeta` VALUES("373", "426", "_zuperla_eutf_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("375", "428", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("376", "428", "_zuperla_eutf_feature_section", "a:3:{s:16:\"feature_settings\";a:7:{s:7:\"element\";s:0:\"\";s:4:\"size\";s:0:\"\";s:6:\"height\";s:2:\"60\";s:10:\"min_height\";s:3:\"200\";s:15:\"header_position\";s:5:\"above\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#eef1f6\";}s:15:\"revslider_alias\";s:0:\"\";s:11:\"single_item\";a:48:{s:5:\"title\";s:0:\"\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:9:\"title_tag\";s:3:\"div\";s:7:\"caption\";s:0:\"\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:11:\"caption_tag\";s:3:\"div\";s:10:\"subheading\";s:0:\"\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:14:\"subheading_tag\";s:3:\"div\";s:17:\"subheading_family\";s:0:\"\";s:12:\"title_family\";s:0:\"\";s:14:\"caption_family\";s:0:\"\";s:12:\"content_size\";s:5:\"large\";s:13:\"content_align\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:14:\"container_size\";s:0:\"\";s:16:\"content_image_id\";s:0:\"\";s:18:\"content_image_size\";s:0:\"\";s:24:\"content_image_max_height\";s:3:\"150\";s:35:\"content_image_responsive_max_height\";s:2:\"50\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";s:15:\"opacity_overlay\";s:1:\"0\";s:11:\"bg_image_id\";s:0:\"\";s:13:\"bg_image_size\";s:0:\"\";s:11:\"bg_position\";s:13:\"center-center\";s:21:\"bg_tablet_sm_position\";s:0:\"\";s:12:\"image_effect\";s:0:\"\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:12:\"video_effect\";s:0:\"\";s:6:\"button\";a:10:{s:2:\"id\";s:13:\"595ca0d30f197\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:7:\"button2\";a:10:{s:2:\"id\";s:13:\"595ca0d30f6b1\";s:4:\"text\";s:0:\"\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:5:\"_self\";s:5:\"color\";s:9:\"primary-1\";s:11:\"hover_color\";s:5:\"black\";s:4:\"size\";s:6:\"medium\";s:5:\"shape\";s:6:\"square\";s:4:\"type\";s:6:\"simple\";s:5:\"class\";s:0:\"\";}s:13:\"arrow_enabled\";s:2:\"no\";s:11:\"arrow_color\";s:5:\"light\";s:18:\"arrow_color_custom\";s:7:\"#ffffff\";s:8:\"el_class\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("377", "428", "_zuperla_eutf_scrolling_speed", "1000");
INSERT INTO `wp_postmeta` VALUES("378", "428", "_zuperla_eutf_custom_title_options", "a:21:{s:6:\"custom\";s:6:\"custom\";s:6:\"height\";s:2:\"30\";s:10:\"min_height\";s:3:\"250\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:6:\"medium\";s:17:\"content_alignment\";s:4:\"left\";s:16:\"content_position\";s:11:\"left-center\";s:17:\"content_animation\";s:4:\"none\";s:7:\"bg_mode\";s:8:\"featured\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("379", "428", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("380", "428", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("381", "428", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("382", "428", "_thumbnail_id", "491");
INSERT INTO `wp_postmeta` VALUES("383", "428", "_zuperla_eutf_description", "Don’t hesitate to send me your Story");
INSERT INTO `wp_postmeta` VALUES("384", "428", "_zuperla_eutf_padding_top_multiplier", "3x");
INSERT INTO `wp_postmeta` VALUES("385", "428", "_zuperla_eutf_padding_bottom_multiplier", "3x");
INSERT INTO `wp_postmeta` VALUES("386", "428", "_zuperla_eutf_sidebar", "zuperla_eutf_sidebar_595ca5b31bd95");
INSERT INTO `wp_postmeta` VALUES("387", "428", "_zuperla_eutf_layout", "right");
INSERT INTO `wp_postmeta` VALUES("388", "515", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("389", "515", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("390", "515", "_menu_item_object_id", "428");
INSERT INTO `wp_postmeta` VALUES("391", "515", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("392", "515", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("393", "515", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("394", "515", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("395", "515", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("396", "515", "_vc_post_settings", "s:30:\"a:1:{s:10:\"vc_grid_id\";a:0:{}}\";");
INSERT INTO `wp_postmeta` VALUES("397", "516", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("398", "516", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("399", "516", "_menu_item_object_id", "426");
INSERT INTO `wp_postmeta` VALUES("400", "516", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("401", "516", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("402", "516", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("403", "516", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("404", "516", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("405", "516", "_vc_post_settings", "s:30:\"a:1:{s:10:\"vc_grid_id\";a:0:{}}\";");
INSERT INTO `wp_postmeta` VALUES("406", "449", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:9.674478125249939;s:5:\"bytes\";i:6048;s:11:\"size_before\";i:62515;s:10:\"size_after\";i:56467;s:4:\"time\";d:0.05;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:2:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.73;s:5:\"bytes\";i:389;s:11:\"size_before\";i:8231;s:10:\"size_after\";i:7842;s:4:\"time\";d:0.03;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.42;s:5:\"bytes\";i:5659;s:11:\"size_before\";i:54284;s:10:\"size_after\";i:48625;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("407", "450", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.740765448304802;s:5:\"bytes\";i:31324;s:11:\"size_before\";i:464695;s:10:\"size_after\";i:433371;s:4:\"time\";d:0.35000000000000003;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.58;s:5:\"bytes\";i:389;s:11:\"size_before\";i:8501;s:10:\"size_after\";i:8112;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.88;s:5:\"bytes\";i:1624;s:11:\"size_before\";i:33258;s:10:\"size_after\";i:31634;s:4:\"time\";d:0.05;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.38;s:5:\"bytes\";i:5292;s:11:\"size_before\";i:82983;s:10:\"size_after\";i:77691;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.7;s:5:\"bytes\";i:3353;s:11:\"size_before\";i:58798;s:10:\"size_after\";i:55445;s:4:\"time\";d:0.04;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:77691;s:10:\"size_after\";i:77691;s:4:\"time\";d:0.12;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.16;s:5:\"bytes\";i:20666;s:11:\"size_before\";i:203464;s:10:\"size_after\";i:182798;s:4:\"time\";d:0.08;}}}");
INSERT INTO `wp_postmeta` VALUES("408", "468", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:39.94190268700073;s:5:\"bytes\";i:550;s:11:\"size_before\";i:1377;s:10:\"size_after\";i:827;s:4:\"time\";d:0.02;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:39.94;s:5:\"bytes\";i:550;s:11:\"size_before\";i:1377;s:10:\"size_after\";i:827;s:4:\"time\";d:0.02;}}}");
INSERT INTO `wp_postmeta` VALUES("409", "469", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:37.58389261744966;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:2831;s:10:\"size_after\";i:1767;s:4:\"time\";d:0.05;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:37.58;s:5:\"bytes\";i:1064;s:11:\"size_before\";i:2831;s:10:\"size_after\";i:1767;s:4:\"time\";d:0.05;}}}");
INSERT INTO `wp_postmeta` VALUES("410", "472", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:8.485494301397049;s:5:\"bytes\";i:70633;s:11:\"size_before\";i:832397;s:10:\"size_after\";i:761764;s:4:\"time\";d:0.7899999999999998;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:11:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.38;s:5:\"bytes\";i:270;s:11:\"size_before\";i:4231;s:10:\"size_after\";i:3961;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.94;s:5:\"bytes\";i:1590;s:11:\"size_before\";i:20018;s:10:\"size_after\";i:18428;s:4:\"time\";d:0.07;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.76;s:5:\"bytes\";i:6267;s:11:\"size_before\";i:71532;s:10:\"size_after\";i:65265;s:4:\"time\";d:0.09;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.65;s:5:\"bytes\";i:10346;s:11:\"size_before\";i:119675;s:10:\"size_after\";i:109329;s:4:\"time\";d:0.14;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.74;s:5:\"bytes\";i:11757;s:11:\"size_before\";i:134484;s:10:\"size_after\";i:122727;s:4:\"time\";d:0.1;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.93;s:5:\"bytes\";i:3822;s:11:\"size_before\";i:48211;s:10:\"size_after\";i:44389;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.45;s:5:\"bytes\";i:3314;s:11:\"size_before\";i:39242;s:10:\"size_after\";i:35928;s:4:\"time\";d:0.04;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.45;s:5:\"bytes\";i:4045;s:11:\"size_before\";i:54320;s:10:\"size_after\";i:50275;s:4:\"time\";d:0.08;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.51;s:5:\"bytes\";i:10861;s:11:\"size_before\";i:127690;s:10:\"size_after\";i:116829;s:4:\"time\";d:0.07;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.62;s:5:\"bytes\";i:8328;s:11:\"size_before\";i:96557;s:10:\"size_after\";i:88229;s:4:\"time\";d:0.08;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.62;s:5:\"bytes\";i:10033;s:11:\"size_before\";i:116437;s:10:\"size_after\";i:106404;s:4:\"time\";d:0.07;}}}");
INSERT INTO `wp_postmeta` VALUES("411", "491", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:7.144270145944239;s:5:\"bytes\";i:72591;s:11:\"size_before\";i:1016073;s:10:\"size_after\";i:943482;s:4:\"time\";d:1.4000000000000001;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.67;s:5:\"bytes\";i:242;s:11:\"size_before\";i:3629;s:10:\"size_after\";i:3387;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.62;s:5:\"bytes\";i:764;s:11:\"size_before\";i:11541;s:10:\"size_after\";i:10777;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.06;s:5:\"bytes\";i:3391;s:11:\"size_before\";i:42062;s:10:\"size_after\";i:38671;s:4:\"time\";d:0.05;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.99;s:5:\"bytes\";i:6177;s:11:\"size_before\";i:77322;s:10:\"size_after\";i:71145;s:4:\"time\";d:0.13;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.81;s:5:\"bytes\";i:7857;s:11:\"size_before\";i:100552;s:10:\"size_after\";i:92695;s:4:\"time\";d:0.21;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.67;s:5:\"bytes\";i:3266;s:11:\"size_before\";i:42601;s:10:\"size_after\";i:39335;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.13;s:5:\"bytes\";i:2378;s:11:\"size_before\";i:29254;s:10:\"size_after\";i:26876;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.85;s:5:\"bytes\";i:4781;s:11:\"size_before\";i:60938;s:10:\"size_after\";i:56157;s:4:\"time\";d:0.07;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.08;s:5:\"bytes\";i:8576;s:11:\"size_before\";i:121196;s:10:\"size_after\";i:112620;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.97;s:5:\"bytes\";i:6545;s:11:\"size_before\";i:82070;s:10:\"size_after\";i:75525;s:4:\"time\";d:0.05;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.47;s:5:\"bytes\";i:9511;s:11:\"size_before\";i:146912;s:10:\"size_after\";i:137401;s:4:\"time\";d:0.43;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.41;s:5:\"bytes\";i:19103;s:11:\"size_before\";i:297996;s:10:\"size_after\";i:278893;s:4:\"time\";d:0.27;}}}");
INSERT INTO `wp_postmeta` VALUES("412", "517", "_form", "<div class=\"eut-form\">\n<div class=\"eut-fields-wrapper\">\n<div> [text* your-name placeholder \"Your Name (required)\"]</div>\n<div>[email* your-email placeholder \"Your Email (required)\"]</div>\n<div>[text your-subject placeholder \"Subject\"]</div>\n<div>[textarea your-message placeholder \"Your message\"]</div>\n<div>[submit \"Send your message\"]</div>\n</div>\n</div>");
INSERT INTO `wp_postmeta` VALUES("413", "517", "_mail", "a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:38:\"Zuperla Personal Blog \"[your-subject]\"\";s:6:\"sender\";s:32:\"[your-name] <aaa@euthemians.com>\";s:9:\"recipient\";s:18:\"aaa@euthemians.com\";s:4:\"body\";s:218:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Zuperla Personal Blog (http://euthemians.com/themes/zuperla/zuperla-personal-blog)\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("414", "517", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:38:\"Zuperla Personal Blog \"[your-subject]\"\";s:6:\"sender\";s:42:\"Zuperla Personal Blog <aaa@euthemians.com>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:160:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Zuperla Personal Blog (http://euthemians.com/themes/zuperla/zuperla-personal-blog)\";s:18:\"additional_headers\";s:28:\"Reply-To: aaa@euthemians.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("415", "517", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}");
INSERT INTO `wp_postmeta` VALUES("416", "517", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("417", "517", "_locale", "en_US");
INSERT INTO `wp_postmeta` VALUES("418", "517", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("421", "12", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("422", "12", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("423", "12", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("424", "12", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("425", "12", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("426", "12", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("427", "12", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("428", "12", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("429", "12", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("430", "12", "eut_post_sidebar", "eut_sidebar_5586c27b8f6d9");
INSERT INTO `wp_postmeta` VALUES("431", "12", "eut_fixed_sidebar", "yes");
INSERT INTO `wp_postmeta` VALUES("432", "12", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("433", "12", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("434", "12", "_wp_old_slug", "post-single-image");
INSERT INTO `wp_postmeta` VALUES("435", "12", "eut_likes", "16");
INSERT INTO `wp_postmeta` VALUES("436", "12", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("437", "12", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("438", "12", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("439", "12", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("440", "12", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("441", "12", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("442", "12", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("443", "12", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("444", "12", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("445", "12", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("446", "12", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("447", "12", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("448", "12", "_thumbnail_id", "394");
INSERT INTO `wp_postmeta` VALUES("449", "12", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("450", "12", "_wp_old_slug", "how-to-better-understand-the-ux-rules");
INSERT INTO `wp_postmeta` VALUES("453", "17", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("454", "17", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("455", "17", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("456", "17", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("457", "17", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("458", "17", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("459", "17", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("460", "17", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("461", "17", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("462", "17", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("463", "17", "eut_post_type_gallery_mode", "slider");
INSERT INTO `wp_postmeta` VALUES("464", "17", "eut_post_slider_items", "a:3:{i:0;a:1:{s:2:\"id\";s:4:\"5999\";}i:1;a:1:{s:2:\"id\";s:4:\"6001\";}i:2;a:1:{s:2:\"id\";s:4:\"6002\";}}");
INSERT INTO `wp_postmeta` VALUES("465", "17", "eut_post_slider_settings", "a:2:{s:15:\"slideshow_speed\";s:4:\"4500\";s:13:\"direction_nav\";s:1:\"2\";}");
INSERT INTO `wp_postmeta` VALUES("466", "17", "eut_likes", "11");
INSERT INTO `wp_postmeta` VALUES("467", "17", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("468", "17", "_wp_old_slug", "post-with-slider");
INSERT INTO `wp_postmeta` VALUES("469", "17", "eut_fixed_sidebar", "yes");
INSERT INTO `wp_postmeta` VALUES("470", "17", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("471", "17", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("472", "17", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("473", "17", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("474", "17", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("475", "17", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("476", "17", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("477", "17", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("478", "17", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("479", "17", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("480", "17", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("481", "17", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("482", "17", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("483", "17", "_wp_old_slug", "can-we-really-trust-paypal");
INSERT INTO `wp_postmeta` VALUES("484", "17", "_thumbnail_id", "396");
INSERT INTO `wp_postmeta` VALUES("485", "17", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("486", "17", "_wp_old_slug", "can-we-really-trust-online-payments");
INSERT INTO `wp_postmeta` VALUES("487", "17", "_wp_old_slug", "my-london");
INSERT INTO `wp_postmeta` VALUES("488", "17", "_zuperla_eutf_description", "A small river named Duden flows by their place and supplies it with the necessary regelialia.");
INSERT INTO `wp_postmeta` VALUES("491", "23", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("492", "23", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("493", "23", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("494", "23", "eut_post_type_video_mode", "html5");
INSERT INTO `wp_postmeta` VALUES("495", "23", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("496", "23", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("497", "23", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("498", "23", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("499", "23", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("500", "23", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("501", "23", "eut_post_video_webm", "http://euthemians.com/themes/corpus/wp-content/uploads/2015/06/video-01.webm");
INSERT INTO `wp_postmeta` VALUES("502", "23", "eut_post_video_mp4", "http://euthemians.com/themes/corpus/wp-content/uploads/2015/06/video-01.mp4");
INSERT INTO `wp_postmeta` VALUES("503", "23", "eut_post_video_ogv", "http://euthemians.com/themes/corpus/wp-content/uploads/2015/06/video-01.ogv");
INSERT INTO `wp_postmeta` VALUES("504", "23", "eut_post_video_poster", "http://euthemians.com/themes/corpus/wp-content/uploads/2015/06/video-image.jpg");
INSERT INTO `wp_postmeta` VALUES("505", "23", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("506", "23", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("507", "23", "_wp_old_slug", "post-html-video");
INSERT INTO `wp_postmeta` VALUES("508", "23", "eut_fixed_sidebar", "yes");
INSERT INTO `wp_postmeta` VALUES("509", "23", "eut_likes", "2");
INSERT INTO `wp_postmeta` VALUES("510", "23", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("511", "23", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("512", "23", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("513", "23", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("514", "23", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("515", "23", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("516", "23", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("517", "23", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("518", "23", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("519", "23", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("520", "23", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("521", "23", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("522", "23", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("523", "23", "_thumbnail_id", "404");
INSERT INTO `wp_postmeta` VALUES("524", "23", "_wp_old_slug", "how-to-upload-your-html-video");
INSERT INTO `wp_postmeta` VALUES("525", "23", "_zuperla_eutf_post_slider_items", "a:6:{i:0;a:1:{s:2:\"id\";s:4:\"1717\";}i:1;a:1:{s:2:\"id\";s:4:\"1724\";}i:2;a:1:{s:2:\"id\";s:4:\"1646\";}i:3;a:1:{s:2:\"id\";s:4:\"1712\";}i:4;a:1:{s:2:\"id\";s:4:\"1706\";}i:5;a:1:{s:2:\"id\";s:4:\"1714\";}}");
INSERT INTO `wp_postmeta` VALUES("526", "23", "_zuperla_eutf_post_slider_settings", "a:3:{s:15:\"slideshow_speed\";s:4:\"3500\";s:13:\"direction_nav\";s:1:\"1\";s:19:\"direction_nav_color\";s:4:\"dark\";}");
INSERT INTO `wp_postmeta` VALUES("527", "23", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("528", "23", "_wp_old_slug", "how-to-easily-upload-your-html-video");
INSERT INTO `wp_postmeta` VALUES("531", "27", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("532", "27", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("533", "27", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("534", "27", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("535", "27", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("536", "27", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("537", "27", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("538", "27", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("539", "27", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("540", "27", "eut_post_video_embed", "https://www.youtube.com/watch?v=PSGx4bBU9Qc");
INSERT INTO `wp_postmeta` VALUES("541", "27", "_oembed_442502e1a1db31d9673fa9efe2ebd3f9", "<iframe width=\"1080\" height=\"608\" src=\"https://www.youtube.com/embed/PSGx4bBU9Qc?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("542", "27", "_oembed_time_442502e1a1db31d9673fa9efe2ebd3f9", "1435658565");
INSERT INTO `wp_postmeta` VALUES("543", "27", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("544", "27", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("545", "27", "_wp_old_slug", "post-youtube-video");
INSERT INTO `wp_postmeta` VALUES("546", "27", "eut_fixed_sidebar", "yes");
INSERT INTO `wp_postmeta` VALUES("547", "27", "eut_likes", "3");
INSERT INTO `wp_postmeta` VALUES("548", "27", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("549", "27", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("550", "27", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("551", "27", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("552", "27", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("553", "27", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("554", "27", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("555", "27", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("556", "27", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("557", "27", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("558", "27", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("559", "27", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("560", "27", "_zuperla_eutf_post_video_bg_opacity", "none");
INSERT INTO `wp_postmeta` VALUES("561", "27", "_zuperla_eutf_post_video_embed", "https://vimeo.com/59736707");
INSERT INTO `wp_postmeta` VALUES("562", "27", "_oembed_88353f2ff53eaf0a9bc0ecdb4c76ca2a", "<iframe src=\"https://player.vimeo.com/video/104652533\" width=\"960\" height=\"540\" frameborder=\"0\" title=\"After Effects Template - Kinetic Typography\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("563", "27", "_oembed_time_88353f2ff53eaf0a9bc0ecdb4c76ca2a", "1471110594");
INSERT INTO `wp_postmeta` VALUES("564", "27", "_thumbnail_id", "402");
INSERT INTO `wp_postmeta` VALUES("565", "27", "_wp_old_slug", "10-social-media-facts");
INSERT INTO `wp_postmeta` VALUES("566", "27", "_wp_old_slug", "10-social-media-facts-for-you");
INSERT INTO `wp_postmeta` VALUES("567", "27", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("568", "27", "_oembed_b9b3f9225f00e5fa50d1421cfd030b20", "<iframe src=\"https://player.vimeo.com/video/59736707\" width=\"1080\" height=\"608\" frameborder=\"0\" title=\"G-STAR The Art of RAW\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("569", "27", "_oembed_time_b9b3f9225f00e5fa50d1421cfd030b20", "1499253880");
INSERT INTO `wp_postmeta` VALUES("570", "27", "_wp_old_slug", "10-social-media-facts-for-you-to-know");
INSERT INTO `wp_postmeta` VALUES("573", "30", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("574", "30", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("575", "30", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("576", "30", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("577", "30", "eut_page_feature_header_integration", "yes");
INSERT INTO `wp_postmeta` VALUES("578", "30", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("579", "30", "eut_page_feature_header_style", "dark");
INSERT INTO `wp_postmeta` VALUES("580", "30", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("581", "30", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("582", "30", "eut_post_sidebar", "eut_sidebar_5586c27b8f6d9");
INSERT INTO `wp_postmeta` VALUES("583", "30", "eut_post_video_embed", "https://vimeo.com/7809605");
INSERT INTO `wp_postmeta` VALUES("584", "30", "_oembed_d2f409a0acdbac09d316c8027d535287", "<iframe src=\"https://player.vimeo.com/video/7809605\" width=\"1080\" height=\"608\" frameborder=\"0\" title=\"The Third &amp; The Seventh\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("585", "30", "_oembed_time_d2f409a0acdbac09d316c8027d535287", "1435658460");
INSERT INTO `wp_postmeta` VALUES("586", "30", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("587", "30", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("588", "30", "_wp_old_slug", "post-vimeo-video");
INSERT INTO `wp_postmeta` VALUES("589", "30", "_wp_old_slug", "get-rid-of-comment-spammers-once-and-for-all");
INSERT INTO `wp_postmeta` VALUES("590", "30", "eut_page_feature_size", "custom");
INSERT INTO `wp_postmeta` VALUES("591", "30", "eut_page_feature_effect", "parallax");
INSERT INTO `wp_postmeta` VALUES("592", "30", "eut_page_image_item", "a:33:{s:2:\"id\";s:4:\"5822\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:11:\"left-center\";s:14:\"text_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("593", "30", "eut_likes", "6");
INSERT INTO `wp_postmeta` VALUES("594", "30", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("595", "30", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("596", "30", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("597", "30", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("598", "30", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("599", "30", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("600", "30", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("601", "30", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("602", "30", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("603", "30", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("604", "30", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("605", "30", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("606", "30", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("607", "30", "_zuperla_eutf_post_video_embed", "https://www.youtube.com/watch?v=ZZKHFQ5JBpI");
INSERT INTO `wp_postmeta` VALUES("608", "30", "_oembed_89f2e3d334ce29eb0de2a3378cde5e1f", "<iframe width=\"1080\" height=\"608\" src=\"https://www.youtube.com/embed/ZZKHFQ5JBpI?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("609", "30", "_oembed_time_89f2e3d334ce29eb0de2a3378cde5e1f", "1471110454");
INSERT INTO `wp_postmeta` VALUES("610", "30", "_thumbnail_id", "400");
INSERT INTO `wp_postmeta` VALUES("611", "30", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("614", "32", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("615", "32", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("616", "32", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("617", "32", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("618", "32", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("619", "32", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("620", "32", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("621", "32", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("622", "32", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("623", "32", "_wp_old_slug", "post-audio");
INSERT INTO `wp_postmeta` VALUES("624", "32", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("625", "32", "eut_post_audio_embed", "<iframe width=\"100%\" height=\"200\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/39654171&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&visual=true\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("626", "32", "eut_disable_title", "yes");
INSERT INTO `wp_postmeta` VALUES("627", "32", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("628", "32", "_wp_old_slug", "audio-post");
INSERT INTO `wp_postmeta` VALUES("629", "32", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("630", "32", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("631", "32", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("632", "32", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("633", "32", "_zuperla_eutf_post_standard_bg_opacity", "40");
INSERT INTO `wp_postmeta` VALUES("634", "32", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("635", "32", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("636", "32", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("637", "32", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("638", "32", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("639", "32", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("640", "32", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("641", "32", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("642", "32", "_wp_old_slug", "what-kind-of-website-works-better");
INSERT INTO `wp_postmeta` VALUES("643", "32", "_thumbnail_id", "408");
INSERT INTO `wp_postmeta` VALUES("644", "32", "_zuperla_eutf_post_standard_style", "zuperla");
INSERT INTO `wp_postmeta` VALUES("645", "32", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("648", "40", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("649", "40", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("650", "40", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("651", "40", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("652", "40", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("653", "40", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("654", "40", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("655", "40", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("656", "40", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("657", "40", "eut_fixed_sidebar", "yes");
INSERT INTO `wp_postmeta` VALUES("658", "40", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("659", "40", "eut_post_slider_items", "a:3:{i:0;a:1:{s:2:\"id\";s:4:\"6013\";}i:1;a:1:{s:2:\"id\";s:4:\"6014\";}i:2;a:1:{s:2:\"id\";s:4:\"6015\";}}");
INSERT INTO `wp_postmeta` VALUES("660", "40", "eut_post_slider_settings", "a:2:{s:15:\"slideshow_speed\";s:4:\"3500\";s:13:\"direction_nav\";s:1:\"2\";}");
INSERT INTO `wp_postmeta` VALUES("661", "40", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("662", "40", "_wp_old_slug", "post-with-gallery");
INSERT INTO `wp_postmeta` VALUES("663", "40", "_wp_old_slug", "how-to-attract-links-and-increase-web-traffic");
INSERT INTO `wp_postmeta` VALUES("664", "40", "_wp_old_slug", "how-to-attract-links");
INSERT INTO `wp_postmeta` VALUES("665", "40", "_wp_old_slug", "how-to-attract-links-increase-web-traffic");
INSERT INTO `wp_postmeta` VALUES("666", "40", "eut_post_type_gallery_mode", "slider");
INSERT INTO `wp_postmeta` VALUES("667", "40", "eut_post_type_gallery_image_mode", "resize");
INSERT INTO `wp_postmeta` VALUES("668", "40", "eut_likes", "8");
INSERT INTO `wp_postmeta` VALUES("669", "40", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("670", "40", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("671", "40", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("672", "40", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("673", "40", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("674", "40", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("675", "40", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("676", "40", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("677", "40", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("678", "40", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("679", "40", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("680", "40", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("681", "40", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("682", "40", "_wp_old_slug", "how-to-increase-web-traffic");
INSERT INTO `wp_postmeta` VALUES("683", "40", "_thumbnail_id", "406");
INSERT INTO `wp_postmeta` VALUES("684", "40", "_wp_old_slug", "how-to-improve-your-ranking");
INSERT INTO `wp_postmeta` VALUES("685", "40", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("686", "40", "_wp_old_slug", "how-to-improve-your-page-ranking");
INSERT INTO `wp_postmeta` VALUES("689", "43", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("690", "43", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("691", "43", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("692", "43", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("693", "43", "eut_page_feature_header_integration", "yes");
INSERT INTO `wp_postmeta` VALUES("694", "43", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("695", "43", "eut_page_feature_header_style", "light");
INSERT INTO `wp_postmeta` VALUES("696", "43", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("697", "43", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("698", "43", "eut_page_feature_element", "image");
INSERT INTO `wp_postmeta` VALUES("699", "43", "eut_page_feature_size", "custom");
INSERT INTO `wp_postmeta` VALUES("700", "43", "eut_page_feature_effect", "parallax");
INSERT INTO `wp_postmeta` VALUES("701", "43", "eut_page_image_item", "a:33:{s:2:\"id\";s:4:\"6006\";s:5:\"title\";s:12:\"How to make \";s:7:\"caption\";s:20:\"Professional brands?\";s:10:\"text_align\";s:13:\"center-center\";s:14:\"text_animation\";s:10:\"fade-in-up\";s:11:\"bg_position\";s:13:\"center-center\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:5:\"light\";s:13:\"caption_color\";s:5:\"light\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:4:\"dark\";s:15:\"opacity_overlay\";s:2:\"70\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("702", "43", "eut_disable_media", "yes");
INSERT INTO `wp_postmeta` VALUES("703", "43", "eut_disable_title", "yes");
INSERT INTO `wp_postmeta` VALUES("704", "43", "eut_disable_meta_fields", "yes");
INSERT INTO `wp_postmeta` VALUES("705", "43", "eut_post_sidebar", "eut_sidebar_5586c27b8f6d9");
INSERT INTO `wp_postmeta` VALUES("706", "43", "eut_fixed_sidebar", "yes");
INSERT INTO `wp_postmeta` VALUES("707", "43", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("708", "43", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("709", "43", "eut_likes", "11");
INSERT INTO `wp_postmeta` VALUES("710", "43", "_wp_old_slug", "post-storytelling");
INSERT INTO `wp_postmeta` VALUES("711", "43", "_wp_old_slug", "new-technology-makes-your-blueprints-obsolete");
INSERT INTO `wp_postmeta` VALUES("712", "43", "_wp_old_slug", "do-you-make-these-html-coding-mistakes");
INSERT INTO `wp_postmeta` VALUES("713", "43", "_zuperla_eutf_fixed_sidebar", "no");
INSERT INTO `wp_postmeta` VALUES("714", "43", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"40\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:4:\"dark\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:5:\"light\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:5:\"light\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:5:\"light\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:5:\"large\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:7:\"fade-in\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("715", "43", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("716", "43", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("717", "43", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("718", "43", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("719", "43", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("720", "43", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("721", "43", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("722", "43", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("723", "43", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("724", "43", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("725", "43", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("726", "43", "_zuperla_eutf_post_standard_style", "zuperla");
INSERT INTO `wp_postmeta` VALUES("727", "43", "_thumbnail_id", "398");
INSERT INTO `wp_postmeta` VALUES("728", "43", "_zuperla_eutf_content_skin_options", "a:3:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";}");
INSERT INTO `wp_postmeta` VALUES("729", "43", "_wp_old_slug", "how-to-make-professional-brands");
INSERT INTO `wp_postmeta` VALUES("732", "390", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("733", "390", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("734", "390", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("735", "390", "eut_post_layout", "right");
INSERT INTO `wp_postmeta` VALUES("736", "390", "eut_post_sidebar", "eut_sidebar_5586c27b8f6d9");
INSERT INTO `wp_postmeta` VALUES("737", "390", "eut_fixed_sidebar", "yes");
INSERT INTO `wp_postmeta` VALUES("738", "390", "eut_page_feature_height", "550");
INSERT INTO `wp_postmeta` VALUES("739", "390", "eut_page_feature_header_integration", "no");
INSERT INTO `wp_postmeta` VALUES("740", "390", "eut_page_feature_header_position", "above");
INSERT INTO `wp_postmeta` VALUES("741", "390", "eut_page_feature_header_style", "default");
INSERT INTO `wp_postmeta` VALUES("742", "390", "eut_page_title_item", "a:13:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:5:\"style\";s:7:\"default\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:8:\"bg_color\";s:7:\"#303030\";s:11:\"title_color\";s:7:\"#ffffff\";s:13:\"caption_color\";s:7:\"#ffffff\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:11:\"arrow_color\";s:7:\"#000000\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("743", "390", "eut_page_video_item", "a:38:{s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:10:\"text_align\";s:8:\"left-top\";s:14:\"text_animation\";s:7:\"fade-in\";s:5:\"style\";s:7:\"default\";s:11:\"title_color\";s:4:\"dark\";s:13:\"caption_color\";s:4:\"dark\";s:9:\"title_tag\";s:2:\"h1\";s:11:\"caption_tag\";s:3:\"div\";s:15:\"pattern_overlay\";s:0:\"\";s:13:\"color_overlay\";s:0:\"\";s:15:\"opacity_overlay\";s:2:\"10\";s:10:\"video_webm\";s:0:\"\";s:9:\"video_mp4\";s:0:\"\";s:9:\"video_ogv\";s:0:\"\";s:14:\"video_bg_image\";s:0:\"\";s:12:\"video_poster\";s:2:\"no\";s:10:\"video_loop\";s:3:\"yes\";s:11:\"video_muted\";s:3:\"yes\";s:11:\"arrow_color\";s:4:\"dark\";s:11:\"arrow_align\";s:4:\"left\";s:8:\"el_class\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:0:\"\";s:13:\"button_target\";s:5:\"_self\";s:12:\"button_color\";s:9:\"primary-1\";s:11:\"button_size\";s:6:\"medium\";s:12:\"button_shape\";s:6:\"square\";s:11:\"button_type\";s:0:\"\";s:12:\"button_class\";s:0:\"\";s:12:\"button_text2\";s:0:\"\";s:11:\"button_url2\";s:0:\"\";s:14:\"button_target2\";s:5:\"_self\";s:13:\"button_color2\";s:9:\"primary-1\";s:12:\"button_size2\";s:6:\"medium\";s:13:\"button_shape2\";s:6:\"square\";s:12:\"button_type2\";s:0:\"\";s:13:\"button_class2\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("744", "390", "eut_likes", "21");
INSERT INTO `wp_postmeta` VALUES("745", "390", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("746", "390", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("747", "390", "_wp_old_slug", "standard-post");
INSERT INTO `wp_postmeta` VALUES("748", "390", "_wp_old_slug", "57-ways-to-become-a-better-writer");
INSERT INTO `wp_postmeta` VALUES("749", "390", "_zuperla_eutf_custom_title_options", "a:19:{s:6:\"height\";s:2:\"45\";s:10:\"min_height\";s:3:\"200\";s:8:\"bg_color\";s:5:\"light\";s:15:\"bg_color_custom\";s:7:\"#000000\";s:16:\"subheading_color\";s:4:\"dark\";s:23:\"subheading_color_custom\";s:7:\"#ffffff\";s:11:\"title_color\";s:4:\"dark\";s:18:\"title_color_custom\";s:7:\"#ffffff\";s:13:\"caption_color\";s:4:\"dark\";s:20:\"caption_color_custom\";s:7:\"#ffffff\";s:16:\"content_bg_color\";s:4:\"none\";s:23:\"content_bg_color_custom\";s:7:\"#ffffff\";s:12:\"content_size\";s:6:\"medium\";s:17:\"content_alignment\";s:6:\"center\";s:16:\"content_position\";s:13:\"center-center\";s:17:\"content_animation\";s:10:\"fade-in-up\";s:11:\"bg_position\";s:13:\"center-center\";s:13:\"color_overlay\";s:4:\"dark\";s:20:\"color_overlay_custom\";s:7:\"#000000\";}");
INSERT INTO `wp_postmeta` VALUES("750", "390", "_zuperla_eutf_area_colors", "a:8:{s:8:\"bg_color\";s:7:\"#eeeeee\";s:14:\"headings_color\";s:7:\"#000000\";s:10:\"font_color\";s:7:\"#999999\";s:10:\"link_color\";s:7:\"#FF7D88\";s:11:\"hover_color\";s:7:\"#000000\";s:12:\"border_color\";s:7:\"#e0e0e0\";s:12:\"button_color\";s:9:\"primary-1\";s:18:\"button_hover_color\";s:5:\"black\";}");
INSERT INTO `wp_postmeta` VALUES("751", "390", "_zuperla_eutf_post_standard_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("752", "390", "_zuperla_eutf_post_standard_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("753", "390", "_zuperla_eutf_post_link_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("754", "390", "_zuperla_eutf_post_link_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("755", "390", "_zuperla_eutf_post_link_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("756", "390", "_zuperla_eutf_post_quote_bg_color", "primary-1");
INSERT INTO `wp_postmeta` VALUES("757", "390", "_zuperla_eutf_post_quote_bg_hover_color", "black");
INSERT INTO `wp_postmeta` VALUES("758", "390", "_zuperla_eutf_post_quote_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("759", "390", "_zuperla_eutf_post_video_bg_color", "black");
INSERT INTO `wp_postmeta` VALUES("760", "390", "_zuperla_eutf_post_video_bg_opacity", "70");
INSERT INTO `wp_postmeta` VALUES("761", "390", "_thumbnail_id", "393");
INSERT INTO `wp_postmeta` VALUES("762", "390", "_zuperla_eutf_content_skin_options", "a:4:{s:10:\"text_color\";s:7:\"#888888\";s:13:\"heading_color\";s:7:\"#000000\";s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:82:\"http://euthemians.com/themes/zuperla/wp-content/uploads/2017/05/zuperla-img-13.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("763", "390", "_wp_old_slug", "57-ways-to-become-a-photographer");
INSERT INTO `wp_postmeta` VALUES("764", "390", "_zuperla_eutf_description", "Duo unum eius nonumes ex. Mel soleat habemus honestatis ex. Sit ea apeirian inimicus, mea veri semper");
INSERT INTO `wp_postmeta` VALUES("765", "390", "_zuperla_eutf_layout", "none");
INSERT INTO `wp_postmeta` VALUES("766", "2863", "_wp_attached_file", "2016/08/zuperla-portfolio-15.jpg");
INSERT INTO `wp_postmeta` VALUES("767", "2863", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-15.jpg\";s:8:\"filesize\";i:658378;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-15-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9123;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-15-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:60716;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3531;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-15-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38372;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-15-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:116739;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-15-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86453;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-15-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23593;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-15-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22352;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-15-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33362;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-15-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49702;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-15-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45988;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-15-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62800;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("768", "2863", "_wp_attached_file", "2016/08/zuperla-portfolio-15.jpg");
INSERT INTO `wp_postmeta` VALUES("769", "2863", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-15.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-15-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-15-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-15-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-15-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-15-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-15-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-15-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-15-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-15-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-15-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-15-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("770", "2863", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("771", "2863", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:14.692331437428575;s:5:\"bytes\";i:89481;s:11:\"size_before\";i:609032;s:10:\"size_after\";i:519551;s:4:\"time\";d:1.2400000000000002;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.9;s:5:\"bytes\";i:349;s:11:\"size_before\";i:3524;s:10:\"size_after\";i:3175;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.08;s:5:\"bytes\";i:1543;s:11:\"size_before\";i:13932;s:10:\"size_after\";i:12389;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.65;s:5:\"bytes\";i:5613;s:11:\"size_before\";i:38311;s:10:\"size_after\";i:32698;s:4:\"time\";d:0.09;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:15.42;s:5:\"bytes\";i:9360;s:11:\"size_before\";i:60688;s:10:\"size_after\";i:51328;s:4:\"time\";d:0.13;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.26;s:5:\"bytes\";i:9722;s:11:\"size_before\";i:86346;s:10:\"size_after\";i:76624;s:4:\"time\";d:0.07;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.64;s:5:\"bytes\";i:3219;s:11:\"size_before\";i:23597;s:10:\"size_after\";i:20378;s:4:\"time\";d:0.02;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.76;s:5:\"bytes\";i:2405;s:11:\"size_before\";i:22356;s:10:\"size_after\";i:19951;s:4:\"time\";d:0.04;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.64;s:5:\"bytes\";i:4212;s:11:\"size_before\";i:33329;s:10:\"size_after\";i:29117;s:4:\"time\";d:0.03;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.98;s:5:\"bytes\";i:7449;s:11:\"size_before\";i:49739;s:10:\"size_after\";i:42290;s:4:\"time\";d:0.05;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.3;s:5:\"bytes\";i:5661;s:11:\"size_before\";i:46017;s:10:\"size_after\";i:40356;s:4:\"time\";d:0.09;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.21;s:5:\"bytes\";i:8911;s:11:\"size_before\";i:62697;s:10:\"size_after\";i:53786;s:4:\"time\";d:0.06;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:18.42;s:5:\"bytes\";i:31037;s:11:\"size_before\";i:168496;s:10:\"size_after\";i:137459;s:4:\"time\";d:0.63;}}}");
INSERT INTO `wp_postmeta` VALUES("772", "2864", "_wp_attached_file", "2016/08/zuperla-portfolio-13.jpg");
INSERT INTO `wp_postmeta` VALUES("773", "2864", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-13.jpg\";s:8:\"filesize\";i:945254;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-13-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7677;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-13-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44289;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3415;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-13-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28347;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-13-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:88082;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-13-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49289;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-13-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17707;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-13-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15243;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-13-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24888;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-13-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36383;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-13-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30548;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-13-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46432;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("774", "2864", "_wp_attached_file", "2016/08/zuperla-portfolio-13.jpg");
INSERT INTO `wp_postmeta` VALUES("775", "2864", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-13.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-13-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-13-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-13-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-13-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-13-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-13-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-13-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-13-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-13-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-13-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-13-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("776", "2864", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("777", "2864", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:16.672486950011756;s:5:\"bytes\";i:73046;s:11:\"size_before\";i:438123;s:10:\"size_after\";i:365077;s:4:\"time\";d:1.02;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:12:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.46;s:5:\"bytes\";i:256;s:11:\"size_before\";i:3433;s:10:\"size_after\";i:3177;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.46;s:5:\"bytes\";i:1147;s:11:\"size_before\";i:10968;s:10:\"size_after\";i:9821;s:4:\"time\";d:0.04;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.75;s:5:\"bytes\";i:4171;s:11:\"size_before\";i:28282;s:10:\"size_after\";i:24111;s:4:\"time\";d:0.04;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:17.14;s:5:\"bytes\";i:7571;s:11:\"size_before\";i:44167;s:10:\"size_after\";i:36596;s:4:\"time\";d:0.1;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:15.74;s:5:\"bytes\";i:7737;s:11:\"size_before\";i:49148;s:10:\"size_after\";i:41411;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.19;s:5:\"bytes\";i:2147;s:11:\"size_before\";i:17614;s:10:\"size_after\";i:15467;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:11.03;s:5:\"bytes\";i:1674;s:11:\"size_before\";i:15179;s:10:\"size_after\";i:13505;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.62;s:5:\"bytes\";i:2633;s:11:\"size_before\";i:24801;s:10:\"size_after\";i:22168;s:4:\"time\";d:0.1;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:16.42;s:5:\"bytes\";i:5950;s:11:\"size_before\";i:36240;s:10:\"size_after\";i:30290;s:4:\"time\";d:0.11;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.7;s:5:\"bytes\";i:4478;s:11:\"size_before\";i:30461;s:10:\"size_after\";i:25983;s:4:\"time\";d:0.05;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:13.7;s:5:\"bytes\";i:6345;s:11:\"size_before\";i:46299;s:10:\"size_after\";i:39954;s:4:\"time\";d:0.21;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";i:22;s:5:\"bytes\";i:28937;s:11:\"size_before\";i:131531;s:10:\"size_after\";i:102594;s:4:\"time\";d:0.23;}}}");
INSERT INTO `wp_postmeta` VALUES("778", "2865", "_wp_attached_file", "2016/08/zuperla-portfolio-10.jpg");
INSERT INTO `wp_postmeta` VALUES("779", "2865", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-10.jpg\";s:8:\"filesize\";i:564521;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-10-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7020;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-10-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43991;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2864;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-10-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29541;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-10-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85792;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-10-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58068;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-10-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17901;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-10-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15928;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-10-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22038;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-10-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37189;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-10-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33925;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-10-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40926;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("780", "2865", "_wp_attached_file", "2016/08/zuperla-portfolio-10.jpg");
INSERT INTO `wp_postmeta` VALUES("781", "2865", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-10.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-10-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-10-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-10-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-10-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-10-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-10-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-10-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-10-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-10-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-10-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-10-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("782", "2865", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("783", "2865", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:492706;s:10:\"size_after\";i:492706;s:4:\"time\";d:1.9500000000000002;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:15:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:2827;s:10:\"size_after\";i:2827;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:11438;s:10:\"size_after\";i:11438;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:31248;s:10:\"size_after\";i:31248;s:4:\"time\";d:0.23;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:45602;s:10:\"size_after\";i:45602;s:4:\"time\";d:0.08;}s:14:\"shop_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:2103;s:10:\"size_after\";i:2103;s:4:\"time\";d:0.01;}s:12:\"shop_catalog\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:15857;s:10:\"size_after\";i:15857;s:4:\"time\";d:0.04;}s:11:\"shop_single\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:32482;s:10:\"size_after\";i:32482;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:48862;s:10:\"size_after\";i:48862;s:4:\"time\";d:0.12;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18767;s:10:\"size_after\";i:18767;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:17289;s:10:\"size_after\";i:17289;s:4:\"time\";d:0.19;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:22853;s:10:\"size_after\";i:22853;s:4:\"time\";d:0.04;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:38503;s:10:\"size_after\";i:38503;s:4:\"time\";d:0.19;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:35780;s:10:\"size_after\";i:35780;s:4:\"time\";d:0.06;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:42300;s:10:\"size_after\";i:42300;s:4:\"time\";d:0.09;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:126795;s:10:\"size_after\";i:126795;s:4:\"time\";d:0.73;}}}");
INSERT INTO `wp_postmeta` VALUES("784", "2866", "_wp_attached_file", "2016/08/zuperla-portfolio-09.jpg");
INSERT INTO `wp_postmeta` VALUES("785", "2866", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-09.jpg\";s:8:\"filesize\";i:320739;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-09-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4079;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-09-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25577;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-09-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1902;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-09-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16422;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-09-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54497;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-09-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31744;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-09-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9830;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-09-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8699;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-09-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13492;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-09-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21367;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-09-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18107;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-09-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25869;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("786", "2866", "_wp_attached_file", "2016/08/zuperla-portfolio-09.jpg");
INSERT INTO `wp_postmeta` VALUES("787", "2866", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-09.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-09-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-09-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-09-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-09-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-09-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-09-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-09-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-09-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-09-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-09-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-09-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-09-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("788", "2866", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("789", "2866", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:275823;s:10:\"size_after\";i:275823;s:4:\"time\";d:1.52;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:15:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1753;s:10:\"size_after\";i:1753;s:4:\"time\";d:0.02;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6124;s:10:\"size_after\";i:6124;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:16140;s:10:\"size_after\";i:16140;s:4:\"time\";d:0.13;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:25536;s:10:\"size_after\";i:25536;s:4:\"time\";d:0.09;}s:14:\"shop_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1359;s:10:\"size_after\";i:1359;s:4:\"time\";d:0.01;}s:12:\"shop_catalog\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:8495;s:10:\"size_after\";i:8495;s:4:\"time\";d:0.03;}s:11:\"shop_single\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:17203;s:10:\"size_after\";i:17203;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:24898;s:10:\"size_after\";i:24898;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:9856;s:10:\"size_after\";i:9856;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:9057;s:10:\"size_after\";i:9057;s:4:\"time\";d:0.04;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:13948;s:10:\"size_after\";i:13948;s:4:\"time\";d:0.04;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:20721;s:10:\"size_after\";i:20721;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18349;s:10:\"size_after\";i:18349;s:4:\"time\";d:0.14;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:25919;s:10:\"size_after\";i:25919;s:4:\"time\";d:0.15;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:76465;s:10:\"size_after\";i:76465;s:4:\"time\";d:0.61;}}}");
INSERT INTO `wp_postmeta` VALUES("790", "2867", "_wp_attached_file", "2016/08/zuperla-portfolio-01.jpg");
INSERT INTO `wp_postmeta` VALUES("791", "2867", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-01.jpg\";s:8:\"filesize\";i:685838;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-01-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4013;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-01-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28437;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1782;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-01-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17526;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-01-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58657;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-01-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34301;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-01-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10363;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-01-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9068;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-01-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14210;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-01-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23126;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-01-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19352;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-01-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27760;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("792", "2867", "_wp_attached_file", "2016/08/zuperla-portfolio-01.jpg");
INSERT INTO `wp_postmeta` VALUES("793", "2867", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-01.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-01-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-01-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-01-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-01-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-01-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-01-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-01-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-01-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-01-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-01-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-01-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("794", "2867", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("795", "2867", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:0.3029602144828013;s:5:\"bytes\";i:930;s:11:\"size_before\";i:306971;s:10:\"size_after\";i:306041;s:4:\"time\";d:1.32;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:15:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1610;s:10:\"size_after\";i:1610;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6270;s:10:\"size_after\";i:6270;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:17870;s:10:\"size_after\";i:17870;s:4:\"time\";d:0.05;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.47;s:5:\"bytes\";i:137;s:11:\"size_before\";i:28942;s:10:\"size_after\";i:28805;s:4:\"time\";d:0.19;}s:14:\"shop_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1187;s:10:\"size_after\";i:1187;s:4:\"time\";d:0.04;}s:12:\"shop_catalog\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:8985;s:10:\"size_after\";i:8985;s:4:\"time\";d:0.09;}s:11:\"shop_single\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:18995;s:10:\"size_after\";i:18995;s:4:\"time\";d:0.09;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.16;s:5:\"bytes\";i:44;s:11:\"size_before\";i:28296;s:10:\"size_after\";i:28252;s:4:\"time\";d:0.18;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:10492;s:10:\"size_after\";i:10492;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:9429;s:10:\"size_after\";i:9429;s:4:\"time\";d:0.02;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.73;s:5:\"bytes\";i:110;s:11:\"size_before\";i:15051;s:10:\"size_after\";i:14941;s:4:\"time\";d:0.04;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.43;s:5:\"bytes\";i:102;s:11:\"size_before\";i:23522;s:10:\"size_after\";i:23420;s:4:\"time\";d:0.14;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.68;s:5:\"bytes\";i:139;s:11:\"size_before\";i:20488;s:10:\"size_after\";i:20349;s:4:\"time\";d:0.05;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.39;s:5:\"bytes\";i:398;s:11:\"size_before\";i:28703;s:10:\"size_after\";i:28305;s:4:\"time\";d:0.1;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:87131;s:10:\"size_after\";i:87131;s:4:\"time\";d:0.26;}}}");
INSERT INTO `wp_postmeta` VALUES("796", "2868", "_wp_attached_file", "2016/08/zuperla-portfolio-14.jpg");
INSERT INTO `wp_postmeta` VALUES("797", "2868", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-14.jpg\";s:8:\"filesize\";i:210772;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-14-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3752;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-14-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26910;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1652;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-14-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16267;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-14-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53710;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-14-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31208;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-14-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9684;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-14-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8600;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-14-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13762;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-14-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21895;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-14-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18681;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-14-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26095;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("798", "2868", "_wp_attached_file", "2016/08/zuperla-portfolio-14.jpg");
INSERT INTO `wp_postmeta` VALUES("799", "2868", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-14.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-14-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-14-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-14-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-14-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-14-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-14-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-14-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-14-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-14-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-14-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-14-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("800", "2868", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("801", "2868", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:0.4425021127421829;s:5:\"bytes\";i:1131;s:11:\"size_before\";i:255592;s:10:\"size_after\";i:254461;s:4:\"time\";d:1.03;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:15:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1238;s:10:\"size_after\";i:1238;s:4:\"time\";d:0.01;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5170;s:10:\"size_after\";i:5170;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:14837;s:10:\"size_after\";i:14837;s:4:\"time\";d:0.06;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.36;s:5:\"bytes\";i:87;s:11:\"size_before\";i:24409;s:10:\"size_after\";i:24322;s:4:\"time\";d:0.08;}s:14:\"shop_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:965;s:10:\"size_after\";i:965;s:4:\"time\";i:0;}s:12:\"shop_catalog\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7521;s:10:\"size_after\";i:7521;s:4:\"time\";d:0.03;}s:11:\"shop_single\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.48;s:5:\"bytes\";i:77;s:11:\"size_before\";i:16072;s:10:\"size_after\";i:15995;s:4:\"time\";d:0.06;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.83;s:5:\"bytes\";i:188;s:11:\"size_before\";i:22697;s:10:\"size_after\";i:22509;s:4:\"time\";d:0.08;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:8830;s:10:\"size_after\";i:8830;s:4:\"time\";d:0.04;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:8004;s:10:\"size_after\";i:8004;s:4:\"time\";d:0.03;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.39;s:5:\"bytes\";i:51;s:11:\"size_before\";i:12912;s:10:\"size_after\";i:12861;s:4:\"time\";d:0.05;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.87;s:5:\"bytes\";i:172;s:11:\"size_before\";i:19664;s:10:\"size_after\";i:19492;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.97;s:5:\"bytes\";i:167;s:11:\"size_before\";i:17288;s:10:\"size_after\";i:17121;s:4:\"time\";d:0.08;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.32;s:5:\"bytes\";i:77;s:11:\"size_before\";i:24283;s:10:\"size_after\";i:24206;s:4:\"time\";d:0.08;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.44;s:5:\"bytes\";i:312;s:11:\"size_before\";i:71702;s:10:\"size_after\";i:71390;s:4:\"time\";d:0.33;}}}");
INSERT INTO `wp_postmeta` VALUES("802", "2869", "_wp_attached_file", "2016/08/zuperla-portfolio-04.jpg");
INSERT INTO `wp_postmeta` VALUES("803", "2869", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-04.jpg\";s:8:\"filesize\";i:377558;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-04-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5526;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-04-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34237;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2397;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-04-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21856;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-04-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68807;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-04-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44814;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-04-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13071;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-04-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11896;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-04-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19051;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-04-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28315;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-04-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24863;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-04-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35558;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("804", "2869", "_wp_attached_file", "2016/08/zuperla-portfolio-04.jpg");
INSERT INTO `wp_postmeta` VALUES("805", "2869", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-04.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-04-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-04-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-04-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-04-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-04-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-04-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-04-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-04-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-04-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-04-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-04-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("806", "2869", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("807", "2869", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:367314;s:10:\"size_after\";i:367314;s:4:\"time\";d:1.32;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:15:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:2190;s:10:\"size_after\";i:2190;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:8143;s:10:\"size_after\";i:8143;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:21760;s:10:\"size_after\";i:21760;s:4:\"time\";d:0.09;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:33984;s:10:\"size_after\";i:33984;s:4:\"time\";d:0.08;}s:14:\"shop_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1658;s:10:\"size_after\";i:1658;s:4:\"time\";d:0.01;}s:12:\"shop_catalog\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:11480;s:10:\"size_after\";i:11480;s:4:\"time\";d:0.07;}s:11:\"shop_single\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:23126;s:10:\"size_after\";i:23126;s:4:\"time\";d:0.06;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:34705;s:10:\"size_after\";i:34705;s:4:\"time\";d:0.13;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:13217;s:10:\"size_after\";i:13217;s:4:\"time\";d:0.07;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:12297;s:10:\"size_after\";i:12297;s:4:\"time\";d:0.05;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:19156;s:10:\"size_after\";i:19156;s:4:\"time\";d:0.05;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:27742;s:10:\"size_after\";i:27742;s:4:\"time\";d:0.09;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:25304;s:10:\"size_after\";i:25304;s:4:\"time\";d:0.08;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:35553;s:10:\"size_after\";i:35553;s:4:\"time\";d:0.09;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:96999;s:10:\"size_after\";i:96999;s:4:\"time\";d:0.4;}}}");
INSERT INTO `wp_postmeta` VALUES("808", "2870", "_wp_attached_file", "2016/08/zuperla-portfolio-05.jpg");
INSERT INTO `wp_postmeta` VALUES("809", "2870", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-05.jpg\";s:8:\"filesize\";i:411288;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-05-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5003;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-05-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34206;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2081;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-05-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21034;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-05-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70001;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-05-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45387;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-05-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12721;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-05-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11340;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-05-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17757;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-05-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27762;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-05-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24578;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-05-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35564;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("810", "2870", "_wp_attached_file", "2016/08/zuperla-portfolio-05.jpg");
INSERT INTO `wp_postmeta` VALUES("811", "2870", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-05.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-05-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-05-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-05-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-05-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-05-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-05-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-05-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-05-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-05-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-05-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-05-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("812", "2870", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("813", "2870", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.359413621588182;s:5:\"bytes\";i:12164;s:11:\"size_before\";i:362087;s:10:\"size_after\";i:349923;s:4:\"time\";d:1.56;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:15:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1802;s:10:\"size_after\";i:1802;s:4:\"time\";d:0.03;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.21;s:5:\"bytes\";i:90;s:11:\"size_before\";i:7410;s:10:\"size_after\";i:7320;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.45;s:5:\"bytes\";i:716;s:11:\"size_before\";i:20742;s:10:\"size_after\";i:20026;s:4:\"time\";d:0.18;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.33;s:5:\"bytes\";i:1105;s:11:\"size_before\";i:33197;s:10:\"size_after\";i:32092;s:4:\"time\";d:0.16;}s:14:\"shop_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:1361;s:10:\"size_after\";i:1361;s:4:\"time\";d:0.02;}s:12:\"shop_catalog\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.36;s:5:\"bytes\";i:248;s:11:\"size_before\";i:10503;s:10:\"size_after\";i:10255;s:4:\"time\";d:0.03;}s:11:\"shop_single\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.02;s:5:\"bytes\";i:669;s:11:\"size_before\";i:22189;s:10:\"size_after\";i:21520;s:4:\"time\";d:0.05;}s:34:\"zuperla-eutf-large-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.85;s:5:\"bytes\";i:1344;s:11:\"size_before\";i:34942;s:10:\"size_after\";i:33598;s:4:\"time\";d:0.06;}s:25:\"zuperla-eutf-small-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.4;s:5:\"bytes\";i:300;s:11:\"size_before\";i:12517;s:10:\"size_after\";i:12217;s:4:\"time\";d:0.03;}s:34:\"zuperla-eutf-small-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.25;s:5:\"bytes\";i:254;s:11:\"size_before\";i:11310;s:10:\"size_after\";i:11056;s:4:\"time\";d:0.03;}s:32:\"zuperla-eutf-small-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.42;s:5:\"bytes\";i:613;s:11:\"size_before\";i:17917;s:10:\"size_after\";i:17304;s:4:\"time\";d:0.14;}s:26:\"zuperla-eutf-medium-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.45;s:5:\"bytes\";i:933;s:11:\"size_before\";i:27027;s:10:\"size_after\";i:26094;s:4:\"time\";d:0.08;}s:35:\"zuperla-eutf-medium-rect-horizontal\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.91;s:5:\"bytes\";i:963;s:11:\"size_before\";i:24640;s:10:\"size_after\";i:23677;s:4:\"time\";d:0.06;}s:33:\"zuperla-eutf-medium-rect-vertical\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.86;s:5:\"bytes\";i:1373;s:11:\"size_before\";i:35567;s:10:\"size_after\";i:34194;s:4:\"time\";d:0.08;}s:23:\"zuperla-eutf-fullscreen\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.52;s:5:\"bytes\";i:3556;s:11:\"size_before\";i:100963;s:10:\"size_after\";i:97407;s:4:\"time\";d:0.59;}}}");
INSERT INTO `wp_postmeta` VALUES("814", "2871", "_wp_attached_file", "2016/08/zuperla-portfolio-16.jpg");
INSERT INTO `wp_postmeta` VALUES("815", "2871", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-16.jpg\";s:8:\"filesize\";i:399993;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-16-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5641;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-16-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36001;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2334;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-16-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22909;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"zuperla-portfolio-16-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:69469;}s:34:\"zuperla-eutf-large-rect-horizontal\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-16-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41480;}s:25:\"zuperla-eutf-small-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-16-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14090;}s:34:\"zuperla-eutf-small-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-16-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12417;}s:32:\"zuperla-eutf-small-rect-vertical\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-16-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18904;}s:26:\"zuperla-eutf-medium-square\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-16-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29486;}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:5:{s:4:\"file\";s:32:\"zuperla-portfolio-16-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25254;}s:33:\"zuperla-eutf-medium-rect-vertical\";a:5:{s:4:\"file\";s:33:\"zuperla-portfolio-16-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35399;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("816", "2871", "_wp_attached_file", "2016/08/zuperla-portfolio-16.jpg");
INSERT INTO `wp_postmeta` VALUES("817", "2871", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:2000;s:4:\"file\";s:32:\"2016/08/zuperla-portfolio-16.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-16-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-16-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-16-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-large-rect-horizontal\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-16-1390x782.jpg\";s:5:\"width\";i:1390;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"zuperla-eutf-small-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-16-560x560.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:34:\"zuperla-eutf-small-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-16-560x420.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"zuperla-eutf-small-rect-vertical\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-16-560x747.jpg\";s:5:\"width\";i:560;s:6:\"height\";i:747;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"zuperla-eutf-medium-square\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-16-900x900.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"zuperla-eutf-medium-rect-horizontal\";a:4:{s:4:\"file\";s:32:\"zuperla-portfolio-16-900x675.jpg\";s:5:\"width\";i:900;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"zuperla-eutf-medium-rect-vertical\";a:4:{s:4:\"file\";s:33:\"zuperla-portfolio-16-840x1120.jpg\";s:5:\"width\";i:840;s:6:\"height\";i:1120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"zuperla-eutf-fullscreen\";a:4:{s:4:\"file\";s:34:\"zuperla-portfolio-16-1920x1920.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("818", "2871", "_wp_attachment_image_alt", "Zuperla Premium WordPress Themes");
INSERT INTO `wp_postmeta` VALUES("819", "2871", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:400284;s:10:\"size_after\";i:400284;s:4:\"time\";d:1.18;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:15:{s:9:\"thumbnail\";O:8:\"stdClas