<?php
/**
 * Pricing Table Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_pricing_table_shortcode' ) ) {

	function zuperla_ext_vce_pricing_table_shortcode( $atts, $content ) {

		$output = $data = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'title' => '',
					'description' => '',
					'heading_tag' => 'h3',
					'heading' => 'h2',
					'increase_heading' => '100',
					'custom_font_family' => '',
					'price' => '',
					'interval' => '',
					'values' => '',
					'price_color' => 'black',
					'button_text' => '',
					'button_link' => '',
					'button_type' => 'simple',
					'button_size' => 'medium',
					'button_color' => 'primary-1',
					'button_hover_color' => 'black',
					'button_line_color' => 'primary-1',
					'button_gradient_color_1' => 'primary-1',
					'button_gradient_color_2' => 'primary-2',
					'button_shape' => 'square',
					'button_class' => '',
					'btn_add_icon' => '',
					'btn_icon_library' => 'fontawesome',
					'btn_icon_fontawesome' => 'fa fa-adjust',
					'btn_icon_openiconic' => 'vc-oi vc-oi-dial',
					'btn_icon_typicons' => 'typcn typcn-adjust-brightness',
					'btn_icon_entypo' => 'entypo-icon entypo-icon-note',
					'btn_icon_linecons' => 'vc_li vc_li-heart',
					'btn_icon_simplelineicons' => 'smp-icon-user',
					'btn_icon_etlineicons' => 'et-icon-mobile',
					'content_bg' => 'white',
					'align' => 'left',
					'animation' => '',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);

		$title_classes = array( 'eut-price' );

		array_push( $title_classes, 'eut-' . $heading );
		array_push( $title_classes, 'eut-text-' . $price_color );

		if( '100' != $increase_heading ){
			array_push( $title_classes, 'eut-increase-heading' );
			array_push( $title_classes, 'eut-heading-' . $increase_heading );
		}

		if ( !empty( $custom_font_family ) ) {
			array_push( $title_classes, 'eut-' . $custom_font_family );
		}

		$title_class_string = implode( ' ', $title_classes );

		$button_options = array(
			'button_text'  => $button_text,
			'button_link'  => $button_link,
			'button_type'  => $button_type,
			'button_size'  => $button_size,
			'button_color' => $button_color,
			'button_hover_color' => $button_hover_color,
			'button_line_color' => $button_line_color,
			'button_gradient_color_1' => $button_gradient_color_1,
			'button_gradient_color_2' => $button_gradient_color_2,
			'button_shape' => $button_shape,
			'button_class' => $button_class,
			'btn_add_icon' => $btn_add_icon,
			'btn_icon_library' => $btn_icon_library,
			'btn_icon_fontawesome' => $btn_icon_fontawesome,
			'btn_icon_openiconic' => $btn_icon_openiconic,
			'btn_icon_typicons' => $btn_icon_typicons,
			'btn_icon_entypo' => $btn_icon_entypo,
			'btn_icon_linecons' => $btn_icon_linecons,
			'btn_icon_simplelineicons' => $btn_icon_simplelineicons,
			'btn_icon_etlineicons' => $btn_icon_etlineicons,
		);
		$button = zuperla_ext_vce_get_button( $button_options );

		//Pricing Table Classes
		$pricing_classes = array( 'eut-element', 'eut-pricing-table' );
		if ( !empty( $animation ) ) {
			array_push( $pricing_classes, 'eut-animated-item' );
			array_push( $pricing_classes, $animation);
			array_push( $pricing_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}

		array_push( $pricing_classes, 'eut-align-' . $align);

		if ( !empty ( $el_class ) ) {
			array_push( $pricing_classes, $el_class);
		}

		if( 'none' != $content_bg ){
			array_push( $pricing_classes, 'eut-bg-' . $content_bg );
			array_push( $pricing_classes, 'eut-box-item' );
		}

		$pricing_class_string = implode( ' ', $pricing_classes );

		//Pricing Lines
		$pricing_lines = explode(",", $values);

		$pricing_lines_data = array();
		foreach ($pricing_lines as $line) {
			$new_line = array();
			$data_line = explode("|", $line);
			$new_line['value1'] = isset( $data_line[0] ) && !empty( $data_line[0] ) ? $data_line[0] : '';
			$new_line['value2'] = isset( $data_line[1] ) && !empty( $data_line[1] ) ? $data_line[1] : '';
			$pricing_lines_data[] = $new_line;
		}

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$output .= '<div class="' . $pricing_class_string . '" style="' . $style . '"' . $data . '>';
		$output .= '  <div class="eut-pricing-header">';
		$output .= '    <div class="eut-pricing-title eut-h6">' . $title . '</div>';
		$output .= '    <div class="eut-pricing-description eut-small-text">' . $description . '</div>';
		$output .= '  </div>';
		$output .= '  <div class="eut-pricing-content">';
		$output .= '    <' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">';
		$output .= '<span>' . $price;
		$output .= '</span>';
		$output .= '     <div class="eut-interval eut-h6">' . $interval . '</div>';
		$output .= '   </' . tag_escape( $heading_tag ) . '>';
		$output .= '  </div>';
	    $output .= '  <ul>';
		foreach($pricing_lines_data as $line) {
			$output .= '<li><strong>' .  $line['value1'] . ' </strong>' .  $line['value2'] . '</li>';
		}
		$output .= '  </ul>';
		$output .= $button;
		$output .= '</div>';

		return $output;
	}
	add_shortcode( 'zuperla_pricing_table', 'zuperla_ext_vce_pricing_table_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_pricing_table_shortcode_params' ) ) {
	function zuperla_ext_vce_pricing_table_shortcode_params( $tag ) {

		$zuperla_ext_vce_pricing_table_shortcode_btn_params = zuperla_ext_vce_get_button_params();
		$zuperla_ext_vce_pricing_table_shortcode_params = array_merge(
			array(
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "zuperla-extension" ),
					"param_name" => "title",
					"value" => "Title",
					"save_always" => true,
					"description" => esc_html__( "Enter your title here.", "zuperla-extension" ),
					"admin_label" => true,
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Description", "zuperla-extension" ),
					"param_name" => "description",
					"value" => "",
					"save_always" => true,
					"description" => esc_html__( "Enter your description here.", "zuperla-extension" ),
					"admin_label" => false,
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Price", "zuperla-extension" ),
					"param_name" => "price",
					"value" => "$0",
					"save_always" => true,
					"description" => esc_html__( "Enter your price here. eg $80.", "zuperla-extension" ),
					"admin_label" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Price Tag", "zuperla-extension" ),
					"param_name" => "heading_tag",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "div", "zuperla-extension" ) => 'div',
					),
					"description" => esc_html__( "Price Tag for SEO", "zuperla-extension" ),
					"std" => 'h3',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Price Size/Typography", "zuperla-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Price size and typography, defined in Theme Options - Typography Options", "zuperla-extension" ),
					"std" => 'h3',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Increase Price Heading Size", "zuperla-extension" ),
					"param_name" => "increase_heading",
					"value" => array(
						esc_html__( "100%", "zuperla-extension" ) => '100',
						esc_html__( "120%", "zuperla-extension" ) => '120',
						esc_html__( "140%", "zuperla-extension" ) => '140',
						esc_html__( "160%", "zuperla-extension" ) => '160',
						esc_html__( "180%", "zuperla-extension" ) => '180',
						esc_html__( "200%", "zuperla-extension" ) => '200',
						esc_html__( "250%", "zuperla-extension" ) => '250',
						esc_html__( "300%", "zuperla-extension" ) => '300',
					),
					"description" => esc_html__( "Set the percentage you want to increase your Headings size.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Price Custom Font Family", "zuperla-extension" ),
					"param_name" => "custom_font_family",
					"value" => array(
						esc_html__( "Same as Typography", "zuperla-extension" ) => '',
						esc_html__( "Custom Font Family 1", "zuperla-extension" ) => 'custom-font-1',
						esc_html__( "Custom Font Family 2", "zuperla-extension" ) => 'custom-font-2',
						esc_html__( "Custom Font Family 3", "zuperla-extension" ) => 'custom-font-3',
						esc_html__( "Custom Font Family 4", "zuperla-extension" ) => 'custom-font-4',

					),
					"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "zuperla-extension" ),
					"std" => '',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Interval", "zuperla-extension" ),
					"param_name" => "interval",
					"value" => "/month",
					"save_always" => true,
					"description" => esc_html__( "Enter interval period here. e.g: /month, per month, per year.", "zuperla-extension" ),
				),
				array(
					"type" => "exploded_textarea",
					"heading" => __("Attributes", "zuperla-extension"),
					"param_name" => "values",
					"description" => esc_html__( "Input attribute values. Divide values with linebreaks (Enter). Example: 100|Users.", "zuperla-extension" ),
					"value" => "100|Users,8 Gig|Disc Space,Unlimited|Data Transfer",
					"save_always" => true,
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Price Color", "zuperla-extension" ),
					"param_name" => "price_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
					),
					'std' => 'black',
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Content Background", "zuperla-extension" ),
					"param_name" => "content_bg",
					"description" => esc_html__( "Selected background color for your image text content.", "zuperla-extension" ),
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => 'none',
						esc_html__( "White", "zuperla-extension" ) => 'white',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
					),
					'std' => 'white',
				),
				zuperla_ext_vce_add_align(),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
			),
			$zuperla_ext_vce_pricing_table_shortcode_btn_params
		);

		return array(
			"name" => esc_html__( "Pricing Table", "zuperla-extension" ),
			"description" => esc_html__( "Stylish pricing tables", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-pricing-table",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => $zuperla_ext_vce_pricing_table_shortcode_params,
		);

	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_pricing_table', 'zuperla_ext_vce_pricing_table_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_pricing_table_shortcode_params( 'zuperla_pricing_table' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
