<?php

/*
 *	Helper functions
 *
 * 	@version	1.0
 * 	@author		Euthemians Team
 * 	@URI		http://euthemians.com
 */



 /**
 * Generic Parameters to reuse
 * Used in vc shortcodes
 */

if( !function_exists( 'zuperla_ext_vce_add_animation' ) ) {
	function zuperla_ext_vce_add_animation() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "CSS Animation", "zuperla-extension"),
			"param_name" => "animation",
			"value" => array(
				esc_html__( "No", "zuperla-extension" ) => '',
				esc_html__( "Fade In", "zuperla-extension" ) => "eut-fade-in",
				esc_html__( "Fade In Up", "zuperla-extension" ) => "eut-fade-in-up",
				esc_html__( "Fade In Up Big", "zuperla-extension" ) => "eut-fade-in-up-big",
				esc_html__( "Fade In Down", "zuperla-extension" ) => "eut-fade-in-down",
				esc_html__( "Fade In Down Big", "zuperla-extension" ) => "eut-fade-in-down-big",
				esc_html__( "Fade In Left", "zuperla-extension" ) => "eut-fade-in-left",
				esc_html__( "Fade In Left Big", "zuperla-extension" ) => "eut-fade-in-left-big",
				esc_html__( "Fade In Right", "zuperla-extension" ) => "eut-fade-in-right",
				esc_html__( "Fade In Right Big", "zuperla-extension" ) => "eut-fade-in-right-big",
				esc_html__( "Zoom In", "zuperla-extension" ) => "eut-zoom-in",
			),
			"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_animation_delay' ) ) {
	function zuperla_ext_vce_add_animation_delay() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__('Css Animation Delay', 'zuperla-extension'),
			"param_name" => "animation_delay",
			"value" => '200',
			"description" => esc_html__( "Add delay in milliseconds.", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_animation_duration' ) ) {
	function zuperla_ext_vce_add_animation_duration() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "CSS Animation Duration", "zuperla-extension"),
			"param_name" => "animation_duration",
			"value" => array(
				esc_html__( "Very Fast", "zuperla-extension" ) => "very-fast",
				esc_html__( "Fast", "zuperla-extension" ) => "fast",
				esc_html__( "Normal", "zuperla-extension" ) => "normal",
				esc_html__( "Slow", "zuperla-extension" ) => "slow",
				esc_html__( "Very Slow", "zuperla-extension" ) => "very-slow",
			),
			"std" => 'normal',
			"description" => esc_html__("Select the duration for your animated element.", 'zuperla-extension' ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_margin_bottom' ) ) {
	function zuperla_ext_vce_add_margin_bottom() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__('Bottom margin', 'zuperla-extension'),
			"param_name" => "margin_bottom",
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_el_class' ) ) {
	function zuperla_ext_vce_add_el_class() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__( "Extra class name", "zuperla-extension" ),
			"param_name" => "el_class",
			"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_align' ) ) {
	function zuperla_ext_vce_add_align() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Alignment", "zuperla-extension" ),
			"param_name" => "align",
			"value" => array(
				esc_html__( "Left", "zuperla-extension" ) => 'left',
				esc_html__( "Right", "zuperla-extension" ) => 'right',
				esc_html__( "Center", "zuperla-extension" ) => 'center',
			),
			"description" => '',
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_inherit_align' ) ) {
	function zuperla_ext_vce_add_inherit_align() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Alignment", "zuperla-extension" ),
			"param_name" => "inherit_align",
			"value" => array(
				esc_html__( "Inherit", "zuperla-extension" ) => 'inherit',
				esc_html__( "Left", "zuperla-extension" ) => 'left',
				esc_html__( "Right", "zuperla-extension" ) => 'right',
				esc_html__( "Center", "zuperla-extension" ) => 'center',
			),
			"description" => 'Inherits its value from its column text align definition.',
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_order_by' ) ) {
	function zuperla_ext_vce_add_order_by() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Order By", "zuperla-extension" ),
			"param_name" => "order_by",
			"value" => array(
				esc_html__( "Date", "zuperla-extension" ) => 'date',
				esc_html__( "Last modified date", "zuperla-extension" ) => 'modified',
				esc_html__( "Number of comments", "zuperla-extension" ) => 'comment_count',
				esc_html__( "Title", "zuperla-extension" ) => 'title',
				esc_html__( "Author", "zuperla-extension" ) => 'author',
				esc_html__( "Random", "zuperla-extension" ) => 'rand',
			),
			"description" => '',
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_order' ) ) {
	function zuperla_ext_vce_add_order() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Order", "zuperla-extension" ),
			"param_name" => "order",
			"value" => array(
				esc_html__( "Descending", "zuperla-extension" ) => 'DESC',
				esc_html__( "Ascending", "zuperla-extension" ) => 'ASC'
			),
			"dependency" => array( 'element' => "order_by", 'value' => array( 'date', 'modified', 'comment_count', 'name', 'author', 'title' ) ),
			"description" => '',
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_slideshow_speed' ) ) {
	function zuperla_ext_vce_add_slideshow_speed() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__( "Slideshow Speed", "zuperla-extension" ),
			"param_name" => "slideshow_speed",
			"value" => '3000',
			"description" => esc_html__( "Slideshow Speed in ms.", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_pagination_speed' ) ) {
	function zuperla_ext_vce_add_pagination_speed() {
		return array(
			"type" => "textfield",
			"heading" => esc_html__( "Pagination Speed", "zuperla-extension" ),
			"param_name" => "pagination_speed",
			"value" => '400',
			"description" => esc_html__( "Pagination Speed in ms.", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_navigation_type' ) ) {
	function zuperla_ext_vce_add_navigation_type() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Navigation Type", "zuperla-extension" ),
			"param_name" => "navigation_type",
			'value' => array(
				esc_html__( 'Style 1' , 'zuperla-extension' ) => '1',
				esc_html__( 'No Navigation' , 'zuperla-extension' ) => '0',
			),
			"description" => esc_html__( "Select your Navigation type.", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_navigation_color' ) ) {
	function zuperla_ext_vce_add_navigation_color() {
		return array(
			"type" => "dropdown",
			"heading" => esc_html__( "Navigation Color", "zuperla-extension" ),
			"param_name" => "navigation_color",
			'value' => array(
				esc_html__( 'Dark' , 'zuperla-extension' ) => 'dark',
				esc_html__( 'Light' , 'zuperla-extension' ) => 'light',
			),
			"description" => esc_html__( "Select the background Navigation color.", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_add_auto_height' ) ) {
	function zuperla_ext_vce_add_auto_height() {
		return array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Auto Height", "zuperla-extension" ),
			"param_name" => "auto_height",
			"value" => array( esc_html__( "Select if you want smooth auto height", "zuperla-extension" ) => 'yes' ),
		);
	}
}


//Title Headings/Tags
if( !function_exists( 'zuperla_ext_vce_get_heading_tag' ) ) {
	function zuperla_ext_vce_get_heading_tag( $std = '' ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Title Tag", "zuperla-extension" ),
			"param_name" => "heading_tag",
			"value" => array(
				esc_html__( "h1", "zuperla-extension" ) => 'h1',
				esc_html__( "h2", "zuperla-extension" ) => 'h2',
				esc_html__( "h3", "zuperla-extension" ) => 'h3',
				esc_html__( "h4", "zuperla-extension" ) => 'h4',
				esc_html__( "h5", "zuperla-extension" ) => 'h5',
				esc_html__( "h6", "zuperla-extension" ) => 'h6',
				esc_html__( "div", "zuperla-extension" ) => 'div',
			),
			"description" => esc_html__( "Title Tag for SEO", "zuperla-extension" ),
			"std" => $std,
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_get_heading' ) ) {
	function zuperla_ext_vce_get_heading( $std = '' ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Title Size/Typography", "zuperla-extension" ),
			"param_name" => "heading",
			"value" => array(
				esc_html__( "h1", "zuperla-extension" ) => 'h1',
				esc_html__( "h2", "zuperla-extension" ) => 'h2',
				esc_html__( "h3", "zuperla-extension" ) => 'h3',
				esc_html__( "h4", "zuperla-extension" ) => 'h4',
				esc_html__( "h5", "zuperla-extension" ) => 'h5',
				esc_html__( "h6", "zuperla-extension" ) => 'h6',
				esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
				esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
				esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
				esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
			),
			"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "zuperla-extension" ),
			"std" => $std,
		);
	}
}

// Heading Increase
if( !function_exists( 'zuperla_ext_vce_get_heading_increase' ) ) {
	function zuperla_ext_vce_get_heading_increase() {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Increase Heading Size", "zuperla-extension" ),
			"param_name" => "increase_heading",
			"value" => array(
				esc_html__( "100%", "zuperla-extension" ) => '100',
				esc_html__( "120%", "zuperla-extension" ) => '120',
				esc_html__( "140%", "zuperla-extension" ) => '140',
				esc_html__( "160%", "zuperla-extension" ) => '160',
				esc_html__( "180%", "zuperla-extension" ) => '180',
				esc_html__( "200%", "zuperla-extension" ) => '200',
				esc_html__( "250%", "zuperla-extension" ) => '250',
				esc_html__( "300%", "zuperla-extension" ) => '300',
			),
			"description" => esc_html__( "Set the percentage you want to increase your Headings size.", "zuperla-extension" ),
		);
	}
}


if( !function_exists( 'zuperla_ext_vce_get_heading_blog' ) ) {
	function zuperla_ext_vce_get_heading_blog( $std = '' ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Title Size", "zuperla-extension" ),
			"param_name" => "heading",
			"value" => array(
				esc_html__( "Auto", "zuperla-extension" ) => 'auto',
				esc_html__( "h1", "zuperla-extension" ) => 'h1',
				esc_html__( "h1", "zuperla-extension" ) => 'h1',
				esc_html__( "h2", "zuperla-extension" ) => 'h2',
				esc_html__( "h3", "zuperla-extension" ) => 'h3',
				esc_html__( "h4", "zuperla-extension" ) => 'h4',
				esc_html__( "h5", "zuperla-extension" ) => 'h5',
				esc_html__( "h6", "zuperla-extension" ) => 'h6',
				esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
				esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
				esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
				esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
			),
			"description" => esc_html__( "Title size and typography", "zuperla-extension" ),
			"std" => $std,
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_get_custom_font_family' ) ) {
	function zuperla_ext_vce_get_custom_font_family( $std = '' ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Custom Font Family", "zuperla-extension" ),
			"param_name" => "custom_font_family",
			"value" => array(
				esc_html__( "Same as Typography", "zuperla-extension" ) => '',
				esc_html__( "Custom Font Family 1", "zuperla-extension" ) => 'custom-font-1',
				esc_html__( "Custom Font Family 2", "zuperla-extension" ) => 'custom-font-2',
				esc_html__( "Custom Font Family 3", "zuperla-extension" ) => 'custom-font-3',
				esc_html__( "Custom Font Family 4", "zuperla-extension" ) => 'custom-font-4',

			),
			"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "zuperla-extension" ),
			"std" => $std,
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_get_gradient_color' ) ) {
	function zuperla_ext_vce_get_gradient_color( ) {
		return	array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Color", "zuperla-extension" ),
			"param_name" => "gradient_color",
			"value" => array(
				esc_html__( "No", "zuperla-extension" ) => '',
				esc_html__( "Yes", "zuperla-extension" ) => 'yes',

			),
			"description" => esc_html__( "Select if you want gradient color", "zuperla-extension" ),
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_get_gradient_color_1' ) ) {
	function zuperla_ext_vce_get_gradient_color_1( ) {
		return	array(
				"type" => "dropdown",
				"heading" => esc_html__( "Gradient Color 1 ", "zuperla-extension" ),
				"param_name" => "gradient_color_1",
				"param_holder_class" => "eut-colored-dropdown",
				'edit_field_class' => 'vc_col-sm-6',
				"value" => array(
					esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
					esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
					esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
					esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
					esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
					esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
					esc_html__( "Green", "zuperla-extension" ) => 'green',
					esc_html__( "Orange", "zuperla-extension" ) => 'orange',
					esc_html__( "Red", "zuperla-extension" ) => 'red',
					esc_html__( "Blue", "zuperla-extension" ) => 'blue',
					esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
					esc_html__( "Purple", "zuperla-extension" ) => 'purple',
					esc_html__( "Black", "zuperla-extension" ) => 'black',
					esc_html__( "Grey", "zuperla-extension" ) => 'grey',
					esc_html__( "White", "zuperla-extension" ) => 'white',
				),
				"description" => esc_html__( "Select first color for gradient.", "zuperla-extension" ),
				"dependency" => array( 'element' => "gradient_color", 'value' => array( 'yes' ) ),
				"std" => 'primary-1',
		);
	}
}

if( !function_exists( 'zuperla_ext_vce_get_gradient_color_2' ) ) {
	function zuperla_ext_vce_get_gradient_color_2( ) {
		return	array(
				"type" => "dropdown",
				"heading" => esc_html__( "Gradient Color 2 ", "zuperla-extension" ),
				"param_name" => "gradient_color_2",
				"param_holder_class" => "eut-colored-dropdown",
				'edit_field_class' => 'vc_col-sm-6',
				"value" => array(
					esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
					esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
					esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
					esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
					esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
					esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
					esc_html__( "Green", "zuperla-extension" ) => 'green',
					esc_html__( "Orange", "zuperla-extension" ) => 'orange',
					esc_html__( "Red", "zuperla-extension" ) => 'red',
					esc_html__( "Blue", "zuperla-extension" ) => 'blue',
					esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
					esc_html__( "Purple", "zuperla-extension" ) => 'purple',
					esc_html__( "Black", "zuperla-extension" ) => 'black',
					esc_html__( "Grey", "zuperla-extension" ) => 'grey',
					esc_html__( "White", "zuperla-extension" ) => 'white',
				),
				"description" => esc_html__( "Select second color for gradient.", "zuperla-extension" ),
				"dependency" => array( 'element' => "gradient_color", 'value' => array( 'yes' ) ),
				"std" => 'primary-2',
		);
	}
}

function zuperla_ext_vce_get_social_links_params() {
	global $zuperla_ext_social_list_extended;

	$social_params = array();
	if ( isset( $zuperla_ext_social_list_extended ) ) {

		foreach ( $zuperla_ext_social_list_extended as $social_item ) {

			$social_params[] = array(
				"type" => "textfield",
				"heading" => esc_html( $social_item['title'] ),
				"param_name" => $social_item['url'],
				"value" => "",
				"group" => esc_html__( "Social Links", "zuperla-extension" ),
			);
		}
	}

	return $social_params;
}


//Button Parameters

function zuperla_ext_vce_get_button_params( $group = 'button', $index = '' ) {


	if ( 'first' == $group ) {
		$group_string = esc_html__( "First Button", "zuperla-extension" );
	} elseif ( 'second' == $group ) {
		$group_string = esc_html__( "Second Button", "zuperla-extension" );
	} else {
		$group_string = esc_html__( "Button", "zuperla-extension" );
	}

	$btn_params = array(
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Button Text", "zuperla-extension" ),
			"param_name" => "button" . $index . "_text",
			"save_always" => true,
			"admin_label" => true,
			"value" => "Button",
			"description" => esc_html__( "Text of the button.", "zuperla-extension" ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Type", "zuperla-extension" ),
			"param_name" => "button" . $index . "_type",
			"value" => array(
				esc_html__( "Simple", "zuperla-extension" ) => 'simple',
				esc_html__( "Outline", "zuperla-extension" ) => 'outline',
				esc_html__( "Underline", "zuperla-extension" ) => 'underline',
				esc_html__( "Gradient", "zuperla-extension" ) => 'gradient',
			),
			"description" => esc_html__( "Select button type.", "zuperla-extension" ),
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Color", "zuperla-extension" ),
			"param_name" => "button" . $index . "_color",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
				esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
				esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
				esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
				esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
				esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
				esc_html__( "Green", "zuperla-extension" ) => 'green',
				esc_html__( "Orange", "zuperla-extension" ) => 'orange',
				esc_html__( "Red", "zuperla-extension" ) => 'red',
				esc_html__( "Blue", "zuperla-extension" ) => 'blue',
				esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
				esc_html__( "Purple", "zuperla-extension" ) => 'purple',
				esc_html__( "Black", "zuperla-extension" ) => 'black',
				esc_html__( "Grey", "zuperla-extension" ) => 'grey',
				esc_html__( "White", "zuperla-extension" ) => 'white',
			),
			"description" => esc_html__( "Color of the button.", "zuperla-extension" ),
			"dependency" => array( 'element' => "button" . $index . "_type", 'value' => array( 'simple', 'outline', 'underline' ) ),
			"group" => $group_string,
			"std" => 'primary-1',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Line Color", "zuperla-extension" ),
			"param_name" => "button" . $index . "_line_color",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
				esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
				esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
				esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
				esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
				esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
				esc_html__( "Green", "zuperla-extension" ) => 'green',
				esc_html__( "Orange", "zuperla-extension" ) => 'orange',
				esc_html__( "Red", "zuperla-extension" ) => 'red',
				esc_html__( "Blue", "zuperla-extension" ) => 'blue',
				esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
				esc_html__( "Purple", "zuperla-extension" ) => 'purple',
				esc_html__( "Black", "zuperla-extension" ) => 'black',
				esc_html__( "Grey", "zuperla-extension" ) => 'grey',
				esc_html__( "White", "zuperla-extension" ) => 'white',
			),
			"description" => esc_html__( "Color of the button line.", "zuperla-extension" ),
			"dependency" => array( 'element' => "button" . $index . "_type", 'value' => array( 'underline' ) ),
			"group" => $group_string,
			"std" => 'primary-1',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Gradient Color 1", "zuperla-extension" ),
			"param_name" => "button" . $index . "_gradient_color_1",
			"param_holder_class" => "eut-colored-dropdown",
			'edit_field_class' => 'vc_col-sm-6',
			"value" => array(
				esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
				esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
				esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
				esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
				esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
				esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
				esc_html__( "Green", "zuperla-extension" ) => 'green',
				esc_html__( "Orange", "zuperla-extension" ) => 'orange',
				esc_html__( "Red", "zuperla-extension" ) => 'red',
				esc_html__( "Blue", "zuperla-extension" ) => 'blue',
				esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
				esc_html__( "Purple", "zuperla-extension" ) => 'purple',
				esc_html__( "Black", "zuperla-extension" ) => 'black',
				esc_html__( "Grey", "zuperla-extension" ) => 'grey',
				esc_html__( "White", "zuperla-extension" ) => 'white',
			),
			"description" => esc_html__( "Select first color for gradient.", "zuperla-extension" ),
			"dependency" => array( 'element' => "button" . $index . "_type", 'value' => array( 'gradient' ) ),
			"group" => $group_string,
			"std" => 'primary-1',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Gradient Color 2", "zuperla-extension" ),
			"param_name" => "button" . $index . "_gradient_color_2",
			"param_holder_class" => "eut-colored-dropdown",
			'edit_field_class' => 'vc_col-sm-6',
			"value" => array(
				esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
				esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
				esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
				esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
				esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
				esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
				esc_html__( "Green", "zuperla-extension" ) => 'green',
				esc_html__( "Orange", "zuperla-extension" ) => 'orange',
				esc_html__( "Red", "zuperla-extension" ) => 'red',
				esc_html__( "Blue", "zuperla-extension" ) => 'blue',
				esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
				esc_html__( "Purple", "zuperla-extension" ) => 'purple',
				esc_html__( "Black", "zuperla-extension" ) => 'black',
				esc_html__( "Grey", "zuperla-extension" ) => 'grey',
				esc_html__( "White", "zuperla-extension" ) => 'white',
			),
			"description" => esc_html__( "Select second color for gradient.", "zuperla-extension" ),
			"dependency" => array( 'element' => "button" . $index . "_type", 'value' => array( 'gradient' ) ),
			"group" => $group_string,
			"std" => 'primary-2',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Hover Color", "zuperla-extension" ),
			"param_name" => "button" . $index . "_hover_color",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
				esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
				esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
				esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
				esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
				esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
				esc_html__( "Green", "zuperla-extension" ) => 'green',
				esc_html__( "Orange", "zuperla-extension" ) => 'orange',
				esc_html__( "Red", "zuperla-extension" ) => 'red',
				esc_html__( "Blue", "zuperla-extension" ) => 'blue',
				esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
				esc_html__( "Purple", "zuperla-extension" ) => 'purple',
				esc_html__( "Black", "zuperla-extension" ) => 'black',
				esc_html__( "Grey", "zuperla-extension" ) => 'grey',
				esc_html__( "White", "zuperla-extension" ) => 'white',
			),
			"description" => esc_html__( "Color of the button.", "zuperla-extension" ),
			"dependency" => array( 'element' => "button" . $index . "_type", 'value' => array( 'simple', 'outline', 'gradient' ) ),
			"group" => $group_string,
			"std" => 'black',
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Size", "zuperla-extension" ),
			"param_name" => "button" . $index . "_size",
			"value" => array(
				esc_html__( "Extra Small", "zuperla-extension" ) => 'extrasmall',
				esc_html__( "Small", "zuperla-extension" ) => 'small',
				esc_html__( "Medium", "zuperla-extension" ) => 'medium',
				esc_html__( "Large", "zuperla-extension" ) => 'large',
				esc_html__( "Extra Large", "zuperla-extension" ) => 'extralarge',
			),
			"description" => '',
			"std" => 'medium',
			"group" => $group_string,
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Button Shape", "zuperla-extension" ),
			"param_name" => "button" . $index . "_shape",
			"value" => array(
				esc_html__( "Square", "zuperla-extension" ) => 'square',
				esc_html__( "Round", "zuperla-extension" ) => 'round',
				esc_html__( "Extra Round", "zuperla-extension" ) => 'extra-round',
			),
			"dependency" => array( 'element' => "button" . $index . "_type", 'value' => array( 'simple', 'outline', 'gradient' ) ),
			"description" => '',
			"std" => 'square',
			"group" => $group_string,
		),
		array(
			"type" => "vc_link",
			"heading" => esc_html__( "Button Link", "zuperla-extension" ),
			"param_name" => "button" . $index . "_link",
			"value" => "",
			"description" => esc_html__( "Enter link.", "zuperla-extension" ),
			"group" => $group_string,
		),
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Add icon?", "zuperla-extension" ),
			"param_name" => "btn" . $index . "_add_icon",
			"value" => array( esc_html__( "Select if you want to show an icon next to button", "zuperla-extension" ) => 'yes' ),
			"group" => $group_string
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon library', 'zuperla-extension' ),
			'value' => array(
				esc_html__( 'Font Awesome', 'zuperla-extension' ) => 'fontawesome',
				esc_html__( 'Open Iconic', 'zuperla-extension' ) => 'openiconic',
				esc_html__( 'Typicons', 'zuperla-extension' ) => 'typicons',
				esc_html__( 'Entypo', 'zuperla-extension' ) => 'entypo',
				esc_html__( 'Linecons', 'zuperla-extension' ) => 'linecons',
				esc_html__( 'Simple Line Icons', 'zuperla-extension' ) => 'simplelineicons',
				esc_html__( 'Elegant Line Icons', 'zuperla-extension' ) => 'etlineicons',
			),
			'param_name' => 'btn' . $index . '_icon_library',
			'description' => esc_html__( 'Select icon library.', 'zuperla-extension' ),
			"dependency" => array( 'element' => "btn" . $index . "_add_icon", 'value' => array( 'yes' ) ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
			'param_name' => 'btn' . $index . '_icon_fontawesome',
			'value' => 'fa fa-adjust',
			'settings' => array(
				'emptyIcon' => false,
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'fontawesome',
			),
			'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
			'param_name' => 'btn' . $index . '_icon_openiconic',
			'value' => 'vc-oi vc-oi-dial',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'openiconic',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'openiconic',
			),
			'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
			'param_name' => 'btn' . $index . '_icon_typicons',
			'value' => 'typcn typcn-adjust-brightness',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'typicons',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'typicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
			'param_name' => 'btn' . $index . '_icon_entypo',
			'value' => 'entypo-icon entypo-icon-note',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'entypo',
				'iconsPerPage' => 300,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'entypo',
			),
			'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
			'param_name' => 'btn' . $index . '_icon_linecons',
			'value' => 'vc_li vc_li-heart',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'linecons',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'linecons',
			),
			'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
			'param_name' => 'btn' . $index . '_icon_simplelineicons',
			'value' => 'smp-icon-user',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'simplelineicons',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'simplelineicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
			"group" => $group_string,
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
			'param_name' => 'btn' . $index . '_icon_etlineicons',
			'value' => 'et-icon-mobile',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'etlineicons',
				'iconsPerPage' => 100,
			),
			'dependency' => array(
				'element' => 'btn' . $index . '_icon_library',
				'value' => 'etlineicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
			"group" => $group_string,
		),
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Button class name", "zuperla-extension" ),
			"param_name" => "button" . $index . "_class",
			"description" => esc_html__( "If you wish to style your button differently, then use this field to add a class name and then refer to it in your css file.", "zuperla-extension" ),
			"group" => $group_string,
		),
	);
	return $btn_params;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
